/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.recallbeams.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.justahuman.recallbeams.RecallBeams;
import me.justahuman.recallbeams.mixin.PokemonRendererAccessor;
import me.shedaniel.math.Color;
import net.fabricmc.loader.api.FabricLoader;
import org.joml.Vector4f;

public class ModConfig {
    private static final Gson GSON = new Gson().newBuilder().setPrettyPrinting().create();
    public static final Color DEFAULT_COLOR;
    public static Color beamColor;

    public static void loadConfig() {
        try (FileReader reader = new FileReader(ModConfig.getConfigFile());){
            JsonPrimitive jsonInt;
            JsonObject jsonObject;
            JsonElement jsonElement;
            JsonElement jsonElement2 = JsonParser.parseReader((Reader)reader);
            if (jsonElement2 instanceof JsonObject && (jsonElement = (jsonObject = (JsonObject)jsonElement2).get("beam_color")) instanceof JsonPrimitive && (jsonInt = (JsonPrimitive)jsonElement).isNumber()) {
                beamColor = Color.ofTransparent((int)jsonInt.getAsInt());
            }
        }
        catch (Exception e) {
            RecallBeams.LOGGER.warn("Error occurred while loading Config!");
            RecallBeams.LOGGER.warn(e.getMessage());
        }
        ModConfig.updateColor();
    }

    public static void updateColor() {
        int color = beamColor.getColor();
        PokemonRendererAccessor.setRecallBeamColour(new Vector4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static void saveConfig() {
        ModConfig.updateColor();
        try (FileWriter fileWriter = new FileWriter(ModConfig.getConfigFile());){
            JsonObject config = new JsonObject();
            config.addProperty("beam_color", (Number)beamColor.getColor());
            GSON.toJson((JsonElement)config, (Appendable)fileWriter);
            fileWriter.flush();
        }
        catch (IOException e) {
            RecallBeams.LOGGER.warn("Error occurred while saving config!");
            RecallBeams.LOGGER.warn(e.getMessage());
        }
    }

    public static File getConfigFile() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("recall_beams.json").toFile();
        if (!configFile.exists()) {
            try {
                configFile.getParentFile().mkdirs();
                if (!configFile.createNewFile()) {
                    throw new IOException();
                }
            }
            catch (IOException | SecurityException e) {
                RecallBeams.LOGGER.warn("Failed to create config file!");
                RecallBeams.LOGGER.warn(e.getMessage());
            }
        }
        return configFile;
    }

    static {
        beamColor = DEFAULT_COLOR = Color.ofRGBA((int)255, (int)255, (int)255, (int)255);
    }
}

