/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils.explosion;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FOFExplosion
extends class_1927 {
    protected static final class_5362 EXPLOSION_DAMAGE_CALCULATOR = new class_5362();
    protected final boolean fire;
    protected final class_1927.class_4179 blockInteraction;
    protected final class_5819 random = class_5819.method_43047();
    protected final class_1937 level;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final PokemonEntity pokemon;
    protected final boolean shouldHurtAlly;
    @Nullable
    public final class_1297 source;
    public final float radius;
    protected final class_1282 damageSource;
    protected final class_5362 damageCalculator;
    protected final ObjectArrayList<class_2338> toBlow = new ObjectArrayList();
    protected final Map<class_1657, class_243> hitPlayers = Maps.newHashMap();

    public FOFExplosion(class_1937 level, @Nullable class_1297 source, PokemonEntity pokemon, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, class_1927.class_4179 blockInteraction, boolean shouldHurtAlly, boolean isProjectileExplosion) {
        super(level, source, damageSource, damageCalculator, toBlowX, toBlowY, toBlowZ, radius, fire, blockInteraction, null, null, (class_6880)class_3417.field_15152);
        this.level = level;
        this.source = source;
        this.radius = radius + this.pokemonExplosionBaseValue(isProjectileExplosion);
        this.x = toBlowX;
        this.y = toBlowY;
        this.z = toBlowZ;
        this.fire = fire;
        this.blockInteraction = blockInteraction;
        this.damageSource = damageSource == null ? level.method_48963().method_48830() : damageSource;
        this.damageCalculator = damageCalculator == null ? this.makeDamageCalculator(source) : damageCalculator;
        this.pokemon = pokemon;
        this.shouldHurtAlly = shouldHurtAlly;
    }

    protected class_5362 makeDamageCalculator(@Nullable class_1297 entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new class_5361(entity);
    }

    public static Optional<Float> getBlockExplosionResistance(class_2680 state, class_3610 fluid) {
        return state.method_26215() && fluid.method_15769() ? Optional.empty() : Optional.of(Float.valueOf(Math.max(state.method_26204().method_9520(), fluid.method_15760())));
    }

    public void method_8348() {
        this.level.method_43275(this.source, (class_6880)class_5712.field_28178, new class_243(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d = (float)j / 15.0f * 2.0f - 1.0f;
                    double e = (float)k / 15.0f * 2.0f - 1.0f;
                    double f = (float)l / 15.0f * 2.0f - 1.0f;
                    double g = Math.sqrt(d * d + e * e + f * f);
                    d /= g;
                    e /= g;
                    f /= g;
                    double m = this.x;
                    double n = this.y;
                    double o = this.z;
                    float p = 0.3f;
                    for (float h = this.radius * (0.8f + this.level.field_9229.method_43057() * 0.2f); h > 0.0f; h -= 0.22500001f) {
                        class_2338 blockPos = class_2338.method_49637((double)m, (double)n, (double)o);
                        class_2680 blockState = this.level.method_8320(blockPos);
                        class_3610 fluidState = this.level.method_8316(blockPos);
                        if (!this.level.method_24794(blockPos)) continue block2;
                        Optional<Float> optional = FOFExplosion.getBlockExplosionResistance(blockState, fluidState);
                        if (optional.isPresent()) {
                            h -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (h > 0.0f) {
                            set.add(blockPos);
                        }
                        m += d * 0.3;
                        n += e * 0.3;
                        o += f * 0.3;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        PokemonAttackEffect.dealAoEDamage(this.pokemon, this.source, this.shouldHurtAlly, false);
    }

    public void method_8350(boolean spawnParticles) {
        this.finalizeExplosion();
    }

    public void finalizeExplosion() {
        if (this.level.field_9236) {
            this.level.method_8486(this.x, this.y, this.z, (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (this.level.field_9229.method_43057() - this.level.field_9229.method_43057()) * 0.2f) * 0.7f, false);
        } else {
            this.level.method_60511(null, this.x, this.y, this.z, (class_6880)class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (this.level.field_9229.method_43057() - this.level.field_9229.method_43057()) * 0.2f) * 0.7f);
        }
        boolean bl = this.method_46667();
        class_2400 particleType = !(this.radius < 2.0f) ? class_2398.field_11221 : class_2398.field_11236;
        class_1937 class_19372 = this.level;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)particleType, this.x, this.y, this.z, 1, 1.0, 0.0, 0.0, 1.0);
        }
        if (bl) {
            ArrayList list = new ArrayList();
            class_156.method_43028(this.toBlow, (class_5819)this.level.field_9229);
            for (class_2338 blockPos : this.toBlow) {
                this.level.method_8320(blockPos).method_55225(this.level, blockPos, (class_1927)this, (itemStack, blockPosx) -> FOFExplosion.addOrAppendStack(list, itemStack, blockPosx));
            }
            for (Pair pair : list) {
                class_2248.method_9577((class_1937)this.level, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
            }
            this.level.method_16107().method_15407();
            for (Pair pair : list) {
                class_2248.method_9577((class_1937)this.level, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (class_2338 blockPos3 : this.toBlow) {
                if (this.random.method_43048(3) != 0 || !this.level.method_8320(blockPos3).method_26215() || !this.level.method_8320(blockPos3.method_10074()).method_26216((class_1922)this.level, blockPos3.method_10074())) continue;
                this.level.method_8501(blockPos3, class_4770.method_24416((class_1922)this.level, (class_2338)blockPos3));
            }
        }
    }

    public boolean method_46667() {
        return this.blockInteraction != class_1927.class_4179.field_40878;
    }

    public static FOFExplosion createExplosion(class_1297 source, PokemonEntity pokemonEntity, double x, double y, double z, boolean shouldHurtAlly, boolean isProjectileExplosion) {
        if (pokemonEntity == null) {
            CobblemonFightOrFlight.LOGGER.warn("trying to create a new FOFExplosion without PokemonEntity");
            return null;
        }
        float radius = FOFExplosion.calculateRadius(pokemonEntity);
        ElementalType type1 = pokemonEntity.getPokemon().getPrimaryType();
        ElementalType type2 = pokemonEntity.getPokemon().getSecondaryType();
        boolean shouldCreateFire = CobblemonFightOrFlight.moveConfig().should_create_fire && (type1.equals(ElementalTypes.FIRE) || type2 != null && type2.equals(ElementalTypes.FIRE));
        class_1927.class_4179 blockInteraction1 = CobblemonFightOrFlight.moveConfig().pokemon_griefing ? class_1927.class_4179.field_40879 : class_1927.class_4179.field_40878;
        return new FOFExplosion(source.method_37908(), source, pokemonEntity, source.method_48923().method_48819((class_1297)pokemonEntity, (class_1297)pokemonEntity), null, x, y, z, radius, shouldCreateFire, blockInteraction1, shouldHurtAlly, isProjectileExplosion);
    }

    protected static float calculateRadius(PokemonEntity pokemonEntity) {
        Move move;
        Move move2 = move = PokemonUtils.shouldShoot(pokemonEntity) ? PokemonUtils.getRangeAttackMove(pokemonEntity) : PokemonUtils.getMeleeMove(pokemonEntity);
        if (move == null) {
            return 0.0f;
        }
        return PokemonAttackEffect.getAoERadius(pokemonEntity, move);
    }

    protected float pokemonExplosionBaseValue(boolean isProjectileExplosion) {
        return isProjectileExplosion ? 0.0f : 5.0f;
    }

    protected static void addOrAppendStack(List<Pair<class_1799, class_2338>> drops, class_1799 stack, class_2338 pos) {
        for (int i = 0; i < drops.size(); ++i) {
            Pair<class_1799, class_2338> pair = drops.get(i);
            class_1799 itemStack = (class_1799)pair.getFirst();
            if (!class_1542.method_24017((class_1799)itemStack, (class_1799)stack)) continue;
            drops.set(i, (Pair<class_1799, class_2338>)Pair.of((Object)class_1542.method_24018((class_1799)itemStack, (class_1799)stack, (int)16), (Object)((class_2338)pair.getSecond())));
            if (!stack.method_7960()) continue;
            return;
        }
        drops.add((Pair<class_1799, class_2338>)Pair.of((Object)stack, (Object)pos));
    }
}

