/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.experience.ExperienceSource;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.EvSource;
import com.cobblemon.mod.common.api.pokemon.stats.SidemodEvSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.ai.sensors.FOFSensors;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.FOFEVCalculator;
import me.rufia.fightorflight.utils.FOFExpCalculator;
import me.rufia.fightorflight.utils.FOFHeldItemManager;
import me.rufia.fightorflight.utils.FOFMove;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonMultipliers;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1471;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4149;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityMixin
extends class_1321
implements PokemonInterface {
    @Final
    @Shadow(remap=false)
    private List<Object> busyLocks;
    @Unique
    @Nullable
    private class_1309 fightorflight$clientSideCachedAttackTarget;
    @Unique
    @Nullable
    private class_1309 ownerLastHurt;
    @Unique
    private int ownerLastHurtTick = 0;
    @Unique
    private int ticksUntilNewAngerParticle = 0;
    @Unique
    private static final class_2940<Integer> DATA_ID_ATTACK_TARGET = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> DATA_ID_CAPTURED_BY = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> ATTACK_MODE;
    @Unique
    private static final class_2940<Integer> ATTACK_TIME;
    @Unique
    private static final class_2940<Integer> MAX_ATTACK_TIME;
    @Unique
    private static final class_2940<String> MOVE;
    @Unique
    private static final class_2940<Integer> CRY_CD;
    @Unique
    private static final class_2940<String> COMMAND;
    @Unique
    private static final class_2940<String> COMMAND_DATA;
    @Unique
    private static final class_2940<class_2338> TARGET_BLOCK_POS;
    @Unique
    private static final class_2940<Integer> MOVE_DURATION;
    @Unique
    private final List<FOFMove> MOVES_FOF = new ArrayList<FOFMove>();

    @Shadow(remap=false)
    public abstract void cry();

    @Shadow(remap=false)
    public abstract Pokemon getPokemon();

    @Shadow(remap=false)
    public abstract int getBeamMode();

    @Unique
    protected void createTargetBlockPos() {
        String data = this.getCommandData();
        class_2338 blockPos = class_2338.field_10980;
        if (data.startsWith("POS_")) {
            if (data.equals("POS_SELF")) {
                blockPos = new class_2338(this.method_31477(), this.method_31479(), this.method_31479());
            }
        } else {
            class_2382 vec3i = FOFUtils.stringToVec3i(data);
            if (vec3i != null) {
                blockPos = new class_2338(vec3i.method_10263(), vec3i.method_10264(), vec3i.method_10260());
            }
        }
        this.setTargetBlockPos(blockPos);
    }

    protected PokemonEntityMixin(class_1299<? extends class_1471> entityType, class_1937 level) {
        super(entityType, level);
    }

    public class_1309 method_5968() {
        if (this.method_37908().field_9236) {
            if (this.fightorflight$clientSideCachedAttackTarget != null) {
                return this.fightorflight$clientSideCachedAttackTarget;
            }
            class_1297 entity = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof class_1309) {
                this.fightorflight$clientSideCachedAttackTarget = (class_1309)entity;
                return this.fightorflight$clientSideCachedAttackTarget;
            }
        }
        return super.method_5968();
    }

    @Inject(method={"onSyncedDataUpdated"}, at={@At(value="TAIL")})
    public void onSyncedDataUpdated(class_2940<?> key, CallbackInfo ci) {
        if (DATA_ID_ATTACK_TARGET.equals(key)) {
            this.fightorflight$clientSideCachedAttackTarget = null;
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void defineSynchedData(class_2945.class_9222 builder, CallbackInfo callbackInfo) {
        builder.method_56912(DATA_ID_ATTACK_TARGET, (Object)0);
        builder.method_56912(DATA_ID_CAPTURED_BY, (Object)0);
        builder.method_56912(ATTACK_TIME, (Object)0);
        builder.method_56912(MAX_ATTACK_TIME, (Object)-1);
        builder.method_56912(MOVE, (Object)"");
        builder.method_56912(CRY_CD, (Object)0);
        builder.method_56912(COMMAND, (Object)"");
        builder.method_56912(COMMAND_DATA, (Object)"");
        builder.method_56912(TARGET_BLOCK_POS, (Object)class_2338.field_10980);
        builder.method_56912(ATTACK_MODE, (Object)0);
        builder.method_56912(MOVE_DURATION, (Object)0);
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="HEAD")})
    private void writeAdditionalNbt(class_2487 compoundTag, CallbackInfoReturnable<Boolean> ci) {
        compoundTag.method_10569(CRY_CD.toString(), 0);
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void readAdditionalNbt(class_2487 compoundTag, CallbackInfo ci) {
        this.field_6011.method_12778(CRY_CD, (Object)compoundTag.method_10550(CRY_CD.toString()));
    }

    @ModifyVariable(method={"assignNewBrainWithMemoriesAndSensors"}, at=@At(value="HEAD"), argsOnly=true, index=3)
    private Set<class_4149<?>> assignNewBrainWithMemoriesAndSensorsMixin(Set<class_4149<?>> sensors) {
        HashSet hashSet = new HashSet(sensors);
        hashSet.add(FOFSensors.POKEMON_HELP_OWNER);
        hashSet.add(FOFSensors.POKEMON_WILD_PROACTIVE);
        hashSet.add(FOFSensors.POKEMON_CAUGHT_BY);
        hashSet.add(FOFSensors.POKESTAFF_ATTACK_TARGET);
        hashSet.add(FOFSensors.POKESTAFF_WALK_TARGET);
        return Set.copyOf(hashSet);
    }

    public void method_5980(class_1309 target) {
        super.method_5980(target);
        if (target != null) {
            this.field_6011.method_12778(DATA_ID_ATTACK_TARGET, (Object)target.method_5628());
        }
    }

    @Override
    public int getAttackTime() {
        return (Integer)this.field_6011.method_12789(ATTACK_TIME);
    }

    @Override
    public void setAttackTime(int val) {
        this.field_6011.method_12778(ATTACK_TIME, (Object)val);
    }

    @Override
    public int getMaxAttackTime() {
        return (Integer)this.field_6011.method_12789(MAX_ATTACK_TIME);
    }

    @Override
    public void setMaxAttackTime(int val) {
        this.field_6011.method_12778(MAX_ATTACK_TIME, (Object)val);
    }

    @Override
    public boolean usingBeam() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public boolean usingSound() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public boolean usingMagic() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public void setCurrentMove(Move move) {
        this.field_6011.method_12778(MOVE, (Object)move.getName());
    }

    @Override
    public String getCurrentMove() {
        return (String)this.field_6011.method_12789(MOVE);
    }

    @Override
    public int getNextCryTime() {
        return (Integer)this.field_6011.method_12789(CRY_CD);
    }

    @Override
    public void setNextCryTime(int time) {
        this.field_6011.method_12778(CRY_CD, (Object)time);
    }

    @Override
    public void setCommand(String cmd) {
        this.field_6011.method_12778(COMMAND, (Object)cmd);
    }

    @Override
    public String getCommand() {
        return (String)this.field_6011.method_12789(COMMAND);
    }

    @Override
    public void setCommandData(String cmdData) {
        this.field_6011.method_12778(COMMAND_DATA, (Object)cmdData);
        this.createTargetBlockPos();
    }

    @Override
    public String getCommandData() {
        return (String)this.field_6011.method_12789(COMMAND_DATA);
    }

    @Override
    public class_2338 getTargetBlockPos() {
        return (class_2338)this.field_6011.method_12789(TARGET_BLOCK_POS);
    }

    @Override
    public void setTargetBlockPos(class_2338 blockPos) {
        this.field_6011.method_12778(TARGET_BLOCK_POS, (Object)blockPos);
    }

    @Override
    public int getCapturedBy() {
        return (Integer)this.field_6011.method_12789(DATA_ID_CAPTURED_BY);
    }

    @Override
    public void setCapturedBy(int id) {
        this.field_6011.method_12778(DATA_ID_CAPTURED_BY, (Object)id);
    }

    @Override
    public int getAttackMode() {
        return (Integer)this.field_6011.method_12789(ATTACK_MODE);
    }

    @Override
    public void setAttackMode(int attackMode) {
        this.field_6011.method_12778(ATTACK_MODE, (Object)attackMode);
    }

    @Override
    public int getMoveDuration() {
        return (Integer)this.field_6011.method_12789(MOVE_DURATION);
    }

    @Override
    public void setMoveDuration(int duration) {
        this.field_6011.method_12778(MOVE_DURATION, (Object)duration);
    }

    @Override
    public int getOwnerLastHurtTick() {
        return this.ownerLastHurtTick;
    }

    @Override
    public class_1309 getOwnerLastHurt() {
        return this.ownerLastHurt;
    }

    @Override
    public void setOwnerLastHurt(@Nullable class_1309 livingEntity) {
        this.ownerLastHurt = livingEntity;
        this.ownerLastHurtTick = this.field_6012;
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private float hurtDamageTweak(float amount) {
        if (PokemonUtils.shouldRetreat((PokemonEntity)this)) {
            PokemonAttackEffect.pokemonRecallWithAnimation((PokemonEntity)this);
            return 0.0f;
        }
        PokemonMultipliers pokemonMultipliers = new PokemonMultipliers((PokemonEntity)this);
        Pokemon pokemon = this.getPokemon();
        int specialDef = (int)((float)pokemon.getSpecialDefence() * (FOFHeldItemManager.canUse(pokemon, (class_1792)CobblemonItems.ASSAULT_VEST) ? 1.3f : 1.0f));
        float def = Math.max(pokemon.getDefence(), specialDef);
        return amount * (1.0f - pokemonMultipliers.getMaximumDamageReduction() * Math.min(CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier, class_3532.method_16439((float)(def / (float)CobblemonFightOrFlight.commonConfig().defense_stat_limit), (float)0.0f, (float)CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier)));
    }

    protected void method_6074(class_1282 damageSource, float damageAmount) {
        float newHealth;
        float d;
        float prevHealth = this.method_6032();
        super.method_6074(damageSource, damageAmount);
        if (PokemonUtils.isUsingNewHealthMechanic() && this.field_6008 == 20 && (d = (newHealth = this.method_6032()) - prevHealth) < 0.0f) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity)this, -d, false);
        }
        if (CobblemonFightOrFlight.commonConfig().slow_down_after_hurt && !this.getPokemon().isPlayerOwned()) {
            this.method_6092(new class_1293(class_1294.field_5909, 100, 0));
        }
        if (damageSource.method_49708(class_8111.field_42360) && damageAmount > 0.0f) {
            PokemonEntity pokemonEntity = (PokemonEntity)this;
            class_1297 entity = damageSource.method_5529();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (FOFHeldItemManager.canUse(pokemonEntity, (class_1792)CobblemonItems.ROCKY_HELMET)) {
                    entity.method_5643(this.method_48923().method_48818((class_1297)pokemonEntity), livingEntity.method_6063() / 6.0f);
                }
                if (PokemonUtils.abilityIs(pokemonEntity, "roughskin") || PokemonUtils.abilityIs(pokemonEntity, "ironbarbs")) {
                    entity.method_5643(this.method_48923().method_48818((class_1297)pokemonEntity), livingEntity.method_6063() / 8.0f);
                }
            }
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void invulnerableToModify(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (!this.busyLocks.isEmpty()) {
            cir.setReturnValue((Object)true);
        }
        if (this.getBeamMode() != 0) {
            cir.setReturnValue((Object)true);
        }
        if (CobblemonFightOrFlight.commonConfig().suffocation_immunity && damageSource.method_49708(class_8111.field_42340)) {
            cir.setReturnValue((Object)true);
        }
        if (!CobblemonFightOrFlight.commonConfig().pvp_immunity && this.method_6139() != null && damageSource.method_5529() instanceof class_1657) {
            cir.setReturnValue((Object)super.method_5679(damageSource));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void hurtImmune(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            if (livingEntity instanceof class_3222) {
                class_3222 player = (class_3222)livingEntity;
                class_1309 ownerEntity = this.method_35057();
                PokemonEntity thisEntity = (PokemonEntity)this;
                if (ownerEntity == null && CobblemonFightOrFlight.commonConfig().force_wild_battle_on_player_attack) {
                    PokemonUtils.pokemonForceEncounterPvE(player, thisEntity);
                    cir.setReturnValue((Object)false);
                } else if (ownerEntity instanceof class_1657 && CobblemonFightOrFlight.commonConfig().force_player_battle_on_player_attack) {
                    PokemonUtils.pokemonForceEncounterPvP(player, thisEntity);
                    cir.setReturnValue((Object)false);
                }
            }
            if (!PokemonAttackEffect.shouldBeHurtByAllyMob((PokemonEntity)this, livingEntity)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    public void method_6025(float healAmount) {
        if (PokemonUtils.isUsingNewHealthMechanic()) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity)this, healAmount, true);
        }
        super.method_6025(healAmount);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        int attackTime;
        if (Objects.equals(this.getCommand(), PokeStaffComponent.CMDMODE.CLEAR.name())) {
            this.setCommand(PokeStaffComponent.CMDMODE.NOCMD.name());
        }
        PokemonEntity thisEntity = (PokemonEntity)this;
        class_1309 targetEntity = PokemonUtils.getTarget(thisEntity);
        int nextCryTime = this.getNextCryTime();
        if (!this.getPokemon().isPlayerOwned() && PokemonUtils.shouldFightTarget(thisEntity)) {
            boolean targetAvailable;
            boolean bl = targetAvailable = targetEntity != null && targetEntity.method_5805();
            if (nextCryTime > 0) {
                this.setNextCryTime(nextCryTime - 1);
            }
            if (nextCryTime == 0) {
                this.setNextCryTime(20);
                if (targetAvailable) {
                    this.cry();
                    if (CobblemonFightOrFlight.commonConfig().multiple_cries) {
                        this.setNextCryTime(CobblemonFightOrFlight.commonConfig().time_to_cry_again);
                    } else {
                        this.setNextCryTime(-1);
                    }
                }
            }
            if (this.ticksUntilNewAngerParticle > 0) {
                --this.ticksUntilNewAngerParticle;
            }
            if (this.ticksUntilNewAngerParticle == 0) {
                this.ticksUntilNewAngerParticle = 25;
                if (targetAvailable) {
                    CobblemonFightOrFlight.PokemonEmoteAngry((class_1308)this);
                }
            }
        }
        if ((attackTime = this.getAttackTime()) > -1) {
            this.setAttackTime(attackTime - 1);
        }
        if (!this.method_37908().field_9236) {
            int t = this.field_6012 % 20;
            int sec = this.field_6012 / 20;
            this.slowTick(t, sec);
        }
    }

    @Override
    public void tryUsingStatusMoves() {
        Move move;
        if (this.getAttackTime() > 0) {
            return;
        }
        PokemonEntity self = (PokemonEntity)this;
        if (self.method_35057() instanceof class_1657 && !FOFHeldItemManager.canUse(self, (class_1792)CobblemonItems.ASSAULT_VEST) && (move = PokemonUtils.getStatusMove(self)) != null && CobblemonFightOrFlight.commonConfig().activate_move_effect && MoveData.moveData.containsKey(move.getName())) {
            for (MoveData data : MoveData.moveData.get(move.getName())) {
                data.invoke(self, null);
            }
            PokemonUtils.makeParticle(10, (class_1297)self, class_2398.field_11211);
            PokemonUtils.sendAnimationPacket(self, "status");
            this.setAttackTime(300);
            this.setMaxAttackTime(300);
        }
    }

    @Unique
    private void slowTick(int ticks, int sec) {
        if (ticks == 11) {
            this.updateAttackMode();
            this.backendMoveCooldown();
        }
        if (sec % 5 == 4 && ticks == 17) {
            this.turnBasedHeldItemTrigger();
        }
    }

    @Unique
    private void turnBasedHeldItemTrigger() {
        if (!FOFHeldItemManager.canUseHeldItemHPInfluencing()) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)this;
        Pokemon pokemon = pokemonEntity.getPokemon();
        float maxHealth = pokemonEntity.method_6063();
        if (FOFHeldItemManager.canUse(pokemonEntity, (class_1792)CobblemonItems.LEFTOVERS)) {
            this.method_6025(maxHealth / 16.0f);
        } else if (FOFHeldItemManager.canUse(pokemonEntity, (class_1792)CobblemonItems.STICKY_BARB)) {
            if (!PokemonUtils.abilityIs(pokemonEntity, "magicguard")) {
                this.method_5643(this.method_48923().method_48831(), maxHealth / 8.0f);
            }
        } else if (FOFHeldItemManager.canUse(pokemonEntity, (class_1792)CobblemonItems.BLACK_SLUDGE)) {
            if (PokemonUtils.hasType(pokemon, ElementalTypes.POISON)) {
                this.method_6025(maxHealth / 16.0f);
            } else if (!PokemonUtils.abilityIs(pokemonEntity, "magicguard")) {
                this.method_5643(this.method_48923().method_48831(), maxHealth / 8.0f);
            }
        }
    }

    @Unique
    private void backendMoveCooldown() {
        String moveName = this.getCurrentMove();
        for (FOFMove move : this.MOVES_FOF) {
            int remainingTime;
            if (Objects.equals(move.getName(), moveName) || (remainingTime = move.getRemainingCooldown()) <= 25) continue;
            move.setRemainingCooldown(remainingTime - 20);
        }
    }

    @Unique
    private void updateAttackMode() {
        boolean moveAvailable;
        PokemonEntity pokemonEntity = (PokemonEntity)this;
        Pokemon pokemon = pokemonEntity.getPokemon();
        Move move = PokemonUtils.getMove(pokemonEntity);
        boolean attackIsHigher = pokemon.getAttack() > pokemon.getSpecialAttack();
        boolean hasOwner = pokemonEntity.method_35057() != null;
        boolean bl = moveAvailable = move != null;
        if (hasOwner && moveAvailable) {
            if (PokemonUtils.isMeleeAttackMove(move)) {
                this.setAttackMode(1);
            } else if (PokemonUtils.isRangeAttackMove(move)) {
                this.setAttackMode(2);
            } else {
                this.setAttackMode(0);
            }
            this.setCurrentMove(move);
        } else if (!attackIsHigher && CobblemonFightOrFlight.commonConfig().wild_pokemon_ranged_attack) {
            this.setAttackMode(2);
        } else {
            this.setAttackMode(1);
        }
    }

    @Override
    public void refreshMovesList() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.MOVES_FOF.clear();
        Pokemon pokemon = this.getPokemon();
        for (Move move : pokemon.getMoveSet()) {
            this.MOVES_FOF.add(new FOFMove(move.getName(), 0, 0));
        }
    }

    @Override
    public void switchMove(Move move) {
        if (this.method_37908().field_9236 || move == null) {
            return;
        }
        if (this.MOVES_FOF.isEmpty()) {
            this.refreshMovesList();
        }
        String oldMoveName = this.getCurrentMove();
        block0: for (int index = 0; index < 4; ++index) {
            FOFMove tmpMove = this.MOVES_FOF.get(index);
            if (tmpMove == null || !Objects.equals(tmpMove.getName(), oldMoveName)) continue;
            tmpMove.setRemainingCooldown(this.getAttackTime());
            tmpMove.setOriginalCooldown(this.getMaxAttackTime());
            for (int i = 0; i < 4; ++i) {
                FOFMove m = this.MOVES_FOF.get(i);
                if (m == null || !Objects.equals(m.getName(), move.getName())) continue;
                if (m.getRemainingCooldown() < 10) {
                    this.setAttackTime(10);
                    this.setMaxAttackTime(10);
                    break block0;
                }
                if (m.getRemainingCooldown() <= 10) break block0;
                this.setAttackTime(m.getRemainingCooldown());
                this.setMaxAttackTime(m.getOriginalCooldown());
                break block0;
            }
            break;
        }
        this.setCurrentMove(move);
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="TAIL")})
    private void dropAllDeathLootInject(class_3218 world, class_1282 source, CallbackInfo ci) {
        PokemonEntity pokemonEntity;
        class_1309 class_13092 = this.method_6065();
        if (class_13092 instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)class_13092).method_35057() != null) {
            PokemonEntity self = (PokemonEntity)this;
            pokemonEntity.getPokemon().addExperience((ExperienceSource)new SidemodExperienceSource("fightorflight"), FOFExpCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon()));
            if (CobblemonFightOrFlight.commonConfig().can_gain_ev) {
                Map<Stat, Integer> map = FOFEVCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon());
                for (Map.Entry<Stat, Integer> entry : map.entrySet()) {
                    SidemodEvSource evSource = new SidemodEvSource("fightorflight", pokemonEntity.getPokemon());
                    pokemonEntity.getPokemon().getEvs().add(entry.getKey(), entry.getValue().intValue(), (EvSource)evSource);
                }
            }
        }
    }

    static {
        ATTACK_TIME = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
        MAX_ATTACK_TIME = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
        MOVE = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13326);
        CRY_CD = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
        COMMAND = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13326);
        COMMAND_DATA = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13326);
        TARGET_BLOCK_POS = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13324);
        ATTACK_MODE = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
        MOVE_DURATION = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    }
}

