/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import java.util.List;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.utils.FOFUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9109;

public abstract class AbstractPokemonSpike
extends AbstractPokemonProjectile {
    protected boolean inGround;
    protected int inGroundTime;
    protected short life;
    protected String type;
    protected class_2680 lastState;
    protected boolean activated;
    private static final class_2940<Integer> IN_GROUND_TICK = class_2945.method_12791(AbstractPokemonSpike.class, (class_2941)class_2943.field_13327);

    public AbstractPokemonSpike(class_1299<? extends AbstractPokemonProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected boolean shouldFall() {
        return this.inGround && this.method_37908().method_18026(new class_238(this.method_19538(), this.method_19538()).method_1014(0.1));
    }

    protected void startFalling() {
        this.inGround = false;
        class_243 vec3 = this.method_18798();
        this.method_18799(vec3.method_18805((double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f)));
    }

    protected class_3966 findHitEntity(class_243 startVec, class_243 endVec) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)startVec, (class_243)endVec, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958);
    }

    @Override
    protected void method_24920(class_3965 result) {
        this.lastState = this.method_37908().method_8320(result.method_17777());
        super.method_24920(result);
        class_243 vec3 = result.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3);
        class_243 vec31 = vec3.method_1029().method_1021(0.05);
        this.method_23327(this.method_23317() - vec31.field_1352, this.method_23318() - vec31.field_1351, this.method_23321() - vec31.field_1350);
        this.inGround = true;
    }

    protected void checkEntityCollision() {
        if (!this.method_37908().field_9236 && this.activated) {
            List list = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(0.1));
            for (class_1309 livingEntity : list) {
                if (this.method_24921() == livingEntity || livingEntity.field_6038 == livingEntity.method_23317() || livingEntity.field_5989 == livingEntity.method_23321()) continue;
                double d = Math.abs(livingEntity.method_23317() - livingEntity.field_6038);
                double e = Math.abs(livingEntity.method_23321() - livingEntity.field_5989);
                if (!(d >= 0.003) && !(e >= 0.003)) continue;
                this.hurtEntity(livingEntity);
            }
        }
    }

    protected abstract void hurtEntity(class_1309 var1);

    public void method_5784(class_1313 type, class_243 pos) {
        super.method_5784(type, pos);
        if (type != class_1313.field_6308 && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        class_1297 owner = this.method_24921();
        this.life = owner != null && owner.method_5805() ? (short)(this.life + 1) : (short)(this.life + 10);
        if (this.life >= this.getMaxLife()) {
            this.method_31472();
        }
    }

    @Override
    public void method_5773() {
        class_243 vec33;
        class_265 voxelshape;
        super.method_5773();
        if (this.inGround) {
            if (this.getInGroundTick() == -1) {
                int randomInterval = this.method_37908().field_9229.method_43048(20);
                this.setInGroundTick(this.field_6012 + randomInterval);
            }
        } else {
            this.setInGroundTick(-1);
        }
        if (this.activated && !this.method_37908().field_9236) {
            this.tickDespawn();
        }
        this.checkEntityCollision();
        boolean flag = this.field_5960;
        class_243 vec3 = this.method_18798();
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double d0 = vec3.method_37267();
            this.method_36456(FOFUtils.toAngle(class_3532.method_15349((double)vec3.field_1352, (double)vec3.field_1350)));
            this.method_36457(FOFUtils.toAngle(class_3532.method_15349((double)vec3.field_1351, (double)d0)));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        class_2338 blockpos = this.method_24515();
        class_2680 blockstate = this.method_37908().method_8320(blockpos);
        if (!(blockstate.method_26215() || flag || (voxelshape = blockstate.method_26220((class_1922)this.method_37908(), blockpos)).method_1110())) {
            vec33 = this.method_19538();
            for (class_238 aabb : voxelshape.method_1090()) {
                if (!aabb.method_996(blockpos).method_1006(vec33)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.inGround && !flag) {
            if (!this.activated) {
                this.activated = true;
                this.onActivated();
            }
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            class_243 vec32 = this.method_19538();
            vec33 = vec32.method_1019(vec3);
            class_3965 hitResult = this.method_37908().method_17742(new class_3959(vec32, vec33, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                vec33 = hitResult.method_17784();
            }
            while (!this.method_31481()) {
                class_3966 entityHitResult = this.findHitEntity(vec32, vec33);
                if (entityHitResult != null && (hitResult = entityHitResult).method_17783() == class_239.class_240.field_1331) {
                    class_1297 entity = entityHitResult.method_17782();
                    class_1297 entity1 = this.method_24921();
                    if (entity instanceof class_1657 && entity1 instanceof class_1657 && !((class_1657)entity1).method_7256((class_1657)entity)) {
                        hitResult = null;
                        entityHitResult = null;
                    }
                }
                if (hitResult != null && !flag) {
                    class_9109 projectileDeflection = this.method_59860((class_239)hitResult);
                    this.field_6007 = true;
                    if (projectileDeflection != class_9109.field_48347) break;
                }
                if (entityHitResult == null) break;
                hitResult = null;
            }
            vec3 = this.method_18798();
            double dx = vec3.field_1352;
            double dy = vec3.field_1351;
            double dz = vec3.field_1350;
            double d4 = vec3.method_37267();
            if (flag) {
                this.method_36456(FOFUtils.toAngle(class_3532.method_15349((double)(-dx), (double)(-dz))));
            } else {
                this.method_36456(FOFUtils.toAngle(class_3532.method_15349((double)dx, (double)dz)));
            }
            this.method_36457(FOFUtils.toAngle(class_3532.method_15349((double)dy, (double)d4)));
            this.method_36457(AbstractPokemonSpike.method_26960((float)this.field_6004, (float)this.method_36455()));
            this.method_36456(AbstractPokemonSpike.method_26960((float)this.field_5982, (float)this.method_36454()));
        }
    }

    protected void onActivated() {
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10575("life", this.life);
        compound.method_10556("activated", this.activated);
        compound.method_10556("inGround", this.inGround);
        if (this.lastState != null) {
            compound.method_10566("inBlockState", (class_2520)class_2512.method_10686((class_2680)this.lastState));
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.life = compound.method_10568("life");
        this.activated = compound.method_10577("activated");
        this.inGround = compound.method_10577("inGround");
        if (compound.method_10573("inBlockState", 10)) {
            this.lastState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)compound.method_10562("inBlockState"));
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IN_GROUND_TICK, (Object)-1);
    }

    public void setInGroundTick(int value) {
        this.field_6011.method_12778(IN_GROUND_TICK, (Object)value);
    }

    public int getInGroundTick() {
        return (Integer)this.field_6011.method_12789(IN_GROUND_TICK);
    }

    protected int getMaxLife() {
        return 300;
    }

    @Override
    protected boolean shoudlCreateParticle() {
        return false;
    }

    protected double method_7490() {
        return 0.05;
    }

    @Override
    protected boolean method_26958(class_1297 target) {
        return false;
    }
}

