/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import com.cobblemon.mod.common.net.messages.client.pokemon.update.ExperienceUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import name.modid.client.battlelog.XPTracker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ExperienceUpdatePacket.class}, remap=false)
public class ExperienceUpdateMixin {
    @Inject(method={"set"}, at={@At(value="HEAD")})
    private void onExperienceSet(Pokemon pokemon, int newXP, CallbackInfo ci) {
        if (!XPTracker.isInBattle() || pokemon == null) {
            return;
        }
        int oldXP = pokemon.getExperience();
        int xpGained = newXP - oldXP;
        if (xpGained > 0) {
            String name = pokemon.getSpecies().getName();
            int oldLevel = pokemon.getLevel();
            int newLevel = pokemon.getExperienceGroup().getLevel(newXP);
            XPTracker.onXPGained(name, xpGained, oldLevel, newLevel);
        }
    }
}

