/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageColorizer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Pseudo
@Mixin(targets={"com.cobblemon.mod.common.client.battle.ClientBattleMessageQueue"}, remap=false)
public class BattleMessageQueueMixin {
    @ModifyArg(method={"add"}, at=@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z", remap=false), index=0, require=0, remap=false)
    private Collection<?> fixWordWrapping(Collection<?> messages) {
        try {
            class_2561 colorized;
            if (!BattleExtrasConfig.isBattleLogColoringEnabled()) {
                return messages;
            }
            if (messages == null || messages.isEmpty()) {
                return messages;
            }
            StringBuilder fullText = new StringBuilder();
            for (Object obj : messages) {
                if (!(obj instanceof class_5481)) continue;
                class_5481 fcs = (class_5481)obj;
                StringBuilder sb = new StringBuilder();
                fcs.accept((index, style, codepoint) -> {
                    sb.appendCodePoint(codepoint);
                    return true;
                });
                String lineText = sb.toString();
                if (fullText.length() > 0 && !Character.isWhitespace(fullText.charAt(fullText.length() - 1)) && lineText.length() > 0 && !Character.isWhitespace(lineText.charAt(0))) {
                    fullText.append(lineText);
                    continue;
                }
                if (fullText.length() > 0 && !fullText.toString().endsWith(" ")) {
                    fullText.append(" ");
                }
                fullText.append(lineText.trim());
            }
            String text = fullText.toString().trim();
            if (text.isEmpty()) {
                return messages;
            }
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null) {
                BattleMessageColorizer.setPlayerName(mc.field_1724.method_5477().getString());
            }
            if ((colorized = BattleMessageColorizer.colorizeLineByParts(text)) == null) {
                return new ArrayList();
            }
            List<class_5481> properlyWrapped = this.wrapTextByWords(colorized, 140, mc.field_1772);
            return properlyWrapped;
        }
        catch (Throwable t) {
            return messages;
        }
    }

    private List<class_5481> wrapTextByWords(class_2561 text, int maxWidth, class_327 font) {
        class_2561 lineComponent;
        ArrayList<class_5481> result = new ArrayList<class_5481>();
        String plainText = text.getString();
        String[] words = plainText.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            Object testLine = currentLine.length() > 0 ? String.valueOf(currentLine) + " " + word : word;
            int testWidth = font.method_1727((String)testLine);
            if (testWidth > maxWidth && currentLine.length() > 0) {
                class_2561 lineComponent2 = BattleMessageColorizer.colorizeLineByParts(currentLine.toString());
                if (lineComponent2 != null) {
                    result.add(lineComponent2.method_30937());
                }
                currentLine = new StringBuilder(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0 && (lineComponent = BattleMessageColorizer.colorizeLineByParts(currentLine.toString())) != null) {
            result.add(lineComponent.method_30937());
        }
        return result;
    }
}

