/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.gui.battle.widgets.BattleOptionTile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleLogger;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_7417;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BattleOptionTile.class}, remap=false)
public abstract class BattleGeneralActionSelectionMixin {
    @Unique
    private static boolean pendingForfeitConfirmation = false;

    @Inject(method={"mousePrimaryClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRunButtonClick(double mouseX, double mouseY, CallbackInfoReturnable<Boolean> cir) {
        try {
            String textString = null;
            String textKey = null;
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.getName().equals("text")) continue;
                field.setAccessible(true);
                Object textObj = field.get(this);
                if (textObj == null) break;
                if (textObj instanceof class_2561) {
                    class_2561 c = (class_2561)textObj;
                    class_7417 class_74172 = c.method_10851();
                    if (class_74172 instanceof class_2588) {
                        class_2588 tc = (class_2588)class_74172;
                        textKey = tc.method_11022();
                    }
                    textString = c.getString();
                    break;
                }
                Method getStringMethod = textObj.getClass().getMethod("getString", new Class[0]);
                textString = (String)getStringMethod.invoke(textObj, new Object[0]);
                break;
            }
            if (textString == null && textKey == null) {
                return;
            }
            boolean isRunButton = false;
            if (textKey != null) {
                String k = textKey.toLowerCase();
                boolean bl = isRunButton = k.endsWith(".run") || k.contains(".run");
            }
            if (!isRunButton && textString != null) {
                String txt = textString.trim().toLowerCase();
                boolean bl = isRunButton = txt.equals("run") || txt.equals("flee") || txt.equals("escape") || txt.equals("forfeit") || txt.equals("\u043f\u043e\u0431\u0435\u0433") || txt.equals("fuite") || txt.equals("flucht") || txt.equals("huida") || txt.equals("fuga") || txt.equals("\u9003\u3052\u308b") || txt.equals("\ub3c4\ub9dd") || txt.equals("\u9003\u8dd1");
            }
            if (!isRunButton) {
                return;
            }
            boolean hovered = false;
            try {
                Method isHoveredMethod = this.getClass().getMethod("isHovered", Double.TYPE, Double.TYPE);
                hovered = (Boolean)isHoveredMethod.invoke((Object)this, mouseX, mouseY);
            }
            catch (NoSuchMethodException ignored) {
                try {
                    Method isMouseOver = this.getClass().getMethod("isMouseOver", Double.TYPE, Double.TYPE);
                    hovered = (Boolean)isMouseOver.invoke((Object)this, mouseX, mouseY);
                }
                catch (NoSuchMethodException ignored2) {
                    try {
                        Field fx = this.getClass().getDeclaredField("x");
                        fx.setAccessible(true);
                        Field fy = this.getClass().getDeclaredField("y");
                        fy.setAccessible(true);
                        Field fw = this.getClass().getDeclaredField("width");
                        fw.setAccessible(true);
                        Field fh = this.getClass().getDeclaredField("height");
                        fh.setAccessible(true);
                        double x = ((Number)fx.get(this)).doubleValue();
                        double y = ((Number)fy.get(this)).doubleValue();
                        double w = ((Number)fw.get(this)).doubleValue();
                        double h = ((Number)fh.get(this)).doubleValue();
                        hovered = mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h;
                    }
                    catch (Throwable t) {
                        hovered = false;
                    }
                }
                catch (Throwable ex) {
                    hovered = false;
                }
            }
            catch (Throwable ex) {
                hovered = false;
            }
            if (!hovered) {
                CobblemonBattleInfoClient.debug("Run mixin: click not on tile (mouseX=" + mouseX + ", mouseY=" + mouseY + ", text='" + textString + "')", new Object[0]);
                return;
            }
            CobblemonBattleInfoClient.debug("Run mixin: hovered=true (mouseX=" + mouseX + ", mouseY=" + mouseY + ", text='" + textString + "')", new Object[0]);
            ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
            if (battle != null) {
                boolean isPvP = BattleLogger.isPvPBattle();
                boolean isNPC = !isPvP && BattleLogger.isRecording();
                boolean isWild = !isPvP && !isNPC;
                CobblemonBattleInfoClient.debug("Run button clicked - isPvP: {}, isNPC: {}, isWild: {}", isPvP, isNPC, isWild);
                if (isPvP && !pendingForfeitConfirmation) {
                    pendingForfeitConfirmation = true;
                    UUID battleId = battle.getBattleId();
                    class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new class_410(confirmed -> {
                        pendingForfeitConfirmation = false;
                        if (confirmed) {
                            this.sendForfeitPacket(battleId);
                            CobblemonBattleInfoClient.debug("PvP forfeit confirmed by user", new Object[0]);
                            class_310.method_1551().method_1507(null);
                        } else {
                            class_310.method_1551().method_1507(null);
                        }
                    }, (class_2561)class_2561.method_43471((String)"confirm.cobblemon-battle-extras.forfeit.title"), (class_2561)class_2561.method_43471((String)"confirm.cobblemon-battle-extras.forfeit.message"))));
                    cir.setReturnValue((Object)true);
                    return;
                }
                if (isNPC) {
                    if (BattleExtrasConfig.isInstantNPCForfeitEnabled()) {
                        pendingForfeitConfirmation = false;
                        this.sendForfeitPacket(battle.getBattleId());
                        CobblemonBattleInfoClient.debug("Instant NPC forfeit sent (config enabled)", new Object[0]);
                        class_310.method_1551().execute(() -> class_310.method_1551().method_1507(null));
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    CobblemonBattleInfoClient.debug("NPC battle - using vanilla forfeit confirmation (config disabled)", new Object[0]);
                    return;
                }
                if (isWild) {
                    if (BattleExtrasConfig.isInstantWildRunEnabled()) {
                        pendingForfeitConfirmation = false;
                        this.sendForfeitPacket(battle.getBattleId());
                        CobblemonBattleInfoClient.debug("Instant run from wild battle (config enabled)", new Object[0]);
                        class_310.method_1551().execute(() -> class_310.method_1551().method_1507(null));
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    CobblemonBattleInfoClient.debug("Wild battle - using vanilla run behavior (config disabled)", new Object[0]);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendForfeitPacket(UUID battleId) {
        try {
            Class<?> forfeitClass = Class.forName("com.cobblemon.mod.common.battles.ForfeitActionResponse");
            Object forfeit = forfeitClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> packetClass = Class.forName("com.cobblemon.mod.common.net.messages.server.battle.BattleSelectActionsPacket");
            Constructor<?> constructor = packetClass.getConstructor(UUID.class, List.class);
            Object packet = constructor.newInstance(battleId, Collections.singletonList(forfeit));
            for (Method m : packetClass.getMethods()) {
                if (!m.getName().equals("sendToServer") || m.getParameterCount() != 0) continue;
                m.invoke(packet, new Object[0]);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

