/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.interpreter.instructions.FaintInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import java.util.UUID;
import name.modid.CobblemonBattleExtras;
import name.modid.CobblemonBattleInfo;
import name.modid.CobblemonBattleInfoClient;
import name.modid.net.NetworkRegistration;
import name.modid.net.ServerHolder;
import name.modid.net.payload.FaintRevivePayload;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FaintInstruction.class})
public class FaintInstructionMixin {
    @Final
    @Shadow
    private BattlePokemon faintingPokemon;

    @Inject(method={"invoke*"}, at={@At(value="TAIL")}, remap=false)
    public void invoke(PokemonBattle battle, CallbackInfo ci) {
        UUID faintingUuid;
        MinecraftServer server = ServerHolder.CURRENT_SERVER;
        if (server == null) {
            return;
        }
        UUID actorUuid = this.faintingPokemon.getActor().getUuid();
        Integer pokemonIndex = CobblemonBattleInfo.getOriginalPokemonIndex(actorUuid, faintingUuid = this.faintingPokemon.getUuid());
        if (pokemonIndex == null) {
            CobblemonBattleExtras.LOGGER.error("[BattleExtras SERVER FAINT] Could not find original index for fainted pokemon! UUID=" + String.valueOf(faintingUuid));
            return;
        }
        int finalIndex = pokemonIndex;
        battle.getActors().forEach(actor -> {
            class_3222 player = server.method_3760().method_14602(actor.getUuid());
            if (player != null) {
                NetworkRegistration.sendToPlayer(player, new FaintRevivePayload(actorUuid.toString(), finalIndex, true));
                CobblemonBattleInfoClient.debug("[BattleExtras SERVER FAINT] Sent faint packet to player " + player.method_5477().getString() + ": actor=" + String.valueOf(actorUuid) + " index=" + finalIndex + " pokemonUUID=" + String.valueOf(faintingUuid), new Object[0]);
            }
        });
    }
}

