/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.net;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import name.modid.net.payload.PokemonTeamData;

public class TeamBallClientData {
    private static final Map<UUID, Map<Integer, String>> TEAM_BALLS = new HashMap<UUID, Map<Integer, String>>();
    private static final Map<UUID, Map<Integer, Boolean>> TEAM_FAINTED = new HashMap<UUID, Map<Integer, Boolean>>();

    public static void setTeamData(UUID actorUuid, List<PokemonTeamData> team) {
        HashMap<Integer, String> balls = new HashMap<Integer, String>();
        HashMap<Integer, Boolean> fainted = new HashMap<Integer, Boolean>();
        for (PokemonTeamData data : team) {
            balls.put(data.id(), data.ball());
            fainted.put(data.id(), data.isKO());
        }
        TEAM_BALLS.put(actorUuid, balls);
        TEAM_FAINTED.put(actorUuid, fainted);
    }

    public static String getBallName(UUID actorUuid, int slot) {
        Map<Integer, String> balls = TEAM_BALLS.get(actorUuid);
        if (balls != null) {
            return balls.getOrDefault(slot, "poke_ball");
        }
        return "poke_ball";
    }

    public static Map<Integer, String> getTeamBalls(UUID actorUuid) {
        return TEAM_BALLS.getOrDefault(actorUuid, new HashMap());
    }

    public static boolean hasData(UUID actorUuid) {
        return TEAM_BALLS.containsKey(actorUuid);
    }

    public static boolean isFainted(UUID actorUuid, int slot) {
        Map<Integer, Boolean> fainted = TEAM_FAINTED.get(actorUuid);
        if (fainted != null) {
            return fainted.getOrDefault(slot, false);
        }
        return false;
    }

    public static void updateFaintStatus(UUID actorUuid, int slot, boolean isFainted) {
        Map<Integer, Boolean> fainted = TEAM_FAINTED.get(actorUuid);
        if (fainted == null) {
            fainted = new HashMap<Integer, Boolean>();
            TEAM_FAINTED.put(actorUuid, fainted);
        }
        fainted.put(slot, isFainted);
    }

    public static void clear() {
        TEAM_BALLS.clear();
        TEAM_FAINTED.clear();
    }
}

