/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.battlelog;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.battlelog.BattleLogEntry;
import name.modid.client.battlelog.BattleLogManager;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.lwjgl.glfw.GLFW;

public class EnhancedBattleLogWidget {
    private static final int PANEL_BG = EnhancedBattleLogWidget.color(16, 24, 40, 224);
    private static final int PANEL_BG_GRADIENT = EnhancedBattleLogWidget.color(24, 32, 52, 224);
    private static final int HEADER_BG = EnhancedBattleLogWidget.color(28, 38, 58, 240);
    private static final int HEADER_BG_LIGHT = EnhancedBattleLogWidget.color(38, 52, 78, 240);
    private static final int BORDER_COLOR = EnhancedBattleLogWidget.color(60, 80, 120, 200);
    private static final int BORDER_HIGHLIGHT = EnhancedBattleLogWidget.color(80, 110, 160, 180);
    private static final int INNER_SHADOW = EnhancedBattleLogWidget.color(8, 12, 24, 100);
    private static final int SCROLLBAR_BG = EnhancedBattleLogWidget.color(30, 40, 60, 180);
    private static final int SCROLLBAR_THUMB = EnhancedBattleLogWidget.color(70, 95, 140, 255);
    private static final int SCROLLBAR_THUMB_HOVER = EnhancedBattleLogWidget.color(90, 120, 170, 255);
    private static final int RESIZE_HANDLE_COLOR = EnhancedBattleLogWidget.color(80, 110, 160, 200);
    private static final int RESIZE_HANDLE_HOVER = EnhancedBattleLogWidget.color(110, 145, 200, 255);
    private static final int HEADER_TEXT = EnhancedBattleLogWidget.color(220, 230, 250, 255);
    private static final int HEADER_ACCENT = EnhancedBattleLogWidget.color(100, 140, 220, 255);
    private static final int HEADER_GLOW = EnhancedBattleLogWidget.color(80, 120, 200, 60);
    private static final int TURN_LINE_COLOR = EnhancedBattleLogWidget.color(70, 95, 140, 140);
    private static final int TURN_LINE_HIGHLIGHT = EnhancedBattleLogWidget.color(100, 140, 200, 100);
    private static final int TURN_TEXT_COLOR = EnhancedBattleLogWidget.color(255, 215, 100, 255);
    private static final int TURN_DIAMOND_COLOR = EnhancedBattleLogWidget.color(180, 160, 80, 200);
    private static final int DIM_TEXT = EnhancedBattleLogWidget.color(130, 150, 180, 255);
    private static final int HEADER_HEIGHT = 20;
    private static final int COLLAPSED_HEIGHT = 24;
    private static final int PADDING = 6;
    private static final int BASE_LINE_HEIGHT = 11;
    private static final int RESIZE_HANDLE_SIZE = 6;
    private static final int SCROLLBAR_WIDTH = 4;
    private static final int CORNER_RADIUS = 3;
    private static int scrollOffset = 0;
    private static int contentHeight = 0;
    private static int visibleHeight = 0;
    private static boolean isFollowingBottom = true;
    private static final int BOTTOM_THRESHOLD = 5;
    private static boolean wasMousePressed = false;
    private static boolean isDragging = false;
    private static int dragOffsetX = 0;
    private static int dragOffsetY = 0;
    private static boolean isResizing = false;
    private static ResizeZone resizeZone = ResizeZone.NONE;
    private static int resizeStartX;
    private static int resizeStartY;
    private static int resizeStartWidth;
    private static int resizeStartHeight;
    private static int resizeStartPanelX;
    private static int resizeStartPanelY;
    private static boolean isDraggingScrollbar;
    private static int scrollbarDragStartY;
    private static int scrollbarDragStartOffset;
    private static int scrollbarX;
    private static int scrollbarY;
    private static int scrollbarHeight;
    private static int scrollbarThumbY;
    private static int scrollbarThumbHeight;
    private static ResizeZone hoveredZone;
    private static boolean isOverScrollbar;
    private static int widgetX;
    private static int widgetY;
    private static int widgetW;
    private static int widgetH;
    private static int headerEndY;
    private static int lineHeight;
    private static class_332 currentGraphics;

    private static int color(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void init() {
    }

    public static void clear() {
        scrollOffset = 0;
        isFollowingBottom = true;
    }

    public static boolean isMouseOverWidget() {
        class_310 mc = class_310.method_1551();
        int mouseX = (int)(mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489());
        int mouseY = (int)(mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506());
        return mouseX >= widgetX && mouseX <= widgetX + widgetW && mouseY >= widgetY && mouseY <= widgetY + widgetH;
    }

    public static void render(class_332 graphics, float tickDelta) {
        if (CobblemonClient.INSTANCE.getBattle() == null) {
            return;
        }
        if (CobblemonClient.INSTANCE.getBattle().getMinimised()) {
            return;
        }
        if (!BattleExtrasConfig.useEnhancedBattleLogStyle()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        float fontScale = BattleExtrasConfig.getBattleLogFontScale();
        lineHeight = Math.max(8, (int)(11.0f * fontScale));
        EnhancedBattleLogWidget.handleInput(mc);
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        boolean isExpanded = BattleExtrasConfig.isBattleLogExpanded();
        int width = BattleExtrasConfig.getBattleLogWidth();
        int expandedHeight = BattleExtrasConfig.getBattleLogHeight();
        int height = isExpanded ? expandedHeight : 24;
        int defaultX = screenWidth - width - 10;
        int defaultY = screenHeight - expandedHeight - 10;
        int savedX = BattleExtrasConfig.getBattleLogX();
        int savedY = BattleExtrasConfig.getBattleLogY();
        int x = savedX >= 0 ? savedX : defaultX;
        int y = savedY >= 0 ? savedY : defaultY;
        x = Math.max(0, Math.min(screenWidth - width, x));
        y = Math.max(0, Math.min(screenHeight - height, y));
        widgetX = x;
        widgetY = y;
        widgetW = width;
        widgetH = height;
        headerEndY = y + 20;
        if (BattleExtrasConfig.useEnhancedBattleLogStyle()) {
            EnhancedBattleLogWidget.drawFancyPanel(graphics, x, y, width, height, isExpanded);
            EnhancedBattleLogWidget.drawFancyHeader(graphics, font, x, y, width, isExpanded);
            if (isExpanded) {
                EnhancedBattleLogWidget.renderContent(graphics, font, x, y, width, height, fontScale);
                if (hoveredZone != ResizeZone.NONE || isResizing) {
                    EnhancedBattleLogWidget.renderResizeHandles(graphics, x, y, width, height);
                }
            }
        } else {
            EnhancedBattleLogWidget.renderNativeStyle(graphics, font, x, y, width, height, isExpanded, fontScale);
        }
    }

    private static void renderNativeStyle(class_332 graphics, class_327 font, int x, int y, int width, int height, boolean isExpanded, float fontScale) {
        int nativeBg = EnhancedBattleLogWidget.color(0, 0, 0, 160);
        int nativeBorder = EnhancedBattleLogWidget.color(60, 60, 60, 200);
        int nativeHeaderBg = EnhancedBattleLogWidget.color(20, 20, 20, 200);
        graphics.method_25294(x, y, x + width, y + height, nativeBg);
        graphics.method_25294(x, y, x + width, y + 1, nativeBorder);
        graphics.method_25294(x, y + height - 1, x + width, y + height, nativeBorder);
        graphics.method_25294(x, y, x + 1, y + height, nativeBorder);
        graphics.method_25294(x + width - 1, y, x + width, y + height, nativeBorder);
        graphics.method_25294(x + 1, y + 1, x + width - 1, y + 20, nativeHeaderBg);
        graphics.method_51433(font, "Battle Log", x + 6, y + 6, -1, false);
        String indicator = isExpanded ? "[-]" : "[+]";
        graphics.method_51433(font, indicator, x + width - font.method_1727(indicator) - 6, y + 6, -5592406, false);
        if (isExpanded) {
            EnhancedBattleLogWidget.renderNativeContent(graphics, font, x, y, width, height, fontScale);
            if (hoveredZone != ResizeZone.NONE || isResizing) {
                EnhancedBattleLogWidget.renderResizeHandles(graphics, x, y, width, height);
            }
        }
    }

    private static void renderNativeContent(class_332 graphics, class_327 font, int x, int y, int width, int height, float fontScale) {
        int contentY = y + 20 + 2;
        int contentAreaHeight = height - 20 - 4;
        int textX = x + 6;
        int textWidth = width - 12 - 4 - 6;
        List<BattleLogEntry> entries = BattleLogManager.getEntries();
        contentHeight = EnhancedBattleLogWidget.calculateNativeContentHeight(font, entries, textWidth, fontScale);
        visibleHeight = contentAreaHeight;
        int maxScroll = Math.max(0, contentHeight - visibleHeight);
        scrollOffset = isFollowingBottom ? maxScroll : Math.max(0, Math.min(scrollOffset, maxScroll));
        if (maxScroll <= 0 || scrollOffset >= maxScroll - 5) {
            isFollowingBottom = true;
        }
        EnhancedBattleLogWidget.enableScissor(graphics, x + 1, contentY, width - 2, contentAreaHeight);
        if (entries.isEmpty()) {
            graphics.method_51433(font, "Waiting for battle...", textX, contentY + 4, -7829368, false);
        } else {
            EnhancedBattleLogWidget.renderNativeLogEntries(graphics, font, entries, textX, contentY, textWidth, fontScale);
        }
        EnhancedBattleLogWidget.disableScissor(graphics);
        if (contentHeight > visibleHeight) {
            EnhancedBattleLogWidget.renderNativeScrollbar(graphics, x + width - 4 - 3, contentY, contentAreaHeight);
        }
    }

    private static int calculateNativeContentHeight(class_327 font, List<BattleLogEntry> entries, int textWidth, float fontScale) {
        if (entries.isEmpty()) {
            return lineHeight;
        }
        int height = 0;
        for (BattleLogEntry entry : entries) {
            if (entry.getType() == BattleLogEntry.EntryType.TURN) continue;
            int scaledWidth = (int)((float)textWidth / fontScale);
            List wrappedLines = font.method_1728((class_5348)entry.getMessage(), scaledWidth);
            height += lineHeight * wrappedLines.size();
        }
        return Math.max(height, lineHeight);
    }

    private static void renderNativeLogEntries(class_332 graphics, class_327 font, List<BattleLogEntry> entries, int textX, int startY, int textWidth, float fontScale) {
        int currentY = startY - scrollOffset;
        for (BattleLogEntry entry : entries) {
            if (entry.getType() == BattleLogEntry.EntryType.TURN) continue;
            int scaledWidth = (int)((float)textWidth / fontScale);
            List wrappedLines = font.method_1728((class_5348)entry.getMessage(), scaledWidth);
            for (class_5481 line : wrappedLines) {
                EnhancedBattleLogWidget.drawColorizedLine(graphics, font, line, textX, currentY, fontScale);
                currentY += lineHeight;
            }
        }
    }

    private static void renderNativeScrollbar(class_332 graphics, int x, int y, int height) {
        int thumbY;
        scrollbarX = x;
        scrollbarY = y;
        scrollbarHeight = height;
        graphics.method_25294(x, y, x + 4, y + height, EnhancedBattleLogWidget.color(30, 30, 30, 180));
        int thumbHeight = Math.max(15, (int)((float)visibleHeight / (float)contentHeight * (float)height));
        int maxScroll = contentHeight - visibleHeight;
        float ratio = maxScroll > 0 ? (float)scrollOffset / (float)maxScroll : 0.0f;
        scrollbarThumbY = thumbY = y + (int)((float)(height - thumbHeight) * ratio);
        scrollbarThumbHeight = thumbHeight;
        int thumbColor = isOverScrollbar ? EnhancedBattleLogWidget.color(140, 140, 140, 255) : EnhancedBattleLogWidget.color(100, 100, 100, 255);
        graphics.method_25294(x, thumbY, x + 4, thumbY + thumbHeight, thumbColor);
    }

    private static void renderContent(class_332 graphics, class_327 font, int x, int y, int width, int height, float fontScale) {
        int contentY = y + 20 + 2;
        int contentAreaHeight = height - 20 - 6;
        int textX = x + 6;
        int textWidth = width - 12 - 4 - 10;
        List<BattleLogEntry> entries = BattleLogManager.getEntries();
        contentHeight = EnhancedBattleLogWidget.calculateContentHeight(font, entries, textWidth, fontScale);
        visibleHeight = contentAreaHeight;
        int maxScroll = Math.max(0, contentHeight - visibleHeight);
        scrollOffset = isFollowingBottom ? maxScroll : Math.max(0, Math.min(scrollOffset, maxScroll));
        if (maxScroll <= 0 || scrollOffset >= maxScroll - 5) {
            isFollowingBottom = true;
        }
        EnhancedBattleLogWidget.enableScissor(graphics, x + 2, contentY, width - 4, contentAreaHeight);
        if (entries.isEmpty()) {
            EnhancedBattleLogWidget.drawScaledText(graphics, font, "No battle messages yet...", textX, contentY + 4, DIM_TEXT, fontScale * 0.9f);
        } else {
            EnhancedBattleLogWidget.renderLogEntries(graphics, font, entries, textX, contentY, textWidth, fontScale);
        }
        EnhancedBattleLogWidget.disableScissor(graphics);
        if (contentHeight > visibleHeight) {
            EnhancedBattleLogWidget.renderScrollbar(graphics, x + width - 4 - 4, contentY, contentAreaHeight);
        }
    }

    private static int calculateContentHeight(class_327 font, List<BattleLogEntry> entries, int textWidth, float fontScale) {
        if (entries.isEmpty()) {
            return lineHeight;
        }
        int height = 0;
        int lastTurn = -1;
        for (BattleLogEntry entry : entries) {
            if (entry.getTurn() != lastTurn) {
                if (lastTurn != -1) {
                    height += 4;
                }
                height += lineHeight + 3;
                lastTurn = entry.getTurn();
            }
            if (entry.getType() == BattleLogEntry.EntryType.TURN) continue;
            int scaledWidth = (int)((float)textWidth / fontScale);
            List wrappedLines = font.method_1728((class_5348)entry.getMessage(), scaledWidth);
            height += lineHeight * wrappedLines.size();
        }
        return Math.max(height, lineHeight);
    }

    private static void renderLogEntries(class_332 graphics, class_327 font, List<BattleLogEntry> entries, int textX, int startY, int textWidth, float fontScale) {
        int currentY = startY - scrollOffset;
        int lastTurn = -1;
        for (BattleLogEntry entry : entries) {
            if (entry.getTurn() != lastTurn) {
                if (lastTurn != -1) {
                    currentY += 4;
                }
                EnhancedBattleLogWidget.renderTurnSeparator(graphics, font, textX - 2, currentY, textWidth + 4, entry.getTurn(), fontScale);
                currentY += lineHeight + 3;
                lastTurn = entry.getTurn();
            }
            if (entry.getType() == BattleLogEntry.EntryType.TURN) continue;
            int scaledWidth = (int)((float)textWidth / fontScale);
            List wrappedLines = font.method_1728((class_5348)entry.getMessage(), scaledWidth);
            for (class_5481 line : wrappedLines) {
                EnhancedBattleLogWidget.drawColorizedLine(graphics, font, line, textX, currentY, fontScale);
                currentY += lineHeight;
            }
        }
    }

    private static void renderTurnSeparator(class_332 graphics, class_327 font, int x, int y, int width, int turn, float fontScale) {
        int lineColor;
        int alpha;
        float progress;
        int i;
        int centerY = y + lineHeight / 2;
        float sepScale = fontScale * 0.85f;
        String turnText = "Turn " + turn;
        int textW = (int)((float)font.method_1727(turnText) * sepScale);
        int diamondSize = 2;
        int diamondGap = 3;
        int textX = x + (width - textW) / 2;
        int leftDiamondX = textX - diamondGap - diamondSize * 2;
        int rightDiamondX = textX + textW + diamondGap;
        int lineEndLeft = leftDiamondX - 1;
        int lineStartRight = rightDiamondX + diamondSize * 2 + 1;
        int leftLineStart = x + 4;
        int rightLineEnd = x + width - 4;
        for (i = leftLineStart; i < Math.max(leftLineStart, lineEndLeft); ++i) {
            progress = (float)(i - leftLineStart) / (float)Math.max(1, lineEndLeft - leftLineStart);
            alpha = (int)(progress * 140.0f);
            lineColor = EnhancedBattleLogWidget.color(70, 95, 140, alpha);
            graphics.method_25294(i, centerY, i + 1, centerY + 1, lineColor);
        }
        for (i = lineStartRight; i < rightLineEnd; ++i) {
            progress = 1.0f - (float)(i - lineStartRight) / (float)Math.max(1, rightLineEnd - lineStartRight);
            alpha = (int)(progress * 140.0f);
            lineColor = EnhancedBattleLogWidget.color(70, 95, 140, alpha);
            graphics.method_25294(i, centerY, i + 1, centerY + 1, lineColor);
        }
        EnhancedBattleLogWidget.drawDiamond(graphics, leftDiamondX, centerY, diamondSize, TURN_DIAMOND_COLOR);
        EnhancedBattleLogWidget.drawDiamond(graphics, rightDiamondX, centerY, diamondSize, TURN_DIAMOND_COLOR);
        EnhancedBattleLogWidget.drawScaledText(graphics, font, turnText, textX, y + 1, TURN_TEXT_COLOR, sepScale);
    }

    private static void drawDiamond(class_332 g, int x, int y, int size, int color) {
        for (int i = 0; i <= size; ++i) {
            g.method_25294(x + size - i, y - i, x + size + i + 1, y - i + 1, color);
            g.method_25294(x + size - i, y + i, x + size + i + 1, y + i + 1, color);
        }
    }

    private static void drawColorizedLine(class_332 graphics, class_327 font, class_5481 line, int x, int y, float fontScale) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905(fontScale, fontScale, 1.0f);
        graphics.method_51430(font, line, 0, 0, -1, true);
        graphics.method_51448().method_22909();
    }

    private static void drawColorizedText(class_332 graphics, class_327 font, class_2561 message, int x, int y, float fontScale) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905(fontScale, fontScale, 1.0f);
        graphics.method_51439(font, message, 0, 0, -1, true);
        graphics.method_51448().method_22909();
    }

    private static void renderScrollbar(class_332 graphics, int x, int y, int height) {
        int thumbY;
        scrollbarX = x;
        scrollbarY = y;
        scrollbarHeight = height;
        graphics.method_25294(x, y + 1, x + 4, y + height - 1, SCROLLBAR_BG);
        graphics.method_25294(x + 1, y, x + 4 - 1, y + 1, SCROLLBAR_BG);
        graphics.method_25294(x + 1, y + height - 1, x + 4 - 1, y + height, SCROLLBAR_BG);
        int thumbHeight = Math.max(15, (int)((float)visibleHeight / (float)contentHeight * (float)height));
        int maxScroll = contentHeight - visibleHeight;
        float ratio = maxScroll > 0 ? (float)scrollOffset / (float)maxScroll : 0.0f;
        scrollbarThumbY = thumbY = y + (int)((float)(height - thumbHeight) * ratio);
        scrollbarThumbHeight = thumbHeight;
        int thumbColor = isOverScrollbar ? SCROLLBAR_THUMB_HOVER : SCROLLBAR_THUMB;
        int thumbHighlight = isOverScrollbar ? EnhancedBattleLogWidget.color(110, 145, 195, 255) : EnhancedBattleLogWidget.color(90, 120, 165, 255);
        graphics.method_25294(x, thumbY + 2, x + 4, thumbY + thumbHeight - 2, thumbColor);
        graphics.method_25294(x + 1, thumbY, x + 4 - 1, thumbY + 2, thumbColor);
        graphics.method_25294(x + 1, thumbY + thumbHeight - 2, x + 4 - 1, thumbY + thumbHeight, thumbColor);
        graphics.method_25294(x, thumbY + 3, x + 1, thumbY + thumbHeight - 3, thumbHighlight);
    }

    private static void renderResizeHandles(class_332 graphics, int x, int y, int width, int height) {
        int handleColor = hoveredZone != ResizeZone.NONE || isResizing ? RESIZE_HANDLE_HOVER : RESIZE_HANDLE_COLOR;
        int len = 10;
        int thick = 2;
        EnhancedBattleLogWidget.drawCornerHandle(graphics, x + width, y + height, len, thick, handleColor, false, false, false, true);
        if (hoveredZone != ResizeZone.NONE || isResizing) {
            EnhancedBattleLogWidget.drawCornerHandle(graphics, x, y, len, thick, handleColor, true, false, false, false);
            EnhancedBattleLogWidget.drawCornerHandle(graphics, x + width, y, len, thick, handleColor, false, true, false, false);
            EnhancedBattleLogWidget.drawCornerHandle(graphics, x, y + height, len, thick, handleColor, false, false, true, false);
            int edgeLen = 14;
            int midX = x + width / 2;
            int midY = y + height / 2;
            graphics.method_25294(midX - edgeLen / 2, y, midX + edgeLen / 2, y + thick, handleColor);
            graphics.method_25294(midX - edgeLen / 2, y + height - thick, midX + edgeLen / 2, y + height, handleColor);
            graphics.method_25294(x, midY - edgeLen / 2, x + thick, midY + edgeLen / 2, handleColor);
            graphics.method_25294(x + width - thick, midY - edgeLen / 2, x + width, midY + edgeLen / 2, handleColor);
        }
    }

    private static void drawCornerHandle(class_332 g, int cx, int cy, int len, int thick, int col, boolean tl, boolean tr, boolean bl, boolean br) {
        if (tl) {
            g.method_25294(cx, cy, cx + len, cy + thick, col);
            g.method_25294(cx, cy, cx + thick, cy + len, col);
        } else if (tr) {
            g.method_25294(cx - len, cy, cx, cy + thick, col);
            g.method_25294(cx - thick, cy, cx, cy + len, col);
        } else if (bl) {
            g.method_25294(cx, cy - thick, cx + len, cy, col);
            g.method_25294(cx, cy - len, cx + thick, cy, col);
        } else if (br) {
            g.method_25294(cx - len, cy - thick, cx, cy, col);
            g.method_25294(cx - thick, cy - len, cx, cy, col);
        }
    }

    private static void drawRoundedRect(class_332 g, int x, int y, int w, int h, int bg, int border) {
        g.method_25294(x + 3, y, x + w - 3, y + h, bg);
        g.method_25294(x, y + 3, x + w, y + h - 3, bg);
        g.method_25294(x + 1, y + 1, x + 3, y + 3, bg);
        g.method_25294(x + w - 3, y + 1, x + w - 1, y + 3, bg);
        g.method_25294(x + 1, y + h - 3, x + 3, y + h - 1, bg);
        g.method_25294(x + w - 3, y + h - 3, x + w - 1, y + h - 1, bg);
        g.method_25294(x + 3, y, x + w - 3, y + 1, border);
        g.method_25294(x + 3, y + h - 1, x + w - 3, y + h, border);
        g.method_25294(x, y + 3, x + 1, y + h - 3, border);
        g.method_25294(x + w - 1, y + 3, x + w, y + h - 3, border);
        g.method_25294(x + 1, y + 1, x + 2, y + 2, border);
        g.method_25294(x + w - 2, y + 1, x + w - 1, y + 2, border);
        g.method_25294(x + 1, y + h - 2, x + 2, y + h - 1, border);
        g.method_25294(x + w - 2, y + h - 2, x + w - 1, y + h - 1, border);
    }

    private static void drawRoundedRectTop(class_332 g, int x, int y, int w, int h, int col) {
        g.method_25294(x + 3, y, x + w - 3, y + h, col);
        g.method_25294(x, y + 3, x + w, y + h, col);
        g.method_25294(x + 1, y + 1, x + 3, y + 3, col);
        g.method_25294(x + w - 3, y + 1, x + w - 1, y + 3, col);
    }

    private static void drawFancyPanel(class_332 g, int x, int y, int w, int h, boolean isExpanded) {
        int borderCol;
        float progress;
        int row;
        int r = 3;
        for (row = 0; row < h; ++row) {
            progress = (float)row / (float)h;
            int bgColor = EnhancedBattleLogWidget.mixColors(PANEL_BG, PANEL_BG_GRADIENT, progress);
            int left = x;
            int right = x + w;
            int top = y + row;
            if (row < r) {
                inset = r - row;
                left = x + Math.max(0, inset - 1);
                right = x + w - Math.max(0, inset - 1);
            } else if (row >= h - r) {
                inset = r - (h - 1 - row);
                left = x + Math.max(0, inset - 1);
                right = x + w - Math.max(0, inset - 1);
            }
            g.method_25294(left, top, right, top + 1, bgColor);
        }
        g.method_25294(x + r, y, x + w - r, y + 1, BORDER_HIGHLIGHT);
        g.method_25294(x + r, y + h - 1, x + w - r, y + h, BORDER_COLOR);
        for (row = r; row < h - r; ++row) {
            progress = (float)row / (float)h;
            borderCol = EnhancedBattleLogWidget.mixColors(BORDER_HIGHLIGHT, BORDER_COLOR, progress);
            g.method_25294(x, y + row, x + 1, y + row + 1, borderCol);
        }
        for (row = r; row < h - r; ++row) {
            progress = (float)row / (float)h;
            borderCol = EnhancedBattleLogWidget.mixColors(BORDER_HIGHLIGHT, BORDER_COLOR, progress);
            g.method_25294(x + w - 1, y + row, x + w, y + row + 1, borderCol);
        }
        g.method_25294(x + 1, y + 1, x + 2, y + 2, BORDER_HIGHLIGHT);
        g.method_25294(x + w - 2, y + 1, x + w - 1, y + 2, BORDER_HIGHLIGHT);
        g.method_25294(x + 1, y + h - 2, x + 2, y + h - 1, BORDER_COLOR);
        g.method_25294(x + w - 2, y + h - 2, x + w - 1, y + h - 1, BORDER_COLOR);
        if (isExpanded) {
            int shadowY = y + 20;
            for (int i = 0; i < 3; ++i) {
                int alpha = 60 - i * 20;
                int shadowCol = EnhancedBattleLogWidget.color(8, 12, 24, alpha);
                g.method_25294(x + 2, shadowY + i, x + w - 2, shadowY + i + 1, shadowCol);
            }
        }
    }

    private static void drawFancyHeader(class_332 g, class_327 font, int x, int y, int w, boolean isExpanded) {
        int r = 3;
        for (int row = 0; row < 20; ++row) {
            float progress = (float)row / 20.0f;
            int headerCol = EnhancedBattleLogWidget.mixColors(HEADER_BG_LIGHT, HEADER_BG, progress);
            int left = x + 1;
            int right = x + w - 1;
            if (row < r) {
                int inset = r - row;
                left = x + Math.max(1, inset);
                right = x + w - Math.max(1, inset);
            }
            g.method_25294(left, y + row + 1, right, y + row + 2, headerCol);
        }
        g.method_25294(x + 4, y + 5, x + 6, y + 20 - 5, HEADER_ACCENT);
        EnhancedBattleLogWidget.drawScaledText(g, font, "BATTLE LOG", x + 10, y + 6, HEADER_TEXT, 0.9f);
        String indicator = isExpanded ? "\u25bc" : "\u25b2";
        int indicatorX = x + w - font.method_1727(indicator) - 6;
        g.method_25294(indicatorX - 2, y + 4, indicatorX + font.method_1727(indicator) + 2, y + 20 - 4, EnhancedBattleLogWidget.color(60, 80, 120, 40));
        g.method_51433(font, indicator, indicatorX, y + 6, EnhancedBattleLogWidget.color(180, 195, 220, 255), false);
        int sepY = y + 20 - 1;
        for (int i = 0; i < w - 4; ++i) {
            float progress = (float)i / (float)(w - 4);
            float intensity = (float)Math.sin((double)progress * Math.PI);
            int alpha = (int)(intensity * 80.0f);
            int sepCol = EnhancedBattleLogWidget.color(80, 110, 160, alpha);
            g.method_25294(x + 2 + i, sepY, x + 3 + i, sepY + 1, sepCol);
        }
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * ratio);
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static void drawScaledText(class_332 g, class_327 font, String text, int x, int y, int color, float scale) {
        g.method_51448().method_22903();
        g.method_51448().method_46416((float)x, (float)y, 0.0f);
        g.method_51448().method_22905(scale, scale, 1.0f);
        g.method_51433(font, text, 0, 0, color, true);
        g.method_51448().method_22909();
    }

    private static void enableScissor(class_332 graphics, int x, int y, int w, int h) {
        currentGraphics = graphics;
        graphics.method_44379(x, y, x + w, y + h);
    }

    private static void disableScissor(class_332 graphics) {
        graphics.method_44380();
        currentGraphics = null;
    }

    private static void enableScissor(int x, int y, int w, int h) {
        if (currentGraphics != null) {
            EnhancedBattleLogWidget.enableScissor(currentGraphics, x, y, w, h);
        } else {
            class_310 mc = class_310.method_1551();
            double scale = mc.method_22683().method_4495();
            RenderSystem.enableScissor((int)((int)((double)x * scale)), (int)((int)((double)(mc.method_22683().method_4502() - y - h) * scale)), (int)((int)((double)w * scale)), (int)((int)((double)h * scale)));
        }
    }

    private static void disableScissor() {
        if (currentGraphics != null) {
            EnhancedBattleLogWidget.disableScissor(currentGraphics);
        } else {
            RenderSystem.disableScissor();
        }
    }

    private static void handleInput(class_310 mc) {
        boolean isOverToggle;
        boolean isOverWidget;
        long handle = mc.method_22683().method_4490();
        int mouseX = (int)(mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489());
        int mouseY = (int)(mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506());
        boolean isMouseDown = GLFW.glfwGetMouseButton((long)handle, (int)0) == 1;
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        boolean bl = isOverWidget = mouseX >= widgetX && mouseX <= widgetX + widgetW && mouseY >= widgetY && mouseY <= widgetY + widgetH;
        if (!(isDragging || isResizing || isDraggingScrollbar)) {
            hoveredZone = EnhancedBattleLogWidget.getResizeZone(mouseX, mouseY);
            isOverScrollbar = EnhancedBattleLogWidget.isOverScrollbarArea(mouseX, mouseY);
        }
        boolean isOverHeader = isOverWidget && mouseY <= headerEndY;
        boolean bl2 = isOverToggle = isOverWidget && mouseX >= widgetX + widgetW - 20 && mouseY <= headerEndY;
        if (isMouseDown) {
            if (isDraggingScrollbar) {
                EnhancedBattleLogWidget.handleScrollbarDrag(mouseY);
            } else if (!wasMousePressed && isOverToggle) {
                BattleExtrasConfig.setBattleLogExpanded(!BattleExtrasConfig.isBattleLogExpanded());
                scrollOffset = 0;
                isFollowingBottom = true;
            } else if (!wasMousePressed && isOverScrollbar && contentHeight > visibleHeight) {
                isDraggingScrollbar = true;
                scrollbarDragStartY = mouseY;
                scrollbarDragStartOffset = scrollOffset;
                isFollowingBottom = false;
            } else if (!wasMousePressed && hoveredZone != ResizeZone.NONE) {
                isResizing = true;
                resizeZone = hoveredZone;
                resizeStartX = mouseX;
                resizeStartY = mouseY;
                resizeStartWidth = widgetW;
                resizeStartHeight = widgetH;
                resizeStartPanelX = widgetX;
                resizeStartPanelY = widgetY;
            } else if (isResizing) {
                EnhancedBattleLogWidget.handleResize(mouseX, mouseY, screenWidth, screenHeight);
            } else if (!wasMousePressed && isOverHeader && !isOverToggle) {
                isDragging = true;
                dragOffsetX = mouseX - widgetX;
                dragOffsetY = mouseY - widgetY;
            } else if (isDragging) {
                int newX = Math.max(0, Math.min(screenWidth - widgetW, mouseX - dragOffsetX));
                int newY = Math.max(0, Math.min(screenHeight - widgetH, mouseY - dragOffsetY));
                BattleExtrasConfig.setBattleLogPosition(newX, newY);
            }
        } else {
            isDragging = false;
            isResizing = false;
            isDraggingScrollbar = false;
        }
        wasMousePressed = isMouseDown;
    }

    private static boolean isOverScrollbarArea(int mouseX, int mouseY) {
        if (contentHeight <= visibleHeight) {
            return false;
        }
        return mouseX >= scrollbarX - 3 && mouseX <= scrollbarX + 4 + 6 && mouseY >= scrollbarY && mouseY <= scrollbarY + scrollbarHeight;
    }

    private static void handleScrollbarDrag(int mouseY) {
        int deltaY = mouseY - scrollbarDragStartY;
        int maxScroll = Math.max(0, contentHeight - visibleHeight);
        if (maxScroll <= 0 || scrollbarHeight <= 0) {
            return;
        }
        int scrollableTrack = scrollbarHeight - scrollbarThumbHeight;
        if (scrollableTrack <= 0) {
            return;
        }
        int scrollDelta = (int)((float)deltaY / (float)scrollableTrack * (float)maxScroll);
        scrollOffset = Math.max(0, Math.min(maxScroll, scrollbarDragStartOffset + scrollDelta));
        isFollowingBottom = scrollOffset >= maxScroll - 5;
    }

    private static ResizeZone getResizeZone(int mouseX, int mouseY) {
        boolean withinY;
        if (!BattleExtrasConfig.isBattleLogExpanded()) {
            return ResizeZone.NONE;
        }
        int x = widgetX;
        int y = widgetY;
        int w = widgetW;
        int h = widgetH;
        int cornerSize = 10;
        boolean nearLeft = mouseX >= x - 6 && mouseX <= x + cornerSize;
        boolean nearRight = mouseX >= x + w - cornerSize && mouseX <= x + w + 6;
        boolean nearTop = mouseY >= y - 6 && mouseY <= y + cornerSize;
        boolean nearBottom = mouseY >= y + h - cornerSize && mouseY <= y + h + 6;
        boolean onLeftEdge = mouseX >= x - 4 && mouseX <= x + 2;
        boolean onRightEdge = mouseX >= x + w - 2 && mouseX <= x + w + 4;
        boolean onTopEdge = mouseY >= y - 4 && mouseY <= y + 2;
        boolean onBottomEdge = mouseY >= y + h - 2 && mouseY <= y + h + 4;
        boolean withinX = mouseX >= x - 6 && mouseX <= x + w + 6;
        boolean bl = withinY = mouseY >= y - 6 && mouseY <= y + h + 6;
        if (nearTop && nearLeft) {
            return ResizeZone.TOP_LEFT;
        }
        if (nearTop && nearRight) {
            return ResizeZone.TOP_RIGHT;
        }
        if (nearBottom && nearLeft) {
            return ResizeZone.BOTTOM_LEFT;
        }
        if (nearBottom && nearRight) {
            return ResizeZone.BOTTOM_RIGHT;
        }
        if (onLeftEdge && withinY && !nearTop && !nearBottom) {
            return ResizeZone.LEFT;
        }
        if (onRightEdge && withinY && !nearTop && !nearBottom) {
            return ResizeZone.RIGHT;
        }
        if (onTopEdge && withinX && !nearLeft && !nearRight) {
            return ResizeZone.TOP;
        }
        if (onBottomEdge && withinX && !nearLeft && !nearRight) {
            return ResizeZone.BOTTOM;
        }
        return ResizeZone.NONE;
    }

    private static void handleResize(int mouseX, int mouseY, int screenWidth, int screenHeight) {
        int deltaX = mouseX - resizeStartX;
        int deltaY = mouseY - resizeStartY;
        int newX = resizeStartPanelX;
        int newY = resizeStartPanelY;
        int newW = resizeStartWidth;
        int newH = resizeStartHeight;
        int minW = 120;
        int maxW = 400;
        int minH = 80;
        int maxH = 400;
        switch (resizeZone.ordinal()) {
            case 1: {
                newW = EnhancedBattleLogWidget.clamp(resizeStartWidth - deltaX, minW, maxW);
                newX = resizeStartPanelX + (resizeStartWidth - newW);
                break;
            }
            case 2: {
                newW = EnhancedBattleLogWidget.clamp(resizeStartWidth + deltaX, minW, maxW);
                break;
            }
            case 3: {
                newH = EnhancedBattleLogWidget.clamp(resizeStartHeight - deltaY, minH, maxH);
                newY = resizeStartPanelY + (resizeStartHeight - newH);
                break;
            }
            case 4: {
                newH = EnhancedBattleLogWidget.clamp(resizeStartHeight + deltaY, minH, maxH);
                break;
            }
            case 5: {
                newW = EnhancedBattleLogWidget.clamp(resizeStartWidth - deltaX, minW, maxW);
                newH = EnhancedBattleLogWidget.clamp(resizeStartHeight - deltaY, minH, maxH);
                newX = resizeStartPanelX + (resizeStartWidth - newW);
                newY = resizeStartPanelY + (resizeStartHeight - newH);
                break;
            }
            case 6: {
                newW = EnhancedBattleLogWidget.clamp(resizeStartWidth + deltaX, minW, maxW);
                newH = EnhancedBattleLogWidget.clamp(resizeStartHeight - deltaY, minH, maxH);
                newY = resizeStartPanelY + (resizeStartHeight - newH);
                break;
            }
            case 7: {
                newW = EnhancedBattleLogWidget.clamp(resizeStartWidth - deltaX, minW, maxW);
                newH = EnhancedBattleLogWidget.clamp(resizeStartHeight + deltaY, minH, maxH);
                newX = resizeStartPanelX + (resizeStartWidth - newW);
                break;
            }
            case 8: {
                newW = EnhancedBattleLogWidget.clamp(resizeStartWidth + deltaX, minW, maxW);
                newH = EnhancedBattleLogWidget.clamp(resizeStartHeight + deltaY, minH, maxH);
                break;
            }
        }
        newX = Math.max(0, Math.min(screenWidth - newW, newX));
        newY = Math.max(0, Math.min(screenHeight - newH, newY));
        BattleExtrasConfig.setBattleLogSize(newW, newH);
        BattleExtrasConfig.setBattleLogPosition(newX, newY);
    }

    private static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static boolean onScroll(double mouseX, double mouseY, double deltaY) {
        if (!BattleExtrasConfig.useEnhancedBattleLogStyle()) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 == null) {
            return false;
        }
        if (!mc.field_1755.getClass().getName().contains("BattleGUI")) {
            return false;
        }
        if (CobblemonClient.INSTANCE.getBattle() == null) {
            return false;
        }
        if (CobblemonClient.INSTANCE.getBattle().getMinimised()) {
            return false;
        }
        if (!BattleExtrasConfig.isBattleLogExpanded()) {
            return false;
        }
        if (widgetW <= 0 || widgetH <= 0) {
            return false;
        }
        int scaledX = (int)(mouseX * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489());
        int scaledY = (int)(mouseY * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506());
        if (scaledX < widgetX || scaledX > widgetX + widgetW || scaledY < widgetY || scaledY > widgetY + widgetH) {
            return false;
        }
        return EnhancedBattleLogWidget.doScroll(deltaY);
    }

    public static boolean onScrollScreen(double mouseX, double mouseY, double deltaY) {
        if (!BattleExtrasConfig.useEnhancedBattleLogStyle()) {
            return false;
        }
        if (CobblemonClient.INSTANCE.getBattle() == null) {
            return false;
        }
        if (CobblemonClient.INSTANCE.getBattle().getMinimised()) {
            return false;
        }
        if (!BattleExtrasConfig.isBattleLogExpanded()) {
            return false;
        }
        if (widgetW <= 0 || widgetH <= 0) {
            return false;
        }
        int scaledX = (int)mouseX;
        int scaledY = (int)mouseY;
        if (scaledX < widgetX || scaledX > widgetX + widgetW || scaledY < widgetY || scaledY > widgetY + widgetH) {
            return false;
        }
        return EnhancedBattleLogWidget.doScroll(deltaY);
    }

    private static boolean doScroll(double deltaY) {
        if (contentHeight > visibleHeight) {
            int scrollAmount = lineHeight * 3 * (deltaY > 0.0 ? -1 : 1);
            int maxScroll = Math.max(0, contentHeight - visibleHeight);
            scrollOffset = Math.max(0, Math.min(maxScroll, scrollOffset + scrollAmount));
            isFollowingBottom = scrollOffset >= maxScroll - 5;
            return true;
        }
        return false;
    }

    static {
        isDraggingScrollbar = false;
        scrollbarDragStartY = 0;
        scrollbarDragStartOffset = 0;
        hoveredZone = ResizeZone.NONE;
        isOverScrollbar = false;
        lineHeight = 11;
        currentGraphics = null;
    }

    private static enum ResizeZone {
        NONE,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

