/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.battlelog;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.battlelog.BattleLogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamageTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DamageTracker");
    private static final Map<UUID, Float> hpPercentages = new ConcurrentHashMap<UUID, Float>();
    private static final Map<UUID, String> pokemonNames = new ConcurrentHashMap<UUID, String>();
    private static final float MIN_CHANGE_THRESHOLD = 0.5f;

    public static void initializeHpFromSwitch(UUID pokemonUuid, String pokemonName, float currentHp, float maxHp) {
        if (pokemonUuid == null || maxHp <= 0.0f) {
            return;
        }
        float hpPercent = currentHp / maxHp * 100.0f;
        hpPercentages.put(pokemonUuid, Float.valueOf(hpPercent));
        pokemonNames.put(pokemonUuid, pokemonName);
        CobblemonBattleInfoClient.debug("[DamageTracker] Initialized {} ({}): {}/{}  HP = {}%", pokemonName, pokemonUuid, Float.valueOf(currentHp), Float.valueOf(maxHp), String.format("%.1f", Float.valueOf(hpPercent)));
    }

    public static void recordHpChange(UUID pokemonUuid, float newHpPercent) {
        if (pokemonUuid == null) {
            return;
        }
        Float oldPercent = hpPercentages.get(pokemonUuid);
        if (oldPercent == null) {
            hpPercentages.put(pokemonUuid, Float.valueOf(newHpPercent));
            return;
        }
        float delta = newHpPercent - oldPercent.floatValue();
        if (Math.abs(delta) >= 0.5f) {
            String pokemonName = pokemonNames.getOrDefault(pokemonUuid, "Pokemon");
            boolean isHealing = delta > 0.0f;
            BattleLogManager.addHpChangeEntry(pokemonName, delta, isHealing);
            CobblemonBattleInfoClient.debug("[DamageTracker] {} HP: {}% \u2192 {}% ({}{}%)", pokemonName, String.format("%.1f", oldPercent), String.format("%.1f", Float.valueOf(newHpPercent)), isHealing ? "+" : "", String.format("%.1f", Float.valueOf(delta)));
        }
        hpPercentages.put(pokemonUuid, Float.valueOf(newHpPercent));
    }

    public static void recordHpChange(UUID pokemonUuid, float currentHp, float maxHp) {
        if (maxHp <= 0.0f) {
            return;
        }
        float hpPercent = currentHp / maxHp * 100.0f;
        DamageTracker.recordHpChange(pokemonUuid, hpPercent);
    }

    public static void clearPokemon(UUID pokemonUuid) {
        hpPercentages.remove(pokemonUuid);
        pokemonNames.remove(pokemonUuid);
    }

    public static void clear() {
        hpPercentages.clear();
        pokemonNames.clear();
        CobblemonBattleInfoClient.debug("[DamageTracker] Cleared all HP tracking", new Object[0]);
    }

    public static void registerPokemon(UUID pokemonUuid, String pokemonName) {
        if (pokemonUuid != null && pokemonName != null) {
            pokemonNames.put(pokemonUuid, pokemonName);
        }
    }

    public static Float getHpPercent(UUID pokemonUuid) {
        return hpPercentages.get(pokemonUuid);
    }
}

