/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleOpacityHelper;
import name.modid.client.BattleSideHelper;
import name.modid.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class TypeIconRenderer {
    private static final class_2960 TYPE_SPRITE_SHEET = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
    private static final String MEGA_SHOWDOWN_TERA_PATH = "mega_showdown:textures/gui/summary/tera_types/";
    private static final boolean MEGA_SHOWDOWN_LOADED = Services.PLATFORM.isModLoaded("mega_showdown");
    private static final class_2960 MEGA_ICON = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/mega_icon.png");
    private static final int MEGA_ICON_SIZE = 64;
    private static final int MEGA_ICON_DISPLAY_SIZE = 8;
    private static int MEGA_ICON_OFFSET_X_PLAYER = 14;
    private static int MEGA_ICON_OFFSET_Y_PLAYER = -15;
    private static int MEGA_ICON_OFFSET_X_OPPONENT = 30;
    private static int MEGA_ICON_OFFSET_Y_OPPONENT = -15;
    private static int MEGA_ICON_OFFSET_X_OPPONENT_SINGLE = 15;
    private static int MEGA_ICON_OFFSET_Y_OPPONENT_SINGLE = -15;
    private static final int ICON_WIDTH = 36;
    private static final int ICON_HEIGHT = 36;
    private static final int SPRITE_SHEET_WIDTH = 648;
    private static final int SPRITE_SHEET_HEIGHT = 36;
    private static final class_2960 TYPELESS_ICON = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/typeless.png");
    private static final int TYPELESS_ICON_SIZE = 36;
    private static final int TERA_ICON_SIZE = 32;
    private static final int DISPLAY_SIZE = 14;
    private static final int TERA_DISPLAY_SIZE = 18;
    private static final int ICON_SPACING = 1;

    public static void init() {
        if (!Services.PLATFORM.isModLoaded("cobblemon")) {
            CobblemonBattleInfoClient.debug("Cobblemon not found, type icons disabled", new Object[0]);
            return;
        }
        Services.EVENTS.registerHudRender((guiGraphics, tickDelta) -> {
            try {
                TypeIconRenderer.renderTypeIcons(guiGraphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Type icon renderer initialized", new Object[0]);
    }

    private static void renderTypeIcons(class_332 gui) {
        if (!BattleExtrasConfig.isTypeIconsEnabled()) {
            return;
        }
        if (BattleExtrasConfig.isHideBattleTilesEnabled()) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        boolean isCompact = battle.getBattleFormat().getBattleType().getPokemonPerSide() > 1;
        float opacity = BattleOpacityHelper.getBattleOpacity();
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int HORIZONTAL_INSET = 12;
        int VERTICAL_INSET = 10;
        int VERTICAL_SPACING = 40;
        int COMPACT_VERTICAL_SPACING = 30;
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        int playerSlot = 0;
        for (Object actor : playerSide.getActors()) {
            for (Object activePokemon : actor.getActivePokemon()) {
                int baseY;
                int baseX;
                ClientBattlePokemon battlePokemon = activePokemon.getBattlePokemon();
                if (battlePokemon == null) continue;
                String pokemonName = battlePokemon.getSpecies().getName();
                String pokemonUUID = battlePokemon.getUuid().toString();
                boolean isMegaEvolved = BattleMessageSubscriber.isMegaEvolved("player", pokemonName.toLowerCase());
                if (!isMegaEvolved) {
                    Object formName;
                    try {
                        Method getNameMethod;
                        Method getFormMethod = battlePokemon.getClass().getMethod("getForm", new Class[0]);
                        Object form = getFormMethod.invoke((Object)battlePokemon, new Object[0]);
                        if (form != null && (formName = (String)(getNameMethod = form.getClass().getMethod("getName", new Class[0])).invoke(form, new Object[0])) != null && ((String)formName).toLowerCase().contains("mega")) {
                            isMegaEvolved = true;
                        }
                    }
                    catch (Exception getFormMethod) {
                        // empty catch block
                    }
                    if (!isMegaEvolved) {
                        try {
                            String formStr;
                            Method getFormMethod;
                            Method getPropsMethod = battlePokemon.getClass().getMethod("getProperties", new Class[0]);
                            Object props = getPropsMethod.invoke((Object)battlePokemon, new Object[0]);
                            if (props != null && (formName = (getFormMethod = props.getClass().getMethod("getForm", new Class[0])).invoke(props, new Object[0])) != null && (formStr = formName.toString()).toLowerCase().contains("mega")) {
                                isMegaEvolved = true;
                            }
                        }
                        catch (Exception getPropsMethod) {
                            // empty catch block
                        }
                    }
                    if (!isMegaEvolved) {
                        try {
                            String aspectsStr;
                            Method getAspectsMethod = battlePokemon.getClass().getMethod("getAspects", new Class[0]);
                            Object aspects = getAspectsMethod.invoke((Object)battlePokemon, new Object[0]);
                            if (aspects != null && (aspectsStr = aspects.toString().toLowerCase()).contains("mega")) {
                                isMegaEvolved = true;
                            }
                        }
                        catch (Exception getAspectsMethod) {
                            // empty catch block
                        }
                    }
                }
                List<ElementalType> displayTypes = TypeIconRenderer.getDisplayTypes(battlePokemon, pokemonName, "player", pokemonUUID);
                if (isCompact) {
                    baseX = 2;
                    baseY = 10 + playerSlot * 30 + 5;
                } else {
                    baseX = 12;
                    baseY = 10 + playerSlot * 40 + 40;
                }
                boolean isTerastallized = BattleMessageSubscriber.isTerastallized("player", pokemonName);
                if (displayTypes == null) {
                    TypeIconRenderer.renderStellarType(gui, baseX, baseY, opacity);
                    if (isMegaEvolved) {
                        TypeIconRenderer.renderMegaIcon(gui, baseX, baseY, opacity, true, 1);
                    }
                } else if (displayTypes.isEmpty() && TypeIconRenderer.isTypeless("player", pokemonName)) {
                    TypeIconRenderer.renderTypelessIcon(gui, baseX, baseY, opacity);
                    if (isMegaEvolved) {
                        TypeIconRenderer.renderMegaIcon(gui, baseX, baseY, opacity, true, 1);
                    }
                } else {
                    if (isCompact) {
                        TypeIconRenderer.renderTypesColumn(gui, displayTypes, baseX, baseY, opacity, isTerastallized);
                    } else {
                        TypeIconRenderer.renderTypesRow(gui, displayTypes, baseX, baseY, opacity, isTerastallized);
                    }
                    if (isMegaEvolved) {
                        TypeIconRenderer.renderMegaIcon(gui, baseX, baseY, opacity, true, displayTypes.size());
                    }
                }
                ++playerSlot;
            }
        }
        int totalOpponentPokemon = 0;
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                if (activePokemon.getBattlePokemon() == null) continue;
                ++totalOpponentPokemon;
            }
        }
        int opponentSlot = 0;
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                int baseY;
                int baseX;
                ClientBattlePokemon battlePokemon = activePokemon.getBattlePokemon();
                if (battlePokemon == null) continue;
                String pokemonName = battlePokemon.getSpecies().getName();
                String pokemonUUID = battlePokemon.getUuid().toString();
                boolean isMegaEvolved = BattleMessageSubscriber.isMegaEvolved("opponent", pokemonName.toLowerCase());
                if (!isMegaEvolved) {
                    Object formName;
                    try {
                        Method getNameMethod;
                        Method getFormMethod = battlePokemon.getClass().getMethod("getForm", new Class[0]);
                        Object form = getFormMethod.invoke((Object)battlePokemon, new Object[0]);
                        if (form != null && (formName = (String)(getNameMethod = form.getClass().getMethod("getName", new Class[0])).invoke(form, new Object[0])) != null && ((String)formName).toLowerCase().contains("mega")) {
                            isMegaEvolved = true;
                        }
                    }
                    catch (Exception getFormMethod) {
                        // empty catch block
                    }
                    if (!isMegaEvolved) {
                        try {
                            String formStr;
                            Method getFormMethod;
                            Method getPropsMethod = battlePokemon.getClass().getMethod("getProperties", new Class[0]);
                            Object props = getPropsMethod.invoke((Object)battlePokemon, new Object[0]);
                            if (props != null && (formName = (getFormMethod = props.getClass().getMethod("getForm", new Class[0])).invoke(props, new Object[0])) != null && (formStr = formName.toString()).toLowerCase().contains("mega")) {
                                isMegaEvolved = true;
                            }
                        }
                        catch (Exception getPropsMethod) {
                            // empty catch block
                        }
                    }
                    if (!isMegaEvolved) {
                        try {
                            String aspectsStr;
                            Method getAspectsMethod = battlePokemon.getClass().getMethod("getAspects", new Class[0]);
                            Object aspects = getAspectsMethod.invoke((Object)battlePokemon, new Object[0]);
                            if (aspects != null && (aspectsStr = aspects.toString().toLowerCase()).contains("mega")) {
                                isMegaEvolved = true;
                            }
                        }
                        catch (Exception getAspectsMethod) {
                            // empty catch block
                        }
                    }
                }
                List<ElementalType> displayTypes = TypeIconRenderer.getDisplayTypes(battlePokemon, pokemonName, "opponent", pokemonUUID);
                if (isCompact) {
                    int reversedSlot = totalOpponentPokemon - opponentSlot - 1;
                    baseX = screenWidth - 12;
                    baseY = 10 + reversedSlot * 30 + 5;
                } else {
                    baseX = screenWidth - 15;
                    baseY = 10 + opponentSlot * 40 + 40;
                }
                boolean isTerastallized = BattleMessageSubscriber.isTerastallized("opponent", pokemonName);
                if (isMegaEvolved) {
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] OPPONENT Pokemon: {} - MEGA DETECTED!", pokemonName);
                }
                if (displayTypes == null) {
                    TypeIconRenderer.renderStellarTypeReversed(gui, baseX, baseY, opacity);
                    if (isMegaEvolved) {
                        TypeIconRenderer.renderMegaIcon(gui, baseX, baseY, opacity, false, 1);
                    }
                } else if (displayTypes.isEmpty() && TypeIconRenderer.isTypeless("opponent", pokemonName)) {
                    TypeIconRenderer.renderTypelessIconReversed(gui, baseX, baseY, opacity);
                    if (isMegaEvolved) {
                        TypeIconRenderer.renderMegaIcon(gui, baseX, baseY, opacity, false, 1);
                    }
                } else {
                    if (isCompact) {
                        TypeIconRenderer.renderTypesColumn(gui, displayTypes, baseX, baseY, opacity, isTerastallized);
                    } else {
                        TypeIconRenderer.renderTypesRowReversed(gui, displayTypes, baseX, baseY, opacity, isTerastallized);
                    }
                    if (isMegaEvolved) {
                        TypeIconRenderer.renderMegaIcon(gui, baseX, baseY, opacity, false, displayTypes.size());
                    }
                }
                ++opponentSlot;
            }
        }
    }

    public static List<ElementalType> getDisplayTypes(Object battlePokemon, String pokemonName) {
        return TypeIconRenderer.getDisplayTypes(battlePokemon, pokemonName, null, null);
    }

    public static List<ElementalType> getDisplayTypes(Object battlePokemon, String pokemonName, String side) {
        return TypeIconRenderer.getDisplayTypes(battlePokemon, pokemonName, side, null);
    }

    public static List<ElementalType> getDisplayTypes(Object battlePokemon, String pokemonName, String side, String pokemonUUID) {
        ElementalType addType;
        String addedType;
        ArrayList<ElementalType> baseTypes;
        Object form;
        Method getForm;
        ElementalType normalType;
        ArrayList<ElementalType> result;
        block116: {
            List<ElementalType> entityTypes;
            String meloettaForm;
            ElementalType normalType2;
            List<ElementalType> targetTypes;
            ElementalType transformType;
            ElementalType waterType;
            result = new ArrayList<ElementalType>();
            String teraType = BattleMessageSubscriber.getTeraType(side, pokemonName);
            if (teraType != null && !teraType.isEmpty()) {
                if (teraType.equalsIgnoreCase("Stellar")) {
                    return null;
                }
                ElementalType teraElementType = TypeIconRenderer.stringToElementalType(teraType);
                if (teraElementType != null) {
                    result.add(teraElementType);
                    return result;
                }
            }
            if (BattleMessageSubscriber.isSoaked(side, pokemonName) && (waterType = TypeIconRenderer.stringToElementalType("Water")) != null) {
                ElementalType addType2;
                result.add(waterType);
                String addedType3 = BattleMessageSubscriber.getAddedType(side, pokemonName);
                if (addedType3 != null && !addedType3.isEmpty() && (addType2 = TypeIconRenderer.stringToElementalType(addedType3)) != null && !result.contains(addType2)) {
                    result.add(addType2);
                }
                return result;
            }
            String transformedType = BattleMessageSubscriber.getTransformedType(side, pokemonName);
            if (transformedType != null && !transformedType.isEmpty() && (transformType = TypeIconRenderer.stringToElementalType(transformedType)) != null) {
                ElementalType addType3;
                result.add(transformType);
                CobblemonBattleInfoClient.debug("[TypeIconRenderer] Found transformed type {} for Pokemon '{}' side '{}'", transformedType, pokemonName, side);
                String addedType4 = BattleMessageSubscriber.getAddedType(side, pokemonName);
                if (addedType4 != null && !addedType4.isEmpty() && (addType3 = TypeIconRenderer.stringToElementalType(addedType4)) != null && !result.contains(addType3)) {
                    result.add(addType3);
                }
                return result;
            }
            String reflectTarget = BattleMessageSubscriber.getReflectTypeTarget(pokemonName);
            if (reflectTarget != null && !reflectTarget.isEmpty() && (targetTypes = TypeIconRenderer.getTargetTypes(reflectTarget)) != null && !targetTypes.isEmpty()) {
                result.addAll(targetTypes);
                return result;
            }
            boolean isMegaEvolved = BattleMessageSubscriber.isMegaEvolved(side, pokemonName != null ? pokemonName.toLowerCase() : "");
            Object megaFormName = null;
            if (!isMegaEvolved) {
                Object formName;
                try {
                    Method formNameMethod;
                    Method getForm2 = battlePokemon.getClass().getMethod("getForm", new Class[0]);
                    Object form2 = getForm2.invoke(battlePokemon, new Object[0]);
                    if (form2 != null && (formName = (String)(formNameMethod = form2.getClass().getMethod("getName", new Class[0])).invoke(form2, new Object[0])) != null && ((String)formName).toLowerCase().contains("mega")) {
                        isMegaEvolved = true;
                        megaFormName = formName;
                    }
                }
                catch (Throwable getForm2) {
                    // empty catch block
                }
                if (!isMegaEvolved) {
                    try {
                        String formStr;
                        Method getFormMethod;
                        Method getProps = battlePokemon.getClass().getMethod("getProperties", new Class[0]);
                        Iterator<ElementalType> props = getProps.invoke(battlePokemon, new Object[0]);
                        if (props != null && (formName = (getFormMethod = props.getClass().getMethod("getForm", new Class[0])).invoke((Object)props, new Object[0])) != null && (formStr = formName.toString()).toLowerCase().contains("mega")) {
                            isMegaEvolved = true;
                            megaFormName = formStr;
                        }
                    }
                    catch (Throwable getProps) {
                        // empty catch block
                    }
                }
            }
            if (isMegaEvolved) {
                List<ElementalType> entityFormTypes = TypeIconRenderer.getTypesFromPokemonEntity(pokemonUUID, pokemonName);
                if (entityFormTypes != null && !entityFormTypes.isEmpty()) {
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} mega types from Pokemon entity for {} (UUID: {})", entityFormTypes.size(), pokemonName, pokemonUUID);
                    if (BattleMessageSubscriber.isRoosted(side, pokemonName)) {
                        for (ElementalType type2 : entityFormTypes) {
                            if (type2.getName().equalsIgnoreCase("flying")) continue;
                            result.add(type2);
                        }
                        if (result.isEmpty() && (normalType2 = TypeIconRenderer.stringToElementalType("Normal")) != null) {
                            result.add(normalType2);
                        }
                    } else {
                        result.addAll(entityFormTypes);
                    }
                    return result;
                }
                try {
                    Method getForm3 = battlePokemon.getClass().getMethod("getForm", new Class[0]);
                    Iterator<String> form3 = getForm3.invoke(battlePokemon, new Object[0]);
                    if (form3 != null) {
                        Method getTypes = form3.getClass().getMethod("getTypes", new Class[0]);
                        Object types = getTypes.invoke(form3, new Object[0]);
                        if (types instanceof Iterable) {
                            for (Object type3 : (Iterable)types) {
                                if (!(type3 instanceof ElementalType)) continue;
                                result.add((ElementalType)type3);
                            }
                        }
                        if (!result.isEmpty()) {
                            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} mega types from form for {} (form={})", result.size(), pokemonName, megaFormName);
                            if (BattleMessageSubscriber.isRoosted(side, pokemonName)) {
                                ElementalType normalType3;
                                result.removeIf(type -> type.getName().equalsIgnoreCase("flying"));
                                if (result.isEmpty() && (normalType3 = TypeIconRenderer.stringToElementalType("Normal")) != null) {
                                    result.add(normalType3);
                                }
                            }
                            return result;
                        }
                    }
                }
                catch (Throwable e) {
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to get mega form types: {}", e.getMessage());
                }
                List<String> megaTypes = BattleMessageSubscriber.getMegaTypes(side, pokemonName);
                if (megaTypes != null && !megaTypes.isEmpty()) {
                    for (String typeName : megaTypes) {
                        ElementalType megaType = TypeIconRenderer.stringToElementalType(typeName);
                        if (megaType == null) continue;
                        result.add(megaType);
                    }
                    if (!result.isEmpty()) {
                        if (BattleMessageSubscriber.isRoosted(side, pokemonName)) {
                            result.removeIf(type -> type.getName().equalsIgnoreCase("flying"));
                            if (result.isEmpty() && (normalType = TypeIconRenderer.stringToElementalType("Normal")) != null) {
                                result.add(normalType);
                            }
                        }
                        return result;
                    }
                }
                try {
                    getForm = battlePokemon.getClass().getMethod("getForm", new Class[0]);
                    form = getForm.invoke(battlePokemon, new Object[0]);
                    if (form != null) {
                        Method getTypes = form.getClass().getMethod("getTypes", new Class[0]);
                        Object types = getTypes.invoke(form, new Object[0]);
                        if (types instanceof Iterable) {
                            for (Object e : (Iterable)types) {
                                if (!(e instanceof ElementalType)) continue;
                                result.add((ElementalType)e);
                            }
                        }
                        if (!result.isEmpty()) {
                            if (BattleMessageSubscriber.isRoosted(side, pokemonName)) {
                                ElementalType normalType4;
                                result.removeIf(type -> type.getName().equalsIgnoreCase("flying"));
                                if (result.isEmpty() && (normalType4 = TypeIconRenderer.stringToElementalType("Normal")) != null) {
                                    result.add(normalType4);
                                }
                            }
                            return result;
                        }
                    }
                }
                catch (Throwable e) {
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to get mega form types: {}", e.getMessage());
                }
            }
            if ((meloettaForm = BattleMessageSubscriber.getMeloettaForm(pokemonName)) != null && pokemonName.toLowerCase().contains("meloetta")) {
                if (meloettaForm.equals("pirouette")) {
                    ElementalType normalType22 = TypeIconRenderer.stringToElementalType("Normal");
                    ElementalType fightingType = TypeIconRenderer.stringToElementalType("Fighting");
                    if (normalType22 != null) {
                        result.add(normalType22);
                    }
                    if (fightingType != null) {
                        result.add(fightingType);
                    }
                    return result;
                }
                if (meloettaForm.equals("aria")) {
                    normalType2 = TypeIconRenderer.stringToElementalType("Normal");
                    ElementalType psychicType = TypeIconRenderer.stringToElementalType("Psychic");
                    if (normalType2 != null) {
                        result.add(normalType2);
                    }
                    if (psychicType != null) {
                        result.add(psychicType);
                    }
                    return result;
                }
            }
            baseTypes = new ArrayList<ElementalType>();
            if (pokemonUUID != null && !pokemonUUID.isEmpty()) {
                try {
                    Class<?> randomizerClientClass = Class.forName("cobblemon.randomizer.client.RandomizerClient");
                    if ("opponent".equals(side)) {
                        Method getOpponentTypes;
                        ElementalType elementalType;
                        Method method;
                        int hasOpponentTypesStored;
                        Method hasWildTypes = randomizerClientClass.getMethod("hasWildPokemonTypes", new Class[0]);
                        boolean hasWildTypesStored = (Boolean)hasWildTypes.invoke(null, new Object[0]);
                        Method getWildTypes = randomizerClientClass.getMethod("getWildPokemonTypes", String.class);
                        String[] wildTypes = (String[])getWildTypes.invoke(null, pokemonUUID);
                        if (wildTypes != null && wildTypes.length > 0) {
                            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Found wild types for {} (UUID: {})", pokemonName, pokemonUUID);
                            for (String string : wildTypes) {
                                type = TypeIconRenderer.stringToElementalType(string);
                                if (type == null) continue;
                                baseTypes.add(type);
                            }
                        }
                        if (baseTypes.isEmpty() && (hasOpponentTypesStored = ((Boolean)(method = randomizerClientClass.getMethod("hasOpponentPokemonTypes", new Class[0])).invoke(null, new Object[0])).booleanValue()) != 0 && (elementalType = (ElementalType)(getOpponentTypes = randomizerClientClass.getMethod("getOpponentPokemonTypes", String.class)).invoke(null, pokemonUUID)) != null && ((String[])elementalType).length > 0) {
                            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Found PvP opponent types for {} (UUID: {})", pokemonName, pokemonUUID);
                            for (ElementalType typeName : elementalType) {
                                ElementalType type5 = TypeIconRenderer.stringToElementalType((String)typeName);
                                if (type5 == null) continue;
                                baseTypes.add(type5);
                            }
                        }
                    } else if ("player".equals(side)) {
                        Method getTypesForPokemon;
                        Object[] playerTypes;
                        Boolean isRunActive = (Boolean)randomizerClientClass.getMethod("isRunActive", new Class[0]).invoke(null, new Object[0]);
                        Boolean isRandomTypes = (Boolean)randomizerClientClass.getMethod("isRandomTypes", new Class[0]).invoke(null, new Object[0]);
                        if (isRunActive != null && isRunActive.booleanValue() && isRandomTypes != null && isRandomTypes.booleanValue() && (playerTypes = (String[])(getTypesForPokemon = randomizerClientClass.getMethod("getTypesForPokemon", String.class, String.class)).invoke(null, pokemonName, pokemonUUID)) != null && playerTypes.length > 0) {
                            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Found player's randomized types for {} (UUID: {}): {}", pokemonName, pokemonUUID, Arrays.toString(playerTypes));
                            for (Object object : playerTypes) {
                                type = TypeIconRenderer.stringToElementalType((String)object);
                                if (type == null) continue;
                                baseTypes.add(type);
                            }
                        }
                    }
                    if (!baseTypes.isEmpty()) {
                        ElementalType addType4;
                        String addedType2;
                        CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} randomized types for {} (UUID: {}, side: {})", baseTypes.size(), pokemonName, pokemonUUID, side);
                        if (BattleMessageSubscriber.isRoosted(side, pokemonName)) {
                            ElementalType normalType5;
                            baseTypes.removeIf(type -> type.getName().equalsIgnoreCase("flying"));
                            if (baseTypes.isEmpty() && (normalType5 = TypeIconRenderer.stringToElementalType("Normal")) != null) {
                                baseTypes.add(normalType5);
                            }
                        }
                        if ((addedType2 = BattleMessageSubscriber.getAddedType(side, pokemonName)) != null && !addedType2.isEmpty() && (addType4 = TypeIconRenderer.stringToElementalType(addedType2)) != null && !baseTypes.contains(addType4)) {
                            baseTypes.add(addType4);
                        }
                        result.addAll(baseTypes);
                        return result;
                    }
                }
                catch (ClassNotFoundException randomizerClientClass) {
                }
                catch (Throwable e) {
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to check randomizer types: {}", e.getMessage());
                }
            }
            if (pokemonUUID != null && !pokemonUUID.isEmpty() && (entityTypes = TypeIconRenderer.getTypesFromPokemonEntity(pokemonUUID, pokemonName)) != null && !entityTypes.isEmpty()) {
                baseTypes.addAll(entityTypes);
                CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} types from Pokemon entity for {} (UUID: {})", baseTypes.size(), pokemonName, pokemonUUID);
            }
            if (baseTypes.isEmpty()) {
                try {
                    Method getProperties = battlePokemon.getClass().getMethod("getProperties", new Class[0]);
                    Object properties = getProperties.invoke(battlePokemon, new Object[0]);
                    if (properties == null) break block116;
                    Method getFormMethod = properties.getClass().getMethod("getForm", new Class[0]);
                    Object formName = getFormMethod.invoke(properties, new Object[0]);
                    Method getSpeciesMethod = battlePokemon.getClass().getMethod("getSpecies", new Class[0]);
                    Object object = getSpeciesMethod.invoke(battlePokemon, new Object[0]);
                    if (formName == null || object == null) break block116;
                    String formNameStr = formName.toString();
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Found form '{}' for {}", formNameStr, pokemonName);
                    try {
                        Method getFormByName = object.getClass().getMethod("getForm", String.class);
                        Object object2 = getFormByName.invoke(object, formNameStr);
                        if (object2 != null) {
                            Method getTypes = object2.getClass().getMethod("getTypes", new Class[0]);
                            Object types = getTypes.invoke(object2, new Object[0]);
                            if (types instanceof Iterable) {
                                for (Object type6 : (Iterable)types) {
                                    if (!(type6 instanceof ElementalType)) continue;
                                    baseTypes.add((ElementalType)type6);
                                }
                            }
                            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} types from species.getForm('{}') for {}", baseTypes.size(), formNameStr, pokemonName);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Method method = object.getClass().getMethod("getForms", new Class[0]);
                            Object forms = method.invoke(object, new Object[0]);
                            if (!(forms instanceof Iterable)) break block116;
                            for (Object form5 : (Iterable)forms) {
                                Method getName = form5.getClass().getMethod("getName", new Class[0]);
                                String name = getName.invoke(form5, new Object[0]).toString();
                                if (!name.equalsIgnoreCase(formNameStr)) continue;
                                Method getTypes = form5.getClass().getMethod("getTypes", new Class[0]);
                                Object types = getTypes.invoke(form5, new Object[0]);
                                if (types instanceof Iterable) {
                                    for (Object type7 : (Iterable)types) {
                                        if (!(type7 instanceof ElementalType)) continue;
                                        baseTypes.add((ElementalType)type7);
                                    }
                                }
                                CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} types from iterating forms for {}", baseTypes.size(), pokemonName);
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to iterate forms: {}", throwable.getMessage());
                        }
                    }
                }
                catch (Throwable e) {
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to get form from properties: {}", e.getMessage());
                }
            }
        }
        if (baseTypes.isEmpty()) {
            String[] pokemonGetterMethods;
            Object pokemon = null;
            for (String string : pokemonGetterMethods = new String[]{"getEffectedPokemon", "effectedPokemon", "getPokemon", "pokemon", "getOriginalPokemon"}) {
                try {
                    Method method = battlePokemon.getClass().getMethod(string, new Class[0]);
                    pokemon = method.invoke(battlePokemon, new Object[0]);
                    if (pokemon == null) continue;
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got Pokemon via {} for {}", string, pokemonName);
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (pokemon != null) {
                try {
                    Method getForm4 = pokemon.getClass().getMethod("getForm", new Class[0]);
                    Object form6 = getForm4.invoke(pokemon, new Object[0]);
                    if (form6 != null) {
                        Method getTypes = form6.getClass().getMethod("getTypes", new Class[0]);
                        Object object = getTypes.invoke(form6, new Object[0]);
                        if (object instanceof Iterable) {
                            for (Object type8 : (Iterable)object) {
                                if (!(type8 instanceof ElementalType)) continue;
                                baseTypes.add((ElementalType)type8);
                            }
                        }
                        CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} types from Pokemon.getForm().getTypes() for {}", baseTypes.size(), pokemonName);
                    }
                }
                catch (Throwable e) {
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to get form types from Pokemon: {}", e.getMessage());
                }
            }
        }
        if (baseTypes.isEmpty()) {
            try {
                Method getTypes;
                Object types;
                getForm = battlePokemon.getClass().getMethod("getForm", new Class[0]);
                form = getForm.invoke(battlePokemon, new Object[0]);
                if (form != null && (types = (getTypes = form.getClass().getMethod("getTypes", new Class[0])).invoke(form, new Object[0])) instanceof Iterable) {
                    for (Object t : (Iterable)types) {
                        if (!(t instanceof ElementalType)) continue;
                        baseTypes.add((ElementalType)t);
                    }
                }
                CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} types from battlePokemon.getForm() for {}", baseTypes.size(), pokemonName);
            }
            catch (Throwable e) {
                CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to get form types from battlePokemon: {}", e.getMessage());
            }
        }
        if (baseTypes.isEmpty()) {
            try {
                Method getTypes;
                Object types;
                Method getSpecies = battlePokemon.getClass().getMethod("getSpecies", new Class[0]);
                Object species = getSpecies.invoke(battlePokemon, new Object[0]);
                if (species != null && (types = (getTypes = species.getClass().getMethod("getTypes", new Class[0])).invoke(species, new Object[0])) instanceof Iterable) {
                    for (Object t : (Iterable)types) {
                        if (!(t instanceof ElementalType)) continue;
                        baseTypes.add((ElementalType)t);
                    }
                }
                CobblemonBattleInfoClient.debug("[TypeIconRenderer] Got {} types from species for {}", baseTypes.size(), pokemonName);
            }
            catch (Throwable e) {
                CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to get species types for {}: {}", pokemonName, e.getMessage());
            }
        }
        if (BattleMessageSubscriber.isRoosted(side, pokemonName)) {
            for (ElementalType type9 : baseTypes) {
                if (type9.getName().equalsIgnoreCase("flying")) continue;
                result.add(type9);
            }
            if (result.isEmpty() && (normalType = TypeIconRenderer.stringToElementalType("Normal")) != null) {
                result.add(normalType);
            }
            if ((addedType = BattleMessageSubscriber.getAddedType(side, pokemonName)) != null && !addedType.isEmpty() && (addType = TypeIconRenderer.stringToElementalType(addedType)) != null && !result.contains(addType)) {
                result.add(addType);
            }
            return result;
        }
        if (BattleMessageSubscriber.hasBurnedUp(side, pokemonName)) {
            ElementalType addType5;
            String burnUpTransformedType = BattleMessageSubscriber.getTransformedType(side, pokemonName);
            if (burnUpTransformedType != null && !burnUpTransformedType.isEmpty()) {
                ElementalType newType = TypeIconRenderer.stringToElementalType(burnUpTransformedType);
                if (newType != null) {
                    result.add(newType);
                }
            } else {
                for (ElementalType type10 : baseTypes) {
                    if (type10.getName().equalsIgnoreCase("fire")) continue;
                    result.add(type10);
                }
            }
            String addedType2 = BattleMessageSubscriber.getAddedType(side, pokemonName);
            if (addedType2 != null && !addedType2.isEmpty() && (addType5 = TypeIconRenderer.stringToElementalType(addedType2)) != null && !result.contains(addType5)) {
                result.add(addType5);
            }
            return result;
        }
        if (BattleMessageSubscriber.hasDoubleShocked(side, pokemonName)) {
            for (ElementalType type2 : baseTypes) {
                if (type2.getName().equalsIgnoreCase("electric")) continue;
                result.add(type2);
            }
            addedType = BattleMessageSubscriber.getAddedType(side, pokemonName);
            if (addedType != null && !addedType.isEmpty() && (addType = TypeIconRenderer.stringToElementalType(addedType)) != null && !result.contains(addType)) {
                result.add(addType);
            }
            return result;
        }
        addedType = BattleMessageSubscriber.getAddedType(side, pokemonName);
        if (addedType != null && !addedType.isEmpty()) {
            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Adding {} type to {} - baseTypes size: {}, baseTypes: {}", addedType, pokemonName, baseTypes.size(), baseTypes);
            result.addAll(baseTypes);
            addType = TypeIconRenderer.stringToElementalType(addedType);
            if (addType != null && !result.contains(addType)) {
                result.add(addType);
            }
            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Final types for {} with added type: {}", pokemonName, result);
            return result;
        }
        return baseTypes;
    }

    private static List<ElementalType> getTargetTypes(String pokemonName) {
        ElementalType addType;
        ArrayList<ElementalType> result = new ArrayList<ElementalType>();
        String addedType = BattleMessageSubscriber.getAddedType(pokemonName);
        if (addedType != null && !addedType.isEmpty() && (addType = TypeIconRenderer.stringToElementalType(addedType)) != null) {
            result.add(addType);
        }
        return result;
    }

    public static ElementalType stringToElementalType(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        try {
            Class<?> elementalTypesClass = Class.forName("com.cobblemon.mod.common.api.types.ElementalTypes");
            Method getMethod = elementalTypesClass.getMethod("get", String.class);
            Object result = getMethod.invoke(null, typeName.toLowerCase());
            if (result instanceof ElementalType) {
                return (ElementalType)result;
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("Could not resolve type: {}", typeName);
        }
        return null;
    }

    private static List<ElementalType> getTypesFromPokemonEntity(String pokemonUUID, String pokemonName) {
        if (pokemonUUID == null || pokemonUUID.isEmpty()) {
            return null;
        }
        try {
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 == null) {
                return null;
            }
            UUID targetUUID = UUID.fromString(pokemonUUID);
            for (class_1297 entity : mc.field_1687.method_18112()) {
                if (entity == null || !entity.getClass().getName().contains("PokemonEntity")) continue;
                try {
                    Method getSecondaryTypeMethod;
                    Object secondaryType;
                    Method getUuidMethod;
                    UUID entityPokemonUUID;
                    Method getPokemonMethod = entity.getClass().getMethod("getPokemon", new Class[0]);
                    Object pokemonData = getPokemonMethod.invoke((Object)entity, new Object[0]);
                    if (pokemonData == null || (entityPokemonUUID = (UUID)(getUuidMethod = pokemonData.getClass().getMethod("getUuid", new Class[0])).invoke(pokemonData, new Object[0])) == null || !entityPokemonUUID.equals(targetUUID)) continue;
                    ArrayList<ElementalType> result = new ArrayList<ElementalType>();
                    Method getPrimaryTypeMethod = pokemonData.getClass().getMethod("getPrimaryType", new Class[0]);
                    Object primaryType = getPrimaryTypeMethod.invoke(pokemonData, new Object[0]);
                    if (primaryType instanceof ElementalType) {
                        result.add((ElementalType)primaryType);
                    }
                    if ((secondaryType = (getSecondaryTypeMethod = pokemonData.getClass().getMethod("getSecondaryType", new Class[0])).invoke(pokemonData, new Object[0])) instanceof ElementalType) {
                        result.add((ElementalType)secondaryType);
                    }
                    if (result.isEmpty()) continue;
                    CobblemonBattleInfoClient.debug("[TypeIconRenderer] Found Pokemon entity {} with UUID {}, got {} types from Pokemon object (may be randomized)", pokemonName, pokemonUUID, result.size());
                    return result;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable e) {
            CobblemonBattleInfoClient.debug("[TypeIconRenderer] Failed to find Pokemon entity for {}: {}", pokemonName, e.getMessage());
        }
        return null;
    }

    private static void renderTypesRow(class_332 gui, List<ElementalType> types, int x, int y, float opacity, boolean isTerastallized) {
        int offsetX = 0;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        int iconSize = isTerastallized ? 18 : 14;
        for (ElementalType type : types) {
            if (isTerastallized && MEGA_SHOWDOWN_LOADED) {
                String typeName = type.getName().toLowerCase();
                class_2960 teraIcon = class_2960.method_60654((String)(MEGA_SHOWDOWN_TERA_PATH + typeName + ".png"));
                gui.method_25293(teraIcon, x + offsetX, y, iconSize, iconSize, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                int textureX = type.getTextureXMultiplier() * 36;
                gui.method_25293(TYPE_SPRITE_SHEET, x + offsetX, y, iconSize, iconSize, (float)textureX, 0.0f, 36, 36, 648, 36);
            }
            offsetX += iconSize + 1;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderTypesColumn(class_332 gui, List<ElementalType> types, int x, int y, float opacity, boolean isTerastallized) {
        int offsetY = 0;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        int iconSize = 10;
        for (ElementalType type : types) {
            if (isTerastallized && MEGA_SHOWDOWN_LOADED) {
                String typeName = type.getName().toLowerCase();
                class_2960 teraIcon = class_2960.method_60654((String)(MEGA_SHOWDOWN_TERA_PATH + typeName + ".png"));
                gui.method_25293(teraIcon, x, y + offsetY, iconSize, iconSize, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                int textureX = type.getTextureXMultiplier() * 36;
                gui.method_25293(TYPE_SPRITE_SHEET, x, y + offsetY, iconSize, iconSize, (float)textureX, 0.0f, 36, 36, 648, 36);
            }
            offsetY += iconSize + 1;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderTypesRowReversed(class_332 gui, List<ElementalType> types, int x, int y, float opacity, boolean isTerastallized) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        int iconSize = isTerastallized ? 18 : 14;
        int offsetX = 0;
        for (int i = types.size() - 1; i >= 0; --i) {
            ElementalType type = types.get(i);
            if (isTerastallized && MEGA_SHOWDOWN_LOADED) {
                String typeName = type.getName().toLowerCase();
                class_2960 teraIcon = class_2960.method_60654((String)(MEGA_SHOWDOWN_TERA_PATH + typeName + ".png"));
                gui.method_25293(teraIcon, x - iconSize - offsetX, y, iconSize, iconSize, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                int textureX = type.getTextureXMultiplier() * 36;
                gui.method_25293(TYPE_SPRITE_SHEET, x - iconSize - offsetX, y, iconSize, iconSize, (float)textureX, 0.0f, 36, 36, 648, 36);
            }
            offsetX += iconSize + 1;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderStellarType(class_332 gui, int x, int y, float opacity) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        class_2960 stellarIcon = class_2960.method_60654((String)"mega_showdown:textures/gui/summary/tera_types/stellar.png");
        gui.method_25293(stellarIcon, x, y, 18, 18, 0.0f, 0.0f, 32, 32, 32, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderStellarTypeReversed(class_332 gui, int x, int y, float opacity) {
        TypeIconRenderer.renderStellarType(gui, x - 18, y, opacity);
    }

    private static boolean isTypeless(String side, String pokemonName) {
        return BattleMessageSubscriber.hasBurnedUp(side, pokemonName) || BattleMessageSubscriber.hasDoubleShocked(side, pokemonName);
    }

    private static void renderTypelessIcon(class_332 gui, int x, int y, float opacity) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        gui.method_25293(TYPELESS_ICON, x, y, 14, 14, 0.0f, 0.0f, 36, 36, 36, 36);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderTypelessIconReversed(class_332 gui, int x, int y, float opacity) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        gui.method_25293(TYPELESS_ICON, x - 14, y, 14, 14, 0.0f, 0.0f, 36, 36, 36, 36);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderMegaIcon(class_332 gui, int x, int y, float opacity, boolean isPlayerSide, int typeCount) {
        int iconX;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        int typeIconsWidth = typeCount * 14 + (typeCount - 1) * 1;
        int iconY = y + 3;
        if (isPlayerSide) {
            iconX = x - 8 - 2;
            if (typeCount == 1) {
                iconX += 14;
                iconY -= 15;
            } else if (typeCount == 2) {
                iconX += MEGA_ICON_OFFSET_X_PLAYER;
                iconY += MEGA_ICON_OFFSET_Y_PLAYER;
            }
        } else {
            iconX = x - typeIconsWidth - 8 - 2;
            if (typeCount == 1) {
                iconX += MEGA_ICON_OFFSET_X_OPPONENT_SINGLE;
                iconY += MEGA_ICON_OFFSET_Y_OPPONENT_SINGLE;
            } else if (typeCount == 2) {
                iconX += MEGA_ICON_OFFSET_X_OPPONENT;
                iconY += MEGA_ICON_OFFSET_Y_OPPONENT;
            }
        }
        gui.method_25293(MEGA_ICON, iconX, iconY, 8, 8, 0.0f, 0.0f, 64, 64, 64, 64);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

