/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.mojang.blaze3d.systems.RenderSystem;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleOpacityHelper;
import name.modid.platform.Services;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class TurnCounterRenderer {
    private static int currentTurn = 0;
    private static final class_2960 TURNBAR_TEXTURE = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/turnbar.png");
    private static final int TURNBAR_WIDTH = 80;
    private static final int TURNBAR_HEIGHT = 10;

    public static void init() {
        Services.EVENTS.registerHudRender((gui, tickDelta) -> {
            try {
                TurnCounterRenderer.render(gui);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Turn counter renderer initialized", new Object[0]);
    }

    public static void setTurn(int turn) {
        currentTurn = turn;
        CobblemonBattleInfoClient.debug("Turn counter set to: {}", turn);
    }

    public static int getCurrentTurn() {
        return currentTurn;
    }

    public static void reset() {
        currentTurn = 0;
    }

    private static void render(class_332 gui) {
        if (!BattleExtrasConfig.isTurnCounterEnabled()) {
            return;
        }
        if (CobblemonClient.INSTANCE.getBattle() == null) {
            return;
        }
        if (currentTurn <= 0) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        class_327 font = mc.field_1772;
        int screenWidth = mc.method_22683().method_4486();
        float opacity = BattleOpacityHelper.getBattleOpacity();
        class_5250 turnText = class_2561.method_43469((String)"battle.turn_counter", (Object[])new Object[]{currentTurn});
        String text = turnText.getString();
        int textWidth = font.method_1727(text);
        int barX = (screenWidth - 80) / 2;
        int barY = 5;
        RenderSystem.setShaderTexture((int)0, (class_2960)TURNBAR_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        gui.method_25290(TURNBAR_TEXTURE, barX, barY, 0.0f, 0.0f, 80, 10, 80, 10);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textColor = BattleOpacityHelper.applyOpacity(-1, opacity);
        int textX = barX + (80 - textWidth) / 2;
        int textY = barY + 1;
        gui.method_51433(font, text, textX, textY, textColor, true);
    }
}

