/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import name.modid.CobblemonBattleInfoClient;

public class RevealedBattleInfo {
    private static final Map<String, PokemonRevealedInfo> revealedInfo = new ConcurrentHashMap<String, PokemonRevealedInfo>();
    private static Object lastBattle = null;

    public static void onBattleStart(Object battle) {
        if (battle != lastBattle) {
            lastBattle = battle;
            revealedInfo.clear();
            CobblemonBattleInfoClient.debug("[RevealedBattleInfo] Cleared for new battle", new Object[0]);
        }
    }

    public static void onBattleEnd() {
        lastBattle = null;
        revealedInfo.clear();
    }

    public static void recordAbility(String side, String pokemonName, String abilityId, String displayName) {
        if (!"opponent".equals(side)) {
            return;
        }
        String key = RevealedBattleInfo.makeSidedKey(side, pokemonName);
        PokemonRevealedInfo info = revealedInfo.computeIfAbsent(key, k -> new PokemonRevealedInfo());
        info.setAbility(abilityId, displayName);
        CobblemonBattleInfoClient.debug("[RevealedBattleInfo] Recorded ability for {}: {} ({})", key, abilityId, displayName);
    }

    public static void recordHeldItem(String side, String pokemonName, String itemId, String displayName) {
        if (!"opponent".equals(side)) {
            return;
        }
        String key = RevealedBattleInfo.makeSidedKey(side, pokemonName);
        PokemonRevealedInfo info = revealedInfo.computeIfAbsent(key, k -> new PokemonRevealedInfo());
        info.setHeldItem(itemId, displayName);
        CobblemonBattleInfoClient.debug("[RevealedBattleInfo] Recorded item for {}: {} ({})", key, itemId, displayName);
    }

    public static void recordMove(String side, String pokemonName, String moveId, String displayName, String moveType) {
        if (!"opponent".equals(side)) {
            return;
        }
        if (RevealedBattleInfo.isMaxMove(moveId, displayName)) {
            return;
        }
        String key = RevealedBattleInfo.makeSidedKey(side, pokemonName);
        PokemonRevealedInfo info = revealedInfo.computeIfAbsent(key, k -> new PokemonRevealedInfo());
        info.addMove(moveId, displayName, moveType);
        CobblemonBattleInfoClient.debug("[RevealedBattleInfo] Recorded move for {}: {} ({}) type={}", key, moveId, displayName, moveType);
    }

    public static PokemonRevealedInfo getRevealedInfo(String pokemonName) {
        String key = RevealedBattleInfo.makeSidedKey("opponent", pokemonName);
        return revealedInfo.get(key);
    }

    public static boolean hasRevealedInfo(String pokemonName) {
        PokemonRevealedInfo info = RevealedBattleInfo.getRevealedInfo(pokemonName);
        return info != null && info.hasAnyInfo();
    }

    private static String makeSidedKey(String side, String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String safeSide = side == null || side.isEmpty() ? "unknown" : side.toLowerCase(Locale.ROOT);
        return safeSide + "_" + RevealedBattleInfo.normalizePokemonName(pokemonName);
    }

    private static String normalizePokemonName(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        return pokemonName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "");
    }

    private static boolean isMaxMove(String moveId, String displayName) {
        if (moveId != null && moveId.toLowerCase(Locale.ROOT).startsWith("max")) {
            return true;
        }
        if (displayName != null) {
            String name = displayName.toLowerCase(Locale.ROOT).trim();
            return name.startsWith("max ") || name.startsWith("g-max ");
        }
        return false;
    }

    public static class PokemonRevealedInfo {
        private String ability = null;
        private String abilityDisplay = null;
        private String heldItem = null;
        private String heldItemDisplay = null;
        private final List<MoveInfo> moves = new ArrayList<MoveInfo>();

        public String getAbility() {
            return this.ability;
        }

        public String getAbilityDisplay() {
            return this.abilityDisplay;
        }

        public String getHeldItem() {
            return this.heldItem;
        }

        public String getHeldItemDisplay() {
            return this.heldItemDisplay;
        }

        public List<MoveInfo> getMoves() {
            return Collections.unmodifiableList(this.moves);
        }

        public void setAbility(String abilityId, String displayName) {
            this.ability = abilityId;
            this.abilityDisplay = displayName;
        }

        public void setHeldItem(String itemId, String displayName) {
            this.heldItem = itemId;
            this.heldItemDisplay = displayName;
        }

        public void addMove(String moveId, String displayName, String type) {
            for (MoveInfo existing : this.moves) {
                if (existing.moveId == null || !existing.moveId.equalsIgnoreCase(moveId)) continue;
                return;
            }
            if (this.moves.size() < 4) {
                this.moves.add(new MoveInfo(moveId, displayName, type));
            }
        }

        public boolean hasAnyInfo() {
            return this.ability != null || this.heldItem != null || !this.moves.isEmpty();
        }

        public static class MoveInfo {
            public final String moveId;
            public final String displayName;
            public final String type;

            public MoveInfo(String moveId, String displayName, String type) {
                this.moveId = moveId;
                this.displayName = displayName;
                this.type = type;
            }
        }
    }
}

