/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleOpacityHelper;
import name.modid.client.ServerConfigHolder;
import name.modid.client.net.TeamBallClientData;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class PokemonCountRenderer {
    private static final int BALL_SIZE = 8;
    private static final int BALL_MARGIN = 2;
    private static final int COMPACT_BALL_SIZE = 6;
    private static final int COMPACT_BALL_MARGIN = 1;
    private static final Map<String, class_2960> BALL_TEXTURES = new HashMap<String, class_2960>();
    private static final Map<UUID, String> LOCAL_BALL_CACHE = new HashMap<UUID, String>();
    private static long lastLocalCacheUpdate = 0L;
    private static final long LOCAL_CACHE_UPDATE_INTERVAL_MS = 2000L;
    private static final float HORIZONTAL_INSET = 20.0f;
    private static final float PORTRAIT_DIAMETER = 68.0f;
    private static final float COMPACT_PORTRAIT_DIAMETER = 55.0f;
    private static final float INFO_OFFSET_X = 10.0f;
    private static final float COMPACT_INFO_OFFSET_X = 8.0f;
    private static final float TILE_WIDTH = 246.0f;
    private static final float COMPACT_TILE_WIDTH = 200.0f;

    private static void updateLocalBallCache() {
        block9: {
            long now = System.currentTimeMillis();
            if (now - lastLocalCacheUpdate < 2000L) {
                return;
            }
            lastLocalCacheUpdate = now;
            try {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 == null) {
                    return;
                }
                Class<?> cobblemonClass = Class.forName("com.cobblemon.mod.common.Cobblemon");
                Method getInstanceMethod = cobblemonClass.getMethod("getINSTANCE", new Class[0]);
                Object cobblemon = getInstanceMethod.invoke(null, new Object[0]);
                Method getStorageMethod = cobblemon.getClass().getMethod("getStorage", new Class[0]);
                Object storage = getStorageMethod.invoke(cobblemon, new Object[0]);
                Method getPartyMethod = storage.getClass().getMethod("getParty", class_1657.class);
                Object party = getPartyMethod.invoke(storage, mc.field_1724);
                if (party == null) {
                    return;
                }
                Method iteratorMethod = party.getClass().getMethod("iterator", new Class[0]);
                Object iter = iteratorMethod.invoke(party, new Object[0]);
                if (!(iter instanceof Iterator)) break block9;
                Iterator it = (Iterator)iter;
                while (it.hasNext()) {
                    Method getUuidMethod;
                    Object uuidObj;
                    Object pokemon = it.next();
                    if (pokemon == null || !((uuidObj = (getUuidMethod = pokemon.getClass().getMethod("getUuid", new Class[0])).invoke(pokemon, new Object[0])) instanceof UUID)) continue;
                    UUID uuid = (UUID)uuidObj;
                    Method getCaughtBallMethod = pokemon.getClass().getMethod("getCaughtBall", new Class[0]);
                    Object caughtBall = getCaughtBallMethod.invoke(pokemon, new Object[0]);
                    if (caughtBall == null) continue;
                    String ballName = "poke_ball";
                    try {
                        Method getPathMethod;
                        Object pathObj;
                        Method getNameMethod = caughtBall.getClass().getMethod("getName", new Class[0]);
                        Object nameObj = getNameMethod.invoke(caughtBall, new Object[0]);
                        if (nameObj != null && (pathObj = (getPathMethod = nameObj.getClass().getMethod("getPath", new Class[0])).invoke(nameObj, new Object[0])) != null) {
                            ballName = pathObj.toString();
                        }
                    }
                    catch (Exception e) {
                        ballName = caughtBall.toString().toLowerCase().replace(" ", "_");
                    }
                    LOCAL_BALL_CACHE.put(uuid, ballName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class_2960 getBallTextureByUuid(Object pokemon) {
        if (pokemon == null) {
            return PokemonCountRenderer.getDefaultBallTexture();
        }
        try {
            Method getUuid = pokemon.getClass().getMethod("getUuid", new Class[0]);
            Object uuidObj = getUuid.invoke(pokemon, new Object[0]);
            if (uuidObj instanceof UUID) {
                UUID uuid = (UUID)uuidObj;
                String ballName = LOCAL_BALL_CACHE.get(uuid);
                if (ballName != null) {
                    return PokemonCountRenderer.getBallTextureByName(ballName);
                }
                PokemonCountRenderer.updateLocalBallCache();
                ballName = LOCAL_BALL_CACHE.get(uuid);
                if (ballName != null) {
                    return PokemonCountRenderer.getBallTextureByName(ballName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PokemonCountRenderer.getDefaultBallTexture();
    }

    private static class_2960 getBallTextureByName(String ballName) {
        String simpleName = ballName;
        if (ballName.contains("/")) {
            simpleName = ballName.substring(ballName.lastIndexOf(47) + 1);
        }
        if (!BALL_TEXTURES.containsKey(simpleName)) {
            class_2960 texture = class_2960.method_60655((String)"cobblemon-battle-extras", (String)("textures/icons/balls/" + simpleName + ".png"));
            BALL_TEXTURES.put(simpleName, texture);
        }
        return BALL_TEXTURES.get(simpleName);
    }

    private static class_2960 getDefaultBallTexture() {
        String defaultBall = "poke_ball";
        if (!BALL_TEXTURES.containsKey(defaultBall)) {
            BALL_TEXTURES.put(defaultBall, class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/icons/balls/poke_ball.png"));
        }
        return BALL_TEXTURES.get(defaultBall);
    }

    public static void drawPokemonCount(class_332 context, ActiveClientBattlePokemon activeBattlePokemon, boolean left, boolean isCompact) {
        if (!BattleExtrasConfig.isPokemonCountEnabled()) {
            return;
        }
        ClientBattlePokemon battlePokemon = activeBattlePokemon.getBattlePokemon();
        if (battlePokemon == null) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        ClientBattleActor actor = activeBattlePokemon.getActor();
        try {
            String actorClassName = actor.getClass().getSimpleName();
            if (actorClassName.contains("Wild")) {
                return;
            }
        }
        catch (Exception actorClassName) {
            // empty catch block
        }
        class_310 mc = class_310.method_1551();
        float portraitDiameter = isCompact ? 55.0f : 68.0f;
        float infoOffsetX = isCompact ? 8.0f : 10.0f;
        float tileWidth = isCompact ? 200.0f : 246.0f;
        float opacity = BattleOpacityHelper.getBattleOpacity();
        UUID actorUuid = actor.getUuid();
        int screenWidth = mc.method_22683().method_4486();
        float tileX = left ? 20.0f : (float)screenWidth - 20.0f - tileWidth;
        float nameplateStartX = tileX + portraitDiameter + infoOffsetX;
        float nameplateWidth = tileWidth - portraitDiameter - infoOffsetX;
        float totalBallWidth = 50.85f;
        float x = nameplateStartX + (nameplateWidth - totalBallWidth) / 2.0f;
        float f = left ? 57.0f : 20.0f;
        int y = 4;
        class_4587 matrix = context.method_51448();
        matrix.method_22903();
        matrix.method_46416(x -= f, 4.0f, 0.0f);
        float ballScale = 0.45f;
        matrix.method_22905(ballScale, ballScale, ballScale);
        int pos = 0;
        for (int i = 0; i < 6; ++i) {
            float colorShift;
            String ballName;
            block24: {
                ballName = "poke_ball";
                colorShift = 0.0f;
                if (TeamBallClientData.hasData(actorUuid)) {
                    Map<Integer, String> teamBalls = TeamBallClientData.getTeamBalls(actorUuid);
                    if (teamBalls.containsKey(i)) {
                        colorShift = 1.0f;
                        ballName = TeamBallClientData.getBallName(actorUuid, i);
                        if (!left && ServerConfigHolder.hideOpponentPokeballTypes()) {
                            ballName = "poke_ball";
                        }
                        if (TeamBallClientData.isFainted(actorUuid, i)) {
                            colorShift = 0.5f;
                        }
                    } else {
                        colorShift = 0.0f;
                    }
                } else {
                    try {
                        Method getPokemon = actor.getClass().getMethod("getPokemon", new Class[0]);
                        Object pokemonList = getPokemon.invoke((Object)actor, new Object[0]);
                        if (!(pokemonList instanceof Iterable)) break block24;
                        int idx = 0;
                        for (Object pokemon : (Iterable)pokemonList) {
                            if (idx == i && pokemon != null) {
                                String path;
                                colorShift = 1.0f;
                                try {
                                    Method getCurrentHealth = pokemon.getClass().getMethod("getCurrentHealth", new Class[0]);
                                    Object health = getCurrentHealth.invoke(pokemon, new Object[0]);
                                    if (health instanceof Number && ((Number)health).intValue() <= 0) {
                                        colorShift = 0.5f;
                                    }
                                }
                                catch (Exception getCurrentHealth) {
                                    // empty catch block
                                }
                                class_2960 localTexture = PokemonCountRenderer.getBallTextureByUuid(pokemon);
                                if (localTexture != null && (path = localTexture.method_12832()).contains("/")) {
                                    ballName = path.substring(path.lastIndexOf(47) + 1).replace(".png", "");
                                }
                                break;
                            }
                            ++idx;
                        }
                    }
                    catch (Exception getPokemon) {
                        // empty catch block
                    }
                }
            }
            float finalAlpha = opacity;
            float r = colorShift;
            float g = colorShift;
            float b = colorShift;
            if (colorShift == 0.0f) {
                finalAlpha = 0.6f * opacity;
                b = 0.0f;
                g = 0.0f;
                r = 0.0f;
            } else if (colorShift == 0.5f) {
                finalAlpha = 0.5f * opacity;
            }
            class_2960 ballTexture = PokemonCountRenderer.getBallTextureByName(ballName);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)finalAlpha);
            context.method_25290(ballTexture, pos, 0, 0.0f, 0.0f, 18, 18, 18, 18);
            pos += 19;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        matrix.method_22909();
    }
}

