/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class CustomTooltipRenderer {
    private static final int DEFAULT_BACKGROUND = -535816152;
    private static final int DEFAULT_BORDER_START = -11513601;
    private static final int DEFAULT_BORDER_END = -8372032;
    private static final int CORNER_RADIUS = 3;
    private static final int SEPARATOR_COLOR = 0x60FFFFFF;
    private static final int SEPARATOR_ACCENT = 0x40FFFFFF;
    private static final class_2960 VANILLA_TOOLTIP_TEXTURE = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/move_tooltip.png");
    private static final int VANILLA_TOOLTIP_WIDTH = 193;
    private static final int VANILLA_TOOLTIP_HEIGHT = 112;
    private static final int VANILLA_PADDING_X = 4;
    private static final int VANILLA_PADDING_Y = 4;
    private static final float VANILLA_TEXT_SCALE = 1.0f;
    private static final int VANILLA_LINE_HEIGHT = 11;

    public static void renderTooltip(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int borderColor) {
        if (lines.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        int maxWidth = 0;
        for (class_2561 line : lines) {
            int width = font.method_27525((class_5348)line);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int tooltipWidth = maxWidth + 12;
        int tooltipHeight = lines.size() * 10 + 12;
        if (lines.size() > 1) {
            tooltipHeight += 2;
        }
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + tooltipWidth > screenWidth) {
            x = mouseX - tooltipWidth - 4;
        }
        if (y + tooltipHeight > screenHeight) {
            y = screenHeight - tooltipHeight;
        }
        if (y < 4) {
            y = 4;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int borderStart = borderColor;
        int borderEnd = CustomTooltipRenderer.darkenColor(borderColor, 0.6f);
        CustomTooltipRenderer.drawRoundedTooltipBox(graphics, x, y, tooltipWidth, tooltipHeight, -535816152, borderStart, borderEnd);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        int textY = y + 6;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            graphics.method_51439(font, line, x + 6, textY, -1, true);
            textY += 10;
            if (i != 0 || lines.size() <= 1) continue;
            textY += 2;
        }
        graphics.method_51448().method_22909();
        RenderSystem.disableBlend();
    }

    public static void renderMoveTooltip(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue) {
        int borderColor = 0xFF000000 | typeHue & 0xFFFFFF;
        CustomTooltipRenderer.renderTooltip(graphics, lines, mouseX, mouseY, borderColor);
    }

    public static void renderMoveTooltipWithIcons(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue, ElementalType type, DamageCategory category) {
        CustomTooltipRenderer.renderMoveTooltipWithIcons(graphics, lines, mouseX, mouseY, typeHue, type, category, -1);
    }

    public static void renderMoveTooltipWithIcons(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue, ElementalType type, DamageCategory category, int anchorBottomY) {
        int borderColor;
        int y;
        int x;
        if (lines.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        float TOOLTIP_SCALE = 0.75f;
        int iconSpace = 11;
        int maxWidth = 0;
        int separatorCount = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int width = font.method_27525((class_5348)lines.get(i));
            if (i == 1) {
                width += iconSpace * 2;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (!lines.get(i).getString().isEmpty()) continue;
            ++separatorCount;
        }
        int unscaledWidth = maxWidth + 16;
        int unscaledHeight = lines.size() * 10 + 14;
        if (lines.size() > 1) {
            unscaledHeight += 2;
        }
        int tooltipWidth = (int)((float)unscaledWidth * 0.75f);
        int tooltipHeight = (int)((float)(unscaledHeight += separatorCount * 2) * 0.75f);
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        if (anchorBottomY >= 0) {
            x = mouseX;
            y = anchorBottomY - tooltipHeight;
            if (x + tooltipWidth > screenWidth) {
                x = screenWidth - tooltipWidth - 4;
            }
            if (x < 4) {
                x = 4;
            }
            if (y < 4) {
                y = 4;
            }
        } else {
            x = mouseX + 12;
            y = mouseY - 12;
            if (x + tooltipWidth > screenWidth) {
                x = mouseX - tooltipWidth - 4;
            }
            if (y + tooltipHeight > screenHeight) {
                y = screenHeight - tooltipHeight;
            }
            if (y < 4) {
                y = 4;
            }
        }
        int borderStart = borderColor = 0xFF000000 | typeHue & 0xFFFFFF;
        int borderEnd = CustomTooltipRenderer.darkenColor(borderColor, 0.6f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905(0.75f, 0.75f, 1.0f);
        CustomTooltipRenderer.drawRoundedTooltipBox(graphics, 0, 0, unscaledWidth, unscaledHeight, -535816152, borderStart, borderEnd);
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        int textY = 6;
        int textX = 6;
        int contentWidth = unscaledWidth - 12;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            String lineStr = line.getString();
            if (lineStr.isEmpty()) {
                CustomTooltipRenderer.drawFancySeparator(graphics, textX, textY + 3, contentWidth, borderStart);
                textY += 12;
                continue;
            }
            if (i == 1 && type != null && category != null) {
                CustomTooltipRenderer.renderTypeIcon(graphics, textX, textY, type);
                String typeName = type.getDisplayName().getString();
                int typeIconWidth = 9;
                graphics.method_51433(font, typeName, textX + typeIconWidth + 2, textY, -5592406, true);
                int typeTextWidth = font.method_1727(typeName);
                String separator = " | ";
                graphics.method_51433(font, separator, textX + typeIconWidth + 2 + typeTextWidth, textY, -10066330, true);
                int separatorWidth = font.method_1727(separator);
                int categoryIconX = textX + typeIconWidth + 2 + typeTextWidth + separatorWidth;
                CustomTooltipRenderer.renderCategoryIcon(graphics, categoryIconX, textY, category);
                String categoryName = category.getDisplayName().getString();
                int categoryIconWidth = 12;
                graphics.method_51433(font, categoryName, categoryIconX + categoryIconWidth + 2, textY, -5592406, true);
            } else {
                graphics.method_51439(font, line, textX, textY, -1, true);
            }
            textY += 10;
            if (i != 0 || lines.size() <= 1) continue;
            CustomTooltipRenderer.drawSubtleSeparator(graphics, textX, textY, contentWidth, borderStart);
            textY += 4;
        }
        graphics.method_51448().method_22909();
        RenderSystem.disableBlend();
    }

    private static void drawFancySeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int rightLineStart;
        int rightLineLen;
        int centerX = x + width / 2;
        int diamondSize = 2;
        int lineColor = CustomTooltipRenderer.mixColors(accentColor, -1, 0.4f);
        int leftLineEnd = centerX - 5;
        int leftLineLen = leftLineEnd - x - 4;
        if (leftLineLen > 0) {
            for (int i = 0; i < leftLineLen; ++i) {
                float progress = (float)i / (float)leftLineLen;
                int alpha = (int)(progress * (float)(lineColor >> 24 & 0xFF));
                int fadedColor = alpha << 24 | lineColor & 0xFFFFFF;
                graphics.method_25294(x + 4 + i, y + 1, x + 4 + i + 1, y + 2, fadedColor);
            }
        }
        if ((rightLineLen = x + width - 4 - (rightLineStart = centerX + 5)) > 0) {
            for (int i = 0; i < rightLineLen; ++i) {
                float progress = 1.0f - (float)i / (float)rightLineLen;
                int alpha = (int)(progress * (float)(lineColor >> 24 & 0xFF));
                int fadedColor = alpha << 24 | lineColor & 0xFFFFFF;
                graphics.method_25294(rightLineStart + i, y + 1, rightLineStart + i + 1, y + 2, fadedColor);
            }
        }
        int dotColor = CustomTooltipRenderer.mixColors(accentColor, -1, 0.5f);
        graphics.method_25294(centerX - diamondSize, y, centerX + diamondSize, y + 4, dotColor);
    }

    private static void drawSubtleSeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int lineColor = CustomTooltipRenderer.mixColors(accentColor, 0xFFFFFF, 0.2f);
        graphics.method_25296(x, y, x + width, y + 1, lineColor, lineColor);
    }

    private static void renderTypeIcon(class_332 graphics, int x, int y, ElementalType type) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types_small.png");
        int ICON_SIZE = 18;
        int TOTAL_TYPES = 18;
        int RENDER_SIZE = 9;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int u = type.getTextureXMultiplier() * ICON_SIZE;
        graphics.method_25293(texture, x, y, RENDER_SIZE, RENDER_SIZE, (float)u, 0.0f, ICON_SIZE, ICON_SIZE, ICON_SIZE * TOTAL_TYPES, ICON_SIZE);
    }

    private static void renderCategoryIcon(class_332 graphics, int x, int y, DamageCategory category) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/categories.png");
        int WIDTH = 24;
        int HEIGHT = 16;
        int TOTAL_CATEGORIES = 3;
        int RENDER_WIDTH = 12;
        int RENDER_HEIGHT = 8;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int v = category.getTextureXMultiplier() * HEIGHT;
        graphics.method_25293(texture, x, y, RENDER_WIDTH, RENDER_HEIGHT, 0.0f, (float)v, WIDTH, HEIGHT, WIDTH, HEIGHT * TOTAL_CATEGORIES);
    }

    private static void drawRoundedTooltipBox(class_332 graphics, int x, int y, int width, int height, int backgroundColor, int borderStart, int borderEnd) {
        int z = 400;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, (float)z);
        int r = 3;
        graphics.method_25294(x + r, y + r, x + width - r, y + height - r, backgroundColor);
        graphics.method_25294(x + r, y + 1, x + width - r, y + r, backgroundColor);
        graphics.method_25294(x + r, y + height - r, x + width - r, y + height - 1, backgroundColor);
        graphics.method_25294(x + 1, y + r, x + r, y + height - r, backgroundColor);
        graphics.method_25294(x + width - r, y + r, x + width - 1, y + height - r, backgroundColor);
        graphics.method_25294(x + 2, y + 2, x + r, y + r, backgroundColor);
        graphics.method_25294(x + width - r, y + 2, x + width - 2, y + r, backgroundColor);
        graphics.method_25294(x + 2, y + height - r, x + r, y + height - 2, backgroundColor);
        graphics.method_25294(x + width - r, y + height - r, x + width - 2, y + height - 2, backgroundColor);
        graphics.method_25296(x + r, y, x + width - r, y + 1, borderStart, borderEnd);
        graphics.method_25296(x + r, y + height - 1, x + width - r, y + height, borderEnd, borderStart);
        graphics.method_25296(x, y + r, x + 1, y + height - r, borderStart, borderEnd);
        graphics.method_25296(x + width - 1, y + r, x + width, y + height - r, borderEnd, borderStart);
        graphics.method_25294(x + 1, y + 2, x + 2, y + r, borderStart);
        graphics.method_25294(x + 2, y + 1, x + r, y + 2, borderStart);
        int topRightColor = CustomTooltipRenderer.mixColors(borderStart, borderEnd, 0.5f);
        graphics.method_25294(x + width - 2, y + 2, x + width - 1, y + r, topRightColor);
        graphics.method_25294(x + width - r, y + 1, x + width - 2, y + 2, topRightColor);
        int bottomLeftColor = CustomTooltipRenderer.mixColors(borderStart, borderEnd, 0.5f);
        graphics.method_25294(x + 1, y + height - r, x + 2, y + height - 2, bottomLeftColor);
        graphics.method_25294(x + 2, y + height - 2, x + r, y + height - 1, bottomLeftColor);
        graphics.method_25294(x + width - 2, y + height - r, x + width - 1, y + height - 2, borderEnd);
        graphics.method_25294(x + width - r, y + height - 2, x + width - 2, y + height - 1, borderEnd);
        graphics.method_51448().method_22909();
    }

    private static int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void renderVanillaStyleMoveTooltip(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue, ElementalType type, DamageCategory category) {
        CustomTooltipRenderer.renderVanillaStyleMoveTooltip(graphics, lines, mouseX, mouseY, typeHue, type, category, -1);
    }

    public static void renderVanillaStyleMoveTooltip(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue, ElementalType type, DamageCategory category, int anchorBottomY) {
        int y;
        int x;
        if (lines.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        float TOOLTIP_SCALE = 0.75f;
        int scaledWidth = 144;
        int scaledHeight = 84;
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        if (anchorBottomY >= 0) {
            x = mouseX;
            y = anchorBottomY - scaledHeight;
            if (x + scaledWidth > screenWidth) {
                x = screenWidth - scaledWidth - 4;
            }
            if (x < 4) {
                x = 4;
            }
            if (y < 4) {
                y = 4;
            }
        } else {
            x = mouseX + 12;
            y = mouseY - 12;
            if (x + scaledWidth > screenWidth) {
                x = mouseX - scaledWidth - 4;
            }
            if (y + scaledHeight > screenHeight) {
                y = screenHeight - scaledHeight;
            }
            if (y < 4) {
                y = 4;
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 400.0f);
        graphics.method_51448().method_22905(0.75f, 0.75f, 1.0f);
        graphics.method_25290(VANILLA_TOOLTIP_TEXTURE, 0, 0, 0.0f, 0.0f, 193, 112, 193, 112);
        String moveName = "";
        Object description = "";
        String power = "";
        String accuracy = "";
        String crit = "";
        String pp = "";
        String effect = "";
        String effectiveness = "";
        for (class_2561 line : lines) {
            String text = line.getString();
            String lowerText = text.toLowerCase();
            if (text.isEmpty()) continue;
            if (!(!moveName.isEmpty() || lowerText.contains("power:") || lowerText.contains("accuracy:") || lowerText.contains("crit") || lowerText.contains("pp:") || lowerText.startsWith("effect:") || lowerText.contains("effective") || lowerText.contains("immune") || lowerText.contains("|"))) {
                moveName = text;
                continue;
            }
            if (text.contains("|")) continue;
            if (lowerText.startsWith("power:") || lowerText.contains("\u2694 power") || lowerText.contains("power:")) {
                power = text.replaceAll("^[\u2022\u2694\\s]+", "").trim();
                continue;
            }
            if (lowerText.startsWith("accuracy:") || lowerText.contains("\u25ce accuracy") || lowerText.contains("accuracy:")) {
                accuracy = text.replaceAll("^[\u2022\u25ce\\s]+", "").trim();
                continue;
            }
            if (lowerText.startsWith("crit") || lowerText.contains("\u2605 crit") || lowerText.contains("crit chance:")) {
                crit = text.replaceAll("^[\u2022\u2605\\s]+", "").trim();
                continue;
            }
            if (lowerText.startsWith("pp:") || lowerText.contains("\u2666 pp") || lowerText.contains("pp:")) {
                pp = text.replaceAll("^[\u2022\u2666\\s]+", "").trim();
                continue;
            }
            if (lowerText.startsWith("effect:") || lowerText.contains("\u2726 effect:") || lowerText.contains("effect:") && !lowerText.contains("effective")) {
                effect = text.replaceAll("^[\u2022\u2726\\s]+", "").trim();
                continue;
            }
            if (lowerText.contains("effective") || lowerText.contains("immune") || lowerText.contains("ineffective")) {
                effectiveness = text.replaceAll("^[\u2022\\s]+", "").trim();
                continue;
            }
            if (!text.contains("|") && !moveName.isEmpty() && ((String)description).isEmpty()) {
                description = text;
                continue;
            }
            if (((String)description).isEmpty() || lowerText.startsWith("power") || lowerText.startsWith("accuracy") || lowerText.startsWith("crit") || lowerText.startsWith("pp") || lowerText.startsWith("effect:")) continue;
            description = (String)description + " " + text;
        }
        int leftColX = 6;
        int rightColX = 100;
        int rightColWidth = 88;
        int currentY = 18;
        float statScale = 0.75f;
        int statLineHeight = 16;
        int descLineHeight = 12;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)leftColX, (float)currentY, 0.0f);
        graphics.method_51448().method_22905(1.0f, 1.0f, 1.0f);
        graphics.method_51433(font, moveName, 0, 0, typeHue | 0xFF000000, true);
        graphics.method_51448().method_22909();
        if (type != null && category != null) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)rightColX, (float)currentY, 0.0f);
            graphics.method_51448().method_22905(1.0f, 1.0f, 1.0f);
            CustomTooltipRenderer.renderTypeIconSmall(graphics, 0, 0, type);
            String typeName = type.getDisplayName().getString();
            graphics.method_51433(font, typeName, 7, 0, -5592406, true);
            int typeWidth = font.method_1727(typeName) + 7;
            graphics.method_51433(font, "|", typeWidth + 2, 0, -10066330, true);
            CustomTooltipRenderer.renderCategoryIconSmall(graphics, typeWidth + 8, 0, category);
            String catName = category.getDisplayName().getString();
            graphics.method_51433(font, catName, typeWidth + 17, 0, -5592406, true);
            graphics.method_51448().method_22909();
        }
        List<String> descLines = CustomTooltipRenderer.wrapTextForVanilla((String)description, font, (int)((float)rightColWidth / 0.8f));
        int descLineIndex = 0;
        int descY = currentY += 13;
        power = CustomTooltipRenderer.cleanStatText(power);
        accuracy = CustomTooltipRenderer.cleanStatText(accuracy);
        crit = CustomTooltipRenderer.cleanStatText(crit);
        pp = CustomTooltipRenderer.cleanStatText(pp);
        effect = CustomTooltipRenderer.cleanStatText(effect);
        if (!power.isEmpty()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, power, leftColX, currentY, CustomTooltipRenderer.getPowerColor(power), statScale);
        }
        if (descLineIndex < descLines.size()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, descLines.get(descLineIndex++), rightColX, descY, -1, 0.8f);
            descY += descLineHeight;
        }
        currentY += statLineHeight;
        if (!accuracy.isEmpty()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, accuracy, leftColX, currentY, -11184641, statScale);
        }
        if (descLineIndex < descLines.size()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, descLines.get(descLineIndex++), rightColX, descY, -1, 0.8f);
            descY += descLineHeight;
        }
        currentY += statLineHeight;
        if (!crit.isEmpty()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, crit, leftColX, currentY, CustomTooltipRenderer.getCritColor(crit), statScale);
        }
        if (descLineIndex < descLines.size()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, descLines.get(descLineIndex++), rightColX, descY, -1, 0.8f);
            descY += descLineHeight;
        }
        currentY += statLineHeight;
        if (!pp.isEmpty()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, pp, leftColX, currentY, -11141291, statScale);
        }
        if (descLineIndex < descLines.size()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, descLines.get(descLineIndex++), rightColX, descY, -1, 0.8f);
            descY += descLineHeight;
        }
        currentY += statLineHeight;
        if (!effect.isEmpty()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, effect, leftColX, currentY, -43521, statScale);
        }
        if (descLineIndex < descLines.size()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, descLines.get(descLineIndex++), rightColX, descY, -1, 0.8f);
            descY += descLineHeight;
        }
        currentY += statLineHeight;
        while (descLineIndex < descLines.size()) {
            CustomTooltipRenderer.drawScaledText(graphics, font, descLines.get(descLineIndex++), rightColX, descY, -1, 0.8f);
            descY += descLineHeight;
        }
        if (!effectiveness.isEmpty()) {
            int effColor = CustomTooltipRenderer.getEffectivenessColor(effectiveness);
            CustomTooltipRenderer.drawScaledText(graphics, font, effectiveness, rightColX, descY, effColor, 0.8f);
        }
        graphics.method_51448().method_22909();
        RenderSystem.disableBlend();
    }

    private static void drawScaledVanillaText(class_332 graphics, class_327 font, String text, int x, int y, int color) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905(1.0f, 1.0f, 1.0f);
        graphics.method_51433(font, text, 0, 0, color, true);
        graphics.method_51448().method_22909();
    }

    private static void drawScaledText(class_332 graphics, class_327 font, String text, int x, int y, int color, float scale) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        graphics.method_51433(font, text, 0, 0, color, true);
        graphics.method_51448().method_22909();
    }

    private static String cleanStatText(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.replaceAll("[\u2694\u25ce\u2605\u2666\u2022\u2726\u26a1]", "").trim();
    }

    private static List<String> wrapTextForVanilla(String text, class_327 font, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() == 0) {
                currentLine.append(word);
                continue;
            }
            if (font.method_1727(String.valueOf(currentLine) + " " + word) <= maxWidth) {
                currentLine.append(" ").append(word);
                continue;
            }
            lines.add(currentLine.toString());
            currentLine = new StringBuilder(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static int getPowerColor(String power) {
        if (power.contains("STAB") || power.contains("\u2192") || power.contains("->")) {
            return -43691;
        }
        return -43691;
    }

    private static int getCritColor(String crit) {
        if (crit.contains("100")) {
            return -43691;
        }
        if (crit.contains("50")) {
            return -22016;
        }
        if (crit.contains("12.5")) {
            return -171;
        }
        return -5592406;
    }

    private static int getEffectivenessColor(String eff) {
        String lower = eff.toLowerCase();
        if (lower.contains("immune") || lower.contains("\u00d70") || lower.contains("x0")) {
            return -11184811;
        }
        if (lower.contains("\u00d70.25") || lower.contains("x0.25") || lower.contains("mostly")) {
            return -8947849;
        }
        if (lower.contains("\u00d70.5") || lower.contains("x0.5") || lower.contains("not very")) {
            return -5592406;
        }
        if (lower.contains("\u00d74") || lower.contains("x4") || lower.contains("extremely")) {
            return -22016;
        }
        if (lower.contains("\u00d72") || lower.contains("x2") || lower.contains("super")) {
            return -11141291;
        }
        return -5592406;
    }

    private static void renderTypeIconSmall(class_332 graphics, int x, int y, ElementalType type) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types_small.png");
        int ICON_SIZE = 18;
        int TOTAL_TYPES = 18;
        int RENDER_SIZE = 6;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int u = type.getTextureXMultiplier() * ICON_SIZE;
        graphics.method_25293(texture, x, y, RENDER_SIZE, RENDER_SIZE, (float)u, 0.0f, ICON_SIZE, ICON_SIZE, ICON_SIZE * TOTAL_TYPES, ICON_SIZE);
    }

    private static void renderCategoryIconSmall(class_332 graphics, int x, int y, DamageCategory category) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/categories.png");
        int WIDTH = 24;
        int HEIGHT = 16;
        int TOTAL_CATEGORIES = 3;
        int RENDER_WIDTH = 8;
        int RENDER_HEIGHT = 5;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int v = category.getTextureXMultiplier() * HEIGHT;
        graphics.method_25293(texture, x, y, RENDER_WIDTH, RENDER_HEIGHT, 0.0f, (float)v, WIDTH, HEIGHT, WIDTH, HEIGHT * TOTAL_CATEGORIES);
    }
}

