/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import name.modid.client.BattleMessageSubscriber;
import name.modid.platform.Services;

public class CobblemonAdapter {
    public boolean isCobblemonPresent() {
        try {
            return Services.PLATFORM.isModLoaded("cobblemon");
        }
        catch (Throwable t) {
            return false;
        }
    }

    public BattleInfo getActiveBattleInfo() {
        if (!this.isCobblemonPresent()) {
            return null;
        }
        try {
            Class<?> clientBattleClass = Class.forName("com.cobblemon.mod.common.client.battle.ClientBattle");
            Object clientBattleInstance = this.tryGetSingletonInstance(clientBattleClass);
            if (clientBattleInstance == null) {
                try {
                    Class<?> overlay = Class.forName("com.cobblemon.mod.common.client.gui.battle.BattleOverlay");
                    clientBattleInstance = this.tryGetSingletonInstance(overlay);
                }
                catch (ClassNotFoundException overlay) {
                    // empty catch block
                }
            }
            if (clientBattleInstance == null) {
                try {
                    Method m = clientBattleClass.getMethod("getActiveClientBattlePokemon", new Class[0]);
                    Object active = m.invoke(null, new Object[0]);
                    return this.extractBattleInfoFromActive(active);
                }
                catch (NoSuchMethodException m) {
                    return null;
                }
            }
            Object active = this.tryInvokeAny(clientBattleInstance, new String[]{"getActiveClientBattlePokemon", "getActivePokemon", "getActive"});
            if (active == null) {
                return null;
            }
            return this.extractBattleInfoFromActive(active);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Object tryGetSingletonInstance(Class<?> cls) {
        try {
            String[] methodNames;
            String[] fieldNames;
            for (String f : fieldNames = new String[]{"INSTANCE", "instance", "INSTANCE$", "client", "CLIENT"}) {
                try {
                    Field field = cls.getField(f);
                    Object val = field.get(null);
                    if (val == null) continue;
                    return val;
                }
                catch (Throwable field) {
                    // empty catch block
                }
            }
            for (String mname : methodNames = new String[]{"getInstance", "get", "getClientBattle", "instance", "getClient"}) {
                try {
                    Method m = cls.getMethod(mname, new Class[0]);
                    Object val = m.invoke(null, new Object[0]);
                    if (val == null) continue;
                    return val;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private Object tryInvokeAny(Object target, String[] names) {
        for (String n : names) {
            try {
                Method m = target.getClass().getMethod(n, new Class[0]);
                return m.invoke(target, new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private BattleInfo extractBattleInfoFromActive(Object active) {
        if (active == null) {
            return null;
        }
        try {
            Iterable<?> iter;
            String enemyName = this.tryCallString(active, new String[]{"getName", "getSpecies", "getDisplayName", "getSpeciesName", "getUniqueName"});
            List<String> types = this.tryCallStringList(active, new String[]{"getTypes", "getType", "getElementTypes", "getElementType"});
            List<String> actualTypes = this.getActualTypes(enemyName, types);
            ArrayList<MoveInfo> moves = new ArrayList<MoveInfo>();
            Object movesCollection = this.tryCallObject(active, new String[]{"getMoves", "getBattleMoves", "getMoveset", "getMovesList", "getMoveSet"});
            if (movesCollection != null && (iter = this.iterableFrom(movesCollection)) != null) {
                for (Object mobj : iter) {
                    String moveName = this.tryCallString(mobj, new String[]{"getName", "getMoveName", "getMove", "getId"});
                    String moveType = this.tryCallString(mobj, new String[]{"getType", "getMoveType", "getElementType"});
                    double eff = CobblemonAdapter.effectivenessAgainst(actualTypes, moveType == null ? "" : moveType);
                    moves.add(new MoveInfo(moveName == null ? "" : moveName, eff));
                }
            }
            return new BattleInfo(enemyName == null ? "" : enemyName, actualTypes == null ? Collections.emptyList() : actualTypes, moves);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private List<String> getActualTypes(String pokemonName, List<String> baseTypes) {
        if (pokemonName == null || pokemonName.isEmpty()) {
            return baseTypes;
        }
        try {
            String teraType = BattleMessageSubscriber.getTeraType(pokemonName);
            if (teraType != null && !teraType.isEmpty()) {
                return Collections.singletonList(teraType);
            }
            List<String> megaTypes = BattleMessageSubscriber.getMegaTypes(pokemonName);
            if (megaTypes != null && !megaTypes.isEmpty()) {
                return megaTypes;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return baseTypes;
    }

    private Object tryCallObject(Object target, String[] names) {
        for (String n : names) {
            try {
                Method m = target.getClass().getMethod(n, new Class[0]);
                return m.invoke(target, new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private String tryCallString(Object target, String[] names) {
        Object o = this.tryCallObject(target, names);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    private List<String> tryCallStringList(Object target, String[] names) {
        Object o = this.tryCallObject(target, names);
        if (o == null) {
            return Collections.emptyList();
        }
        Iterable<?> iter = this.iterableFrom(o);
        if (iter == null) {
            return Collections.singletonList(o.toString());
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Object e : iter) {
            out.add(e == null ? "" : e.toString());
        }
        return out;
    }

    private Iterable<?> iterableFrom(Object o) {
        if (o instanceof Iterable) {
            return (Iterable)o;
        }
        if (o.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int len = Array.getLength(o);
            for (int i = 0; i < len; ++i) {
                list.add(Array.get(o, i));
            }
            return list;
        }
        return null;
    }

    public static double effectivenessAgainst(List<String> defenderTypes, String moveType) {
        if (defenderTypes == null || defenderTypes.isEmpty()) {
            return 1.0;
        }
        HashMap<String, List<String>> strong = new HashMap<String, List<String>>();
        strong.put("fire", Arrays.asList("grass", "ice", "bug"));
        strong.put("water", Arrays.asList("fire", "rock"));
        strong.put("grass", Arrays.asList("water", "rock"));
        double mult = 1.0;
        String atk = moveType == null ? "" : moveType.toLowerCase();
        List strongAgainst = strong.getOrDefault(atk, Collections.emptyList());
        for (String def : defenderTypes) {
            if (!strongAgainst.contains(def.toLowerCase())) continue;
            mult *= 2.0;
        }
        return mult;
    }

    public static class BattleInfo {
        public final String enemyName;
        public final List<String> enemyTypes;
        public final List<MoveInfo> moves;

        public BattleInfo(String enemyName, List<String> enemyTypes, List<MoveInfo> moves) {
            this.enemyName = enemyName;
            this.enemyTypes = enemyTypes;
            this.moves = moves;
        }
    }

    public static class MoveInfo {
        public final String name;
        public final double effectiveness;

        public MoveInfo(String name, double effectiveness) {
            this.name = name;
            this.effectiveness = effectiveness;
        }
    }
}

