/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.AbilityPopupRenderer;
import name.modid.client.BattleLogger;
import name.modid.client.BattleMessageColorizer;
import name.modid.client.CritChanceCache;
import name.modid.client.RevealedBattleInfo;
import name.modid.client.TurnCounterRenderer;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7417;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BattleMessageSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleMessageSubscriber");
    private static final String PROP_DEBUG_KEYS = "battleextras.debugKeys";
    private static final String PROP_LEGACY_PARSING = "battleextras.legacyParsing";
    private static final String PROP_KEY_PARSING = "battleextras.keyParsing";
    private static final String ENV_DEBUG_KEYS = "BATTLEEXTRAS_DEBUG_KEYS";
    private static final String PROP_DEBUG_KEYS_FILTER = "battleextras.debugKeysFilter";
    private static final String ENV_DEBUG_KEYS_FILTER = "BATTLEEXTRAS_DEBUG_KEYS_FILTER";
    private static final String ENV_LEGACY_PARSING = "BATTLEEXTRAS_LEGACY_PARSING";
    private static final String ENV_KEY_PARSING = "BATTLEEXTRAS_KEY_PARSING";
    private static String currentWeather = "";
    private static String currentTerrain = "";
    private static int weatherTurns = 0;
    private static int terrainTurns = 0;
    private static int terrainStartTurn = 0;
    private static boolean weatherJustSet = false;
    private static final Map<String, Map<String, Integer>> statStages = new ConcurrentHashMap<String, Map<String, Integer>>();
    private static final Map<String, Map<String, Integer>> pendingBatonPassStats = new ConcurrentHashMap<String, Map<String, Integer>>();
    private static final Map<String, Map<String, Integer>> screens = new ConcurrentHashMap<String, Map<String, Integer>>();
    private static final Map<String, Map<String, Integer>> hazards = new ConcurrentHashMap<String, Map<String, Integer>>();
    private static final Map<String, Boolean> leechSeeded = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> ingrained = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> aquaRing = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> hasSubstitute = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> confused = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> identified = new ConcurrentHashMap<String, Boolean>();
    private static int trickRoomTurns = 0;
    private static final Map<String, Integer> tailwind = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, String> terastallized = new ConcurrentHashMap<String, String>();
    private static final Map<String, Boolean> soaked = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> burnedUp = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> doubleShocked = new ConcurrentHashMap<String, Boolean>();
    private static String pendingBurnUpPokemon = null;
    private static String pendingDoubleShockPokemon = null;
    private static final Map<String, String> lastBurnUpDoubleShockSide = new ConcurrentHashMap<String, String>();
    private static String pendingSoakPokemon = null;
    private static String pendingSoakTarget = null;
    private static String pendingTeraPokemon = null;
    private static String pendingTeraSide = null;
    private static final Map<String, Integer> roosted = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> magnetRise = new ConcurrentHashMap<String, Integer>();
    private static String pendingMagnetRisePokemon = null;
    private static final Map<String, Integer> telekinesis = new ConcurrentHashMap<String, Integer>();
    private static String pendingTelekinesisMessage = null;
    private static String pendingHealBlockPokemon = null;
    private static String pendingEmbargoPokemon = null;
    private static String pendingSafeguardSide = null;
    private static String pendingLuckyChantSide = null;
    private static String pendingMistSide = null;
    private static String pendingSendOutTrainer = null;
    private static String pendingTransformTypePokemon = null;
    private static String pendingTransformTypeName = null;
    private static final String[] ALL_TYPES = new String[]{"Normal", "Fire", "Water", "Electric", "Grass", "Ice", "Fighting", "Poison", "Ground", "Flying", "Psychic", "Bug", "Rock", "Ghost", "Dragon", "Dark", "Steel", "Fairy"};
    private static final Map<String, String> transformedTypes = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> addedTypes = new ConcurrentHashMap<String, String>();
    private static final Map<String, List<String>> reflectTypes = new ConcurrentHashMap<String, List<String>>();
    private static String pendingAddedType = null;
    private static String pendingReflectTypePokemon = null;
    private static String pendingReflectTypeTarget = null;
    private static final Map<String, Boolean> smackDownGrounded = new ConcurrentHashMap<String, Boolean>();
    private static final StringBuilder statChangeBuffer = new StringBuilder();
    private static long lastStatChangeMessageTime = 0L;
    private static final long STAT_CHANGE_BUFFER_TIMEOUT_MS = 100L;
    private static int gravityTurns = 0;
    private static int wonderRoomTurns = 0;
    private static int magicRoomTurns = 0;
    private static final Map<String, Integer> embargo = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> healBlock = new ConcurrentHashMap<String, Integer>();
    private static boolean hasLightClay = false;
    private static final Map<String, List<String>> megaEvolved = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, String> meloettaForm = new ConcurrentHashMap<String, String>();
    private static String pendingMeloettaFormPokemon = null;
    private static final Map<String, String> pokemonAbilities = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> activePrimalPokemon = new ConcurrentHashMap<String, String>();
    private static final Map<String, Map<String, int[]>> pokemonMovePP = new ConcurrentHashMap<String, Map<String, int[]>>();
    private static boolean hasWeatherRock = false;
    private static int weatherStartTurn = 0;
    private static boolean subscribed = false;
    private static Object lastBattle = null;
    private static int tickCounter = 0;
    private static int lastTurnNumber = 0;
    private static int currentTurnNumber = 0;
    private static int playerPokemonCount = 0;
    private static int opponentPokemonCount = 0;
    private static String lastPokemonName = null;
    private static String currentActivePlayerPokemon = null;
    private static String currentActiveOpponentPokemon = null;
    private static String pendingStatMessage = null;
    private static long lastMessageTime = 0L;
    private static final StringBuilder messageBuffer = new StringBuilder();
    private static long lastBufferMessageTime = 0L;
    private static final long MESSAGE_BUFFER_TIMEOUT = 100L;
    private static String localPlayerName = null;
    private static final Set<String> localPlayerPokemon = ConcurrentHashMap.newKeySet();
    private static final Set<String> opponentPokemon = ConcurrentHashMap.newKeySet();
    private static final Map<String, String> ownerTextToSide = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> heldItems = new ConcurrentHashMap<String, String>();
    private static boolean translationKeyParsingEnabled = true;
    private static boolean legacyStringParsingEnabled = false;
    private static boolean translationKeyDebugLogging = false;
    private static String translationKeyDebugFilter = null;
    private static long lastPacketHookDebugMs = 0L;
    private static long lastPacketFilteredKeyDebugMs = 0L;
    private static String lastFilteredKey = null;
    private static long lastPacketKeyInfoMs = 0L;
    private static String lastInfoKey = null;
    private static Class<?> cachedCobblemonClientClass;
    private static Object cachedCobblemonClientInstance;
    private static Method cachedGetBattleMethod;
    private static boolean reflectionCacheInitialized;
    private static final String[] ACCESSOR_METHOD_NAMES;
    private static final String[] DEBUG_ACCESSOR_METHOD_NAMES;
    private static final Map<Class<?>, Map<String, Method>> methodCache;
    private static final Map<Class<?>, Set<String>> methodNotFoundCache;
    private static final ConcurrentHashMap<String, Long> recentAbilityPopups;
    private static final long ABILITY_POPUP_DEDUPE_WINDOW_MS = 1500L;
    private static volatile long lastAbilityPopupFromKeyMs;
    private static final long SUPPRESS_LEGACY_ABILITY_WINDOW_MS = 2000L;
    private static int waterSportTurns;
    private static int mudSportTurns;
    private static String pendingIngrainPokemon;
    private static String pendingAquaRingPokemon;

    private static String normalizePokemonName(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        return pokemonName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "");
    }

    private static String makeSidedKey(String side, String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String safeSide = side == null || side.isEmpty() ? "unknown" : side.toLowerCase();
        return safeSide + "_" + pokemonName.toLowerCase(Locale.ROOT);
    }

    private static String determineSideFromFullText(String pokemonFullText, String pokemonLower) {
        String side = null;
        if (pokemonFullText != null) {
            side = ownerTextToSide.get(pokemonFullText.toLowerCase(Locale.ROOT));
        }
        if (side == null && pokemonLower != null) {
            side = ownerTextToSide.get(pokemonLower);
        }
        if (side == null && pokemonFullText != null) {
            if (pokemonFullText.contains("'s ") && localPlayerName != null) {
                int apostropheIdx = pokemonFullText.indexOf("'s ");
                if (apostropheIdx > 0) {
                    String ownerName = pokemonFullText.substring(0, apostropheIdx);
                    side = ownerName.equalsIgnoreCase(localPlayerName) ? "player" : "opponent";
                }
            } else if (!pokemonFullText.contains("'s ")) {
                side = "opponent";
            }
        }
        if (side == null && pokemonLower != null) {
            if (localPlayerPokemon.contains(pokemonLower)) {
                side = "player";
            } else if (opponentPokemon.contains(pokemonLower)) {
                side = "opponent";
            }
        }
        return side;
    }

    private static String extractNameFromSidedKey(String sidedKey) {
        if (sidedKey == null) {
            return null;
        }
        int idx = sidedKey.indexOf(95);
        return idx >= 0 ? sidedKey.substring(idx + 1) : sidedKey;
    }

    private static String readStringToggle(String systemPropertyName, String envVarName, String defaultValue) {
        try {
            String prop = System.getProperty(systemPropertyName);
            if (prop != null && !prop.isBlank()) {
                return prop.trim();
            }
        }
        catch (Throwable prop) {
            // empty catch block
        }
        try {
            String env = System.getenv(envVarName);
            if (env != null && !env.isBlank()) {
                return env.trim();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    private static boolean shouldDebugLogKey(String key) {
        try {
            if (!translationKeyDebugLogging) {
                return false;
            }
            if (key == null) {
                return false;
            }
            if (translationKeyDebugFilter == null || translationKeyDebugFilter.isBlank()) {
                return true;
            }
            String f = translationKeyDebugFilter.toLowerCase(Locale.ROOT);
            if (f.equals("battle")) {
                return key.toLowerCase(Locale.ROOT).contains("cobblemon.battle");
            }
            return key.toLowerCase(Locale.ROOT).contains(f);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static boolean readBooleanToggle(String systemPropertyName, String envVarName, boolean defaultValue) {
        try {
            String prop = System.getProperty(systemPropertyName);
            if (prop != null && !prop.isBlank()) {
                return Boolean.parseBoolean(prop.trim());
            }
        }
        catch (Throwable prop) {
            // empty catch block
        }
        try {
            String env = System.getenv(envVarName);
            if (env != null && !env.isBlank()) {
                return Boolean.parseBoolean(env.trim());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    public static void onBattleTranslatableMessage(class_2588 tc) {
        try {
            long now;
            if (!translationKeyParsingEnabled) {
                return;
            }
            if (tc == null) {
                return;
            }
            if (translationKeyDebugLogging && (now = System.currentTimeMillis()) - lastPacketHookDebugMs > 2000L) {
                lastPacketHookDebugMs = now;
                try {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] BattleMessageHandler hook is firing (TranslatableContents packets observed). If you still don't see TK(packet) lines, your debug filter is excluding them.", new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (BattleMessageSubscriber.shouldDebugLogKey(tc.method_11022())) {
                try {
                    now = System.currentTimeMillis();
                    if (!(now - lastPacketKeyInfoMs <= 250L || lastInfoKey != null && lastInfoKey.equals(tc.method_11022()))) {
                        lastPacketKeyInfoMs = now;
                        lastInfoKey = tc.method_11022();
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] TKi(packet): {} args={}", tc.method_11022(), tc.method_11023() != null ? tc.method_11023().length : 0);
                    }
                }
                catch (Throwable now2) {
                    // empty catch block
                }
                try {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] TK(packet): {} args={}", tc.method_11022(), tc.method_11023() != null ? tc.method_11023().length : 0);
                }
                catch (Throwable now2) {}
            } else if (translationKeyDebugLogging) {
                try {
                    now = System.currentTimeMillis();
                    if (!(now - lastPacketFilteredKeyDebugMs <= 2000L || lastFilteredKey != null && lastFilteredKey.equals(tc.method_11022()))) {
                        lastPacketFilteredKeyDebugMs = now;
                        lastFilteredKey = tc.method_11022();
                        String f = translationKeyDebugFilter == null ? "" : translationKeyDebugFilter;
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Debug filter '{}' excluded key: {}", f, tc.method_11022());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            BattleMessageSubscriber.processTranslatableMessage(tc);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void onBattleTransformPacket(BattleTransformPokemonPacket packet) {
        try {
            if (packet == null) {
                return;
            }
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Transform packet received - PNX: {} (NOT marking as mega - handled by message parsing)", packet.getPnx());
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error processing transform packet", t);
        }
    }

    private static void initReflectionCache() {
        if (reflectionCacheInitialized) {
            return;
        }
        try {
            cachedCobblemonClientClass = Class.forName("com.cobblemon.mod.common.client.CobblemonClient");
            cachedCobblemonClientInstance = cachedCobblemonClientClass.getField("INSTANCE").get(null);
            cachedGetBattleMethod = cachedCobblemonClientInstance.getClass().getMethod("getBattle", new Class[0]);
            reflectionCacheInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void tick() {
        ++tickCounter;
        try {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                if (subscribed) {
                    BattleMessageSubscriber.reset();
                }
                return;
            }
            if (localPlayerName == null && mc.field_1724.method_5477() != null) {
                localPlayerName = mc.field_1724.method_5477().getString();
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Local player name: {}", localPlayerName);
            }
            BattleMessageSubscriber.initReflectionCache();
            if (!reflectionCacheInitialized || cachedGetBattleMethod == null || cachedCobblemonClientInstance == null) {
                return;
            }
            Object battle = cachedGetBattleMethod.invoke(cachedCobblemonClientInstance, new Object[0]);
            if (battle == null) {
                if (subscribed) {
                    BattleMessageSubscriber.reset();
                }
                return;
            }
            if (battle != lastBattle) {
                lastBattle = battle;
                subscribed = false;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] New battle detected!", new Object[0]);
                BattleMessageSubscriber.checkPlayerWeatherRock(battle);
                BattleMessageSubscriber.checkPlayerLightClay(battle);
                BattleMessageSubscriber.extractOpponentPokemonFromBattle(battle);
            }
            if (!subscribed) {
                BattleMessageSubscriber.subscribeToMessages(battle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void subscribeToMessages(Object battle) {
        try {
            Object kotlinUnit;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Subscribing via reflection", new Object[0]);
            Method getMessages = battle.getClass().getMethod("getMessages", new Class[0]);
            Object messageQueue = getMessages.invoke(battle, new Object[0]);
            Method subscribeMethod = null;
            for (Method m : messageQueue.getClass().getMethods()) {
                if (!m.getName().equals("subscribe") || m.getParameterCount() != 1) continue;
                subscribeMethod = m;
                break;
            }
            if (subscribeMethod == null) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] No subscribe method found", new Object[0]);
                return;
            }
            Class<?> function1Class = Class.forName("kotlin.jvm.functions.Function1");
            try {
                Class<?> unitClass = Class.forName("kotlin.Unit");
                kotlinUnit = unitClass.getField("INSTANCE").get(null);
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Failed to cache Kotlin Unit", new Object[0]);
                return;
            }
            Object function1Proxy = Proxy.newProxyInstance(function1Class.getClassLoader(), new Class[]{function1Class}, (proxy, method, args) -> {
                if (method.getName().equals("invoke") && args != null && args.length == 1) {
                    Object msg = args[0];
                    BattleMessageSubscriber.processMessage(msg);
                }
                return kotlinUnit;
            });
            subscribeMethod.invoke(messageQueue, function1Proxy);
            subscribed = true;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Subscribed successfully!", new Object[0]);
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Subscribe error: {}", e.getMessage(), e);
        }
    }

    private static void processMessage(Object msg) {
        try {
            String text;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] processMessage called with: {}", msg != null ? msg.getClass().getName() : "null");
            boolean handledByKeyParser = false;
            if (translationKeyParsingEnabled) {
                if (translationKeyDebugLogging) {
                    try {
                        for (String m : DEBUG_ACCESSOR_METHOD_NAMES) {
                            try {
                                class_2588 tc0;
                                class_2561 c;
                                class_7417 class_74172;
                                Object r;
                                Method method = BattleMessageSubscriber.getCachedMethod(msg.getClass(), m);
                                if (method == null || !((r = method.invoke(msg, new Object[0])) instanceof class_2561) || !((class_74172 = (c = (class_2561)r).method_10851()) instanceof class_2588) || !BattleMessageSubscriber.shouldDebugLogKey((tc0 = (class_2588)class_74172).method_11022())) continue;
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] TK(direct:{}): {} args={}", m, tc0.method_11022(), tc0.method_11023() != null ? tc0.method_11023().length : 0);
                            }
                            catch (Throwable method) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                List<class_2588> foundKeys = BattleMessageSubscriber.extractAllTranslatableContents(msg);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Found {} translation keys in message", foundKeys.size());
                for (class_2588 tc : foundKeys) {
                    handledByKeyParser = true;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Processing key: {}", tc.method_11022());
                    if (BattleMessageSubscriber.shouldDebugLogKey(tc.method_11022())) {
                        try {
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] TK: {} args={}", tc.method_11022(), tc.method_11023() != null ? tc.method_11023().length : 0);
                        }
                        catch (Throwable m) {
                            // empty catch block
                        }
                    }
                    BattleMessageSubscriber.processTranslatableMessage(tc);
                }
            }
            if ((text = BattleMessageSubscriber.extractTextFromFormattedCharSequence(msg)) != null && !text.isEmpty()) {
                String completeMessage;
                String trimmed;
                String completeMessage2;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Raw message: '{}'", text);
                if (!legacyStringParsingEnabled) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastBufferMessageTime > 100L && messageBuffer.length() > 0) {
                        completeMessage2 = messageBuffer.toString();
                        BattleLogger.addBattleMessage(completeMessage2);
                        messageBuffer.setLength(0);
                    }
                    if (messageBuffer.length() > 0) {
                        messageBuffer.append(" ");
                    }
                    messageBuffer.append(text.trim());
                    lastBufferMessageTime = currentTime;
                    trimmed = text.trim();
                    if (trimmed.endsWith("!") || trimmed.endsWith(".") || trimmed.endsWith("?")) {
                        completeMessage = messageBuffer.toString();
                        BattleLogger.addBattleMessage(completeMessage);
                        messageBuffer.setLength(0);
                    }
                    return;
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastBufferMessageTime > 100L && messageBuffer.length() > 0) {
                    completeMessage2 = messageBuffer.toString();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Processing buffered: '{}'", completeMessage2);
                    BattleLogger.addBattleMessage(completeMessage2);
                    BattleMessageSubscriber.processCompleteMessage(completeMessage2);
                    messageBuffer.setLength(0);
                }
                if (messageBuffer.length() > 0) {
                    messageBuffer.append(" ");
                }
                messageBuffer.append(text.trim());
                lastBufferMessageTime = currentTime;
                trimmed = text.trim();
                if (trimmed.endsWith("!") || trimmed.endsWith(".") || trimmed.endsWith("?")) {
                    completeMessage = messageBuffer.toString();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Processing complete: '{}'", completeMessage);
                    BattleLogger.addBattleMessage(completeMessage);
                    BattleMessageSubscriber.processCompleteMessage(completeMessage);
                    messageBuffer.setLength(0);
                }
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Process error: {}", e.getMessage(), e);
        }
    }

    private static List<class_2588> extractAllTranslatableContents(Object msg) {
        ArrayList<class_2588> out = new ArrayList<class_2588>();
        Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        try {
            BattleMessageSubscriber.extractAllTranslatableContents0(msg, out, visited, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    private static void extractAllTranslatableContents0(Object obj, List<class_2588> out, Set<Object> visited, int depth) {
        if (obj == null) {
            return;
        }
        if (depth > 6) {
            return;
        }
        if (visited.contains(obj)) {
            return;
        }
        visited.add(obj);
        if (obj instanceof class_2561) {
            class_2561 c = (class_2561)obj;
            class_2588 tc = BattleMessageSubscriber.tryGetTranslatableContents(c);
            if (tc != null) {
                out.add(tc);
            }
            try {
                class_2588 inner;
                Object[] args;
                class_7417 class_74172 = c.method_10851();
                if (class_74172 instanceof class_2588 && (args = (inner = (class_2588)class_74172).method_11023()) != null) {
                    for (Object a : args) {
                        BattleMessageSubscriber.extractAllTranslatableContents0(a, out, visited, depth + 1);
                    }
                }
            }
            catch (Throwable inner) {
                // empty catch block
            }
            return;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object a = Array.get(obj, i);
                BattleMessageSubscriber.extractAllTranslatableContents0(a, out, visited, depth + 1);
            }
            return;
        }
        if (obj instanceof Iterable) {
            Iterable it = (Iterable)obj;
            for (Object a : it) {
                BattleMessageSubscriber.extractAllTranslatableContents0(a, out, visited, depth + 1);
            }
            return;
        }
        for (String m : ACCESSOR_METHOD_NAMES) {
            try {
                Method method = BattleMessageSubscriber.getCachedMethod(obj.getClass(), m);
                if (method == null) continue;
                Object r = method.invoke(obj, new Object[0]);
                BattleMessageSubscriber.extractAllTranslatableContents0(r, out, visited, depth + 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Method getCachedMethod(Class<?> clazz, String methodName) {
        Method cached;
        Set<String> notFound = methodNotFoundCache.get(clazz);
        if (notFound != null && notFound.contains(methodName)) {
            return null;
        }
        Map<String, Method> classMethods = methodCache.get(clazz);
        if (classMethods != null && (cached = classMethods.get(methodName)) != null) {
            return cached;
        }
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            methodCache.computeIfAbsent(clazz, k -> new ConcurrentHashMap()).put(methodName, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            methodNotFoundCache.computeIfAbsent(clazz, k -> ConcurrentHashMap.newKeySet()).add(methodName);
        }
        finally {
            return null;
        }
    }

    private static class_2588 tryGetTranslatableContents(class_2561 component) {
        try {
            if (component == null) {
                return null;
            }
            class_7417 class_74172 = component.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 tc = (class_2588)class_74172;
                return tc;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processTranslatableMessage(class_2588 msg) {
        try {
            int i;
            Object[] parts;
            String key = msg.method_11022();
            if (key == null) {
                return;
            }
            if (key.contains("switch")) {
                CobblemonBattleInfoClient.debug("[processTranslatableMessage] SWITCH KEY: {} args={}", key, msg.method_11023() == null ? 0 : msg.method_11023().length);
            }
            if (translationKeyDebugLogging) {
                try {
                    if (key.contains("mega") || key.contains("forme") || key.contains("transform")) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] MEGA DEBUG - Key: {} args: {}", key, msg.method_11023() == null ? 0 : msg.method_11023().length);
                    }
                    if (key.contains("switch") || key.contains("sendout") || key.contains("sent")) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] SWITCH DEBUG - Key: {} args: {}", key, msg.method_11023() == null ? 0 : msg.method_11023().length);
                        if (msg.method_11023() != null) {
                            for (int i2 = 0; i2 < msg.method_11023().length; ++i2) {
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}]: {}", i2, BattleMessageSubscriber.safeExtractPlainText(msg.method_11023()[i2]));
                            }
                        }
                    }
                }
                catch (Throwable i2) {
                    // empty catch block
                }
            }
            if ((parts = key.split("\\.")).length < 3) {
                return;
            }
            if (!"cobblemon".equals(parts[0])) return;
            if (!"battle".equals(parts[1])) {
                return;
            }
            Object[] args = msg.method_11023();
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Battle TK: {} (args: {})", key, args == null ? 0 : args.length);
            if (key.contains("switch") || key.contains("withdraw") || key.contains("recall") || key.contains("return") || key.contains("sendout")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] SWITCH KEY: {} (args: {})", key, args == null ? 0 : args.length);
                if (args != null) {
                    for (i = 0; i < args.length; ++i) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}]: {}", i, BattleMessageSubscriber.safeExtractPlainText(args[i]));
                    }
                }
            }
            if (key.contains("focus") || key.contains("pump") || key.contains("critical") || key.contains("crit")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] FOCUS/CRIT KEY DETECTED: {} (args: {})", key, args == null ? 0 : args.length);
                if (args != null) {
                    for (i = 0; i < args.length; ++i) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}]: {}", i, BattleMessageSubscriber.safeExtractPlainText(args[i]));
                    }
                }
            }
            if (key.contains("smack") || key.contains("ground") || key.contains("fell") || key.contains("gravity")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] GROUNDING KEY DETECTED: {}", key);
                if (args != null) {
                    for (i = 0; i < args.length; ++i) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}]: {}", i, BattleMessageSubscriber.safeExtractPlainText(args[i]));
                    }
                }
            }
            if (key.contains("burn") || key.contains("type") || key.contains("transform") || key.contains("shock")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] TYPE/BURN DEBUG - Key: {} (args: {})", key, args == null ? 0 : args.length);
                if (args != null) {
                    for (i = 0; i < args.length; ++i) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}]: {}", i, BattleMessageSubscriber.safeExtractPlainText(args[i]));
                    }
                }
            }
            if (key.contains("switch.self") && args != null && args.length >= 1) {
                class_2561 c;
                String speciesId = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0);
                fullText = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                String ownerFromSwitch = null;
                Object object = args[0];
                if (object instanceof class_2561 && (object = (c = (class_2561)object).method_10851()) instanceof class_2588) {
                    class_2588 tc = (class_2588)object;
                    CobblemonBattleInfoClient.debug("[SIDE_TRACK] switch.self translation key: '{}', args: {}", tc.method_11022(), tc.method_11023().length);
                    if (tc.method_11022().equals("cobblemon.battle.owned_pokemon") && tc.method_11023().length >= 1) {
                        ownerFromSwitch = BattleMessageSubscriber.safeExtractPlainText(tc.method_11023()[0]);
                    }
                }
                if (speciesId != null) {
                    if (fullText != null && ownerFromSwitch != null && localPlayerName != null) {
                        lowerFullText = fullText.toLowerCase(Locale.ROOT);
                        ownerTextToSide.put(lowerFullText, "player");
                        CobblemonBattleInfoClient.debug("[SIDE_TRACK] Mapped PLAYER from switch with owner: '{}'", lowerFullText);
                    } else {
                        CobblemonBattleInfoClient.debug("[SIDE_TRACK] Skipped mapping bare Pokemon name: '{}' (no owner info)", fullText);
                    }
                    localPlayerPokemon.add(speciesId.toLowerCase(Locale.ROOT));
                    if (fullText != null) {
                        localPlayerPokemon.add(fullText.toLowerCase(Locale.ROOT));
                    }
                    CobblemonBattleInfoClient.debug("[SIDE_TRACK] Added to localPlayerPokemon: '{}', '{}'", speciesId, fullText);
                    currentActivePlayerPokemon = speciesId;
                    CobblemonBattleInfoClient.debug("[SIDE_TRACK] Player active Pokemon set to: '{}'", speciesId);
                    batonStats = pendingBatonPassStats.remove("player");
                    if (batonStats != null && !batonStats.isEmpty()) {
                        newStatKey = BattleMessageSubscriber.makeSidedKey("player", speciesId);
                        newStats = statStages.computeIfAbsent(newStatKey, k -> new ConcurrentHashMap());
                        newStats.putAll(batonStats);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Baton Pass: Transferred stats to player's {}: {}", speciesId, batonStats);
                    }
                }
            } else if (key.contains("switch.other") && args != null && args.length >= 2) {
                String speciesId = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 1);
                fullText = BattleMessageSubscriber.safeExtractPlainText(args[1]);
                String trainerName = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                CobblemonBattleInfoClient.debug("[SIDE_TRACK] switch.other args[0]='{}', args[1]='{}'", trainerName, fullText);
                if (speciesId != null) {
                    if (fullText != null) {
                        lowerFullText = fullText.toLowerCase(Locale.ROOT);
                        ownerTextToSide.put(lowerFullText, "opponent");
                        CobblemonBattleInfoClient.debug("[SIDE_TRACK] Mapped OPPONENT from switch (direct): '{}'", lowerFullText);
                    }
                    opponentPokemon.add(speciesId.toLowerCase(Locale.ROOT));
                    if (fullText != null) {
                        opponentPokemon.add(fullText.toLowerCase(Locale.ROOT));
                    }
                    CobblemonBattleInfoClient.debug("[SIDE_TRACK] Added to opponentPokemon: '{}', '{}'", speciesId, fullText);
                    currentActiveOpponentPokemon = speciesId;
                    CobblemonBattleInfoClient.debug("[SIDE_TRACK] Opponent active Pokemon set to: '{}'", speciesId);
                    batonStats = pendingBatonPassStats.remove("opponent");
                    if (batonStats != null && !batonStats.isEmpty()) {
                        newStatKey = BattleMessageSubscriber.makeSidedKey("opponent", speciesId);
                        newStats = statStages.computeIfAbsent(newStatKey, k -> new ConcurrentHashMap());
                        newStats.putAll(batonStats);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Baton Pass: Transferred stats to opponent's {}: {}", speciesId, batonStats);
                    }
                }
            }
            switch (parts[2]) {
                case "switch_in": 
                case "sendout": 
                case "switch": {
                    BattleMessageSubscriber.tryApplySwitchInFromArgs((String[])parts, args);
                    if (!key.contains("switch.self")) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    BattleMessageColorizer.registerPlayerSwitchAction();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Registered player switch action", new Object[0]);
                    return;
                }
                case "withdraw": 
                case "recall": 
                case "return": {
                    BattleMessageSubscriber.tryApplySwitchOutFromArgs((String[])parts, args);
                    return;
                }
                case "dragged_out": {
                    BattleMessageSubscriber.tryApplyForcedSwitchFromArgs((String[])parts, args, key);
                    return;
                }
                case "ability": {
                    String[] abilityParts;
                    class_2588 tc;
                    String abilityKey;
                    class_2561 c;
                    BattleMessageSubscriber.tryApplyAbilityPopupFromArgs((String[])parts, args);
                    if (args == null) return;
                    if (args.length < 2) return;
                    String localizedAbilityName = BattleMessageSubscriber.safeExtractPlainText(args[1]);
                    String abilityId = null;
                    Object object = args[1];
                    if (object instanceof class_2561 && (object = (c = (class_2561)object).method_10851()) instanceof class_2588 && (abilityKey = (tc = (class_2588)object).method_11022()) != null && abilityKey.startsWith("cobblemon.ability.") && (abilityParts = abilityKey.split("\\.")).length >= 3) {
                        abilityId = abilityParts[2];
                    }
                    if (abilityId == null && localizedAbilityName != null) {
                        abilityId = localizedAbilityName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "");
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Derived ability ID from name: '{}' -> '{}'", localizedAbilityName, abilityId);
                    }
                    if (localizedAbilityName != null && abilityId != null) {
                        BattleMessageColorizer.registerAbilityMetadata(localizedAbilityName, abilityId);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Registered ability: '{}' (id: '{}')", localizedAbilityName, abilityId);
                    }
                    String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    String pokemonSpecies = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] ABILITY DEBUG - pokemonFull: '{}', pokemonSpecies: '{}'", pokemonFull, pokemonSpecies);
                    if (pokemonSpecies == null && pokemonFull != null) {
                        pokemonSpecies = BattleMessageSubscriber.stripOwnerPrefix(pokemonFull).toLowerCase(Locale.ROOT);
                        pokemonSpecies = pokemonSpecies.replaceAll("[^a-z0-9]", "");
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] ABILITY DEBUG - derived pokemonSpecies: '{}'", pokemonSpecies);
                    }
                    String abilitySide = null;
                    if (pokemonSpecies != null && (abilitySide = BattleMessageSubscriber.determineSideFromBattle(pokemonSpecies)) != null) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Ability side from battle state: {} -> {}", pokemonSpecies, abilitySide);
                    }
                    if (abilitySide == null && pokemonFull != null) {
                        abilitySide = ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT));
                        if (abilitySide != null) {
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Ability side from ownerTextToSide (full): {} -> {}", pokemonFull, abilitySide);
                        }
                        if (abilitySide == null && pokemonSpecies != null && (abilitySide = ownerTextToSide.get(pokemonSpecies)) != null) {
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Ability side from ownerTextToSide (species): {} -> {}", pokemonSpecies, abilitySide);
                        }
                    }
                    if (abilitySide == null && pokemonSpecies != null) {
                        if (localPlayerPokemon.contains(pokemonSpecies)) {
                            abilitySide = "player";
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Ability side from localPlayerPokemon: {} -> player", pokemonSpecies);
                        } else if (opponentPokemon.contains(pokemonSpecies)) {
                            abilitySide = "opponent";
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Ability side from opponentPokemon: {} -> opponent", pokemonSpecies);
                        }
                    }
                    if (abilitySide == null) {
                        abilitySide = "opponent";
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Ability side fallback to opponent for: {}", pokemonSpecies);
                    }
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Recording ability - Pokemon: '{}', Side: '{}', AbilityId: '{}', Display: '{}'", pokemonSpecies, abilitySide, abilityId, localizedAbilityName);
                    if ("opponent".equals(abilitySide) && pokemonSpecies != null && abilityId != null && localizedAbilityName != null) {
                        RevealedBattleInfo.recordAbility(abilitySide, pokemonSpecies, abilityId, localizedAbilityName);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] SUCCESS - Recorded ability for opponent: {} = {}", pokemonSpecies, localizedAbilityName);
                        return;
                    }
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] SKIPPED recording - side='{}', species='{}', abilityId='{}', display='{}'", abilitySide, pokemonSpecies, abilityId, localizedAbilityName);
                    return;
                }
                case "terastallize": {
                    class_2561 c;
                    Object argStr;
                    Object arg;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] TERA KEY RECEIVED: {} args={}", String.join((CharSequence)".", (CharSequence[])parts), args != null ? args.length : 0);
                    if (args != null) {
                        for (int i3 = 0; i3 < args.length; ++i3) {
                            arg = args[i3];
                            argStr = "null";
                            if (arg instanceof class_2561) {
                                c = (class_2561)arg;
                                argStr = "Component{getString='" + c.getString() + "'";
                                class_7417 abilityParts = c.method_10851();
                                if (abilityParts instanceof class_2588) {
                                    class_2588 tc = (class_2588)abilityParts;
                                    argStr = (String)argStr + ", key='" + tc.method_11022() + "'";
                                }
                                argStr = (String)argStr + "}";
                            } else if (arg != null) {
                                argStr = arg.getClass().getSimpleName() + "{" + String.valueOf(arg) + "}";
                            }
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] TERA args[{}] = {}", i3, argStr);
                        }
                    }
                    BattleMessageSubscriber.tryApplyTerastallizationFromArgs((String[])parts, args);
                    return;
                }
                case "mega": {
                    class_2561 c;
                    Object argStr;
                    Object arg;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] MEGA KEY RECEIVED: {} args={}", String.join((CharSequence)".", (CharSequence[])parts), args != null ? args.length : 0);
                    if (args != null) {
                        for (int i4 = 0; i4 < args.length; ++i4) {
                            arg = args[i4];
                            argStr = "null";
                            if (arg instanceof class_2561) {
                                c = (class_2561)arg;
                                argStr = "Component{getString='" + c.getString() + "'";
                                class_7417 abilityParts = c.method_10851();
                                if (abilityParts instanceof class_2588) {
                                    class_2588 tc = (class_2588)abilityParts;
                                    argStr = (String)argStr + ", key='" + tc.method_11022() + "'";
                                }
                                argStr = (String)argStr + "}";
                            } else if (arg != null) {
                                argStr = arg.getClass().getSimpleName() + "{" + String.valueOf(arg) + "}";
                            }
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] MEGA args[{}] = {}", i4, argStr);
                        }
                    }
                    BattleMessageSubscriber.tryApplyMegaEvolutionFromArgs((String[])parts, args);
                    return;
                }
                case "formechange": {
                    String side;
                    boolean isNonMegaFormChange;
                    String pokemonFull;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] FORMECHANGE KEY: {} args={}", String.join((CharSequence)".", (CharSequence[])parts), args != null ? args.length : 0);
                    String formeChangePokemon = null;
                    if (args != null && args.length >= 1 && (formeChangePokemon = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0)) == null && args.length >= 2) {
                        formeChangePokemon = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 1);
                    }
                    boolean bl = isNonMegaFormChange = formeChangePokemon != null && (formeChangePokemon.contains("meloetta") || formeChangePokemon.contains("darmanitan") || formeChangePokemon.contains("aegislash") || formeChangePokemon.contains("wishiwashi") || formeChangePokemon.contains("minior") || formeChangePokemon.contains("mimikyu") || formeChangePokemon.contains("morpeko") || formeChangePokemon.contains("eiscue") || formeChangePokemon.contains("zygarde") || formeChangePokemon.contains("castform") || formeChangePokemon.contains("cherrim"));
                    if (isNonMegaFormChange) {
                        String formArg;
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] FORMECHANGE: Skipping non-mega form change for {}", formeChangePokemon);
                        if (!formeChangePokemon.contains("meloetta")) return;
                        pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                        String string = side = pokemonFull != null ? ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT)) : null;
                        if (side == null && pokemonFull != null) {
                            side = pokemonFull.contains("'s ") ? "player" : "opponent";
                        }
                        String storageKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, "meloetta") : "meloetta";
                        String string2 = formArg = args.length >= 2 && args[1] != null ? args[1].toString().toLowerCase().trim() : "";
                        if (formArg.contains("pirouette")) {
                            meloettaForm.put(storageKey, "pirouette");
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta changed to Pirouette form [key: {}]", storageKey);
                            return;
                        }
                        if (!formArg.contains("aria")) return;
                        meloettaForm.put(storageKey, "aria");
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta changed to Aria form [key: {}]", storageKey);
                        return;
                    }
                    if (args != null) {
                        for (int i5 = 0; i5 < args.length; ++i5) {
                            Object arg = args[i5];
                            Object argStr = "null";
                            if (arg instanceof class_2561) {
                                class_2561 c = (class_2561)arg;
                                argStr = "Component{getString='" + c.getString() + "'";
                                class_7417 class_74172 = c.method_10851();
                                if (class_74172 instanceof class_2588) {
                                    class_2588 tc = (class_2588)class_74172;
                                    argStr = (String)argStr + ", key='" + tc.method_11022() + "'";
                                }
                                argStr = (String)argStr + "}";
                            } else if (arg != null) {
                                argStr = arg.getClass().getSimpleName() + "{" + String.valueOf(arg) + "}";
                            }
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] FORMECHANGE args[{}] = {}", i5, argStr);
                        }
                    }
                    String megaForm = null;
                    if (args != null && args.length >= 2 && args[1] != null) {
                        String formArg = args[1].toString().toLowerCase().trim();
                        if (formArg.equals("x")) {
                            megaForm = "x";
                        } else if (formArg.equals("y")) {
                            megaForm = "y";
                        }
                    }
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] FORMECHANGE detected form from args[1]: {}", megaForm);
                    BattleMessageSubscriber.tryApplyMegaEvolutionFromArgsWithForm((String[])parts, args, megaForm);
                    return;
                }
                case "fainted": {
                    if (args == null) return;
                    if (args.length < 1) return;
                    String speciesId = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0);
                    String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    String side = null;
                    if (pokemonFull != null && (side = ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT))) == null && speciesId != null) {
                        side = ownerTextToSide.get(speciesId);
                    }
                    if (speciesId == null) return;
                    if (speciesId.isBlank()) return;
                    String sidedKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, speciesId) : null;
                    boolean removed = false;
                    if (sidedKey != null) {
                        removed = megaEvolved.remove(sidedKey) != null;
                        statStages.remove(sidedKey);
                    }
                    if (!removed) {
                        megaEvolved.remove(speciesId);
                    }
                    statStages.remove(speciesId);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Fainted: Cleared status for '{}' (side: {})", speciesId, side);
                    return;
                }
                case "turn": {
                    int newTurn = 0;
                    if (parts.length >= 4) {
                        try {
                            newTurn = Integer.parseInt((String)parts[3]);
                        }
                        catch (NumberFormatException pokemonFull) {
                            // empty catch block
                        }
                    }
                    if (newTurn <= 0) {
                        newTurn = Math.max(currentTurnNumber + 1, 1);
                    }
                    if (newTurn > lastTurnNumber) {
                        currentTurnNumber = newTurn;
                        TurnCounterRenderer.setTurn(newTurn);
                        lastTurnNumber = newTurn;
                    }
                    BattleMessageSubscriber.decrementScreenTurns("player");
                    BattleMessageSubscriber.decrementScreenTurns("opponent");
                    BattleMessageSubscriber.decrementHazardTurnsIfAny();
                    BattleMessageSubscriber.decrementTailwindTurns("player");
                    BattleMessageSubscriber.decrementTailwindTurns("opponent");
                    BattleMessageSubscriber.decrementWeatherTurnsIfActive();
                    BattleMessageSubscriber.decrementTerrainTurnsIfActive();
                    BattleMessageSubscriber.decrementRoomTurnsIfActive();
                    BattleMessageSubscriber.decrementGravityTurns();
                    BattleMessageSubscriber.decrementEmbargoTurns();
                    BattleMessageSubscriber.decrementHealBlockTurns();
                    return;
                }
                case "weather": {
                    if (parts.length < 5) return;
                    String weatherId = parts[3];
                    CharSequence action = parts[4];
                    if ("start".equals(action)) {
                        BattleMessageSubscriber.setWeatherFromId(weatherId);
                        if (args == null) return;
                        if (args.length <= 0) return;
                        BattleMessageColorizer.registerWeatherMetadata(weatherId);
                        return;
                    }
                    if ("end".equals(action)) {
                        currentWeather = "";
                        weatherTurns = 0;
                        weatherStartTurn = 0;
                        return;
                    }
                    if (!"upkeep".equals(action)) return;
                    if (weatherTurns != 0) return;
                    if (hasWeatherRock) return;
                    hasWeatherRock = true;
                    weatherTurns = 3;
                    if (!currentWeather.isEmpty()) return;
                    BattleMessageSubscriber.setWeatherFromId(weatherId);
                    weatherTurns = 3;
                    return;
                }
                case "fieldstart": {
                    if (parts.length < 4) return;
                    Object effect = parts[3];
                    if (((String)effect).contains("terrain")) {
                        BattleMessageSubscriber.setTerrainFromId((String)effect);
                        return;
                    }
                    BattleMessageSubscriber.setRoomFromId((String)effect);
                    return;
                }
                case "fieldend": {
                    if (parts.length < 4) return;
                    Object effect = parts[3];
                    if (((String)effect).contains("terrain")) {
                        currentTerrain = "";
                        terrainTurns = 0;
                        terrainStartTurn = 0;
                        return;
                    }
                    BattleMessageSubscriber.clearRoomFromId((String)effect);
                    return;
                }
                case "sidestart": {
                    CharSequence effectId;
                    if (parts.length < 5) return;
                    String side = BattleMessageSubscriber.determineSideFromPartsOrArgs((String[])parts, args);
                    if (BattleMessageSubscriber.applySideEffectFromId(side, (String)(effectId = parts[4]))) return;
                    BattleMessageSubscriber.applyHazardFromId(side, (String)effectId);
                    return;
                }
                case "sideend": {
                    CharSequence effectId;
                    if (parts.length < 5) return;
                    String side = BattleMessageSubscriber.determineSideFromPartsOrArgs((String[])parts, args);
                    if (BattleMessageSubscriber.removeSideEffectFromId(side, (String)(effectId = parts[4]))) return;
                    BattleMessageSubscriber.removeHazard(side, BattleMessageSubscriber.hazardDisplayName((String)effectId));
                    return;
                }
                case "boost": 
                case "unboost": {
                    Object arg;
                    class_2588 tc;
                    class_2561 c;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] ========== STAT BOOST/UNBOOST ==========", new Object[0]);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Key: {}, isBoost: {}", key, "boost".equals(parts[2]));
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Parts: {}", Arrays.toString(parts));
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Args count: {}", args == null ? 0 : args.length);
                    if (args != null) {
                        for (int i6 = 0; i6 < args.length; ++i6) {
                            class_7417 removed;
                            arg = args[i6];
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}] type: {}", i6, arg == null ? "null" : arg.getClass().getName());
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}] value: {}", i6, BattleMessageSubscriber.safeExtractPlainText(arg));
                            if (!(arg instanceof class_2561) || !((removed = (c = (class_2561)arg).method_10851()) instanceof class_2588)) continue;
                            tc = (class_2588)removed;
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   arg[{}] translation key: {}", i6, tc.method_11022());
                        }
                    }
                    BattleMessageSubscriber.tryApplyStatBoost((String[])parts, args, "boost".equals(parts[2]));
                    return;
                }
                case "setboost": {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] ========== SETBOOST ==========", new Object[0]);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Key: {}", key);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Parts: {}", Arrays.toString(parts));
                    if (parts.length < 4) return;
                    Object effect = parts[3];
                    if (!"bellydrum".equals(effect)) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    String speciesId = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0);
                    if (speciesId == null && pokemonFull != null) {
                        speciesId = BattleMessageSubscriber.stripOwnerPrefix(pokemonFull).toLowerCase(Locale.ROOT);
                    }
                    String side = null;
                    if (pokemonFull != null && (side = ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT))) == null && speciesId != null) {
                        side = ownerTextToSide.get(speciesId);
                    }
                    if (speciesId == null) return;
                    String statKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, speciesId) : speciesId;
                    Map stages = statStages.computeIfAbsent(statKey, k -> new ConcurrentHashMap());
                    stages.put("attack", 6);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Belly Drum: Set {} attack to +6 (key: {})", speciesId, statKey);
                    return;
                }
                case "clearallboost": {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] ========== CLEARALLBOOST (Haze) ==========", new Object[0]);
                    statStages.clear();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Cleared all stat stages", new Object[0]);
                    return;
                }
                case "clearboost": {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] ========== CLEARBOOST ==========", new Object[0]);
                    if (args == null) return;
                    if (args.length < 1) return;
                    String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    String speciesId = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
                    if (speciesId == null && pokemonFull != null) {
                        speciesId = BattleMessageSubscriber.stripOwnerPrefix(pokemonFull);
                    }
                    if (speciesId == null) return;
                    String pokemon = BattleMessageSubscriber.stripOwnerPrefix(speciesId).toLowerCase(Locale.ROOT);
                    String side = BattleMessageSubscriber.determineSideFromFullText(pokemonFull, pokemon);
                    String statKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, pokemon) : pokemon;
                    statStages.remove(statKey);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Cleared stat stages for {} (key: {})", pokemon, statKey);
                    return;
                }
                case "copyboost": {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] ========== COPYBOOST (Psych Up) ==========", new Object[0]);
                    if (args == null) return;
                    if (args.length < 2) return;
                    String userFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    String targetFull = BattleMessageSubscriber.safeExtractPlainText(args[1]);
                    String userSpecies = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
                    String targetSpecies = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 1);
                    if (userSpecies == null && userFull != null) {
                        userSpecies = BattleMessageSubscriber.stripOwnerPrefix(userFull);
                    }
                    if (targetSpecies == null && targetFull != null) {
                        targetSpecies = BattleMessageSubscriber.stripOwnerPrefix(targetFull);
                    }
                    if (userSpecies == null) return;
                    if (targetSpecies == null) return;
                    String userPokemon = BattleMessageSubscriber.stripOwnerPrefix(userSpecies).toLowerCase(Locale.ROOT);
                    String targetPokemon = BattleMessageSubscriber.stripOwnerPrefix(targetSpecies).toLowerCase(Locale.ROOT);
                    String userSide = BattleMessageSubscriber.determineSideFromFullText(userFull, userPokemon);
                    String targetSide = BattleMessageSubscriber.determineSideFromFullText(targetFull, targetPokemon);
                    String userKey = userSide != null ? BattleMessageSubscriber.makeSidedKey(userSide, userPokemon) : userPokemon;
                    String targetKey = targetSide != null ? BattleMessageSubscriber.makeSidedKey(targetSide, targetPokemon) : targetPokemon;
                    Map<String, Integer> targetStats = statStages.get(targetKey);
                    if (targetStats != null && !targetStats.isEmpty()) {
                        Map userStats = statStages.computeIfAbsent(userKey, k -> new ConcurrentHashMap());
                        userStats.clear();
                        userStats.putAll(targetStats);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Psych Up: Copied stats from {} to {} (targetKey: {}, userKey: {})", targetPokemon, userPokemon, targetKey, userKey);
                        return;
                    }
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Psych Up: No stats to copy from {} (targetKey: {})", targetPokemon, targetKey);
                    return;
                }
                case "used_move": 
                case "used_move_on": {
                    String moveIdLower;
                    String[] moveParts;
                    class_2588 tc;
                    String moveKey;
                    class_2561 c;
                    if (args == null) return;
                    if (args.length < 2) return;
                    String localizedMoveName = BattleMessageSubscriber.safeExtractPlainText(args[1]);
                    String moveId = null;
                    String moveType = null;
                    Object targetPokemon = args[1];
                    if (targetPokemon instanceof class_2561 && (targetPokemon = (c = (class_2561)targetPokemon).method_10851()) instanceof class_2588 && (moveKey = (tc = (class_2588)targetPokemon).method_11022()) != null && moveKey.startsWith("cobblemon.move.") && (moveParts = moveKey.split("\\.")).length >= 3) {
                        moveId = moveParts[2];
                        moveType = BattleMessageSubscriber.getMoveTypeFromId(moveId);
                    }
                    if (localizedMoveName != null && moveType != null) {
                        BattleMessageColorizer.registerMoveMetadata(localizedMoveName, moveType);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Registered move: '{}' -> '{}'", localizedMoveName, moveType);
                    } else {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Could not register move: '{}' (moveId: '{}', moveType: '{}')", localizedMoveName, moveId, moveType);
                    }
                    String userFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    String userSpecies = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0);
                    if (userSpecies == null && userFull != null) {
                        userSpecies = BattleMessageSubscriber.stripOwnerPrefix(userFull).toLowerCase(Locale.ROOT);
                    }
                    String moveSide = null;
                    if (userFull != null && (moveSide = ownerTextToSide.get(userFull.toLowerCase(Locale.ROOT))) == null && userSpecies != null) {
                        moveSide = ownerTextToSide.get(userSpecies);
                    }
                    if (moveSide == null && userSpecies != null) {
                        if (localPlayerPokemon.contains(userSpecies)) {
                            moveSide = "player";
                        } else if (opponentPokemon.contains(userSpecies)) {
                            moveSide = "opponent";
                        }
                    }
                    if ("opponent".equals(moveSide) && userSpecies != null && moveId != null && localizedMoveName != null) {
                        RevealedBattleInfo.recordMove(moveSide, userSpecies, moveId, localizedMoveName, moveType);
                    }
                    if (moveId != null && "batonpass".equals(moveId.toLowerCase())) {
                        String batonSide = null;
                        if (userFull != null && (batonSide = ownerTextToSide.get(userFull.toLowerCase(Locale.ROOT))) == null && userSpecies != null) {
                            batonSide = ownerTextToSide.get(userSpecies);
                        }
                        if (batonSide != null && userSpecies != null) {
                            String statKey = BattleMessageSubscriber.makeSidedKey(batonSide, userSpecies);
                            Map<String, Integer> currentStats = statStages.get(statKey);
                            if (currentStats != null && !currentStats.isEmpty()) {
                                pendingBatonPassStats.put(batonSide, new ConcurrentHashMap<String, Integer>(currentStats));
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Baton Pass: Saved stats for {} side: {}", batonSide, currentStats);
                            } else {
                                pendingBatonPassStats.put(batonSide, new ConcurrentHashMap());
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Baton Pass: No stats to pass for {} side", batonSide);
                            }
                        }
                    }
                    if (moveId != null && ("burnup".equals(moveIdLower = moveId.toLowerCase()) || "doubleshock".equals(moveIdLower))) {
                        String burnSide = null;
                        if (userFull != null && (burnSide = ownerTextToSide.get(userFull.toLowerCase(Locale.ROOT))) == null) {
                            burnSide = userFull.contains("'s ") ? "player" : (localPlayerPokemon.contains(userSpecies) ? "player" : "opponent");
                        }
                        if (burnSide != null && userSpecies != null) {
                            String storageKey = BattleMessageSubscriber.makeSidedKey(burnSide, userSpecies);
                            if ("burnup".equals(moveIdLower)) {
                                burnedUp.put(storageKey, true);
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Burn Up - lost Fire type! (key: {}, side: {})", userSpecies, storageKey, burnSide);
                            } else {
                                doubleShocked.put(storageKey, true);
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Double Shock - lost Electric type! (key: {}, side: {})", userSpecies, storageKey, burnSide);
                            }
                            lastBurnUpDoubleShockSide.put(userSpecies, burnSide);
                        }
                    }
                    if (localizedMoveName == null) return;
                    if (args.length < 3) return;
                    String moveLower = localizedMoveName.toLowerCase().replace(" ", "");
                    boolean isGroundingMove = false;
                    if (moveId != null) {
                        String moveIdLower2 = moveId.toLowerCase();
                        boolean bl = isGroundingMove = "smackdown".equals(moveIdLower2) || "thousandarrows".equals(moveIdLower2);
                    }
                    if (!isGroundingMove) {
                        if (!"smackdown".equals(moveLower)) {
                            if (!"thousandarrows".equals(moveLower)) return;
                        }
                        boolean bl = true;
                        isGroundingMove = bl;
                    }
                    if (!isGroundingMove) return;
                    String targetName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 2);
                    if (targetName == null) return;
                    if (targetName.isBlank()) return;
                    targetName = BattleMessageSubscriber.stripOwnerPrefix(targetName);
                    String lowerName = targetName.toLowerCase();
                    smackDownGrounded.put(lowerName, true);
                    magnetRise.remove(lowerName);
                    telekinesis.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was hit by {}! Now grounded. [from used_move_on]", targetName, localizedMoveName);
                    return;
                }
                case "start": {
                    Object effectId;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] START detected - Full key: {}, parts.length: {}, args.length: {}", key, parts.length, args == null ? 0 : args.length);
                    if (parts.length >= 4) {
                        effectId = parts[3];
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Effect ID: {}", effectId);
                    }
                    for (int i7 = 0; i7 < parts.length; ++i7) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber]   parts[{}]: {}", i7, parts[i7]);
                    }
                    if (parts.length < 4) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    Object effectId2 = parts[3];
                    String localizedMessage = class_2561.method_43469((String)key, (Object[])args).getString();
                    String statusType = null;
                    switch (((String)effectId2).toLowerCase()) {
                        case "brn": {
                            statusType = "burn";
                            break;
                        }
                        case "psn": {
                            statusType = "poison";
                            break;
                        }
                        case "tox": {
                            statusType = "badly poisoned";
                            break;
                        }
                        case "par": {
                            statusType = "paralysis";
                            break;
                        }
                        case "slp": {
                            statusType = "sleep";
                            break;
                        }
                        case "frz": {
                            statusType = "freeze";
                            break;
                        }
                        case "confusion": {
                            statusType = "confusion";
                        }
                    }
                    if (statusType != null && localizedMessage != null) {
                        BattleMessageColorizer.registerStatusEffectMetadata(localizedMessage, statusType);
                    }
                    if ("focusenergy".equals(effectId2)) {
                        BattleMessageSubscriber.tryApplyFocusEnergy(args);
                        return;
                    }
                    BattleMessageSubscriber.tryApplyVolatileStatusFromArgs((String)effectId2, args);
                    return;
                }
                case "end": {
                    if (parts.length < 4) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    Object effectId = parts[3];
                    BattleMessageSubscriber.tryRemoveVolatileStatusFromArgs((String)effectId, args);
                    return;
                }
                case "move": {
                    if (parts.length < 4) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    String moveName = ((String)parts[3]).toLowerCase();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Move message detected: {}", moveName);
                    if (!"smackdown".equals(moveName)) {
                        if (!"thousandarrows".equals(moveName)) return;
                    }
                    String targetName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, args.length > 1 ? 1 : 0);
                    if (targetName == null) return;
                    if (targetName.isBlank()) return;
                    targetName = BattleMessageSubscriber.stripOwnerPrefix(targetName);
                    String lowerName = targetName.toLowerCase();
                    smackDownGrounded.put(lowerName, true);
                    magnetRise.remove(lowerName);
                    telekinesis.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was hit by {}! Now grounded. [from move message]", targetName, moveName);
                    return;
                }
                case "singleturn": {
                    String side;
                    if (parts.length < 4) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    Object effectId = ((String)parts[3]).toLowerCase();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Singleturn message detected: {} (turn: {})", effectId, lastTurnNumber);
                    if (!"roost".equals(effectId)) return;
                    String pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
                    if (pokemonName == null) return;
                    if (pokemonName.isBlank()) return;
                    String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
                    String lowerName = pokemonName.toLowerCase();
                    String string = side = pokemonFull != null ? ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT)) : null;
                    if (side == null && pokemonFull != null) {
                        side = pokemonFull.contains("'s ") ? "player" : (localPlayerPokemon.contains(lowerName) ? "player" : "opponent");
                    }
                    String storageKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, lowerName) : lowerName;
                    roosted.put(storageKey, lastTurnNumber);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Roost (loses Flying type for turn {}) [from singleturn args] (key: {}, side: {})", pokemonName, lastTurnNumber, storageKey, side);
                    return;
                }
                case "activate": {
                    String pokemonName;
                    if (parts.length < 4) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    Object effectId = ((String)parts[3]).toLowerCase();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Activate message detected: {}", effectId);
                    if (!"smackdown".equals(effectId)) {
                        if (!"gravity".equals(effectId)) return;
                    }
                    if ((pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0)) == null) return;
                    if (pokemonName.isBlank()) return;
                    pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
                    String lowerName = pokemonName.toLowerCase();
                    smackDownGrounded.put(lowerName, true);
                    magnetRise.remove(lowerName);
                    telekinesis.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} grounded by {}! [from activate message]", pokemonName, effectId);
                    return;
                }
                case "item": 
                case "enditem": {
                    if (parts.length < 4) return;
                    if (args == null) return;
                    if (args.length < 1) return;
                    String itemId = ((String)parts[3]).toLowerCase();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Item message detected: {} (parts[2]: {})", itemId, parts[2]);
                    String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    String pokemonSpecies = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0);
                    if (pokemonSpecies == null && pokemonFull != null) {
                        pokemonSpecies = BattleMessageSubscriber.stripOwnerPrefix(pokemonFull).toLowerCase(Locale.ROOT);
                    }
                    String itemSide = null;
                    if (pokemonFull != null && (itemSide = ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT))) == null && pokemonSpecies != null) {
                        itemSide = ownerTextToSide.get(pokemonSpecies);
                    }
                    if (itemSide == null && pokemonSpecies != null) {
                        if (localPlayerPokemon.contains(pokemonSpecies)) {
                            itemSide = "player";
                        } else if (opponentPokemon.contains(pokemonSpecies)) {
                            itemSide = "opponent";
                        }
                    }
                    String localizedItemName = null;
                    if (args.length >= 2) {
                        localizedItemName = BattleMessageSubscriber.safeExtractPlainText(args[1]);
                    }
                    if (localizedItemName == null || localizedItemName.isBlank()) {
                        localizedItemName = BattleMessageSubscriber.formatItemName(itemId);
                    }
                    if ("opponent".equals(itemSide) && pokemonSpecies != null && itemId != null && localizedItemName != null) {
                        RevealedBattleInfo.recordHeldItem(itemSide, pokemonSpecies, itemId, localizedItemName);
                    }
                    String normalizedItemId = itemId != null ? itemId.replace("_", "") : "";
                    if (!"whiteherb".equals(normalizedItemId)) return;
                    if (pokemonSpecies == null) return;
                    String side = BattleMessageSubscriber.determineSideFromFullText(pokemonFull, pokemonSpecies);
                    if (side == null) {
                        side = itemSide;
                    }
                    String statKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, pokemonSpecies) : pokemonSpecies;
                    BattleMessageSubscriber.clearNegativeStatStages(statKey, pokemonSpecies);
                    return;
                }
                case "frisk": {
                    String[] itemParts;
                    class_2588 tc;
                    String itemKey;
                    class_2561 c;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Frisk message detected", new Object[0]);
                    if (args == null) return;
                    if (args.length < 3) return;
                    String targetFull = BattleMessageSubscriber.safeExtractPlainText(args[1]);
                    CharSequence targetSpecies = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 1);
                    if (targetSpecies == null && targetFull != null) {
                        targetSpecies = BattleMessageSubscriber.stripOwnerPrefix(targetFull).toLowerCase(Locale.ROOT);
                    }
                    String itemName = BattleMessageSubscriber.safeExtractPlainText(args[2]);
                    String itemId = null;
                    Object side = args[2];
                    if (side instanceof class_2561 && (side = (c = (class_2561)side).method_10851()) instanceof class_2588 && (itemKey = (tc = (class_2588)side).method_11022()) != null && (itemParts = itemKey.split("\\.")).length >= 3) {
                        itemId = itemParts[itemParts.length - 1];
                    }
                    if (itemId == null && itemName != null) {
                        itemId = itemName.toLowerCase().replace(" ", "_");
                    }
                    String friskSide = null;
                    if (targetFull != null && (friskSide = ownerTextToSide.get(targetFull.toLowerCase(Locale.ROOT))) == null && targetSpecies != null) {
                        friskSide = ownerTextToSide.get(targetSpecies);
                    }
                    if (friskSide == null && targetSpecies != null) {
                        if (localPlayerPokemon.contains(targetSpecies)) {
                            friskSide = "player";
                        } else if (opponentPokemon.contains(targetSpecies)) {
                            friskSide = "opponent";
                        }
                    }
                    if (!"opponent".equals(friskSide)) return;
                    if (targetSpecies == null) return;
                    if (itemId == null) return;
                    if (itemName == null) return;
                    RevealedBattleInfo.recordHeldItem(friskSide, (String)targetSpecies, itemId, itemName);
                    return;
                }
                case "supereffective": 
                case "resisted": 
                case "immune": 
                case "miss": 
                case "fail": 
                case "damage": 
                case "hitcount": {
                    String localizedMessage = class_2561.method_43469((String)key, (Object[])args).getString();
                    switch (parts[2]) {
                        case "supereffective": {
                            BattleMessageColorizer.registerEffectivenessMetadata(localizedMessage, "super");
                            return;
                        }
                        case "resisted": {
                            BattleMessageColorizer.registerEffectivenessMetadata(localizedMessage, "resisted");
                            return;
                        }
                        case "immune": {
                            BattleMessageColorizer.registerEffectivenessMetadata(localizedMessage, "immune");
                            return;
                        }
                        case "miss": 
                        case "fail": {
                            BattleMessageColorizer.registerMissMetadata(localizedMessage);
                        }
                    }
                    return;
                }
                default: {
                    if (key == null) return;
                    if (!key.contains("cobblemon.battle")) return;
                    String localizedMessage = class_2561.method_43469((String)key, (Object[])args).getString();
                    String lowerKey = key.toLowerCase();
                    String lowerMessage = localizedMessage.toLowerCase();
                    if (lowerKey.contains("supereffective") || lowerKey.contains("super.effective")) {
                        BattleMessageColorizer.registerEffectivenessMetadata(localizedMessage, "super");
                    } else if (lowerKey.contains("resisted") || lowerKey.contains("not.very.effective") || lowerKey.contains("notveryeffective")) {
                        BattleMessageColorizer.registerEffectivenessMetadata(localizedMessage, "resisted");
                    } else if (lowerKey.contains("immune") || lowerKey.contains("no.effect") || lowerKey.contains("noeffect")) {
                        BattleMessageColorizer.registerEffectivenessMetadata(localizedMessage, "immune");
                    } else if (lowerKey.contains("miss") || lowerKey.contains("fail") || lowerKey.contains("avoid")) {
                        BattleMessageColorizer.registerMissMetadata(localizedMessage);
                    } else if (lowerKey.contains("critical") || lowerKey.contains("crit")) {
                        BattleMessageColorizer.registerCriticalHitMetadata(localizedMessage);
                    }
                    if (lowerKey.contains(".brn") || lowerMessage.contains("burn")) {
                        BattleMessageColorizer.registerStatusEffectMetadata(localizedMessage, "burn");
                        return;
                    }
                    if (lowerKey.contains(".psn") || lowerKey.contains(".tox") || lowerMessage.contains("poison")) {
                        BattleMessageColorizer.registerStatusEffectMetadata(localizedMessage, "poison");
                        return;
                    }
                    if (lowerKey.contains(".par") || lowerMessage.contains("paralyz")) {
                        BattleMessageColorizer.registerStatusEffectMetadata(localizedMessage, "paralysis");
                        return;
                    }
                    if (lowerKey.contains(".slp") || lowerMessage.contains("asleep") || lowerMessage.contains("sleep")) {
                        BattleMessageColorizer.registerStatusEffectMetadata(localizedMessage, "sleep");
                        return;
                    }
                    if (!lowerKey.contains(".frz") && !lowerMessage.contains("frozen")) {
                        if (!lowerMessage.contains("freeze")) return;
                    }
                    BattleMessageColorizer.registerStatusEffectMetadata(localizedMessage, "freeze");
                }
            }
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void tryApplyAbilityPopupFromArgs(String[] parts, Object[] args) {
        try {
            if (args == null || args.length < 2) {
                return;
            }
            class_2561 pokemonComponent = null;
            if (args[0] instanceof class_2561) {
                pokemonComponent = (class_2561)args[0];
            }
            class_2561 abilityComponent = null;
            String abilityId = "unknown";
            if (args[1] instanceof class_2561) {
                String[] p;
                class_2588 tc;
                String key;
                abilityComponent = (class_2561)args[1];
                class_7417 class_74172 = abilityComponent.method_10851();
                if (class_74172 instanceof class_2588 && (key = (tc = (class_2588)class_74172).method_11022()) != null && key.startsWith("cobblemon.ability.") && (p = key.split("\\.")).length >= 3) {
                    abilityId = p[p.length - 1];
                }
            } else if (args[1] instanceof String) {
                abilityId = (String)args[1];
                String abilityKeyId = abilityId.toLowerCase().replaceAll("\\s+", "");
                abilityComponent = class_2561.method_43471((String)("cobblemon.ability." + abilityKeyId));
            }
            String pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
            if (pokemonName == null || pokemonName.isBlank()) {
                pokemonName = "unknown";
            }
            if (BattleMessageSubscriber.shouldShowAbilityPopup(pokemonName, abilityId)) {
                if (pokemonComponent != null && abilityComponent != null) {
                    AbilityPopupRenderer.showAbilityPopup(pokemonComponent, abilityComponent);
                }
                BattleMessageSubscriber.markAbilityPopupShown(pokemonName, abilityId);
                BattleMessageSubscriber.markAbilityPopupShownFromKey();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void tryApplySwitchInFromArgs(String[] parts, Object[] args) {
        try {
            if (args == null || args.length < 2) {
                return;
            }
            String trainerName = BattleMessageSubscriber.safeExtractPlainText(args[0]);
            String pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 1);
            if (pokemonName == null || pokemonName.isBlank()) {
                return;
            }
            if (localPlayerName != null && trainerName != null && trainerName.equals(localPlayerName)) {
                localPlayerPokemon.add(pokemonName.toLowerCase());
                opponentPokemon.remove(pokemonName.toLowerCase());
                currentActivePlayerPokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked player Pokemon (switch-in via TK): {} (now active)", pokemonName);
            } else if (!localPlayerPokemon.contains(pokemonName.toLowerCase())) {
                opponentPokemon.add(pokemonName.toLowerCase());
                BattleMessageColorizer.registerOpponentPokemon(pokemonName);
                currentActiveOpponentPokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked opponent Pokemon (switch-in via TK): {} (now active)", pokemonName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void tryApplySwitchOutFromArgs(String[] parts, Object[] args) {
        try {
            if (args == null || args.length < 1) {
                return;
            }
            String pokemonName = null;
            if (args.length >= 2) {
                pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 1);
            }
            if (pokemonName == null || pokemonName.isBlank()) {
                pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
            }
            if (pokemonName == null || pokemonName.isBlank()) {
                return;
            }
            pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
            BattleMessageSubscriber.clearStatStagesForPokemon(pokemonName);
            BattleMessageSubscriber.clearVolatileStatus(pokemonName);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Switch-out (TK): Cleared stat stages and volatile status for {}", pokemonName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void tryApplyForcedSwitchFromArgs(String[] parts, Object[] args, String key) {
        try {
            class_2588 tc;
            String wrapperKey;
            class_2561 c;
            if (args == null || args.length < 1) {
                return;
            }
            String newPokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
            if (newPokemonName == null || newPokemonName.isBlank()) {
                newPokemonName = BattleMessageSubscriber.safeExtractPlainText(args[0]);
            }
            if (newPokemonName != null) {
                String beforeStrip = newPokemonName;
                newPokemonName = BattleMessageSubscriber.stripOwnerPrefix(newPokemonName);
            }
            String ownerNameFromKey = null;
            Object object = args[0];
            if (object instanceof class_2561 && (object = (c = (class_2561)object).method_10851()) instanceof class_2588 && (wrapperKey = (tc = (class_2588)object).method_11022()) != null && (wrapperKey.contains("owned_pokemon") || wrapperKey.contains("enemy_pokemon") || wrapperKey.contains("wild_pokemon")) && tc.method_11023().length >= 1) {
                ownerNameFromKey = BattleMessageSubscriber.safeExtractPlainText(tc.method_11023()[0]);
            }
            String side = null;
            String previousActivePokemon = null;
            if (newPokemonName != null) {
                String lowerNewPokemon = newPokemonName.toLowerCase(Locale.ROOT);
                if (ownerNameFromKey != null && localPlayerName != null) {
                    if (ownerNameFromKey.equalsIgnoreCase(localPlayerName)) {
                        side = "player";
                        previousActivePokemon = currentActivePlayerPokemon;
                        currentActivePlayerPokemon = newPokemonName;
                        localPlayerPokemon.add(lowerNewPokemon);
                    } else {
                        side = "opponent";
                        previousActivePokemon = currentActiveOpponentPokemon;
                        currentActiveOpponentPokemon = newPokemonName;
                        opponentPokemon.add(lowerNewPokemon);
                    }
                } else if (localPlayerPokemon.contains(lowerNewPokemon)) {
                    side = "player";
                    previousActivePokemon = currentActivePlayerPokemon;
                    currentActivePlayerPokemon = newPokemonName;
                } else if (opponentPokemon.contains(lowerNewPokemon)) {
                    side = "opponent";
                    previousActivePokemon = currentActiveOpponentPokemon;
                    currentActiveOpponentPokemon = newPokemonName;
                } else {
                    String fullText = BattleMessageSubscriber.safeExtractPlainText(args[0]);
                    if (fullText != null) {
                        String lowerFull = fullText.toLowerCase(Locale.ROOT);
                        String mappedSide = ownerTextToSide.get(lowerFull);
                        if (mappedSide != null) {
                            side = mappedSide;
                            if ("player".equals(side)) {
                                previousActivePokemon = currentActivePlayerPokemon;
                                currentActivePlayerPokemon = newPokemonName;
                                localPlayerPokemon.add(lowerNewPokemon);
                            } else {
                                previousActivePokemon = currentActiveOpponentPokemon;
                                currentActiveOpponentPokemon = newPokemonName;
                                opponentPokemon.add(lowerNewPokemon);
                            }
                        } else {
                            boolean isPlayerPokemon = false;
                            if (localPlayerName != null && !localPlayerName.isBlank()) {
                                String lowerFullText = fullText.toLowerCase(Locale.ROOT);
                                String lowerPlayerName = localPlayerName.toLowerCase(Locale.ROOT);
                                isPlayerPokemon = lowerFullText.contains(lowerPlayerName);
                            }
                            if (isPlayerPokemon) {
                                side = "player";
                                previousActivePokemon = currentActivePlayerPokemon;
                                currentActivePlayerPokemon = newPokemonName;
                                localPlayerPokemon.add(lowerNewPokemon);
                                ownerTextToSide.put(lowerFull, "player");
                            } else {
                                side = "opponent";
                                previousActivePokemon = currentActiveOpponentPokemon;
                                currentActiveOpponentPokemon = newPokemonName;
                                opponentPokemon.add(lowerNewPokemon);
                                ownerTextToSide.put(lowerFull, "opponent");
                            }
                        }
                    }
                }
            }
            if (previousActivePokemon != null && !previousActivePokemon.equalsIgnoreCase(newPokemonName)) {
                BattleMessageSubscriber.clearStatStagesForPokemon(previousActivePokemon);
                BattleMessageSubscriber.clearVolatileStatus(previousActivePokemon);
            }
        }
        catch (Throwable t) {
            LOGGER.error("[BattleMessageSubscriber] Error in tryApplyForcedSwitchFromArgs: {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private static boolean shouldShowAbilityPopup(String pokemonName, String abilityName) {
        try {
            String k = (pokemonName + "|" + abilityName).toLowerCase(Locale.ROOT);
            long now = System.currentTimeMillis();
            Long last = recentAbilityPopups.get(k);
            return last == null || now - last > 1500L;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    private static void markAbilityPopupShown(String pokemonName, String abilityName) {
        try {
            String k = (pokemonName + "|" + abilityName).toLowerCase(Locale.ROOT);
            recentAbilityPopups.put(k, System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void markAbilityPopupShownFromKey() {
        try {
            lastAbilityPopupFromKeyMs = System.currentTimeMillis();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean shouldRunLegacyAbilityParsing() {
        try {
            long now = System.currentTimeMillis();
            return now - lastAbilityPopupFromKeyMs > 2000L;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    private static String safeExtractAbilityNameFromArgs(Object[] args, int idx) {
        try {
            String s;
            if (args == null || idx >= args.length) {
                return null;
            }
            Object o = args[idx];
            if (o instanceof class_2561) {
                class_2561 c = (class_2561)o;
                class_7417 class_74172 = c.method_10851();
                if (class_74172 instanceof class_2588) {
                    String s2;
                    String id;
                    String[] p;
                    class_2588 tc = (class_2588)class_74172;
                    String key = tc.method_11022();
                    if (key != null && (p = key.split("\\.")).length >= 3 && (id = p[p.length - 1]) != null && !id.isBlank()) {
                        return BattleMessageSubscriber.formatIdentifierToTitle(id);
                    }
                    Object[] a = tc.method_11023();
                    if (a != null && a.length > 0 && (s2 = BattleMessageSubscriber.safeExtractPlainText(a[0])) != null && !s2.isBlank()) {
                        return s2;
                    }
                }
                try {
                    String s3 = c.getString();
                    if (s3 != null && !s3.isBlank()) {
                        return s3;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return (s = String.valueOf(o)) == null || s.isBlank() ? null : s;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String safeExtractPlainText(Object o) {
        try {
            if (o == null) {
                return null;
            }
            if (o instanceof class_2561) {
                class_2561 c = (class_2561)o;
                try {
                    String s = c.getString();
                    return s == null || s.isBlank() ? null : s;
                }
                catch (Throwable ignored) {
                    return null;
                }
            }
            String s = String.valueOf(o);
            return s == null || s.isBlank() ? null : s;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String formatIdentifierToTitle(String id) {
        try {
            String s = id;
            if (s == null) {
                return null;
            }
            if ((s = s.replace('_', ' ').replace('-', ' ').trim()).isEmpty()) {
                return null;
            }
            String[] parts = s.split("\\s+");
            StringBuilder out = new StringBuilder();
            for (String p : parts) {
                if (p.isBlank()) continue;
                if (out.length() > 0) {
                    out.append(' ');
                }
                out.append(Character.toUpperCase(p.charAt(0)));
                if (p.length() <= 1) continue;
                out.append(p.substring(1));
            }
            return out.toString();
        }
        catch (Throwable ignored) {
            return id;
        }
    }

    private static void tryApplyTerastallizationFromArgs(String[] parts, Object[] args) {
        try {
            String pokemonFull;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] tryApplyTerastallizationFromArgs called", new Object[0]);
            if (args == null || args.length == 0) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera: No args!", new Object[0]);
                return;
            }
            String speciesId = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, 0);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera: speciesId='{}'", speciesId);
            if ((speciesId == null || speciesId.isBlank()) && (pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0])) != null) {
                speciesId = BattleMessageSubscriber.stripOwnerPrefix(pokemonFull).toLowerCase(Locale.ROOT);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera: speciesId from stripOwnerPrefix='{}'", speciesId);
            }
            if (speciesId == null || speciesId.isBlank()) {
                return;
            }
            pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
            String side = null;
            if (pokemonFull != null && (side = ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT))) == null) {
                side = ownerTextToSide.get(speciesId);
            }
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera: speciesId='{}' pokemonFull='{}' -> side='{}' (map keys: {})", speciesId, pokemonFull, side, ownerTextToSide.keySet());
            String teraType = null;
            if (args.length >= 2) {
                teraType = BattleMessageSubscriber.safeExtractTypeNameFromArgs(args, 1);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera: teraType from args[1]='{}'", teraType);
            }
            if ((teraType == null || teraType.isBlank()) && parts != null) {
                for (String p : parts) {
                    String t;
                    if (p == null || (t = BattleMessageSubscriber.typeNameFromId(p)) == null) continue;
                    teraType = t;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera: teraType from parts='{}'", teraType);
                    break;
                }
            }
            if (teraType != null && !teraType.isBlank()) {
                String storageKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, speciesId) : speciesId;
                terastallized.put(storageKey, teraType);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera STORED: '{}' -> {}", storageKey, teraType);
            } else {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera: No teraType found!", new Object[0]);
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera error", t);
        }
    }

    private static void tryApplyMegaEvolutionFromArgs(String[] parts, Object[] args) {
        try {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] tryApplyMegaEvolutionFromArgs called - key: {}, args: {}", String.join((CharSequence)".", parts), args == null ? 0 : args.length);
            BattleMessageSubscriber.tryApplyMegaEvolutionFromArgsWithForm(parts, args, null);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error in tryApplyMegaEvolutionFromArgs", t);
        }
    }

    private static void tryApplyMegaEvolutionFromArgsWithForm(String[] parts, Object[] args, String megaForm) {
        block15: {
            try {
                String storageKey;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] tryApplyMegaEvolutionFromArgsWithForm called - key: {}, args: {}, form: {}", String.join((CharSequence)".", parts), args == null ? 0 : args.length, megaForm);
                if (args == null || args.length == 0) {
                    LOGGER.warn("[BattleMessageSubscriber] Mega: No args provided!");
                    return;
                }
                int speciesIdx = args.length >= 2 && BattleMessageSubscriber.safeLooksLikeActorLabel(args[0]) ? 1 : 0;
                String idKeyLower = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(args, speciesIdx);
                if (idKeyLower == null || idKeyLower.isBlank()) {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega: Failed to extract Pokemon species ID from args", new Object[0]);
                    return;
                }
                String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[speciesIdx]);
                String side = null;
                if (pokemonFull != null && (side = ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT))) == null) {
                    side = ownerTextToSide.get(idKeyLower);
                }
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega: species='{}' pokemonFull='{}' -> side='{}'", idKeyLower, pokemonFull, side);
                if (megaForm == null && args.length > 0) {
                    for (Object arg : args) {
                        if (!(arg instanceof class_2561)) continue;
                        class_2561 c = (class_2561)arg;
                        String text = c.getString().toLowerCase();
                        if (text.contains("x form") || text.contains("mega x") || text.contains("-x")) {
                            megaForm = "x";
                            break;
                        }
                        if (!text.contains("y form") && !text.contains("mega y") && !text.contains("-y")) continue;
                        megaForm = "y";
                        break;
                    }
                }
                String string = storageKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, idKeyLower) : idKeyLower;
                if (megaEvolved.containsKey(storageKey)) {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega: Types already set for '{}', skipping", storageKey);
                    return;
                }
                List<String> megaTypes = BattleMessageSubscriber.getMegaFormTypes(idKeyLower, megaForm);
                if (megaTypes == null || megaTypes.isEmpty()) {
                    megaTypes = Collections.emptyList();
                }
                megaEvolved.put(storageKey, megaTypes);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega stored: '{}' (form={}) with types: {}", storageKey, megaForm, megaTypes);
                CritChanceCache.markForClearing();
                if (parts.length < 3 || !"mega".equals(parts[2])) break block15;
                try {
                    class_2561 pokemonComp;
                    String pokemonText;
                    String messageWithoutPokemon;
                    Object object;
                    String fullKey = String.join((CharSequence)".", parts);
                    class_5250 megaMessage = class_2561.method_43469((String)fullKey, (Object[])args);
                    String localizedText = megaMessage.getString();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Evolution full message: '{}'", localizedText);
                    String lowerText = localizedText.toLowerCase();
                    if (args.length > 0 && (object = args[0]) instanceof class_2561 && !(messageWithoutPokemon = localizedText.replace(pokemonText = (pokemonComp = (class_2561)object).getString(), "").trim()).isEmpty()) {
                        BattleMessageColorizer.registerEffectMetadata(messageWithoutPokemon, "mega_evolved");
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Registered Mega Evolution phrase for colorization: '{}'", messageWithoutPokemon);
                    }
                    BattleMessageColorizer.registerEffectMetadata("Mega Evolved!", "mega_evolved");
                    BattleMessageColorizer.registerEffectMetadata("Mega Evolved", "mega_evolved");
                    BattleMessageColorizer.registerEffectMetadata("mega evolved!", "mega_evolved");
                    BattleMessageColorizer.registerEffectMetadata("mega evolved", "mega_evolved");
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Registered 'Mega Evolved!' variations for colorization", new Object[0]);
                    if (lowerText.contains("mega")) {
                        String[] words = localizedText.split("\\s+");
                        for (int i = 0; i < words.length - 1; ++i) {
                            if (!words[i].toLowerCase().contains("mega")) continue;
                            String phrase = words[i] + " " + words[i + 1];
                            String cleanPhrase = phrase.replaceAll("[!?.,;]$", "");
                            BattleMessageColorizer.registerEffectMetadata(cleanPhrase, "mega_evolved");
                            BattleMessageColorizer.registerEffectMetadata(cleanPhrase + "!", "mega_evolved");
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Registered Mega Evolution phrases: '{}' and '{}!'", cleanPhrase, cleanPhrase);
                        }
                    }
                }
                catch (Throwable regError) {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Failed to register Mega Evolution colorization metadata", regError);
                }
            }
            catch (Throwable t) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega extraction error", t);
            }
        }
    }

    private static boolean safeLooksLikeActorLabel(Object arg0) {
        try {
            String s;
            if (arg0 == null) {
                return false;
            }
            if (arg0 instanceof class_2561) {
                class_2561 c = (class_2561)arg0;
                s = c.getString();
            } else {
                s = String.valueOf(arg0);
            }
            if (s == null) {
                return false;
            }
            String lower = s.toLowerCase(Locale.ROOT);
            return lower.contains("owned pokemon") || lower.contains("opposing pokemon") || lower.contains("wild pokemon") || lower.contains("ally pokemon") || lower.contains("enemy pokemon");
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static String safeExtractPokemonSpeciesIdLowerFromArgs(Object[] args, int idx) {
        try {
            if (args == null || idx >= args.length) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Invalid args or index (args={}, idx={})", args == null ? "null" : Integer.valueOf(args.length), idx);
                return null;
            }
            Object o = args[idx];
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: args[{}] = {} (type: {})", idx, o, o == null ? "null" : o.getClass().getSimpleName());
            if (o instanceof class_2561) {
                class_2561 c = (class_2561)o;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Component string: '{}', contents type: {}", c.getString(), c.method_10851().getClass().getSimpleName());
                class_7417 class_74172 = c.method_10851();
                if (class_74172 instanceof class_2588) {
                    class_2588 tc = (class_2588)class_74172;
                    String key = tc.method_11022();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Translation key: '{}'", key);
                    if (key != null && key.startsWith("cobblemon.species.")) {
                        String id;
                        String[] p = key.split("\\.");
                        if (p.length >= 3 && (id = p[2]) != null && !id.isBlank() && !id.equals("name")) {
                            String result = id.toLowerCase(Locale.ROOT);
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: SUCCESS - Extracted species ID: '{}'", result);
                            return result;
                        }
                    } else if (key != null && (key.contains("owned_pokemon") || key.contains("enemy_pokemon") || key.contains("wild_pokemon"))) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Found wrapper key '{}', checking nested args", key);
                        Object[] nestedArgs = tc.method_11023();
                        if (nestedArgs != null) {
                            for (int i = 0; i < nestedArgs.length; ++i) {
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Checking nested arg[{}]", i);
                                String nestedResult = BattleMessageSubscriber.safeExtractPokemonSpeciesIdLowerFromArgs(nestedArgs, i);
                                if (nestedResult == null) continue;
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: SUCCESS from nested - Extracted species ID: '{}'", nestedResult);
                                return nestedResult;
                            }
                        }
                    } else {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Translation key doesn't start with 'cobblemon.species.': '{}'", key);
                    }
                } else {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Component contents is not TranslatableContents", new Object[0]);
                }
            } else {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Argument is not a Component", new Object[0]);
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: Exception", t);
        }
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Mega Extract: FAILED to extract species ID", new Object[0]);
        return null;
    }

    private static String safeExtractPokemonSpeciesNameFromArgs(Object[] args, int idx) {
        try {
            String id;
            String[] p;
            class_2588 tc;
            String key;
            class_2561 c;
            class_7417 class_74172;
            if (args == null || idx >= args.length) {
                return null;
            }
            Object o = args[idx];
            if (o instanceof class_2561 && (class_74172 = (c = (class_2561)o).method_10851()) instanceof class_2588 && (key = (tc = (class_2588)class_74172).method_11022()) != null && (p = key.split("\\.")).length >= 3 && (id = p[p.length - 1]) != null && !id.isBlank()) {
                return BattleMessageSubscriber.formatIdentifierToTitle(id);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String safeExtractTypeNameFromArgs(Object[] args, int idx) {
        try {
            class_2588 tc;
            String[] p;
            class_2561 c;
            class_7417 class_74172;
            if (args == null || idx >= args.length) {
                return null;
            }
            Object o = args[idx];
            if (o instanceof class_2561 && (class_74172 = (c = (class_2561)o).method_10851()) instanceof class_2588 && (p = (tc = (class_2588)class_74172).method_11022().split("\\.")).length >= 3) {
                return BattleMessageSubscriber.typeNameFromId(p[2]);
            }
            return BattleMessageSubscriber.typeNameFromId(String.valueOf(o));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String typeNameFromId(String id) {
        try {
            if (id == null) {
                return null;
            }
            String t = id.toLowerCase(Locale.ROOT);
            if (t.contains(".")) {
                String[] p = t.split("\\.");
                t = p[p.length - 1];
            }
            return switch (t) {
                case "stellar" -> "Stellar";
                case "normal" -> "Normal";
                case "fire" -> "Fire";
                case "water" -> "Water";
                case "electric" -> "Electric";
                case "grass" -> "Grass";
                case "ice" -> "Ice";
                case "fighting" -> "Fighting";
                case "poison" -> "Poison";
                case "ground" -> "Ground";
                case "flying" -> "Flying";
                case "psychic" -> "Psychic";
                case "bug" -> "Bug";
                case "rock" -> "Rock";
                case "ghost" -> "Ghost";
                case "dragon" -> "Dragon";
                case "dark" -> "Dark";
                case "steel" -> "Steel";
                case "fairy" -> "Fairy";
                default -> null;
            };
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean isSelfSide(Object[] args) {
        try {
            class_2561 c;
            class_7417 class_74172;
            if (args == null || args.length == 0) {
                return true;
            }
            Object a0 = args[0];
            if (a0 instanceof class_2561 && (class_74172 = (c = (class_2561)a0).method_10851()) instanceof class_2588) {
                class_2588 tc = (class_2588)class_74172;
                return tc.method_11022().contains("ally") || tc.method_11022().contains("self");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private static String determineSideFromPartsOrArgs(String[] parts, Object[] args) {
        try {
            if (parts != null && parts.length >= 4) {
                String p = parts[3].toLowerCase(Locale.ROOT);
                if (p.contains("opponent") || p.contains("foe") || p.contains("enemy")) {
                    return "opponent";
                }
                if (p.contains("self") || p.contains("ally") || p.contains("player")) {
                    return "player";
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return BattleMessageSubscriber.isSelfSide(args) ? "player" : "opponent";
    }

    private static boolean applySideEffectFromId(String side, String effectId) {
        try {
            int screenDuration;
            if (side == null) {
                side = "player";
            }
            if (effectId == null) {
                return false;
            }
            String id = effectId.toLowerCase(Locale.ROOT);
            int n = screenDuration = hasLightClay ? 8 : 5;
            if (id.contains("lightscreen") || id.contains("light_screen")) {
                BattleMessageSubscriber.setScreen(side, "Light Screen", screenDuration);
                return true;
            }
            if ((id.contains("reflect") || id.contains("reflectscreen")) && !id.contains("reflecttype")) {
                BattleMessageSubscriber.setScreen(side, "Reflect", screenDuration);
                return true;
            }
            if (id.contains("auroraveil") || id.contains("aurora_veil")) {
                BattleMessageSubscriber.setScreen(side, "Aurora Veil", screenDuration);
                return true;
            }
            if (id.contains("mist") && !id.contains("misty")) {
                BattleMessageSubscriber.setScreen(side, "Mist", 5);
                return true;
            }
            if (id.contains("safeguard")) {
                BattleMessageSubscriber.setScreen(side, "Safeguard", 5);
                return true;
            }
            if (id.contains("luckychant") || id.contains("lucky_chant")) {
                BattleMessageSubscriber.setScreen(side, "Lucky Chant", 5);
                return true;
            }
            if (id.contains("tailwind")) {
                tailwind.put(side, 4);
                return true;
            }
            return false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static boolean removeSideEffectFromId(String side, String effectId) {
        try {
            if (side == null) {
                side = "player";
            }
            if (effectId == null) {
                return false;
            }
            String id = effectId.toLowerCase(Locale.ROOT);
            if (id.contains("lightscreen") || id.contains("light_screen")) {
                BattleMessageSubscriber.removeScreen(side, "Light Screen");
                return true;
            }
            if ((id.contains("reflect") || id.contains("reflectscreen")) && !id.contains("reflecttype")) {
                BattleMessageSubscriber.removeScreen(side, "Reflect");
                return true;
            }
            if (id.contains("auroraveil") || id.contains("aurora_veil")) {
                BattleMessageSubscriber.removeScreen(side, "Aurora Veil");
                return true;
            }
            if (id.contains("mist") && !id.contains("misty")) {
                BattleMessageSubscriber.removeScreen(side, "Mist");
                return true;
            }
            if (id.contains("safeguard")) {
                BattleMessageSubscriber.removeScreen(side, "Safeguard");
                return true;
            }
            if (id.contains("luckychant") || id.contains("lucky_chant")) {
                BattleMessageSubscriber.removeScreen(side, "Lucky Chant");
                return true;
            }
            if (id.contains("tailwind")) {
                tailwind.remove(side);
                return true;
            }
            return false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static void setWeatherFromId(String weatherId) {
        boolean weatherChanged;
        String id = weatherId == null ? "" : weatherId.toLowerCase(Locale.ROOT);
        String previousWeather = currentWeather;
        boolean isPrimalWeather = false;
        if (id.equals("primordialsea")) {
            currentWeather = "Heavy Rain";
            isPrimalWeather = true;
        } else if (id.equals("desolateland")) {
            currentWeather = "Harsh Sunlight";
            isPrimalWeather = true;
        } else if (id.equals("deltastream")) {
            currentWeather = "Strong Winds";
            isPrimalWeather = true;
        } else if (id.contains("rain")) {
            currentWeather = "Rain";
        } else if (id.contains("sun") || id.equals("sunnyday")) {
            currentWeather = "Sun";
        } else if (id.contains("sandstorm")) {
            currentWeather = "Sandstorm";
        } else if (id.contains("hail")) {
            currentWeather = "Hail";
        } else if (id.contains("snow")) {
            currentWeather = "Snow";
        } else {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Unknown weather ID: '{}'", weatherId);
            return;
        }
        boolean bl = weatherChanged = !currentWeather.equals(previousWeather);
        if (isPrimalWeather) {
            weatherTurns = -1;
            weatherStartTurn = 0;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Primal weather set to '{}' (permanent, ID: '{}')", currentWeather, weatherId);
        } else {
            int weatherDuration;
            int n = weatherDuration = hasWeatherRock ? 8 : 5;
            if (weatherChanged) {
                weatherTurns = weatherDuration;
                weatherStartTurn = currentTurnNumber;
                weatherJustSet = true;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Weather CHANGED to '{}' with {} turns on turn {} (ID: '{}')", currentWeather, weatherTurns, currentTurnNumber, weatherId);
            } else {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Weather '{}' refreshed (ID: '{}')", currentWeather, weatherId);
            }
        }
    }

    private static void setTerrainFromId(String terrainId) {
        if (terrainId == null) {
            return;
        }
        String id = terrainId.toLowerCase(Locale.ROOT);
        if (id.contains("electric")) {
            currentTerrain = "Electric Terrain";
        } else if (id.contains("grassy")) {
            currentTerrain = "Grassy Terrain";
        } else if (id.contains("misty")) {
            currentTerrain = "Misty Terrain";
        } else if (id.contains("psychic")) {
            currentTerrain = "Psychic Terrain";
        }
        terrainTurns = currentTerrain.isEmpty() ? 0 : 5;
        terrainStartTurn = lastTurnNumber > 0 ? lastTurnNumber : 1;
    }

    private static void setRoomFromId(String effectId) {
        if (effectId == null) {
            return;
        }
        String id = effectId.toLowerCase(Locale.ROOT);
        if (id.contains("trickroom")) {
            trickRoomTurns = 5;
        } else if (id.contains("gravity")) {
            gravityTurns = 5;
        } else if (id.contains("wonderroom")) {
            wonderRoomTurns = 5;
        } else if (id.contains("magicroom")) {
            magicRoomTurns = 5;
        } else if (id.contains("watersport")) {
            waterSportTurns = 5;
        } else if (id.contains("mudsport")) {
            mudSportTurns = 5;
        }
    }

    private static void clearRoomFromId(String effectId) {
        if (effectId == null) {
            return;
        }
        String id = effectId.toLowerCase(Locale.ROOT);
        if (id.contains("trickroom")) {
            trickRoomTurns = 0;
        } else if (id.contains("gravity")) {
            gravityTurns = 0;
        } else if (id.contains("wonderroom")) {
            wonderRoomTurns = 0;
        } else if (id.contains("magicroom")) {
            magicRoomTurns = 0;
        } else if (id.contains("watersport")) {
            waterSportTurns = 0;
        } else if (id.contains("mudsport")) {
            mudSportTurns = 0;
        }
    }

    private static void applyHazardFromId(String side, String hazardId) {
        String hazard = BattleMessageSubscriber.hazardDisplayName(hazardId);
        if (hazard.isEmpty()) {
            return;
        }
        if (hazard.equals("Spikes")) {
            BattleMessageSubscriber.addHazardLayer(side, hazard, 3);
        } else if (hazard.equals("Toxic Spikes")) {
            BattleMessageSubscriber.addHazardLayer(side, hazard, 2);
        } else {
            BattleMessageSubscriber.setHazard(side, hazard, 1);
        }
    }

    private static String hazardDisplayName(String hazardId) {
        if (hazardId == null) {
            return "";
        }
        String id = hazardId.toLowerCase(Locale.ROOT);
        if (id.contains("stealthrock")) {
            return "Stealth Rock";
        }
        if (id.contains("toxicspikes")) {
            return "Toxic Spikes";
        }
        if (id.contains("spikes")) {
            return "Spikes";
        }
        if (id.contains("stickyweb")) {
            return "Sticky Web";
        }
        return "";
    }

    private static void tryApplyStatBoost(String[] parts, Object[] args, boolean isBoost) {
        try {
            String lowerFullText;
            Object i2;
            class_2588 tc;
            class_2561 c;
            Object object;
            if (parts.length < 4 || args == null || args.length < 2) {
                return;
            }
            String severity = parts[3];
            String pokemonSpecies = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
            String pokemonFullText = BattleMessageSubscriber.safeExtractPlainText(args[0]);
            String stat = BattleMessageSubscriber.safeExtractStatIdFromArgs(args, 1);
            String ownerNameFromKey = null;
            if (args.length >= 1 && (object = args[0]) instanceof class_2561 && (object = (c = (class_2561)object).method_10851()) instanceof class_2588) {
                tc = (class_2588)object;
                if (tc.method_11022().equals("cobblemon.battle.owned_pokemon") && tc.method_11023().length >= 1) {
                    ownerNameFromKey = BattleMessageSubscriber.safeExtractPlainText(tc.method_11023()[0]);
                    CobblemonBattleInfoClient.debug("[STAT_EXTRACT] Extracted owner from translation key: '{}'", ownerNameFromKey);
                }
                CobblemonBattleInfoClient.debug("[STAT_EXTRACT] Pokemon translation key: '{}', args count: {}", tc.method_11022(), tc.method_11023().length);
                for (int i2 = 0; i2 < tc.method_11023().length; ++i2) {
                    CobblemonBattleInfoClient.debug("[STAT_EXTRACT]   Pokemon arg[{}]: {}", i2, tc.method_11023()[i2]);
                }
            }
            CobblemonBattleInfoClient.debug("[STAT_EXTRACT] pokemonSpecies='{}', pokemonFullText='{}', stat='{}', severity='{}', ownerFromKey='{}'", pokemonSpecies, pokemonFullText, stat, severity, ownerNameFromKey);
            if (args.length >= 2 && (i2 = args[1]) instanceof class_2561 && (i2 = (c = (class_2561)i2).method_10851()) instanceof class_2588) {
                tc = (class_2588)i2;
                CobblemonBattleInfoClient.debug("[STAT_EXTRACT] Stat translation key: '{}'", tc.method_11022());
            }
            if (pokemonSpecies == null || stat == null) {
                CobblemonBattleInfoClient.debug("[STAT_EXTRACT] FAILED - pokemonSpecies or stat is null, skipping", new Object[0]);
                return;
            }
            String pokemon = BattleMessageSubscriber.stripOwnerPrefix(pokemonSpecies);
            String lowerPokemon = pokemon.toLowerCase(Locale.ROOT);
            String side = null;
            if (ownerNameFromKey != null && localPlayerName != null) {
                if (ownerNameFromKey.equalsIgnoreCase(localPlayerName)) {
                    side = "player";
                    CobblemonBattleInfoClient.debug("[SIDE_DETECT_1] Matched player via translation key owner: '{}'", ownerNameFromKey);
                } else {
                    side = "opponent";
                    CobblemonBattleInfoClient.debug("[SIDE_DETECT_1] Owner '{}' != localPlayer '{}', assuming opponent", ownerNameFromKey, localPlayerName);
                }
            }
            if (side == null && pokemonFullText != null) {
                side = ownerTextToSide.get(pokemonFullText.toLowerCase(Locale.ROOT));
                CobblemonBattleInfoClient.debug("[SIDE_DETECT_2] Lookup pokemonFullText='{}' -> side={}", pokemonFullText.toLowerCase(Locale.ROOT), side);
            }
            if (side == null && ownerNameFromKey == null) {
                side = "opponent";
                CobblemonBattleInfoClient.debug("[SIDE_DETECT_3] No owner info for '{}', assuming opponent", pokemonFullText);
            }
            if (side == null && pokemonFullText != null && localPlayerName != null) {
                int diIdx;
                String ownerName = null;
                if (pokemonFullText.contains("'s ")) {
                    int apostropheIdx = pokemonFullText.indexOf("'s ");
                    if (apostropheIdx > 0) {
                        ownerName = pokemonFullText.substring(0, apostropheIdx);
                    }
                } else if (pokemonFullText.contains(" de ")) {
                    int deIdx = pokemonFullText.indexOf(" de ");
                    if (deIdx > 0) {
                        ownerName = pokemonFullText.substring(deIdx + 4);
                    }
                } else if (pokemonFullText.contains(" von ")) {
                    int vonIdx = pokemonFullText.indexOf(" von ");
                    if (vonIdx > 0) {
                        ownerName = pokemonFullText.substring(vonIdx + 5);
                    }
                } else if (pokemonFullText.contains(" di ") && (diIdx = pokemonFullText.indexOf(" di ")) > 0) {
                    ownerName = pokemonFullText.substring(diIdx + 4);
                }
                if (ownerName != null) {
                    if (ownerName.equalsIgnoreCase(localPlayerName)) {
                        side = "player";
                        CobblemonBattleInfoClient.debug("[SIDE_DETECT] Matched player name '{}' in '{}'", localPlayerName, pokemonFullText);
                    } else {
                        side = "opponent";
                        CobblemonBattleInfoClient.debug("[SIDE_DETECT] Owner '{}' doesn't match player '{}' in '{}'", ownerName, localPlayerName, pokemonFullText);
                    }
                } else {
                    side = "opponent";
                    CobblemonBattleInfoClient.debug("[SIDE_DETECT] No owner prefix, assuming wild/opponent: '{}'", pokemonFullText);
                }
            }
            if (side == null) {
                if (localPlayerPokemon.contains(lowerPokemon)) {
                    side = "player";
                } else if (opponentPokemon.contains(lowerPokemon)) {
                    side = "opponent";
                }
            }
            CobblemonBattleInfoClient.debug("[SIDE_DETECT] pokemonFullText='{}', pokemonSpecies='{}' -> side='{}' (map keys: {})", pokemonFullText, pokemonSpecies, side, ownerTextToSide.keySet());
            String statKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, pokemon) : pokemon;
            Map stages = statStages.computeIfAbsent(statKey, k -> new ConcurrentHashMap());
            int delta = switch (severity) {
                case "1", "slight" -> 1;
                case "2", "sharp" -> 2;
                case "3", "drastic", "severe" -> 3;
                case "max" -> 6;
                default -> {
                    LOGGER.warn("[BattleMessageSubscriber] Unknown severity '{}', defaulting to 1", (Object)severity);
                    yield 1;
                }
            };
            int current = stages.getOrDefault(stat, 0);
            int next = isBoost ? Math.min(6, current + delta) : Math.max(-6, current - delta);
            stages.put(stat, next);
            if (side != null && pokemonFullText != null && !ownerTextToSide.containsKey(lowerFullText = pokemonFullText.toLowerCase(Locale.ROOT))) {
                ownerTextToSide.put(lowerFullText, side);
                CobblemonBattleInfoClient.debug("[SIDE_LEARN] Learned mapping: '{}' -> {}", lowerFullText, side);
            }
            CobblemonBattleInfoClient.debug("[STAT_APPLIED] {} {} {} -> {} (key: '{}', side: {})", pokemon, stat, current, next, statKey, side);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error in tryApplyStatBoost", t);
        }
    }

    private static void tryApplyFocusEnergy(Object[] args) {
        try {
            if (args == null || args.length < 1) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] tryApplyFocusEnergy: No args provided", new Object[0]);
                return;
            }
            String pokemonSpecies = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
            String pokemonFullText = BattleMessageSubscriber.safeExtractPlainText(args[0]);
            if (pokemonSpecies == null || pokemonSpecies.isBlank()) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] tryApplyFocusEnergy: Failed to extract Pokemon name", new Object[0]);
                return;
            }
            String pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonSpecies);
            String lowerPokemon = pokemonName.toLowerCase(Locale.ROOT);
            String side = null;
            if (pokemonFullText != null) {
                side = ownerTextToSide.get(pokemonFullText.toLowerCase(Locale.ROOT));
            }
            if (side == null) {
                side = ownerTextToSide.get(lowerPokemon);
            }
            if (side == null && pokemonFullText != null) {
                if (pokemonFullText.contains("'s ") && localPlayerName != null) {
                    int apostropheIdx = pokemonFullText.indexOf("'s ");
                    if (apostropheIdx > 0) {
                        String ownerName = pokemonFullText.substring(0, apostropheIdx);
                        side = ownerName.equalsIgnoreCase(localPlayerName) ? "player" : "opponent";
                    }
                } else if (!pokemonFullText.contains("'s ")) {
                    side = "opponent";
                }
            }
            if (side == null) {
                if (localPlayerPokemon.contains(lowerPokemon)) {
                    side = "player";
                } else if (opponentPokemon.contains(lowerPokemon)) {
                    side = "opponent";
                }
            }
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Focus Energy detected side='{}' for pokemon='{}'", side, pokemonName);
            String statKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, pokemonName) : pokemonName;
            Map stages = statStages.computeIfAbsent(statKey, k -> new ConcurrentHashMap());
            stages.put("Crit", 2);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Focus Energy APPLIED: {} (side: {}, key: {}) Crit = +2", pokemonName, side, statKey);
        }
        catch (Throwable e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error applying Focus Energy", e);
        }
    }

    private static String safeExtractPokemonNameFromArgs(Object[] args, int idx) {
        try {
            if (args == null || idx >= args.length) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: args null or idx out of bounds", new Object[0]);
                return null;
            }
            Object o = args[idx];
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: arg[{}] type={}, value={}", idx, o == null ? "null" : o.getClass().getSimpleName(), o);
            if (o instanceof class_2561) {
                class_2561 c = (class_2561)o;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: Component getString='{}', contentsType={}", c.getString(), c.method_10851().getClass().getSimpleName());
                class_7417 class_74172 = c.method_10851();
                if (class_74172 instanceof class_2588) {
                    String[] parts;
                    class_2588 tc = (class_2588)class_74172;
                    String key = tc.method_11022();
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: TranslatableContents key='{}'", key);
                    if (key != null && key.startsWith("cobblemon.species.") && (parts = key.split("\\.")).length >= 3) {
                        String speciesId = parts[2];
                        return speciesId;
                    }
                    if (key != null && (key.contains("owned_pokemon") || key.contains("enemy_pokemon") || key.contains("wild_pokemon"))) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: Found wrapper key '{}', checking nested args for species", key);
                        Object[] nestedArgs = tc.method_11023();
                        if (nestedArgs != null) {
                            for (int i = 0; i < nestedArgs.length; ++i) {
                                String[] parts2;
                                class_2588 nestedTc;
                                String nestedKey;
                                class_2561 nestedComp;
                                class_7417 class_74173;
                                Object nestedArg = nestedArgs[i];
                                if (!(nestedArg instanceof class_2561) || !((class_74173 = (nestedComp = (class_2561)nestedArg).method_10851()) instanceof class_2588) || (nestedKey = (nestedTc = (class_2588)class_74173).method_11022()) == null || !nestedKey.startsWith("cobblemon.species.") || (parts2 = nestedKey.split("\\.")).length < 3) continue;
                                String speciesId = parts2[2];
                                return speciesId;
                            }
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: No species key found in nested args", new Object[0]);
                        }
                    }
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: No species key found, falling back to getString()", new Object[0]);
                }
                String fallback = c.getString();
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: FALLBACK to localized string: '{}'", fallback);
                return fallback;
            }
            String result = o == null ? null : o.toString();
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: Non-Component result: '{}'", result);
            return result;
        }
        catch (Throwable t) {
            LOGGER.error("[BattleMessageSubscriber] safeExtractPokemonNameFromArgs: Exception", t);
            return null;
        }
    }

    private static String safeExtractMoveIdFromArgs(Object[] args, int idx) {
        try {
            class_2561 c;
            class_7417 class_74172;
            if (args == null || idx >= args.length) {
                return null;
            }
            Object o = args[idx];
            if (o instanceof class_2561 && (class_74172 = (c = (class_2561)o).method_10851()) instanceof class_2588) {
                class_2588 tc = (class_2588)class_74172;
                String[] p = tc.method_11022().split("\\.");
                return p.length >= 3 ? p[2] : tc.method_11022();
            }
            return o == null ? null : o.toString();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String safeExtractStatIdFromArgs(Object[] args, int idx) {
        try {
            class_2561 c;
            class_7417 class_74172;
            if (args == null || idx >= args.length) {
                return null;
            }
            Object o = args[idx];
            if (o instanceof class_2561 && (class_74172 = (c = (class_2561)o).method_10851()) instanceof class_2588) {
                String statId;
                class_2588 tc = (class_2588)class_74172;
                String[] p = tc.method_11022().split("\\.");
                String string = statId = p.length >= 3 ? p[2] : tc.method_11022();
                if (statId != null) {
                    statId = statId.toLowerCase(Locale.ROOT).replace("_", "").replace(" ", "");
                }
                return statId;
            }
            return o == null ? null : o.toString();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String safeExtractTypeIdFromArgs(Object[] args, int idx) {
        try {
            class_2561 c;
            class_7417 class_74172;
            if (args == null || idx >= args.length) {
                return null;
            }
            Object o = args[idx];
            if (o instanceof class_2561 && (class_74172 = (c = (class_2561)o).method_10851()) instanceof class_2588) {
                class_2588 tc = (class_2588)class_74172;
                String[] p = tc.method_11022().split("\\.");
                return p.length >= 3 ? p[2] : tc.method_11022();
            }
            return o == null ? null : o.toString();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String getMoveTypeFromId(String moveId) {
        block10: {
            try {
                if (moveId == null || moveId.isBlank()) {
                    return null;
                }
                Class<?> movesClass = Class.forName("com.cobblemon.mod.common.api.moves.Moves");
                Object movesInstance = movesClass.getField("INSTANCE").get(null);
                Method getByNameMethod = movesInstance.getClass().getMethod("getByName", String.class);
                Object move = getByNameMethod.invoke(movesInstance, moveId);
                if (move == null) break block10;
                Object elementalType = null;
                try {
                    Method getElementalTypeMethod = move.getClass().getMethod("getElementalType", new Class[0]);
                    elementalType = getElementalTypeMethod.invoke(move, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method getTypeMethod = move.getClass().getMethod("getType", new Class[0]);
                        elementalType = getTypeMethod.invoke(move, new Object[0]);
                    }
                    catch (NoSuchMethodException e2) {
                        try {
                            Field typeField = move.getClass().getField("type");
                            elementalType = typeField.get(move);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                }
                if (elementalType != null) {
                    Method getNameMethod = elementalType.getClass().getMethod("getName", new Class[0]);
                    String typeName = (String)getNameMethod.invoke(elementalType, new Object[0]);
                    return typeName;
                }
            }
            catch (Throwable e) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Could not get move type for '{}': {}", moveId, e.getMessage());
            }
        }
        return null;
    }

    private static void tryApplyVolatileStatusFromArgs(String effectId, Object[] args) {
        try {
            String side;
            String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
            String pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
            if (pokemonName == null || pokemonName.isBlank()) {
                return;
            }
            pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
            String lowerName = pokemonName.toLowerCase();
            String string = side = pokemonFull != null ? ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT)) : null;
            if (side == null && pokemonFull != null) {
                boolean hasOwnerPrefix = false;
                if (localPlayerName != null && !localPlayerName.isBlank()) {
                    String fullLower = pokemonFull.toLowerCase(Locale.ROOT);
                    String nameLower = localPlayerName.toLowerCase(Locale.ROOT);
                    hasOwnerPrefix = fullLower.contains(nameLower);
                }
                side = hasOwnerPrefix ? "player" : (localPlayerPokemon.contains(lowerName) ? "player" : "opponent");
            }
            String storageKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, lowerName) : lowerName;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Processing effect '{}' for pokemon '{}' (key: {}, side: {})", effectId.toLowerCase(), pokemonName, storageKey, side);
            block19 : switch (effectId.toLowerCase()) {
                case "leechseed": {
                    leechSeeded.put(storageKey, true);
                    break;
                }
                case "ingrain": {
                    ingrained.put(storageKey, true);
                    break;
                }
                case "aquaring": {
                    aquaRing.put(storageKey, true);
                    break;
                }
                case "substitute": {
                    hasSubstitute.put(storageKey, true);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} created a Substitute! [key: {}, side: {}]", pokemonName, storageKey, side);
                    break;
                }
                case "embargo": {
                    embargo.put(storageKey, 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Embargo! (5 turns) [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "healblock": {
                    healBlock.put(storageKey, 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Heal Block! (5 turns) [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "magnetrise": {
                    magnetRise.put(storageKey, 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Magnet Rise! (5 turns) [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "telekinesis": {
                    telekinesis.put(storageKey, 3);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Telekinesis! (3 turns) [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "smackdown": {
                    smackDownGrounded.put(storageKey, true);
                    magnetRise.remove(storageKey);
                    telekinesis.remove(storageKey);
                    magnetRise.remove(lowerName);
                    telekinesis.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was hit by Smack Down! Now grounded. [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "typechange": {
                    if (args.length < 2) break;
                    String typeId = BattleMessageSubscriber.safeExtractTypeIdFromArgs(args, 1);
                    if (typeId == null || typeId.isBlank()) {
                        typeId = BattleMessageSubscriber.safeExtractPlainText(args[1]);
                    }
                    if (typeId != null && !typeId.isBlank()) {
                        if (typeId.contains("???")) {
                            String effectiveSide = side;
                            String trackedSide = lastBurnUpDoubleShockSide.get(lowerName);
                            if (trackedSide != null) {
                                effectiveSide = trackedSide;
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Using tracked side '{}' for {} Burn Up/Double Shock (was: {})", trackedSide, lowerName, side);
                                lastBurnUpDoubleShockSide.remove(lowerName);
                            }
                            String effectiveKey = BattleMessageSubscriber.makeSidedKey(effectiveSide, lowerName);
                            burnedUp.put(effectiveKey, true);
                            if (typeId.contains("/")) {
                                String[] typeParts;
                                for (String part : typeParts = typeId.split("/")) {
                                    if ("???".equals(part.trim()) || part.trim().isEmpty()) continue;
                                    Object remainingType = part.trim();
                                    remainingType = ((String)remainingType).substring(0, 1).toUpperCase() + ((String)remainingType).substring(1).toLowerCase();
                                    transformedTypes.put(effectiveKey, (String)remainingType);
                                    break block19;
                                }
                            }
                        } else {
                            String normalizedType = typeId.substring(0, 1).toUpperCase() + typeId.substring(1).toLowerCase();
                            transformedTypes.put(storageKey, normalizedType);
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} transformed into {} type! [from typechange args] (key: {}, side: {})", pokemonName, normalizedType, storageKey, side);
                            if ("water".equalsIgnoreCase(typeId)) {
                                soaked.put(storageKey, true);
                                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was soaked! [from args] (key: {})", pokemonName, storageKey);
                            }
                        }
                    }
                    break;
                }
                case "typeadd": {
                    if (args.length < 2) break;
                    String typeId = BattleMessageSubscriber.safeExtractTypeIdFromArgs(args, 1);
                    if (typeId != null && !typeId.isBlank()) {
                        String normalizedType = typeId.substring(0, 1).toUpperCase() + typeId.substring(1).toLowerCase();
                        addedTypes.put(storageKey, normalizedType);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} had {} type added! [from typeadd args] (key: {})", pokemonName, normalizedType, storageKey);
                    }
                    break;
                }
                case "confusion": {
                    confused.put(storageKey, true);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is now confused! [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "foresight": 
                case "miracleeye": {
                    identified.put(storageKey, true);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was identified! [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "burnup": {
                    burnedUp.put(storageKey, true);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Burn Up and lost Fire type! [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "doubleshock": {
                    doubleShocked.put(storageKey, true);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Double Shock and lost Electric type! [key: {}]", pokemonName, storageKey);
                }
            }
        }
        catch (Throwable e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error applying volatile status from args", e);
        }
    }

    private static void tryRemoveVolatileStatusFromArgs(String effectId, Object[] args) {
        try {
            String side;
            String pokemonFull = BattleMessageSubscriber.safeExtractPlainText(args[0]);
            String pokemonName = BattleMessageSubscriber.safeExtractPokemonNameFromArgs(args, 0);
            if (pokemonName == null || pokemonName.isBlank()) {
                return;
            }
            pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
            String lowerName = pokemonName.toLowerCase();
            String string = side = pokemonFull != null ? ownerTextToSide.get(pokemonFull.toLowerCase(Locale.ROOT)) : null;
            if (side == null && pokemonFull != null) {
                side = pokemonFull.contains("'s ") ? "player" : "opponent";
            }
            String storageKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, lowerName) : lowerName;
            switch (effectId.toLowerCase()) {
                case "leechseed": {
                    leechSeeded.remove(storageKey);
                    leechSeeded.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} leech seed removed [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "ingrain": {
                    ingrained.remove(storageKey);
                    ingrained.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} ingrain ended [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "aquaring": {
                    aquaRing.remove(storageKey);
                    aquaRing.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Aqua Ring ended [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "substitute": {
                    hasSubstitute.remove(storageKey);
                    hasSubstitute.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Substitute faded! [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "embargo": {
                    embargo.remove(storageKey);
                    embargo.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Embargo ended [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "healblock": {
                    healBlock.remove(storageKey);
                    healBlock.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Heal Block ended [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "magnetrise": {
                    magnetRise.remove(storageKey);
                    magnetRise.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Magnet Rise ended [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "telekinesis": {
                    telekinesis.remove(storageKey);
                    telekinesis.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Telekinesis ended [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "smackdown": {
                    smackDownGrounded.remove(storageKey);
                    smackDownGrounded.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is no longer grounded [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "typechange": {
                    transformedTypes.remove(storageKey);
                    transformedTypes.remove(lowerName);
                    soaked.remove(storageKey);
                    soaked.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} type change ended [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "typeadd": {
                    addedTypes.remove(storageKey);
                    addedTypes.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} added type removed [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "confusion": {
                    confused.remove(storageKey);
                    confused.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is no longer confused [key: {}]", pokemonName, storageKey);
                    break;
                }
                case "foresight": 
                case "miracleeye": {
                    identified.remove(storageKey);
                    identified.remove(lowerName);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is no longer identified [from args]", pokemonName);
                }
            }
        }
        catch (Throwable e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error removing volatile status from args", e);
        }
    }

    private static void decrementHazardTurnsIfAny() {
    }

    private static void decrementWeatherTurnsIfActive() {
        try {
            if (currentWeather == null || currentWeather.isEmpty()) {
                return;
            }
            if (weatherTurns < 0) {
                return;
            }
            if (weatherJustSet) {
                weatherJustSet = false;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Skipping weather decrement - just set this turn", new Object[0]);
                return;
            }
            if (weatherTurns > 0) {
                --weatherTurns;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void decrementTerrainTurnsIfActive() {
        try {
            if (currentTerrain == null || currentTerrain.isEmpty()) {
                return;
            }
            if (terrainStartTurn == currentTurnNumber) {
                return;
            }
            if (terrainTurns > 0) {
                --terrainTurns;
            }
            if (terrainTurns <= 0) {
                currentTerrain = "";
                terrainTurns = 0;
                terrainStartTurn = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void decrementRoomTurnsIfActive() {
        try {
            if (trickRoomTurns > 0) {
                --trickRoomTurns;
            }
            if (trickRoomTurns < 0) {
                trickRoomTurns = 0;
            }
            if (wonderRoomTurns > 0) {
                --wonderRoomTurns;
            }
            if (wonderRoomTurns < 0) {
                wonderRoomTurns = 0;
            }
            if (magicRoomTurns > 0) {
                --magicRoomTurns;
            }
            if (magicRoomTurns < 0) {
                magicRoomTurns = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void processCompleteMessage(String text) {
        try {
            String pokemonName;
            Object combinedText = text;
            if (pendingStatMessage != null && System.currentTimeMillis() - lastMessageTime < 500L) {
                combinedText = pendingStatMessage + " " + text;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Combined with pending: '{}'", combinedText);
            }
            if ((pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
                lastPokemonName = pokemonName;
                pendingStatMessage = text;
                lastMessageTime = System.currentTimeMillis();
            }
            BattleMessageSubscriber.trackPokemonOwnership((String)combinedText);
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Processing error: {}", e.getMessage(), e);
        }
    }

    private static void trackPokemonOwnership(String text) {
        String pokemonName;
        String possiblePlayer;
        int apostropheIdx;
        if (localPlayerName == null) {
            return;
        }
        if (!legacyStringParsingEnabled) {
            return;
        }
        String lower = text.toLowerCase();
        if (text.contains(localPlayerName + "'s ")) {
            String pokemonName2 = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName2 != null) {
                localPlayerPokemon.add(pokemonName2.toLowerCase());
                opponentPokemon.remove(pokemonName2.toLowerCase());
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked local player Pokemon: {}", pokemonName2);
            }
        } else if (lower.startsWith("go! ") || lower.contains("go! ")) {
            String afterGo;
            int endIdx;
            int goIdx = lower.indexOf("go! ");
            if (goIdx >= 0 && (endIdx = (afterGo = text.substring(goIdx + 4)).indexOf(33)) > 0) {
                String pokemonName3 = afterGo.substring(0, endIdx).trim();
                localPlayerPokemon.add(pokemonName3.toLowerCase());
                opponentPokemon.remove(pokemonName3.toLowerCase());
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked local player Pokemon (Go!): {}", pokemonName3);
            }
        } else if (lower.contains("opposing ") || lower.contains("the foe's ")) {
            String pokemonName4 = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName4 != null && !localPlayerPokemon.contains(pokemonName4.toLowerCase())) {
                opponentPokemon.add(pokemonName4.toLowerCase());
                BattleMessageColorizer.registerOpponentPokemon(pokemonName4);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked opponent Pokemon: {}", pokemonName4);
            }
        } else if (pendingSendOutTrainer != null && lower.startsWith("out ")) {
            String afterOut = text.substring(4);
            int endIdx = afterOut.indexOf(33);
            if (endIdx > 0) {
                String pokemonName5 = afterOut.substring(0, endIdx).trim();
                if (pokemonName5.contains("(") && pokemonName5.contains(")")) {
                    int parenStart = pokemonName5.indexOf(40);
                    int parenEnd = pokemonName5.indexOf(41);
                    if (parenEnd > parenStart) {
                        pokemonName5 = pokemonName5.substring(parenStart + 1, parenEnd).trim();
                    }
                }
                if (!pokemonName5.isEmpty() && !localPlayerPokemon.contains(pokemonName5.toLowerCase())) {
                    opponentPokemon.add(pokemonName5.toLowerCase());
                    BattleMessageColorizer.registerOpponentPokemon(pokemonName5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked opponent Pokemon (sent out by '{}') [from continuation]: {}", pendingSendOutTrainer, pokemonName5);
                }
            }
            pendingSendOutTrainer = null;
        } else if (lower.contains(" sent out ") || lower.endsWith(" sent")) {
            String possibleOpponent;
            int sentIdx;
            if (lower.contains(" sent out ")) {
                String afterSentOut;
                int endIdx;
                String possibleOpponent2;
                int sentOutIdx = lower.indexOf(" sent out ");
                if (sentOutIdx > 0 && !(possibleOpponent2 = text.substring(0, sentOutIdx).trim()).equals(localPlayerName) && (endIdx = (afterSentOut = text.substring(sentOutIdx + 10)).indexOf(33)) > 0) {
                    String pokemonName6 = afterSentOut.substring(0, endIdx).trim();
                    if (pokemonName6.contains("(") && pokemonName6.contains(")")) {
                        int parenStart = pokemonName6.indexOf(40);
                        int parenEnd = pokemonName6.indexOf(41);
                        if (parenEnd > parenStart) {
                            pokemonName6 = pokemonName6.substring(parenStart + 1, parenEnd).trim();
                        }
                    }
                    if (!pokemonName6.isEmpty() && !localPlayerPokemon.contains(pokemonName6.toLowerCase())) {
                        opponentPokemon.add(pokemonName6.toLowerCase());
                        BattleMessageColorizer.registerOpponentPokemon(pokemonName6);
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked opponent Pokemon (sent out by '{}'): {}", possibleOpponent2, pokemonName6);
                    }
                }
            } else if (lower.endsWith(" sent") && (sentIdx = lower.lastIndexOf(" sent")) > 0 && !(possibleOpponent = text.substring(0, sentIdx).trim()).equals(localPlayerName)) {
                pendingSendOutTrainer = possibleOpponent;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending send-out for trainer: {}", possibleOpponent);
            }
        } else if (text.contains("'s ") && (apostropheIdx = text.indexOf("'s ")) > 0 && !(possiblePlayer = text.substring(0, apostropheIdx)).equals(localPlayerName) && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null && !localPlayerPokemon.contains(pokemonName.toLowerCase())) {
            opponentPokemon.add(pokemonName.toLowerCase());
            BattleMessageColorizer.registerOpponentPokemon(pokemonName);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tracked opponent Pokemon (other player): {}", pokemonName);
        }
    }

    private static String determineSide(String pokemonName, String messageText) {
        String lower;
        String result = null;
        Object reason = "unknown";
        if (pokemonName != null) {
            String lowerName = pokemonName.toLowerCase();
            if (localPlayerPokemon.contains(lowerName)) {
                result = "player";
                reason = "tracked in localPlayerPokemon";
                CobblemonBattleInfoClient.debug("[SIDE_DETECT] {} -> {} ({})", pokemonName, result, reason);
                return result;
            }
            if (opponentPokemon.contains(lowerName)) {
                result = "opponent";
                reason = "tracked in opponentPokemon";
                CobblemonBattleInfoClient.debug("[SIDE_DETECT] {} -> {} ({})", pokemonName, result, reason);
                return result;
            }
        }
        if ((lower = messageText.toLowerCase()).contains("opposing ") || lower.contains("the foe's ") || lower.contains("enemy ")) {
            result = "opponent";
            reason = "text contains 'opposing'/'foe'/'enemy'";
            CobblemonBattleInfoClient.debug("[SIDE_DETECT] {} -> {} ({}) [text: {}]", pokemonName, result, reason, messageText);
            return result;
        }
        if (localPlayerName != null && messageText.contains(localPlayerName + "'s ")) {
            result = "player";
            reason = "text contains localPlayerName '" + localPlayerName + "'s'";
            CobblemonBattleInfoClient.debug("[SIDE_DETECT] {} -> {} ({}) [text: {}]", pokemonName, result, reason, messageText);
            return result;
        }
        result = "player";
        reason = "DEFAULT FALLBACK";
        LOGGER.warn("[SIDE_DETECT] {} -> {} ({}) [text: {}] [localPlayerPokemon: {}, opponentPokemon: {}]", new Object[]{pokemonName, result, reason, messageText, localPlayerPokemon, opponentPokemon});
        return result;
    }

    private static String determineUserSideFromMessage(String text) {
        if (localPlayerName == null) {
            return BattleMessageSubscriber.determineSide(BattleMessageSubscriber.extractPokemonName(text), text);
        }
        if (text.contains(localPlayerName + "'s ")) {
            return "player";
        }
        String cleanLocal = localPlayerName.replaceAll("^_+", "").replaceAll("_+$", "");
        if (!cleanLocal.equals(localPlayerName) && text.contains(cleanLocal + "'s ")) {
            return "player";
        }
        int apostropheIdx = text.indexOf("'s ");
        if (apostropheIdx > 0) {
            String possibleOwner = text.substring(0, apostropheIdx);
            int lastSpace = possibleOwner.lastIndexOf(32);
            if (lastSpace >= 0) {
                possibleOwner = possibleOwner.substring(lastSpace + 1);
            }
            if (!possibleOwner.equals(localPlayerName) && !possibleOwner.equals(cleanLocal)) {
                return "opponent";
            }
        }
        return "opponent";
    }

    private static String determineTargetSide(String text) {
        String lower = text.toLowerCase();
        if (lower.contains("your team") || lower.contains("your side")) {
            return "player";
        }
        if (lower.contains("opposing team") || lower.contains("foe's side") || lower.contains("the opposing")) {
            return "opponent";
        }
        String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
        String userSide = BattleMessageSubscriber.determineSide(pokemonName, text);
        if (lower.contains("used ")) {
            return userSide.equals("player") ? "opponent" : "player";
        }
        return BattleMessageSubscriber.determineSide(pokemonName, text);
    }

    private static String extractTextFromFormattedCharSequence(Object formattedCharSeq) {
        try {
            StringBuilder sb = new StringBuilder();
            Method acceptMethod = null;
            Class<?> sinkType = null;
            for (Class<?> iface : formattedCharSeq.getClass().getInterfaces()) {
                for (Method m : iface.getMethods()) {
                    if (!m.getName().equals("accept") || m.getParameterCount() != 1) continue;
                    acceptMethod = m;
                    sinkType = m.getParameterTypes()[0];
                    break;
                }
                if (acceptMethod != null) break;
            }
            if (acceptMethod == null || sinkType == null) {
                return null;
            }
            Object sinkProxy = Proxy.newProxyInstance(sinkType.getClassLoader(), new Class[]{sinkType}, (proxy, method, args) -> {
                if (method.getName().equals("accept")) {
                    if (args != null && args.length >= 3) {
                        int codePoint = ((Number)args[2]).intValue();
                        sb.appendCodePoint(codePoint);
                    }
                    return true;
                }
                return null;
            });
            acceptMethod.invoke(formattedCharSeq, sinkProxy);
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void decrementScreenTurns(String side) {
        Map<String, Integer> sideScreens = screens.get(side);
        if (sideScreens != null) {
            ArrayList<String> toExtend = new ArrayList<String>();
            for (Map.Entry<String, Integer> entry : sideScreens.entrySet()) {
                int currentTurns = entry.getValue();
                if (currentTurns <= 0) continue;
                int newTurns = currentTurns - 1;
                entry.setValue(newTurns);
                if (newTurns != 0 || hasLightClay) continue;
                toExtend.add(entry.getKey());
            }
            sideScreens.entrySet().removeIf(e -> (Integer)e.getValue() < 0);
        }
    }

    private static void detectLightClayAndExtendScreens() {
        for (String side : new String[]{"player", "opponent"}) {
            Map<String, Integer> sideScreens = screens.get(side);
            if (sideScreens == null) continue;
            for (Map.Entry<String, Integer> entry : sideScreens.entrySet()) {
                if (entry.getValue() != 0 || hasLightClay) continue;
                hasLightClay = true;
                entry.setValue(3);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Screen continued past 5 turns - Light Clay detected! Adding 3 more turns for {}", entry.getKey());
            }
        }
    }

    private static void decrementTailwindTurns(String side) {
        if (tailwind.containsKey(side)) {
            int current = tailwind.get(side);
            if (current > 1) {
                tailwind.put(side, current - 1);
            } else {
                tailwind.remove(side);
            }
        }
    }

    public static int getWaterSportTurns() {
        return waterSportTurns;
    }

    private static void decrementWaterSportTurns() {
        if (waterSportTurns > 0) {
            --waterSportTurns;
        }
    }

    public static int getMudSportTurns() {
        return mudSportTurns;
    }

    private static void decrementMudSportTurns() {
        if (mudSportTurns > 0) {
            --mudSportTurns;
        }
    }

    public static int getMagnetRiseTurns(String pokemonName) {
        if (pokemonName == null) {
            return 0;
        }
        return magnetRise.getOrDefault(pokemonName.toLowerCase(), 0);
    }

    public static int getMagnetRiseTurns(String side, String pokemonName) {
        String sidedKey;
        int turns;
        if (pokemonName == null) {
            return 0;
        }
        if (side != null && !side.isEmpty() && (turns = magnetRise.getOrDefault(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName), 0).intValue()) > 0) {
            return turns;
        }
        return magnetRise.getOrDefault(pokemonName.toLowerCase(), 0);
    }

    public static boolean hasUngroundedEffect(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        return magnetRise.getOrDefault(lower, 0) > 0 || telekinesis.getOrDefault(lower, 0) > 0;
    }

    public static boolean hasUngroundedEffect(String side, String pokemonName) {
        String lower;
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            if (magnetRise.getOrDefault(sidedKey, 0) > 0) {
                return true;
            }
            if (telekinesis.getOrDefault(sidedKey, 0) > 0) {
                return true;
            }
        }
        return magnetRise.getOrDefault(lower = pokemonName.toLowerCase(), 0) > 0 || telekinesis.getOrDefault(lower, 0) > 0;
    }

    public static int getUngroundedTurns(String pokemonName) {
        if (pokemonName == null) {
            return 0;
        }
        String lower = pokemonName.toLowerCase();
        int magnetTurns = magnetRise.getOrDefault(lower, 0);
        int teleTurns = telekinesis.getOrDefault(lower, 0);
        return Math.max(magnetTurns, teleTurns);
    }

    public static boolean isMagnetRiseActive(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        return magnetRise.getOrDefault(pokemonName.toLowerCase(), 0) > 0;
    }

    public static boolean isMagnetRiseActive(String side, String pokemonName) {
        String sidedKey;
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty() && magnetRise.getOrDefault(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName), 0) > 0) {
            return true;
        }
        return magnetRise.getOrDefault(pokemonName.toLowerCase(), 0) > 0;
    }

    public static boolean isTelekinesisActive(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        return telekinesis.getOrDefault(pokemonName.toLowerCase(), 0) > 0;
    }

    public static boolean isTelekinesisActive(String side, String pokemonName) {
        String sidedKey;
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty() && telekinesis.getOrDefault(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName), 0) > 0) {
            return true;
        }
        return telekinesis.getOrDefault(pokemonName.toLowerCase(), 0) > 0;
    }

    public static int getTelekinesisturns(String side, String pokemonName) {
        String sidedKey;
        int turns;
        if (pokemonName == null) {
            return 0;
        }
        if (side != null && !side.isEmpty() && (turns = telekinesis.getOrDefault(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName), 0).intValue()) > 0) {
            return turns;
        }
        return telekinesis.getOrDefault(pokemonName.toLowerCase(), 0);
    }

    private static void decrementMagnetRiseTurns() {
        magnetRise.replaceAll((k, v) -> v > 0 ? v - 1 : 0);
        magnetRise.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
    }

    private static void decrementTelekinesiseTurns() {
        telekinesis.replaceAll((k, v) -> v > 0 ? v - 1 : 0);
        telekinesis.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
    }

    public static boolean isGrounded(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        return gravityTurns > 0 || ingrained.getOrDefault(lower, false) != false || smackDownGrounded.getOrDefault(lower, false) != false;
    }

    public static int getGravityTurns() {
        return gravityTurns;
    }

    public static int getCurrentTurn() {
        return currentTurnNumber;
    }

    public static boolean isSmackDownGrounded(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        return smackDownGrounded.getOrDefault(pokemonName.toLowerCase(), false);
    }

    public static boolean isSmackDownGrounded(String side, String pokemonName) {
        String sidedKey;
        Boolean val;
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty() && (val = smackDownGrounded.get(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName))) != null) {
            return val;
        }
        return smackDownGrounded.getOrDefault(pokemonName.toLowerCase(), false);
    }

    public static int getUngroundedTurns(String side, String pokemonName) {
        int teleTurns;
        int magnetTurns;
        if (pokemonName == null) {
            return 0;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            magnetTurns = magnetRise.getOrDefault(sidedKey, 0);
            teleTurns = telekinesis.getOrDefault(sidedKey, 0);
            if (magnetTurns > 0 || teleTurns > 0) {
                return Math.max(magnetTurns, teleTurns);
            }
        }
        String lower = pokemonName.toLowerCase();
        magnetTurns = magnetRise.getOrDefault(lower, 0);
        teleTurns = telekinesis.getOrDefault(lower, 0);
        return Math.max(magnetTurns, teleTurns);
    }

    private static void decrementGravityTurns() {
        if (gravityTurns > 0 && --gravityTurns == 0) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Gravity wore off!", new Object[0]);
        }
    }

    private static void decrementEmbargoTurns() {
        embargo.replaceAll((k, v) -> v > 0 ? v - 1 : 0);
        embargo.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
    }

    private static void decrementHealBlockTurns() {
        healBlock.replaceAll((k, v) -> v > 0 ? v - 1 : 0);
        healBlock.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
    }

    private static void setScreen(String side, String screen, int turns) {
        screens.computeIfAbsent(side, k -> new ConcurrentHashMap()).put(screen, turns);
    }

    private static void removeScreen(String side, String screen) {
        Map<String, Integer> sideScreens = screens.get(side);
        if (sideScreens != null) {
            sideScreens.remove(screen);
        }
    }

    private static void parseHazards(String text) {
        String hazardSide;
        String userSide;
        boolean isToxicSpikes;
        String lower = text.toLowerCase();
        String targetSide = BattleMessageSubscriber.determineTargetSide(text);
        if (lower.contains("stealth rock")) {
            if (lower.contains("disappeared") || lower.contains("blown away") || lower.contains("spun away")) {
                String removalSide = BattleMessageSubscriber.determineSide(BattleMessageSubscriber.extractPokemonName(text), text);
                BattleMessageSubscriber.removeHazard(removalSide, "Stealth Rock");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Stealth Rock removed", removalSide);
            } else if (lower.contains("used stealth rock")) {
                BattleMessageSubscriber.setHazard(targetSide, "Stealth Rock", 1);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Stealth Rock set (used by {})", targetSide, targetSide.equals("player") ? "opponent" : "player");
            } else if (lower.contains("pointed stones float") || lower.contains("rocks float")) {
                String scatteredSide = lower.contains("your team") || lower.contains("your side") ? "player" : (lower.contains("opposing team") || lower.contains("foe's side") || lower.contains("the opposing") ? "opponent" : targetSide);
                BattleMessageSubscriber.setHazard(scatteredSide, "Stealth Rock", 1);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Stealth Rock set (float message)", scatteredSide);
            }
        }
        boolean bl = isToxicSpikes = lower.contains("toxic spikes") || lower.contains("poison spikes");
        if (isToxicSpikes) {
            if (lower.contains("disappeared") || lower.contains("blown away") || lower.contains("spun away") || lower.contains("absorbed")) {
                String removalSide = BattleMessageSubscriber.determineSide(BattleMessageSubscriber.extractPokemonName(text), text);
                BattleMessageSubscriber.removeHazard(removalSide, "Toxic Spikes");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Toxic Spikes removed", removalSide);
            } else if (lower.contains("used toxic spikes") || lower.contains("used poison spikes")) {
                userSide = BattleMessageSubscriber.determineUserSideFromMessage(text);
                hazardSide = userSide.equals("player") ? "opponent" : "player";
                BattleMessageSubscriber.addHazardLayer(hazardSide, "Toxic Spikes", 2);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Toxic Spikes layer added (user was on {} side)", hazardSide, userSide);
            }
        }
        if (!isToxicSpikes && lower.contains("spikes")) {
            if (lower.contains("disappeared") || lower.contains("blown away") || lower.contains("spun away")) {
                BattleMessageSubscriber.removeHazard(targetSide, "Spikes");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Spikes removed", targetSide);
            } else if (lower.contains("used spikes")) {
                userSide = BattleMessageSubscriber.determineUserSideFromMessage(text);
                hazardSide = userSide.equals("player") ? "opponent" : "player";
                BattleMessageSubscriber.addHazardLayer(hazardSide, "Spikes", 3);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Spikes layer added (user was on {} side)", hazardSide, userSide);
            }
        }
        if (lower.contains("sticky web")) {
            if (lower.contains("disappeared") || lower.contains("blown away") || lower.contains("spun away")) {
                BattleMessageSubscriber.removeHazard(targetSide, "Sticky Web");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Sticky Web removed", targetSide);
            } else if (lower.contains("used sticky web")) {
                BattleMessageSubscriber.setHazard(targetSide, "Sticky Web", 1);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Sticky Web set (used)", targetSide);
            } else if (lower.contains("sticky web has been laid") || lower.contains("web spread")) {
                String scatteredSide = lower.contains("your team") || lower.contains("your side") ? "player" : (lower.contains("opposing team") || lower.contains("foe's side") || lower.contains("the opposing") ? "opponent" : targetSide);
                BattleMessageSubscriber.setHazard(scatteredSide, "Sticky Web", 1);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Sticky Web set (laid message)", scatteredSide);
            }
        }
        if ((lower.contains("rapid spin") || lower.contains("defog")) && (lower.contains("blew away") || lower.contains("spun away") || lower.contains("cleared"))) {
            String clearSide = lower.contains("opposing") || lower.contains("foe") ? "opponent" : "player";
            BattleMessageSubscriber.clearAllHazards(clearSide);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} hazards cleared by Rapid Spin/Defog", clearSide);
        }
    }

    private static void setHazard(String side, String hazard, int layers) {
        hazards.computeIfAbsent(side, k -> new ConcurrentHashMap()).put(hazard, layers);
    }

    private static void addHazardLayer(String side, String hazard, int maxLayers) {
        Map sideHazards = hazards.computeIfAbsent(side, k -> new ConcurrentHashMap());
        int current = sideHazards.getOrDefault(hazard, 0);
        sideHazards.put(hazard, Math.min(current + 1, maxLayers));
    }

    private static void removeHazard(String side, String hazard) {
        Map<String, Integer> sideHazards = hazards.get(side);
        if (sideHazards != null) {
            sideHazards.remove(hazard);
        }
    }

    private static void clearAllHazards(String side) {
        Map<String, Integer> sideHazards = hazards.get(side);
        if (sideHazards != null) {
            sideHazards.clear();
        }
    }

    private static void parseStatChanges(String text) {
        boolean isStatMessage;
        long currentTime = System.currentTimeMillis();
        boolean bl = isStatMessage = text.toLowerCase().contains("attack") || text.toLowerCase().contains("defense") || text.toLowerCase().contains("speed") || text.toLowerCase().contains("accuracy") || text.toLowerCase().contains("evasion");
        if (currentTime - lastStatChangeMessageTime > 100L && statChangeBuffer.length() > 0) {
            BattleMessageSubscriber.processStatChangeBuffer();
            statChangeBuffer.setLength(0);
        }
        if (isStatMessage || statChangeBuffer.length() > 0) {
            if (statChangeBuffer.length() > 0) {
                statChangeBuffer.append(" ");
            }
            statChangeBuffer.append(text);
            lastStatChangeMessageTime = currentTime;
            if (text.endsWith("!") || text.endsWith(".")) {
                BattleMessageSubscriber.processStatChangeBuffer();
                statChangeBuffer.setLength(0);
            }
        }
    }

    private static void processStatChangeBuffer() {
        String bufferedText = statChangeBuffer.toString();
        String lower = bufferedText.toLowerCase();
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Processing buffered stat change: '{}'", bufferedText);
        String[] stats = new String[]{"special attack", "special defense", "attack", "defense", "speed", "accuracy", "evasion", "evasiveness"};
        String[] statAbbrev = new String[]{"SP.ATK", "SP.DEF", "ATK", "DEF", "SPD", "ACC", "Eva", "Eva"};
        for (int i = 0; i < stats.length; ++i) {
            if (!lower.contains(stats[i])) continue;
            int change = 0;
            if (lower.contains("rose drastically") || lower.contains("drastically rose")) {
                change = 3;
            } else if (lower.contains("rose sharply") || lower.contains("sharply rose")) {
                change = 2;
            } else if (lower.contains("rose")) {
                change = 1;
            } else if (lower.contains("fell drastically") || lower.contains("drastically fell")) {
                change = -3;
            } else if (lower.contains("harshly fell") || lower.contains("severely fell") || lower.contains("fell harshly") || lower.contains("fell severely")) {
                change = -2;
            } else if (lower.contains("fell sharply") || lower.contains("sharply fell")) {
                change = -2;
            } else if (lower.contains("fell")) {
                change = -1;
            }
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Detected change: {} for stat: {}", change, statAbbrev[i]);
            if (change == 0) break;
            String pokemonName = BattleMessageSubscriber.extractPokemonName(bufferedText);
            if (pokemonName == null && lastPokemonName != null) {
                pokemonName = lastPokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Using cached Pokemon name: {}", pokemonName);
            }
            if (pokemonName == null) break;
            String pokemonFull = bufferedText.toLowerCase(Locale.ROOT);
            String side = ownerTextToSide.get(pokemonFull);
            if (side == null && pokemonName != null) {
                side = ownerTextToSide.get(pokemonName.toLowerCase(Locale.ROOT));
            }
            String statKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, pokemonName) : pokemonName;
            Map stages = statStages.computeIfAbsent(statKey, k -> new ConcurrentHashMap());
            int current = stages.getOrDefault(statAbbrev[i], 0);
            int newValue = Math.max(-6, Math.min(6, current + change));
            stages.put(statAbbrev[i], newValue);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Stat change: {} (side: {}, key: {}) {} {} -> {}", pokemonName, side, statKey, statAbbrev[i], current, newValue);
            break;
        }
    }

    private static void parseFocusEnergy(String text) {
        String lower = text.toLowerCase();
        if (lower.contains("is getting pumped")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName == null && lastPokemonName != null) {
                pokemonName = lastPokemonName;
            }
            if (pokemonName != null) {
                String pokemonFull = text.toLowerCase(Locale.ROOT);
                String side = ownerTextToSide.get(pokemonFull);
                if (side == null && pokemonName != null) {
                    side = ownerTextToSide.get(pokemonName.toLowerCase(Locale.ROOT));
                }
                String statKey = side != null ? BattleMessageSubscriber.makeSidedKey(side, pokemonName) : pokemonName;
                Map stages = statStages.computeIfAbsent(statKey, k -> new ConcurrentHashMap());
                stages.put("Crit", 2);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Focus Energy: {} (side: {}, key: {}) Crit = +2", pokemonName, side, statKey);
            }
        }
    }

    private static void parseAbility(String text) {
        String[][] knownAbilities;
        String lower = text.toLowerCase();
        if (lower.contains(" rose") || lower.contains(" fell") || lower.contains(" was lowered") || lower.contains(" was raised")) {
            String pokemonName;
            if (lower.contains("intimidate") && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
                AbilityPopupRenderer.showAbilityPopup(pokemonName, "Intimidate");
            }
            return;
        }
        String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
        if (pokemonName == null) {
            return;
        }
        for (String[] ability : knownAbilities = new String[][]{{"sand stream", "Sand Stream"}, {"drizzle", "Drizzle"}, {"drought", "Drought"}, {"snow warning", "Snow Warning"}, {"electric surge", "Electric Surge"}, {"grassy surge", "Grassy Surge"}, {"misty surge", "Misty Surge"}, {"psychic surge", "Psychic Surge"}, {"intimidate", "Intimidate"}, {"pressure", "Pressure"}, {"mold breaker", "Mold Breaker"}, {"teravolt", "Teravolt"}, {"turboblaze", "Turboblaze"}, {"trace", "Trace"}, {"download", "Download"}, {"flash fire", "Flash Fire"}, {"levitate", "Levitate"}, {"sturdy", "Sturdy"}, {"wonder guard", "Wonder Guard"}, {"lightning rod", "Lightning Rod"}, {"storm drain", "Storm Drain"}, {"volt absorb", "Volt Absorb"}, {"water absorb", "Water Absorb"}, {"motor drive", "Motor Drive"}, {"justified", "Justified"}, {"rattled", "Rattled"}, {"speed boost", "Speed Boost"}, {"moody", "Moody"}, {"unnerve", "Unnerve"}, {"frisk", "Frisk"}, {"forewarn", "Forewarn"}, {"anticipation", "Anticipation"}, {"synchronize", "Synchronize"}, {"moxie", "Moxie"}, {"beast boost", "Beast Boost"}, {"soul-heart", "Soul-Heart"}, {"protean", "Protean"}, {"libero", "Libero"}, {"imposter", "Imposter"}, {"dry skin", "Dry Skin"}, {"thick fat", "Thick Fat"}, {"defiant", "Defiant"}, {"competitive", "Competitive"}, {"contrary", "Contrary"}, {"poison heal", "Poison Heal"}, {"guts", "Guts"}, {"marvel scale", "Marvel Scale"}, {"toxic boost", "Toxic Boost"}, {"flare boost", "Flare Boost"}, {"quick feet", "Quick Feet"}, {"magic bounce", "Magic Bounce"}, {"mirror armor", "Mirror Armor"}, {"prankster", "Prankster"}, {"technician", "Technician"}, {"adaptability", "Adaptability"}, {"sheer force", "Sheer Force"}, {"iron fist", "Iron Fist"}, {"mega launcher", "Mega Launcher"}, {"strong jaw", "Strong Jaw"}, {"tough claws", "Tough Claws"}, {"pixilate", "Pixilate"}, {"refrigerate", "Refrigerate"}, {"aerilate", "Aerilate"}, {"galvanize", "Galvanize"}, {"scrappy", "Scrappy"}, {"regenerator", "Regenerator"}, {"natural cure", "Natural Cure"}, {"poison point", "Poison Point"}, {"static", "Static"}, {"flame body", "Flame Body"}, {"effect spore", "Effect Spore"}, {"rough skin", "Rough Skin"}, {"iron barbs", "Iron Barbs"}, {"aftermath", "Aftermath"}, {"cute charm", "Cute Charm"}, {"cursed body", "Cursed Body"}, {"shadow tag", "Shadow Tag"}, {"arena trap", "Arena Trap"}, {"magnet pull", "Magnet Pull"}, {"weak armor", "Weak Armor"}, {"stamina", "Stamina"}, {"berserk", "Berserk"}, {"emergency exit", "Emergency Exit"}, {"wimp out", "Wimp Out"}, {"water compaction", "Water Compaction"}, {"sand spit", "Sand Spit"}, {"anger point", "Anger Point"}, {"white smoke", "White Smoke"}, {"clear body", "Clear Body"}, {"full metal body", "Full Metal Body"}, {"hyper cutter", "Hyper Cutter"}, {"keen eye", "Keen Eye"}, {"big pecks", "Big Pecks"}, {"own tempo", "Own Tempo"}, {"inner focus", "Inner Focus"}, {"oblivious", "Oblivious"}, {"limber", "Limber"}, {"insomnia", "Insomnia"}, {"vital spirit", "Vital Spirit"}, {"immunity", "Immunity"}, {"water veil", "Water Veil"}, {"magma armor", "Magma Armor"}, {"sand veil", "Sand Veil"}, {"snow cloak", "Snow Cloak"}, {"tangled feet", "Tangled Feet"}, {"air lock", "Air Lock"}, {"cloud nine", "Cloud Nine"}, {"overcoat", "Overcoat"}, {"sap sipper", "Sap Sipper"}, {"steam engine", "Steam Engine"}, {"intrepid sword", "Intrepid Sword"}, {"dauntless shield", "Dauntless Shield"}, {"chilling neigh", "Chilling Neigh"}, {"grim neigh", "Grim Neigh"}, {"as one", "As One"}, {"curious medicine", "Curious Medicine"}, {"gulp missile", "Gulp Missile"}, {"ice face", "Ice Face"}, {"mimicry", "Mimicry"}, {"power spot", "Power Spot"}, {"screen cleaner", "Screen Cleaner"}, {"steely spirit", "Steely Spirit"}, {"perish body", "Perish Body"}, {"wandering spirit", "Wandering Spirit"}, {"gorilla tactics", "Gorilla Tactics"}, {"neutralizing gas", "Neutralizing Gas"}, {"pastel veil", "Pastel Veil"}, {"hunger switch", "Hunger Switch"}, {"quick draw", "Quick Draw"}, {"unseen fist", "Unseen Fist"}, {"transistor", "Transistor"}, {"dragon's maw", "Dragon's Maw"}, {"thermal exchange", "Thermal Exchange"}, {"anger shell", "Anger Shell"}, {"purifying salt", "Purifying Salt"}, {"well-baked body", "Well-Baked Body"}, {"wind rider", "Wind Rider"}, {"guard dog", "Guard Dog"}, {"rocky payload", "Rocky Payload"}, {"wind power", "Wind Power"}, {"zero to hero", "Zero to Hero"}, {"commander", "Commander"}, {"electromorphosis", "Electromorphosis"}, {"opportunist", "Opportunist"}, {"cud chew", "Cud Chew"}, {"sharpness", "Sharpness"}, {"supreme overlord", "Supreme Overlord"}, {"costar", "Costar"}, {"toxic debris", "Toxic Debris"}, {"armor tail", "Armor Tail"}, {"earth eater", "Earth Eater"}, {"mycelium might", "Mycelium Might"}, {"hospitality", "Hospitality"}, {"minds eye", "Mind's Eye"}, {"embody aspect", "Embody Aspect"}, {"toxic chain", "Toxic Chain"}, {"supersweet syrup", "Supersweet Syrup"}, {"hadron engine", "Hadron Engine"}, {"orichalcum pulse", "Orichalcum Pulse"}, {"protosynthesis", "Protosynthesis"}, {"quark drive", "Quark Drive"}, {"good as gold", "Good as Gold"}, {"vessel of ruin", "Vessel of Ruin"}, {"sword of ruin", "Sword of Ruin"}, {"tablets of ruin", "Tablets of Ruin"}, {"beads of ruin", "Beads of Ruin"}, {"lingering aroma", "Lingering Aroma"}, {"seed sower", "Seed Sower"}, {"thermal exchange", "Thermal Exchange"}, {"berserk", "Berserk"}, {"analytic", "Analytic"}, {"harvest", "Harvest"}, {"illusion", "Illusion"}, {"pickpocket", "Pickpocket"}, {"receiver", "Receiver"}, {"power of alchemy", "Power of Alchemy"}, {"symbiosis", "Symbiosis"}, {"stakeout", "Stakeout"}, {"battery", "Battery"}, {"fluffy", "Fluffy"}, {"dazzling", "Dazzling"}, {"queenly majesty", "Queenly Majesty"}, {"innards out", "Innards Out"}, {"stall", "Stall"}, {"slow start", "Slow Start"}, {"truant", "Truant"}, {"schooling", "Schooling"}, {"shields down", "Shields Down"}, {"disguise", "Disguise"}, {"battle bond", "Battle Bond"}, {"power construct", "Power Construct"}, {"corrosion", "Corrosion"}, {"comatose", "Comatose"}, {"dancer", "Dancer"}, {"ball fetch", "Ball Fetch"}, {"cotton down", "Cotton Down"}, {"propeller tail", "Propeller Tail"}, {"ice scales", "Ice Scales"}, {"ripen", "Ripen"}, {"stalwart", "Stalwart"}}) {
            if (!lower.contains(ability[0])) continue;
            AbilityPopupRenderer.showAbilityPopup(pokemonName, ability[1]);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Ability popup: {} - {}", pokemonName, ability[1]);
            return;
        }
    }

    private static void parseSwitchOut(String text) {
        String pokemonName;
        boolean isSwitchOut;
        String lower = text.toLowerCase();
        boolean bl = isSwitchOut = lower.contains("withdrew") || lower.contains("come back") || lower.contains("that's enough") || lower.contains("switch out") || lower.contains("switched out") || lower.contains("was dragged out") || lower.contains("was blown away");
        if (isSwitchOut && (pokemonName = BattleMessageSubscriber.extractSwitchOutPokemonName(text)) != null) {
            BattleMessageSubscriber.clearStatStagesForPokemon(pokemonName);
            BattleMessageSubscriber.clearVolatileStatus(pokemonName);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Cleared stat stages and volatile status for switched-out Pokemon: {}", pokemonName);
        }
    }

    private static String extractSwitchOutPokemonName(String text) {
        int commaIdx;
        int apostropheS;
        int wasIdx;
        int idx;
        String lower = text.toLowerCase();
        if (lower.contains("withdrew") && (idx = lower.indexOf("withdrew")) >= 0) {
            String afterWithdrew = text.substring(idx + "withdrew ".length()).trim();
            int endIdx = afterWithdrew.indexOf(33);
            if (endIdx > 0) {
                return afterWithdrew.substring(0, endIdx).trim();
            }
            endIdx = afterWithdrew.indexOf(44);
            if (endIdx > 0) {
                return afterWithdrew.substring(0, endIdx).trim();
            }
            String[] words = afterWithdrew.split("\\s+");
            if (words.length > 0) {
                return words[0].replaceAll("[!.,]", "").trim();
            }
        }
        if ((lower.contains("was dragged out") || lower.contains("was blown away")) && (wasIdx = lower.indexOf(" was ")) > 0) {
            String beforeWas = text.substring(0, wasIdx).trim();
            apostropheS = beforeWas.lastIndexOf("'s ");
            if (apostropheS > 0) {
                return beforeWas.substring(apostropheS + 3).trim();
            }
            return beforeWas;
        }
        if ((lower.contains(", come back") || lower.contains(", that's enough")) && (commaIdx = text.indexOf(44)) > 0) {
            String beforeComma = text.substring(0, commaIdx).trim();
            apostropheS = beforeComma.lastIndexOf("'s ");
            if (apostropheS > 0) {
                return beforeComma.substring(apostropheS + 3).trim();
            }
            return beforeComma;
        }
        return null;
    }

    private static void clearStatStagesForPokemon(String pokemonName) {
        if (pokemonName == null) {
            return;
        }
        String lowerName = pokemonName.toLowerCase();
        statStages.remove(pokemonName);
        statStages.remove(lowerName);
        statStages.remove(BattleMessageSubscriber.makeSidedKey("player", pokemonName));
        statStages.remove(BattleMessageSubscriber.makeSidedKey("opponent", pokemonName));
        statStages.entrySet().removeIf(entry -> {
            String namePart;
            String key = (String)entry.getKey();
            String keyLower = key.toLowerCase();
            if (key.equalsIgnoreCase(pokemonName) || keyLower.contains(lowerName) || lowerName.contains(keyLower)) {
                return true;
            }
            return key.contains("_") && ((namePart = key.substring(key.indexOf("_") + 1)).equalsIgnoreCase(pokemonName) || namePart.equalsIgnoreCase(lowerName));
        });
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Stat stages after clearing {}: {}", pokemonName, statStages);
    }

    private static boolean clearNegativeStatStages(String statKey, String pokemonName) {
        if (statKey == null) {
            return false;
        }
        Map<String, Integer> stages = statStages.get(statKey);
        if (stages == null || stages.isEmpty()) {
            return false;
        }
        boolean removed = stages.entrySet().removeIf(entry -> entry.getValue() != null && (Integer)entry.getValue() < 0);
        if (stages.isEmpty()) {
            statStages.remove(statKey);
        }
        return removed;
    }

    private static String extractPokemonName(String text) {
        String lowerWord;
        String firstWord;
        int firstApostrophe;
        String workingText = text;
        if (workingText.startsWith("The opposing ")) {
            workingText = workingText.substring("The opposing ".length());
        }
        if ((firstApostrophe = workingText.indexOf("'s ")) <= 0) {
            return null;
        }
        int secondApostrophe = workingText.indexOf("'s ", firstApostrophe + 3);
        if (secondApostrophe > 0) {
            String pokemonName = workingText.substring(firstApostrophe + 3, secondApostrophe).trim();
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Extracted Pokemon (between apostrophes): {}", pokemonName);
            return pokemonName;
        }
        String beforeApostrophe = workingText.substring(0, firstApostrophe).trim();
        String afterApostrophe = workingText.substring(firstApostrophe + 3).trim();
        String[] words = afterApostrophe.split(" ");
        if (!(words.length <= 0 || (firstWord = words[0].trim()).isEmpty() || !Character.isUpperCase(firstWord.charAt(0)) || (lowerWord = firstWord.toLowerCase()).equals("attack") || lowerWord.equals("defense") || lowerWord.equals("speed") || lowerWord.equals("special") || lowerWord.equals("accuracy") || lowerWord.equals("evasion") || lowerWord.equals("evasiveness") || lowerWord.equals("hp") || lowerWord.equals("sand") || lowerWord.equals("drizzle") || lowerWord.equals("drought") || lowerWord.equals("snow") || lowerWord.equals("heal") || lowerWord.equals("leech") || lowerWord.equals("substitute") || lowerWord.equals("stat"))) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Extracted Pokemon (after owner): {}", firstWord);
            return firstWord;
        }
        String pokemonName = beforeApostrophe;
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Extracted Pokemon (first part): {}", pokemonName);
        return pokemonName;
    }

    private static void reset() {
        currentWeather = "";
        currentTerrain = "";
        weatherTurns = 0;
        terrainTurns = 0;
        trickRoomTurns = 0;
        weatherStartTurn = 0;
        terrainStartTurn = 0;
        hasWeatherRock = false;
        waterSportTurns = 0;
        mudSportTurns = 0;
        gravityTurns = 0;
        statStages.clear();
        pendingBatonPassStats.clear();
        screens.clear();
        hazards.clear();
        leechSeeded.clear();
        ingrained.clear();
        aquaRing.clear();
        hasSubstitute.clear();
        confused.clear();
        identified.clear();
        tailwind.clear();
        terastallized.clear();
        soaked.clear();
        burnedUp.clear();
        roosted.clear();
        megaEvolved.clear();
        magnetRise.clear();
        telekinesis.clear();
        smackDownGrounded.clear();
        pokemonMovePP.clear();
        localPlayerPokemon.clear();
        opponentPokemon.clear();
        ownerTextToSide.clear();
        transformedTypes.clear();
        heldItems.clear();
        doubleShocked.clear();
        lastBurnUpDoubleShockSide.clear();
        wonderRoomTurns = 0;
        magicRoomTurns = 0;
        hasLightClay = false;
        embargo.clear();
        healBlock.clear();
        subscribed = false;
        lastBattle = null;
        lastTurnNumber = 0;
        currentTurnNumber = 0;
        lastPokemonName = null;
        currentActivePlayerPokemon = null;
        currentActiveOpponentPokemon = null;
        pendingStatMessage = null;
        pendingSoakPokemon = null;
        pendingTeraPokemon = null;
        pendingBurnUpPokemon = null;
        pendingDoubleShockPokemon = null;
        pendingMagnetRisePokemon = null;
        pendingTelekinesisMessage = null;
        pendingHealBlockPokemon = null;
        pendingEmbargoPokemon = null;
        pendingSafeguardSide = null;
        pendingLuckyChantSide = null;
        pendingMistSide = null;
        pendingSendOutTrainer = null;
        pendingTransformTypePokemon = null;
        pendingTransformTypeName = null;
        pendingIngrainPokemon = null;
        pendingAquaRingPokemon = null;
        pendingAddedType = null;
        pendingReflectTypePokemon = null;
        pendingReflectTypeTarget = null;
        pendingMeloettaFormPokemon = null;
        addedTypes.clear();
        reflectTypes.clear();
        meloettaForm.clear();
        messageBuffer.setLength(0);
        lastBufferMessageTime = 0L;
        TurnCounterRenderer.reset();
        BattleMessageColorizer.clearOpponentPokemon();
    }

    private static void parseLeechSeed(String text) {
        String pokemonName;
        String lower = text.toLowerCase();
        if (lower.contains("was seeded")) {
            String pokemonName2 = BattleMessageSubscriber.extractPokemonNameFromMessage(text, "was seeded");
            if (pokemonName2 != null) {
                leechSeeded.put(pokemonName2, true);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was seeded!", pokemonName2);
            }
        } else if ((lower.contains("leech seed wore off") || lower.contains("leech seed failed")) && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
            leechSeeded.remove(pokemonName);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} leech seed removed", pokemonName);
        }
    }

    private static void parseIngrain(String text) {
        String pokemonName;
        String lower = text.toLowerCase();
        if (pendingIngrainPokemon != null && (lower.contains("its roots") || lower.equals("its roots!"))) {
            String pokemonName2 = BattleMessageSubscriber.stripOwnerPrefix(pendingIngrainPokemon);
            ingrained.put(pokemonName2.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is now ingrained! [from continuation]", pokemonName2);
            pendingIngrainPokemon = null;
            return;
        }
        if (lower.contains("planted its roots") || lower.contains("took root")) {
            String pokemonName3 = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName3 != null) {
                pokemonName3 = BattleMessageSubscriber.stripOwnerPrefix(pokemonName3);
                ingrained.put(pokemonName3.toLowerCase(), true);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is now ingrained!", pokemonName3);
            }
            pendingIngrainPokemon = null;
            return;
        }
        if (lower.contains("planted") && !lower.contains("its roots") && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
            pendingIngrainPokemon = pokemonName;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Ingrain for: {}", pokemonName);
        }
    }

    private static void parseAquaRing(String text) {
        String lower = text.toLowerCase();
        if (pendingAquaRingPokemon != null && lower.contains("veil of water")) {
            String pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pendingAquaRingPokemon);
            aquaRing.put(pokemonName.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} now has Aqua Ring! [multi-line]", pokemonName);
            pendingAquaRingPokemon = null;
            return;
        }
        if (pendingAquaRingPokemon != null && (lower.contains("surrounded itself with a") || lower.contains("surrounded itself in a"))) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Aqua Ring middle line detected, keeping pending: {}", pendingAquaRingPokemon);
            return;
        }
        if (lower.contains("surrounded itself with a veil of water") || lower.contains("surrounded itself in a veil of water")) {
            int surroundedIdx;
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName == null && (surroundedIdx = lower.indexOf(" surrounded itself")) > 0) {
                String beforeSurrounded = text.substring(0, surroundedIdx);
                int apostropheIdx = beforeSurrounded.lastIndexOf("'s ");
                pokemonName = apostropheIdx > 0 ? beforeSurrounded.substring(apostropheIdx + 3).trim() : beforeSurrounded.trim();
            }
            if (pokemonName != null) {
                pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
                aquaRing.put(pokemonName.toLowerCase(), true);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} now has Aqua Ring!", pokemonName);
            } else {
                LOGGER.warn("[BattleMessageSubscriber] Could not extract Pokemon name from Aqua Ring message: {}", (Object)text);
            }
            pendingAquaRingPokemon = null;
            return;
        }
        if (lower.contains("surrounded itself with a") || lower.contains("surrounded itself in a")) {
            int surroundedIdx;
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName == null && (surroundedIdx = lower.indexOf(" surrounded itself")) > 0) {
                String beforeSurrounded = text.substring(0, surroundedIdx);
                int apostropheIdx = beforeSurrounded.lastIndexOf("'s ");
                pokemonName = apostropheIdx > 0 ? beforeSurrounded.substring(apostropheIdx + 3).trim() : beforeSurrounded.trim();
            }
            if (pokemonName != null) {
                pendingAquaRingPokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Aqua Ring for: {}", pokemonName);
            }
            return;
        }
        if (!(!lower.contains("'s ") || lower.contains(" used ") || lower.contains("surrounded") || lower.contains("veil") || lower.contains("type") || lower.contains("restored"))) {
            String pokemonPart = text.trim();
            if (pokemonPart.endsWith("!") || pokemonPart.endsWith(".")) {
                pokemonPart = pokemonPart.substring(0, pokemonPart.length() - 1).trim();
            }
            if (pokemonPart.contains("'s ")) {
                pokemonPart = pokemonPart.substring(pokemonPart.lastIndexOf("'s ") + 3);
            }
            if (!pokemonPart.isEmpty() && !pokemonPart.contains(" ")) {
                pendingAquaRingPokemon = pokemonPart.trim();
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Potential Aqua Ring Pokemon from name line: {}", pendingAquaRingPokemon);
            }
        }
    }

    private static void parseSubstitute(String text) {
        String pokemonName;
        String lower = text.toLowerCase();
        if (lower.contains("made a substitute") || lower.contains("put in a substitute") || lower.contains("created a substitute")) {
            String pokemonName2 = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName2 != null) {
                hasSubstitute.put(pokemonName2, true);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} created a substitute!", pokemonName2);
            }
        } else if ((lower.contains("substitute faded") || lower.contains("substitute broke") || lower.contains("substitute was hit") || lower.contains("substitute disappeared")) && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
            hasSubstitute.remove(pokemonName);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {}'s substitute broke!", pokemonName);
        }
    }

    private static void parseConfusion(String text) {
        String pokemonName;
        String lower = text.toLowerCase();
        if (lower.contains("became confused") || lower.contains("was confused")) {
            String pokemonName2 = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName2 != null) {
                confused.put(pokemonName2, true);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} became confused!", pokemonName2);
            }
        } else if (lower.contains("snapped out of") && lower.contains("confusion") && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
            confused.remove(pokemonName);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} snapped out of confusion!", pokemonName);
        }
    }

    private static void parseIdentified(String text) {
        String pokemonName;
        String lower = text.toLowerCase();
        if (lower.contains("was identified") || lower.contains("identified!")) {
            String pokemonName2 = BattleMessageSubscriber.extractPokemonNameFromMessage(text, "was identified");
            if (pokemonName2 != null) {
                identified.put(pokemonName2, true);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was identified!", pokemonName2);
            }
        } else if ((lower.contains("foresight") || lower.contains("odor sleuth") || lower.contains("miracle eye")) && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null && !lower.contains("used")) {
            identified.put(pokemonName, true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was identified by move!", pokemonName);
        }
    }

    private static void parseTrickRoom(String text) {
        String lower = text.toLowerCase();
        if ((lower.contains("twisted the dimensions") || lower.contains("trick room")) && (lower.contains("used trick room") || lower.contains("twisted the dimensions"))) {
            trickRoomTurns = 5;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Trick Room activated! ({} turns)", trickRoomTurns);
        }
        if (lower.contains("dimensions returned to normal") || lower.contains("trick room wore off") || lower.contains("twisted dimensions returned")) {
            trickRoomTurns = 0;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Trick Room ended!", new Object[0]);
        }
    }

    private static void parseWonderRoom(String text) {
        String lower = text.toLowerCase();
        if ((lower.contains("returned to normal") || lower.contains("wore off")) && (lower.contains("wonder room") || lower.contains("defense and sp. def"))) {
            wonderRoomTurns = 0;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Wonder Room ended!", new Object[0]);
            return;
        }
        if (lower.contains("wonder room") && (lower.contains("used wonder room") || lower.contains("bizarre area"))) {
            wonderRoomTurns = 5;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Wonder Room activated! ({} turns)", wonderRoomTurns);
            return;
        }
        if (lower.contains("def stats are swapped") && !lower.contains("returned")) {
            wonderRoomTurns = 5;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Wonder Room activated (alt message)! ({} turns)", wonderRoomTurns);
        }
    }

    private static void parseMagicRoom(String text) {
        String lower = text.toLowerCase();
        if (lower.contains("magic room")) {
            if (lower.contains("used magic room")) {
                magicRoomTurns = 5;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Magic Room activated! ({} turns)", magicRoomTurns);
            } else if (lower.contains("wore off") || lower.contains("returned to normal")) {
                magicRoomTurns = 0;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Magic Room ended!", new Object[0]);
            }
        }
        if (lower.contains("items lose their effects") || lower.contains("items lose their effect") || lower.contains("held items lose")) {
            magicRoomTurns = 5;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Magic Room activated (alt message)! ({} turns)", magicRoomTurns);
        }
    }

    private static void parseEmbargo(String text) {
        String pokemonName;
        String lower = text.toLowerCase();
        if (pendingEmbargoPokemon != null && lower.contains("anymore")) {
            embargo.put(pendingEmbargoPokemon.toLowerCase(), 5);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Embargo! (5 turns) [from continuation]", pendingEmbargoPokemon);
            pendingEmbargoPokemon = null;
            return;
        }
        if (lower.contains("embargo") && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
            pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
            if (lower.contains("wore off") || lower.contains("ended")) {
                embargo.remove(pokemonName.toLowerCase());
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {}'s Embargo ended!", pokemonName);
            } else if (lower.contains("used embargo")) {
                pendingEmbargoPokemon = null;
            }
        }
        if (lower.contains("can't use items")) {
            String pokemonName2;
            int cantIdx = lower.indexOf("can't");
            String fullName = null;
            if (cantIdx > 0) {
                fullName = text.substring(0, cantIdx).trim();
            }
            if ((pokemonName2 = BattleMessageSubscriber.stripOwnerPrefix(fullName)) != null && !pokemonName2.isEmpty()) {
                if (lower.contains("anymore")) {
                    embargo.put(pokemonName2.toLowerCase(), 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Embargo! (5 turns)", pokemonName2);
                    pendingEmbargoPokemon = null;
                } else {
                    pendingEmbargoPokemon = pokemonName2;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Embargo for: {}", pokemonName2);
                }
            } else if (lastPokemonName != null) {
                if (lower.contains("anymore")) {
                    embargo.put(lastPokemonName.toLowerCase(), 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Embargo! (5 turns) [from lastPokemon]", lastPokemonName);
                } else {
                    pendingEmbargoPokemon = lastPokemonName;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Embargo for (lastPokemon): {}", lastPokemonName);
                }
            }
        }
    }

    private static String determineSideFromBattle(String pokemonName) {
        if (pokemonName == null || pokemonName.isEmpty()) {
            return null;
        }
        try {
            ClientBattleSide side2;
            ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
            if (battle == null) {
                return null;
            }
            String normalizedSearch = pokemonName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "");
            ClientBattleSide side1 = battle.getSide1();
            if (side1 != null) {
                for (ClientBattleActor actor : side1.getActors()) {
                    for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                        String name;
                        String normalizedName;
                        ClientBattlePokemon battlePokemon;
                        if (activePokemon == null || (battlePokemon = activePokemon.getBattlePokemon()) == null || !(normalizedName = (name = battlePokemon.getDisplayName().getString()).toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "")).equals(normalizedSearch) && !normalizedName.contains(normalizedSearch) && !normalizedSearch.contains(normalizedName)) continue;
                        CobblemonBattleInfoClient.debug("[SIDE_FROM_BATTLE] {} -> player (found in Side1)", pokemonName);
                        return "player";
                    }
                }
            }
            if ((side2 = battle.getSide2()) != null) {
                for (ClientBattleActor actor : side2.getActors()) {
                    for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                        String name;
                        String normalizedName;
                        ClientBattlePokemon battlePokemon;
                        if (activePokemon == null || (battlePokemon = activePokemon.getBattlePokemon()) == null || !(normalizedName = (name = battlePokemon.getDisplayName().getString()).toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "")).equals(normalizedSearch) && !normalizedName.contains(normalizedSearch) && !normalizedSearch.contains(normalizedName)) continue;
                        CobblemonBattleInfoClient.debug("[SIDE_FROM_BATTLE] {} -> opponent (found in Side2)", pokemonName);
                        return "opponent";
                    }
                }
            }
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.debug("[SIDE_FROM_BATTLE] Error checking battle for {}: {}", pokemonName, t.getMessage());
        }
        return null;
    }

    private static String stripOwnerPrefix(String name) {
        if (name == null) {
            return null;
        }
        int apostropheIdx = name.lastIndexOf("'s ");
        if (apostropheIdx > 0) {
            return name.substring(apostropheIdx + 3).trim();
        }
        int deIdx = name.indexOf(" de ");
        if (deIdx > 0) {
            return name.substring(0, deIdx).trim();
        }
        int vonIdx = name.indexOf(" von ");
        if (vonIdx > 0) {
            return name.substring(0, vonIdx).trim();
        }
        int diIdx = name.indexOf(" di ");
        if (diIdx > 0) {
            return name.substring(0, diIdx).trim();
        }
        return name.trim();
    }

    private static String formatItemName(String itemId) {
        if (itemId == null || itemId.isBlank()) {
            return itemId;
        }
        String[] words = itemId.replace("_", " ").split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1).toLowerCase());
        }
        return result.toString();
    }

    private static void parseHealBlock(String text) {
        String pokemonName;
        String lower = text.toLowerCase();
        if (pendingHealBlockPokemon != null && (lower.contains("healing") || lower.equals("healing!"))) {
            String strippedPending = BattleMessageSubscriber.stripOwnerPrefix(pendingHealBlockPokemon);
            healBlock.put(strippedPending.toLowerCase(), 5);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Heal Block! (5 turns) [from continuation]", strippedPending);
            pendingHealBlockPokemon = null;
            return;
        }
        if (lower.contains("heal block") && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null) {
            pokemonName = BattleMessageSubscriber.stripOwnerPrefix(pokemonName);
            if (lower.contains("wore off") || lower.contains("ended")) {
                healBlock.remove(pokemonName.toLowerCase());
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {}'s Heal Block ended!", pokemonName);
            }
        }
        if (lower.contains("was prevented")) {
            int wasIdx = lower.indexOf("was prevented");
            String pokemonName2 = null;
            if (wasIdx > 0) {
                pokemonName2 = text.substring(0, wasIdx).trim();
                pokemonName2 = BattleMessageSubscriber.stripOwnerPrefix(pokemonName2);
            }
            if (pokemonName2 != null && !pokemonName2.isEmpty()) {
                if (lower.contains("healing")) {
                    healBlock.put(pokemonName2.toLowerCase(), 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Heal Block! (5 turns)", pokemonName2);
                    pendingHealBlockPokemon = null;
                } else {
                    pendingHealBlockPokemon = pokemonName2;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Heal Block for: {}", pokemonName2);
                }
            } else if (lastPokemonName != null) {
                String strippedLastPokemon = BattleMessageSubscriber.stripOwnerPrefix(lastPokemonName);
                if (lower.contains("healing")) {
                    healBlock.put(strippedLastPokemon.toLowerCase(), 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} is under Heal Block! (5 turns) [from lastPokemon]", strippedLastPokemon);
                } else {
                    pendingHealBlockPokemon = strippedLastPokemon;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Heal Block for (lastPokemon): {}", strippedLastPokemon);
                }
            }
        }
    }

    private static void parseSafeguard(String text) {
        String lower = text.toLowerCase();
        if (pendingSafeguardSide != null && lower.contains("mystical veil")) {
            BattleMessageSubscriber.setScreen(pendingSafeguardSide, "Safeguard", 5);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Safeguard (5 turns) [from continuation]", pendingSafeguardSide);
            pendingSafeguardSide = null;
            return;
        }
        if (lower.contains("safeguard")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            String side = BattleMessageSubscriber.determineSide(pokemonName, text);
            if (lower.contains("wore off") || lower.contains("faded") || lower.contains("ended") || lower.contains("no longer protected")) {
                BattleMessageSubscriber.removeScreen(side, "Safeguard");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Safeguard ended", side);
            } else if (lower.contains("used safeguard")) {
                BattleMessageSubscriber.setScreen(side, "Safeguard", 5);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Safeguard (5 turns)", side);
            }
        }
        if (lower.contains("cloaked") || lower.contains("your team cloaked")) {
            String side;
            String string = side = lower.contains("your") ? "player" : "opponent";
            if (lower.contains("mystical veil")) {
                BattleMessageSubscriber.setScreen(side, "Safeguard", 5);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Safeguard (5 turns) [from cloaked message]", side);
                pendingSafeguardSide = null;
            } else {
                pendingSafeguardSide = side;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Safeguard for side: {}", side);
            }
        }
    }

    private static void parseMist(String text) {
        String lower = text.toLowerCase();
        boolean isMistyTerrain = lower.contains("misty terrain");
        if (!isMistyTerrain && (lower.contains("no longer protected by mist") || lower.contains("mist") && (lower.contains("wore off") || lower.contains("faded") || lower.contains("ended")))) {
            String side;
            if (lower.contains("your") || lower.contains("ally")) {
                side = "player";
            } else if (lower.contains("opposing") || lower.contains("foe") || lower.contains("enemy")) {
                side = "opponent";
            } else {
                String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
                side = BattleMessageSubscriber.determineSide(pokemonName, text);
            }
            BattleMessageSubscriber.removeScreen(side, "Mist");
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Mist ended (no longer protected)", side);
            return;
        }
        if (pendingMistSide != null && !isMistyTerrain && lower.contains("shrouded in mist")) {
            BattleMessageSubscriber.setScreen(pendingMistSide, "Mist", 5);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Mist (5 turns) [from continuation]", pendingMistSide);
            pendingMistSide = null;
            return;
        }
        if (lower.contains("team became")) {
            String side;
            String string = side = lower.contains("your") ? "player" : "opponent";
            if (lower.contains("shrouded in mist")) {
                BattleMessageSubscriber.setScreen(side, "Mist", 5);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Mist (5 turns)", side);
            } else {
                pendingMistSide = side;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Mist for side: {}", side);
            }
            return;
        }
        if (!isMistyTerrain && lower.contains("mist")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            String side = BattleMessageSubscriber.determineSide(pokemonName, text);
            if (lower.contains("used mist")) {
                BattleMessageSubscriber.setScreen(side, "Mist", 5);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Mist (5 turns) [from used mist]", side);
            }
        }
    }

    private static void parseLuckyChant(String text) {
        String lower = text.toLowerCase();
        if (pendingLuckyChantSide != null && (lower.contains("critical hits") || lower.contains("team from"))) {
            BattleMessageSubscriber.setScreen(pendingLuckyChantSide, "Lucky Chant", 5);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Lucky Chant (5 turns) [from continuation]", pendingLuckyChantSide);
            pendingLuckyChantSide = null;
            return;
        }
        if (lower.contains("lucky chant")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            String side = BattleMessageSubscriber.determineSide(pokemonName, text);
            if (lower.contains("wore off") || lower.contains("faded") || lower.contains("ended")) {
                BattleMessageSubscriber.removeScreen(side, "Lucky Chant");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Lucky Chant ended", side);
            } else if (lower.contains("used lucky chant")) {
                BattleMessageSubscriber.setScreen(side, "Lucky Chant", 5);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Lucky Chant (5 turns)", side);
            } else if (lower.contains("shielded")) {
                String targetSide;
                String string = targetSide = lower.contains("your") ? "player" : "opponent";
                if (lower.contains("critical hits")) {
                    BattleMessageSubscriber.setScreen(targetSide, "Lucky Chant", 5);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} set Lucky Chant (5 turns) [from shielded message]", targetSide);
                } else {
                    pendingLuckyChantSide = targetSide;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Lucky Chant for side: {}", targetSide);
                }
            }
        }
    }

    private static void parseTailwind(String text) {
        String lower = text.toLowerCase();
        if (lower.contains("tailwind")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            String side = BattleMessageSubscriber.determineSide(pokemonName, text);
            if (lower.contains("petered out") || lower.contains("wore off") || lower.contains("subsided")) {
                tailwind.remove(side);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Tailwind ended", side);
            } else if (lower.contains("blew from behind") || lower.contains("used tailwind")) {
                tailwind.put(side, 4);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} Tailwind activated!", side);
            }
        }
    }

    private static void parseTerastallization(String text) {
        String pokemonName;
        String teraType;
        String lower = text.toLowerCase();
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] parseTerastallization checking: '{}'", text);
        if (pendingTeraPokemon != null) {
            teraType = BattleMessageSubscriber.extractTeraType(text);
            if (teraType != null) {
                String pokemonLower = pendingTeraPokemon.toLowerCase();
                terastallized.put(pokemonLower, teraType);
                if (pendingTeraSide != null) {
                    String sidedKey = BattleMessageSubscriber.makeSidedKey(pendingTeraSide, pokemonLower);
                    terastallized.put(sidedKey, teraType);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} terastallized to {} type! (from continuation, side: {})", pendingTeraPokemon, teraType, pendingTeraSide);
                } else {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} terastallized to {} type! (from continuation)", pendingTeraPokemon, teraType);
                }
                pendingTeraPokemon = null;
                pendingTeraSide = null;
                return;
            }
            if (lower.contains("terastalliz")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Still waiting for Tera type, pending: {}", pendingTeraPokemon);
                return;
            }
        }
        if (lower.contains("terastalliz")) {
            pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            String teraType2 = BattleMessageSubscriber.extractTeraType(text);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Tera message - Pokemon: '{}', Type: '{}'", pokemonName, teraType2);
            if (pokemonName != null && teraType2 != null) {
                String pokemonLower = pokemonName.toLowerCase();
                String side = BattleMessageSubscriber.determineSide(pokemonName, text);
                terastallized.put(pokemonLower, teraType2);
                if (side != null) {
                    String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonLower);
                    terastallized.put(sidedKey, teraType2);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} terastallized to {} type! (side: {})", pokemonName, teraType2, side);
                } else {
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} terastallized to {} type!", pokemonName, teraType2);
                }
                pendingTeraPokemon = null;
                pendingTeraSide = null;
            } else if (pokemonName != null) {
                pendingTeraPokemon = pokemonName;
                pendingTeraSide = BattleMessageSubscriber.determineSide(pokemonName, text);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Tera for: {}, side: {}, waiting for type", pokemonName, pendingTeraSide);
            }
            return;
        }
        if ((lower.contains("'s ") || lower.contains("'s ")) && lower.trim().endsWith(" has") && !lower.contains("used")) {
            pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName != null) {
                pendingTeraPokemon = pokemonName;
                pendingTeraSide = BattleMessageSubscriber.determineSide(pokemonName, text);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Tera (from 'has' line) for: {}, side: {}", pokemonName, pendingTeraSide);
            }
            return;
        }
        if (pendingTeraPokemon != null && (lower.contains("-type") || lower.contains(" type")) && (teraType = BattleMessageSubscriber.extractTeraType(text)) != null) {
            String pokemonLower = pendingTeraPokemon.toLowerCase();
            terastallized.put(pokemonLower, teraType);
            if (pendingTeraSide != null) {
                String sidedKey = BattleMessageSubscriber.makeSidedKey(pendingTeraSide, pokemonLower);
                terastallized.put(sidedKey, teraType);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} terastallized to {} type! (from type-only line, side: {})", pendingTeraPokemon, teraType, pendingTeraSide);
            } else {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} terastallized to {} type! (from type-only line)", pendingTeraPokemon, teraType);
            }
            pendingTeraPokemon = null;
            pendingTeraSide = null;
        }
        if (pendingTeraPokemon != null && lower.contains("used")) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Clearing pending Tera for {} (interrupted by move usage)", pendingTeraPokemon);
            pendingTeraPokemon = null;
        }
    }

    private static String extractTeraType(String text) {
        String[] types;
        String lower = text.toLowerCase();
        if (!lower.contains("terastalliz") && pendingTeraPokemon == null) {
            return null;
        }
        for (String type : types = new String[]{"stellar", "normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            if (!lower.contains(type + "-type") && !lower.contains(type + " type") && !lower.contains("the " + type)) continue;
            return type.substring(0, 1).toUpperCase() + type.substring(1);
        }
        return null;
    }

    private static void parseSoak(String text) {
        String pokemonName;
        String beforeTransformed;
        String pokemonName2;
        int idx;
        String lower = text.toLowerCase();
        if (lower.equals("type!") && pendingSoakPokemon != null) {
            soaked.put(pendingSoakPokemon.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was soaked (now pure Water type)! (3-line)", pendingSoakPokemon);
            pendingSoakPokemon = null;
            return;
        }
        if (lower.contains("transformed into the water") && !lower.contains("type")) {
            int idx2 = lower.indexOf("transformed into");
            if (idx2 > 0) {
                String beforeTransformed2 = text.substring(0, idx2).trim();
                String pokemonName3 = BattleMessageSubscriber.extractPokemonNameFromPrefix(beforeTransformed2);
                if (pokemonName3 != null && !pokemonName3.isEmpty()) {
                    pendingSoakPokemon = pokemonName3;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Soak (3-line) for: {}", pokemonName3);
                }
            } else if (pendingSoakTarget != null) {
                pendingSoakPokemon = pendingSoakTarget;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Soak (3-line from target) for: {}", pendingSoakPokemon);
            }
            return;
        }
        if (lower.contains("the water type") && pendingSoakPokemon != null) {
            soaked.put(pendingSoakPokemon.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was soaked (now pure Water type)!", pendingSoakPokemon);
            pendingSoakPokemon = null;
            return;
        }
        if (lower.contains("transformed into") && !lower.contains("the water type") && !lower.contains("the water")) {
            String beforeTransformed3;
            String pokemonName4;
            int idx3 = lower.indexOf("transformed into");
            if (idx3 > 0 && (pokemonName4 = BattleMessageSubscriber.extractPokemonNameFromPrefix(beforeTransformed3 = text.substring(0, idx3).trim())) != null && !pokemonName4.isEmpty()) {
                pendingSoakPokemon = pokemonName4;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Soak for: {}", pokemonName4);
            }
            return;
        }
        if (lower.contains("transformed into the water type") && (idx = lower.indexOf("transformed into the water type")) > 0 && (pokemonName2 = BattleMessageSubscriber.extractPokemonNameFromPrefix(beforeTransformed = text.substring(0, idx).trim())) != null && !pokemonName2.isEmpty()) {
            soaked.put(pokemonName2.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} was soaked (now pure Water type)!", pokemonName2);
        }
        if (!(!text.contains("'s ") || lower.contains("transformed") || lower.contains("used") || lower.contains("type") || lower.contains("fainted") || (pokemonName = BattleMessageSubscriber.extractPokemonNameFromPrefix(text)) == null || pokemonName.isEmpty())) {
            pendingSoakTarget = pokemonName;
        }
    }

    private static String extractPokemonNameFromPrefix(String prefix) {
        String pokemonName = prefix;
        if (pokemonName.startsWith("The opposing ")) {
            pokemonName = pokemonName.substring("The opposing ".length());
        } else if (pokemonName.startsWith("Wild ")) {
            pokemonName = pokemonName.substring("Wild ".length());
        }
        if (pokemonName.contains("'s ")) {
            int apostropheIdx = pokemonName.lastIndexOf("'s ");
            pokemonName = pokemonName.substring(apostropheIdx + 3);
        }
        return pokemonName.trim();
    }

    public static boolean isSoaked(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            return soaked.containsKey(sidedKey);
        }
        return false;
    }

    public static boolean isSoaked(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (soaked.containsKey(lower)) {
            return true;
        }
        if (soaked.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower))) {
            return true;
        }
        return soaked.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower));
    }

    private static void parseBurnUp(String text) {
        int idx;
        String lower = text.toLowerCase();
        if (lower.contains("used burn up")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName != null) {
                pendingBurnUpPokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Burn Up used by: {}", pokemonName);
            }
            return;
        }
        if (lower.contains("???") && lower.contains("type!") && pendingBurnUpPokemon != null) {
            burnedUp.put(pendingBurnUpPokemon.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Burn Up and lost Fire type!", pendingBurnUpPokemon);
            pendingBurnUpPokemon = null;
            return;
        }
        if (lower.contains("burned itself out") && (idx = lower.indexOf("burned itself out")) > 0) {
            String pokemonName = text.substring(0, idx).trim();
            if (pokemonName.endsWith("'s")) {
                pokemonName = pokemonName.substring(0, pokemonName.length() - 2);
            }
            burnedUp.put(pokemonName.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Burn Up and lost Fire type!", pokemonName);
        }
    }

    private static void parseDoubleShock(String text) {
        String lower = text.toLowerCase();
        if (lower.contains("used double shock")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName != null) {
                pendingDoubleShockPokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Double Shock used by: {}", pokemonName);
            }
            return;
        }
        if (lower.contains("???") && lower.contains("type!") && pendingDoubleShockPokemon != null) {
            doubleShocked.put(pendingDoubleShockPokemon.toLowerCase(), true);
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Double Shock and lost Electric type!", pendingDoubleShockPokemon);
            pendingDoubleShockPokemon = null;
            return;
        }
    }

    public static boolean hasDoubleShocked(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            return doubleShocked.containsKey(sidedKey);
        }
        return false;
    }

    public static boolean hasDoubleShocked(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (doubleShocked.containsKey(lower)) {
            return true;
        }
        if (doubleShocked.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower))) {
            return true;
        }
        return doubleShocked.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower));
    }

    private static void parseMeloettaFormChange(String text) {
        String lower = text.toLowerCase();
        if (lower.contains("used relic song")) {
            String pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            if (pokemonName != null && pokemonName.toLowerCase().contains("meloetta")) {
                pendingMeloettaFormPokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Relic Song used by Meloetta: {}", pokemonName);
            }
            return;
        }
        if (lower.contains("formechange.defaul") || lower.contains("t.temporary.end") || lower.contains("formechange.default.temporary.end")) {
            meloettaForm.entrySet().removeIf(entry -> ((String)entry.getValue()).equals("pirouette"));
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta reverted to Aria form (Normal/Psychic) - temporary form ended", new Object[0]);
            pendingMeloettaFormPokemon = null;
            return;
        }
        if (lower.contains("transformed into its") && !lower.contains("form")) {
            String pokemonName;
            if (pendingMeloettaFormPokemon == null && (pokemonName = BattleMessageSubscriber.extractPokemonName(text)) != null && pokemonName.toLowerCase().contains("meloetta")) {
                pendingMeloettaFormPokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta transforming (from combined text): {}", pokemonName);
            }
            return;
        }
        if (lower.contains("pirouette form")) {
            String pokemonName = pendingMeloettaFormPokemon;
            if (pokemonName == null) {
                pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            }
            if (pokemonName != null) {
                meloettaForm.put(pokemonName.toLowerCase(), "pirouette");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta transformed to Pirouette form (Normal/Fighting): {}", pokemonName);
            } else {
                meloettaForm.put("meloetta", "pirouette");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta transformed to Pirouette form (Normal/Fighting)", new Object[0]);
            }
            pendingMeloettaFormPokemon = null;
            return;
        }
        if (lower.contains("aria form")) {
            String pokemonName = pendingMeloettaFormPokemon;
            if (pokemonName == null) {
                pokemonName = BattleMessageSubscriber.extractPokemonName(text);
            }
            if (pokemonName != null) {
                meloettaForm.put(pokemonName.toLowerCase(), "aria");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta transformed to Aria form (Normal/Psychic): {}", pokemonName);
            } else {
                meloettaForm.put("meloetta", "aria");
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Meloetta transformed to Aria form (Normal/Psychic)", new Object[0]);
            }
            pendingMeloettaFormPokemon = null;
            return;
        }
    }

    public static String getMeloettaForm(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String form = meloettaForm.get(pokemonName.toLowerCase());
        if (form != null) {
            return form;
        }
        return meloettaForm.get("meloetta");
    }

    public static String getMeloettaForm(String side, String pokemonName) {
        String sidedKey;
        String form;
        if (pokemonName == null) {
            return null;
        }
        if (side != null && !side.isEmpty() && (form = meloettaForm.get(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName))) != null) {
            return form;
        }
        return BattleMessageSubscriber.getMeloettaForm(pokemonName);
    }

    private static void parseTypeTransformation(String text) {
        int idx;
        String lower = text.toLowerCase();
        if (pendingTransformTypePokemon != null) {
            if (pendingTransformTypeName != null && lower.contains("type!")) {
                BattleMessageSubscriber.setTransformedType(pendingTransformTypePokemon, pendingTransformTypeName);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} transformed into {} type! [from split line with pending type]", pendingTransformTypePokemon, pendingTransformTypeName);
                pendingTransformTypePokemon = null;
                pendingTransformTypeName = null;
                return;
            }
            for (String type : ALL_TYPES) {
                if (!lower.contains(type.toLowerCase() + " type") && !lower.contains(type.toLowerCase() + "type")) continue;
                BattleMessageSubscriber.setTransformedType(pendingTransformTypePokemon, type);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} transformed into {} type! [from continuation]", pendingTransformTypePokemon, type);
                pendingTransformTypePokemon = null;
                pendingTransformTypeName = null;
                return;
            }
            for (String type : ALL_TYPES) {
                if (!lower.endsWith(type.toLowerCase()) && !lower.endsWith(type.toLowerCase() + " ")) continue;
                pendingTransformTypeName = type;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Partial type transform - found type {} at end of line, saving for continuation", type);
                return;
            }
            if (lower.trim().equals("type!") || lower.contains("type!")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Got 'type!' continuation but couldn't find type name", new Object[0]);
            }
        }
        if (lower.endsWith("transformed into") && !lower.contains("type") && (idx = lower.indexOf("transformed into")) > 0) {
            String pokemonName;
            String pokemonPart = text.substring(0, idx).trim();
            if (pokemonPart.contains("'s ")) {
                pokemonPart = pokemonPart.substring(pokemonPart.lastIndexOf("'s ") + 3);
            }
            if (!(pokemonName = pokemonPart.trim()).isEmpty()) {
                pendingTransformTypePokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending type transform (Magic Powder pattern) for: {}", pokemonName);
                return;
            }
        }
        if (pendingTransformTypePokemon != null && lower.startsWith("the ") && lower.contains("type!")) {
            for (String type : ALL_TYPES) {
                if (!lower.contains("the " + type.toLowerCase() + " type")) continue;
                BattleMessageSubscriber.setTransformedType(pendingTransformTypePokemon, type);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} transformed into {} type! [Magic Powder pattern]", pendingTransformTypePokemon, type);
                pendingTransformTypePokemon = null;
                return;
            }
        }
        if (pendingTransformTypePokemon != null && lower.contains("type!") && !lower.contains("transformed")) {
            for (String type : ALL_TYPES) {
                if (!lower.startsWith(type.toLowerCase() + " type") && !lower.equals(type.toLowerCase() + " type!") && !lower.contains(type.toLowerCase() + " type!")) continue;
                BattleMessageSubscriber.setTransformedType(pendingTransformTypePokemon, type);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} transformed into {} type! [3-line pattern]", pendingTransformTypePokemon, type);
                pendingTransformTypePokemon = null;
                pendingTransformTypeName = null;
                return;
            }
        }
        if (lower.contains("transformed into the")) {
            int idx2 = lower.indexOf("transformed into the");
            String pokemonName = null;
            if (idx2 > 0) {
                String pokemonPart = text.substring(0, idx2).trim();
                if (pokemonPart.contains("'s ")) {
                    pokemonPart = pokemonPart.substring(pokemonPart.lastIndexOf("'s ") + 3);
                }
                pokemonName = pokemonPart.trim();
            }
            if ((pokemonName == null || pokemonName.isEmpty()) && pendingTransformTypePokemon != null) {
                pokemonName = pendingTransformTypePokemon;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Using pending Pokemon name for transform: {}", pokemonName);
            }
            String afterTransform = text.substring(idx2 + 20).trim();
            String afterTransformLower = afterTransform.toLowerCase();
            for (String type : ALL_TYPES) {
                if (!afterTransformLower.contains(type.toLowerCase() + " type") && !afterTransformLower.contains(type.toLowerCase() + "type") || pokemonName == null || pokemonName.isEmpty()) continue;
                BattleMessageSubscriber.setTransformedType(pokemonName, type);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} transformed into {} type! (Protean/Libero)", pokemonName, type);
                pendingTransformTypePokemon = null;
                pendingTransformTypeName = null;
                return;
            }
            for (String type : ALL_TYPES) {
                if (!afterTransformLower.endsWith(type.toLowerCase()) && !afterTransformLower.equals(type.toLowerCase()) || pokemonName == null || pokemonName.isEmpty()) continue;
                pendingTransformTypePokemon = pokemonName;
                pendingTransformTypeName = type;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Split type transform - Pokemon: {}, Type: {} (waiting for 'type!' line)", pokemonName, type);
                return;
            }
            if (pokemonName != null && !pokemonName.isEmpty()) {
                pendingTransformTypePokemon = pokemonName;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending type transform for: {}", pokemonName);
            }
        }
        if (lower.contains("'s ") && !lower.contains(" used ") && !lower.contains("transformed") && !lower.contains("type")) {
            String pokemonPart = text.trim();
            if (pokemonPart.contains("'s ")) {
                pokemonPart = pokemonPart.substring(pokemonPart.lastIndexOf("'s ") + 3);
            }
            if (!pokemonPart.isEmpty() && !pokemonPart.contains(" ")) {
                pendingTransformTypePokemon = pokemonPart.trim();
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Potential type transform Pokemon from name line: {}", pendingTransformTypePokemon);
            }
        }
    }

    private static void setTransformedType(String pokemonName, String type) {
        if (pokemonName == null || type == null) {
            return;
        }
        String key = pokemonName.toLowerCase();
        soaked.remove(key);
        burnedUp.remove(key);
        transformedTypes.put(key, type);
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Set {} transformed type to {}", pokemonName, type);
    }

    public static String getTransformedType(String side, String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String lower = pokemonName.toLowerCase();
        String normalized = BattleMessageSubscriber.normalizePokemonName(pokemonName);
        if (side != null && !side.isEmpty()) {
            String normalizedKey;
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, lower);
            String result = transformedTypes.get(sidedKey);
            if (result != null) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] getTransformedType found '{}' for key '{}'", result, sidedKey);
                return result;
            }
            if (!lower.equals(normalized) && (result = transformedTypes.get(normalizedKey = BattleMessageSubscriber.makeSidedKey(side, normalized))) != null) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] getTransformedType found '{}' for normalized key '{}'", result, normalizedKey);
                return result;
            }
        }
        return null;
    }

    public static String getTransformedType(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String lower = pokemonName.toLowerCase();
        String normalized = BattleMessageSubscriber.normalizePokemonName(pokemonName);
        String result = transformedTypes.get(lower);
        if (result != null) {
            return result;
        }
        if (!lower.equals(normalized) && (result = transformedTypes.get(normalized)) != null) {
            return result;
        }
        for (String name : new String[]{lower, normalized}) {
            result = transformedTypes.get(BattleMessageSubscriber.makeSidedKey("player", name));
            if (result != null) {
                return result;
            }
            result = transformedTypes.get(BattleMessageSubscriber.makeSidedKey("opponent", name));
            if (result == null) continue;
            return result;
        }
        if (!transformedTypes.isEmpty()) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] getTransformedType lookup for '{}' (normalized: '{}') failed. Available keys: {}", lower, normalized, transformedTypes.keySet());
        }
        return null;
    }

    private static void parseAddedType(String text) {
        int idx;
        String lower = text.toLowerCase();
        if (pendingAddedType != null) {
            String pokemonName = text.trim();
            if (pokemonName.endsWith("!")) {
                pokemonName = pokemonName.substring(0, pokemonName.length() - 1).trim();
            }
            if (pokemonName.contains("'s ")) {
                pokemonName = pokemonName.substring(pokemonName.lastIndexOf("'s ") + 3).trim();
            }
            if (!pokemonName.isEmpty()) {
                addedTypes.put(pokemonName.toLowerCase(), pendingAddedType);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} had {} type added! [from continuation]", pokemonName, pendingAddedType);
                pendingAddedType = null;
                return;
            }
        }
        if (lower.contains("type was added to") && (idx = lower.indexOf("type was added to")) > 0) {
            String beforeType = text.substring(0, idx).trim();
            for (String type : ALL_TYPES) {
                if (!beforeType.equalsIgnoreCase(type)) continue;
                String afterTo = text.substring(idx + 17).trim();
                if (!afterTo.isEmpty() && afterTo.endsWith("!")) {
                    String pokemonName = afterTo.substring(0, afterTo.length() - 1).trim();
                    if (pokemonName.contains("'s ")) {
                        pokemonName = pokemonName.substring(pokemonName.lastIndexOf("'s ") + 3).trim();
                    }
                    addedTypes.put(pokemonName.toLowerCase(), type);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} had {} type added!", pokemonName, type);
                } else {
                    pendingAddedType = type;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending added type: {}", type);
                }
                return;
            }
        }
    }

    public static String getAddedType(String side, String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            return addedTypes.get(sidedKey);
        }
        return null;
    }

    public static String getAddedType(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String lower = pokemonName.toLowerCase();
        String result = addedTypes.get(lower);
        if (result != null) {
            return result;
        }
        result = addedTypes.get(BattleMessageSubscriber.makeSidedKey("player", lower));
        if (result != null) {
            return result;
        }
        result = addedTypes.get(BattleMessageSubscriber.makeSidedKey("opponent", lower));
        return result;
    }

    private static void parseReflectType(String text) {
        int idx;
        String lower = text.toLowerCase();
        if (pendingReflectTypePokemon != null && lower.contains("'s type!") && (idx = lower.indexOf("'s type!")) > 0) {
            String targetName = text.substring(0, idx).trim();
            if (targetName.contains("'s ")) {
                targetName = targetName.substring(targetName.lastIndexOf("'s ") + 3);
            }
            if (!targetName.isEmpty()) {
                pendingReflectTypeTarget = targetName;
                ArrayList<CallSite> copiedTypes = new ArrayList<CallSite>();
                copiedTypes.add((CallSite)((Object)("REFLECT:" + targetName)));
                reflectTypes.put(pendingReflectTypePokemon.toLowerCase(), copiedTypes);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} copied {}'s type with Reflect Type! [from continuation]", pendingReflectTypePokemon, targetName);
                pendingReflectTypePokemon = null;
                pendingReflectTypeTarget = null;
                return;
            }
        }
        if (lower.contains("type became the same as") && (idx = lower.indexOf("type became the same as")) > 0) {
            String pokemonName;
            String beforePart = text.substring(0, idx).trim();
            if (beforePart.endsWith("'s")) {
                beforePart = beforePart.substring(0, beforePart.length() - 2).trim();
            }
            if ((pokemonName = beforePart).contains("'s ")) {
                pokemonName = pokemonName.substring(pokemonName.lastIndexOf("'s ") + 3);
            }
            if (!pokemonName.isEmpty()) {
                String afterAs = text.substring(idx + 23).trim();
                if (afterAs.contains("'s type!")) {
                    int targetIdx = afterAs.indexOf("'s type!");
                    String targetName = afterAs.substring(0, targetIdx).trim();
                    ArrayList<CallSite> copiedTypes = new ArrayList<CallSite>();
                    copiedTypes.add((CallSite)((Object)("REFLECT:" + targetName)));
                    reflectTypes.put(pokemonName.toLowerCase(), copiedTypes);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} copied {}'s type with Reflect Type!", pokemonName, targetName);
                } else {
                    pendingReflectTypePokemon = pokemonName;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Pending Reflect Type for: {}", pokemonName);
                }
            }
        }
    }

    public static String getReflectTypeTarget(String pokemonName) {
        String first;
        if (pokemonName == null) {
            return null;
        }
        List<String> types = reflectTypes.get(pokemonName.toLowerCase());
        if (types != null && !types.isEmpty() && (first = types.get(0)).startsWith("REFLECT:")) {
            return first.substring(8);
        }
        return null;
    }

    public static boolean hasBurnedUp(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            return burnedUp.containsKey(sidedKey);
        }
        return false;
    }

    public static boolean hasBurnedUp(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (burnedUp.containsKey(lower)) {
            return true;
        }
        if (burnedUp.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower))) {
            return true;
        }
        if (burnedUp.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower))) {
            return true;
        }
        if (!burnedUp.isEmpty()) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] hasBurnedUp('{}') = false, burnedUp keys: {}", lower, burnedUp.keySet());
        }
        return false;
    }

    private static void parseRoost(String text) {
        int idx;
        String lower = text.toLowerCase();
        if (lower.contains("loses flying type this turn") && (idx = lower.indexOf("loses flying type")) > 0) {
            String pokemonName;
            String beforeLoses = text.substring(0, idx).trim();
            if (beforeLoses.startsWith("(")) {
                beforeLoses = beforeLoses.substring(1);
            }
            if ((pokemonName = BattleMessageSubscriber.extractPokemonNameFromPrefix(beforeLoses)) != null && !pokemonName.isEmpty()) {
                roosted.put(pokemonName.toLowerCase(), lastTurnNumber);
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used Roost (loses Flying type for turn {})", pokemonName, lastTurnNumber);
            }
        }
    }

    public static boolean isRoosted(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Integer roostTurn = roosted.get(sidedKey);
            return roostTurn != null && roostTurn == lastTurnNumber;
        }
        return false;
    }

    public static boolean isRoosted(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        Integer roostTurn = roosted.get(lower);
        if (roostTurn != null && roostTurn == lastTurnNumber) {
            return true;
        }
        roostTurn = roosted.get(BattleMessageSubscriber.makeSidedKey("player", lower));
        if (roostTurn != null && roostTurn == lastTurnNumber) {
            return true;
        }
        roostTurn = roosted.get(BattleMessageSubscriber.makeSidedKey("opponent", lower));
        return roostTurn != null && roostTurn == lastTurnNumber;
    }

    private static List<String> getMegaFormTypes(String pokemonName, String megaForm) {
        String lower = pokemonName.toLowerCase();
        if (lower.contains("charizard") && "x".equals(megaForm)) {
            return Arrays.asList("Fire", "Dragon");
        }
        if (lower.contains("charizard") && "y".equals(megaForm)) {
            return Arrays.asList("Fire", "Flying");
        }
        if (lower.contains("charizard")) {
            return null;
        }
        if (lower.contains("mewtwo") && "x".equals(megaForm)) {
            return Arrays.asList("Psychic", "Fighting");
        }
        if (lower.contains("mewtwo") && "y".equals(megaForm)) {
            return Arrays.asList("Psychic");
        }
        if (lower.contains("ampharos")) {
            return Arrays.asList("Electric", "Dragon");
        }
        if (lower.contains("aggron")) {
            return Arrays.asList("Steel");
        }
        if (lower.contains("altaria")) {
            return Arrays.asList("Dragon", "Fairy");
        }
        if (lower.contains("lopunny")) {
            return Arrays.asList("Normal", "Fighting");
        }
        if (lower.contains("gyarados")) {
            return Arrays.asList("Water", "Dark");
        }
        if (lower.contains("sceptile")) {
            return Arrays.asList("Grass", "Dragon");
        }
        if (lower.contains("pinsir")) {
            return Arrays.asList("Bug", "Flying");
        }
        if (lower.contains("audino")) {
            return Arrays.asList("Normal", "Fairy");
        }
        return null;
    }

    public static List<String> getMegaTypes(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        return megaEvolved.get(pokemonName.toLowerCase());
    }

    public static List<String> getMegaTypes(String side, String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String nameLower = pokemonName.toLowerCase(Locale.ROOT);
        if (side != null && !side.isEmpty()) {
            String sidedKey = side.toLowerCase(Locale.ROOT) + "_" + nameLower;
            return megaEvolved.get(sidedKey);
        }
        return null;
    }

    public static boolean isMegaEvolved(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String queryKey = pokemonName.toLowerCase();
        boolean result = megaEvolved.containsKey(queryKey);
        if (!result) {
            result = megaEvolved.containsKey("player_" + queryKey) || megaEvolved.containsKey("opponent_" + queryKey);
        }
        return result;
    }

    public static boolean isMegaEvolved(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String nameLower = pokemonName.toLowerCase(Locale.ROOT);
        if (side != null && !side.isEmpty()) {
            String sidedKey = side.toLowerCase(Locale.ROOT) + "_" + nameLower;
            return megaEvolved.containsKey(sidedKey);
        }
        return false;
    }

    private static String extractPokemonNameFromMessage(String text, String action) {
        String lower = text.toLowerCase();
        int actionIdx = lower.indexOf(action);
        if (actionIdx <= 0) {
            CobblemonBattleInfoClient.debug("[extractPokemonNameFromMessage] Action '{}' not found in text: '{}'", action, text);
            return null;
        }
        String beforeAction = text.substring(0, actionIdx).trim();
        CobblemonBattleInfoClient.debug("[extractPokemonNameFromMessage] Before action: '{}'", beforeAction);
        if (beforeAction.startsWith("The opposing ")) {
            beforeAction = beforeAction.substring("The opposing ".length());
        } else if (beforeAction.startsWith("Wild ")) {
            beforeAction = beforeAction.substring("Wild ".length());
        }
        if (beforeAction.contains("'s ")) {
            int lastApostrophe = beforeAction.lastIndexOf("'s ");
            beforeAction = beforeAction.substring(lastApostrophe + 3);
        }
        String result = beforeAction.trim();
        CobblemonBattleInfoClient.debug("[extractPokemonNameFromMessage] Extracted name: '{}'", result);
        return result;
    }

    private static void checkPlayerWeatherRock(Object battle) {
        try {
            Method getActors;
            Object actors;
            Method getSide1 = battle.getClass().getMethod("getSide1", new Class[0]);
            Method getSide2 = battle.getClass().getMethod("getSide2", new Class[0]);
            Object side1 = getSide1.invoke(battle, new Object[0]);
            Object side2 = getSide2.invoke(battle, new Object[0]);
            Method getRequest = battle.getClass().getMethod("getFirstUnansweredRequest", new Class[0]);
            Object request = getRequest.invoke(battle, new Object[0]);
            Object playerSide = side1;
            if (request != null) {
                try {
                    Method getActivePokemon = request.getClass().getMethod("getActivePokemon", new Class[0]);
                    Object activePokemon = getActivePokemon.invoke(request, new Object[0]);
                    if (activePokemon != null) {
                        Method getActor = activePokemon.getClass().getMethod("getActor", new Class[0]);
                        Object requestActor = getActor.invoke(activePokemon, new Object[0]);
                        Method getActors2 = side1.getClass().getMethod("getActors", new Class[0]);
                        Object actors1 = getActors2.invoke(side1, new Object[0]);
                        if (actors1 instanceof Iterable) {
                            boolean found = false;
                            for (Object actor : (Iterable)actors1) {
                                if (actor != requestActor) continue;
                                found = true;
                                break;
                            }
                            playerSide = found ? side1 : side2;
                        }
                    }
                }
                catch (Exception getActivePokemon) {
                    // empty catch block
                }
            }
            if ((actors = (getActors = playerSide.getClass().getMethod("getActors", new Class[0])).invoke(playerSide, new Object[0])) instanceof Iterable) {
                for (Object actor : (Iterable)actors) {
                    try {
                        Method getPokemon = actor.getClass().getMethod("getPokemon", new Class[0]);
                        Object pokemonList = getPokemon.invoke(actor, new Object[0]);
                        if (!(pokemonList instanceof Iterable)) continue;
                        for (Object pokemon : (Iterable)pokemonList) {
                            if (!BattleMessageSubscriber.checkPokemonHeldItemForRock(pokemon)) continue;
                            hasWeatherRock = true;
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Weather rock detected on player's team! Weather will last 8 turns.", new Object[0]);
                            return;
                        }
                    }
                    catch (Exception e) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking actor Pokemon: {}", e.getMessage());
                    }
                }
            }
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] No weather rock found on player's team.", new Object[0]);
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking for weather rock: {}", e.getMessage());
        }
    }

    private static boolean checkPokemonHeldItemForRock(Object pokemon) {
        block13: {
            try {
                Object heldItem;
                for (String methodName : new String[]{"getHeldItem", "heldItem", "getItem", "item"}) {
                    try {
                        Method method = pokemon.getClass().getMethod(methodName, new Class[0]);
                        heldItem = method.invoke(pokemon, new Object[0]);
                        if (heldItem == null || !BattleMessageSubscriber.isWeatherRock(heldItem)) continue;
                        return true;
                    }
                    catch (NoSuchMethodException method) {
                        // empty catch block
                    }
                }
                for (String fieldName : new String[]{"heldItem", "item", "heldItemStack"}) {
                    try {
                        Field field = pokemon.getClass().getDeclaredField(fieldName);
                        field.setAccessible(true);
                        heldItem = field.get(pokemon);
                        if (heldItem == null || !BattleMessageSubscriber.isWeatherRock(heldItem)) continue;
                        return true;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                try {
                    Method getEffected = pokemon.getClass().getMethod("getEffectedPokemon", new Class[0]);
                    Object effectedPokemon = getEffected.invoke(pokemon, new Object[0]);
                    if (effectedPokemon == null) break block13;
                    for (String methodName : new String[]{"getHeldItem", "heldItem"}) {
                        try {
                            Method method = effectedPokemon.getClass().getMethod(methodName, new Class[0]);
                            Object heldItem2 = method.invoke(effectedPokemon, new Object[0]);
                            if (heldItem2 == null || !BattleMessageSubscriber.isWeatherRock(heldItem2)) continue;
                            return true;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                catch (NoSuchMethodException getEffected) {
                }
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking held item: {}", e.getMessage());
            }
        }
        return false;
    }

    private static boolean isWeatherRock(Object item) {
        try {
            String itemString = item.toString().toLowerCase();
            if (itemString.contains("heat_rock") || itemString.contains("heatrock") || itemString.contains("damp_rock") || itemString.contains("damprock") || itemString.contains("icy_rock") || itemString.contains("icyrock") || itemString.contains("smooth_rock") || itemString.contains("smoothrock")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Found weather rock: {}", itemString);
                return true;
            }
            for (String methodName : new String[]{"getId", "getRegistryName", "getName", "name"}) {
                try {
                    String resultStr;
                    Method method = item.getClass().getMethod(methodName, new Class[0]);
                    Object result = method.invoke(item, new Object[0]);
                    if (result == null || !(resultStr = result.toString().toLowerCase()).contains("heat_rock") && !resultStr.contains("damp_rock") && !resultStr.contains("icy_rock") && !resultStr.contains("smooth_rock")) continue;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Found weather rock via getId: {}", resultStr);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking if item is weather rock: {}", e.getMessage());
        }
        return false;
    }

    public static void setHasWeatherRock(boolean hasRock) {
        hasWeatherRock = hasRock;
    }

    private static void checkPlayerLightClay(Object battle) {
        try {
            Method getActors;
            Object actors;
            Method getSide1 = battle.getClass().getMethod("getSide1", new Class[0]);
            Method getSide2 = battle.getClass().getMethod("getSide2", new Class[0]);
            Object side1 = getSide1.invoke(battle, new Object[0]);
            Object side2 = getSide2.invoke(battle, new Object[0]);
            Method getRequest = battle.getClass().getMethod("getFirstUnansweredRequest", new Class[0]);
            Object request = getRequest.invoke(battle, new Object[0]);
            Object playerSide = side1;
            if (request != null) {
                try {
                    Method getActivePokemon = request.getClass().getMethod("getActivePokemon", new Class[0]);
                    Object activePokemon = getActivePokemon.invoke(request, new Object[0]);
                    if (activePokemon != null) {
                        Method getActor = activePokemon.getClass().getMethod("getActor", new Class[0]);
                        Object requestActor = getActor.invoke(activePokemon, new Object[0]);
                        Method getActors2 = side1.getClass().getMethod("getActors", new Class[0]);
                        Object actors1 = getActors2.invoke(side1, new Object[0]);
                        if (actors1 instanceof Iterable) {
                            boolean found = false;
                            for (Object actor : (Iterable)actors1) {
                                if (actor != requestActor) continue;
                                found = true;
                                break;
                            }
                            playerSide = found ? side1 : side2;
                        }
                    }
                }
                catch (Exception getActivePokemon) {
                    // empty catch block
                }
            }
            if ((actors = (getActors = playerSide.getClass().getMethod("getActors", new Class[0])).invoke(playerSide, new Object[0])) instanceof Iterable) {
                for (Object actor : (Iterable)actors) {
                    try {
                        Method getPokemon = actor.getClass().getMethod("getPokemon", new Class[0]);
                        Object pokemonList = getPokemon.invoke(actor, new Object[0]);
                        if (!(pokemonList instanceof Iterable)) continue;
                        for (Object pokemon : (Iterable)pokemonList) {
                            if (!BattleMessageSubscriber.checkPokemonHeldItemForLightClay(pokemon)) continue;
                            hasLightClay = true;
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Light Clay detected on player's team! Screens will last 8 turns.", new Object[0]);
                            return;
                        }
                    }
                    catch (Exception e) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking actor Pokemon for Light Clay: {}", e.getMessage());
                    }
                }
            }
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] No Light Clay found on player's team.", new Object[0]);
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking for Light Clay: {}", e.getMessage());
        }
    }

    private static boolean checkPokemonHeldItemForLightClay(Object pokemon) {
        block13: {
            try {
                Object heldItem;
                for (String methodName : new String[]{"getHeldItem", "heldItem", "getItem", "item"}) {
                    try {
                        Method method = pokemon.getClass().getMethod(methodName, new Class[0]);
                        heldItem = method.invoke(pokemon, new Object[0]);
                        if (heldItem == null || !BattleMessageSubscriber.isLightClay(heldItem)) continue;
                        return true;
                    }
                    catch (NoSuchMethodException method) {
                        // empty catch block
                    }
                }
                for (String fieldName : new String[]{"heldItem", "item", "heldItemStack"}) {
                    try {
                        Field field = pokemon.getClass().getDeclaredField(fieldName);
                        field.setAccessible(true);
                        heldItem = field.get(pokemon);
                        if (heldItem == null || !BattleMessageSubscriber.isLightClay(heldItem)) continue;
                        return true;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                try {
                    Method getEffected = pokemon.getClass().getMethod("getEffectedPokemon", new Class[0]);
                    Object effectedPokemon = getEffected.invoke(pokemon, new Object[0]);
                    if (effectedPokemon == null) break block13;
                    for (String methodName : new String[]{"getHeldItem", "heldItem"}) {
                        try {
                            Method method = effectedPokemon.getClass().getMethod(methodName, new Class[0]);
                            Object heldItem2 = method.invoke(effectedPokemon, new Object[0]);
                            if (heldItem2 == null || !BattleMessageSubscriber.isLightClay(heldItem2)) continue;
                            return true;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                catch (NoSuchMethodException getEffected) {
                }
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking held item for Light Clay: {}", e.getMessage());
            }
        }
        return false;
    }

    private static boolean isLightClay(Object item) {
        try {
            String itemString = item.toString().toLowerCase();
            if (itemString.contains("light_clay") || itemString.contains("lightclay")) {
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Found Light Clay: {}", itemString);
                return true;
            }
            for (String methodName : new String[]{"getId", "getRegistryName", "getName", "name"}) {
                try {
                    String resultStr;
                    Method method = item.getClass().getMethod(methodName, new Class[0]);
                    Object result = method.invoke(item, new Object[0]);
                    if (result == null || !(resultStr = result.toString().toLowerCase()).contains("light_clay") && !resultStr.contains("lightclay")) continue;
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Found Light Clay via getId: {}", resultStr);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error checking if item is Light Clay: {}", e.getMessage());
        }
        return false;
    }

    public static void setHasLightClay(boolean hasClay) {
        hasLightClay = hasClay;
    }

    private static void extractOpponentPokemonFromBattle(Object battle) {
        try {
            Method getActors;
            Object actors;
            Method getSide1 = battle.getClass().getMethod("getSide1", new Class[0]);
            Method getSide2 = battle.getClass().getMethod("getSide2", new Class[0]);
            Object side1 = getSide1.invoke(battle, new Object[0]);
            Object side2 = getSide2.invoke(battle, new Object[0]);
            Method getRequest = battle.getClass().getMethod("getFirstUnansweredRequest", new Class[0]);
            Object request = getRequest.invoke(battle, new Object[0]);
            Object playerSide = side1;
            Object opponentSide = side2;
            if (request != null) {
                try {
                    Method getActivePokemon = request.getClass().getMethod("getActivePokemon", new Class[0]);
                    Object activePokemon = getActivePokemon.invoke(request, new Object[0]);
                    if (activePokemon != null) {
                        Method getActor = activePokemon.getClass().getMethod("getActor", new Class[0]);
                        Object requestActor = getActor.invoke(activePokemon, new Object[0]);
                        Method getActors2 = side1.getClass().getMethod("getActors", new Class[0]);
                        Object actors1 = getActors2.invoke(side1, new Object[0]);
                        if (actors1 instanceof Iterable) {
                            boolean foundOnSide1 = false;
                            for (Object actor : (Iterable)actors1) {
                                if (actor != requestActor) continue;
                                foundOnSide1 = true;
                                break;
                            }
                            if (foundOnSide1) {
                                playerSide = side1;
                                opponentSide = side2;
                            } else {
                                playerSide = side2;
                                opponentSide = side1;
                            }
                        }
                    }
                }
                catch (Exception getActivePokemon) {
                    // empty catch block
                }
            }
            if ((actors = (getActors = opponentSide.getClass().getMethod("getActors", new Class[0])).invoke(opponentSide, new Object[0])) instanceof Iterable) {
                for (Object actor : (Iterable)actors) {
                    try {
                        Method getActivePokemon = actor.getClass().getMethod("getActivePokemon", new Class[0]);
                        Object activePokemonList = getActivePokemon.invoke(actor, new Object[0]);
                        if (!(activePokemonList instanceof Iterable)) continue;
                        for (Object activePokemon : (Iterable)activePokemonList) {
                            Method getSpecies;
                            Object species;
                            Method getName;
                            String pokemonName;
                            Method getBattlePokemon = activePokemon.getClass().getMethod("getBattlePokemon", new Class[0]);
                            Object battlePokemon = getBattlePokemon.invoke(activePokemon, new Object[0]);
                            if (battlePokemon == null || (pokemonName = (String)(getName = (species = (getSpecies = battlePokemon.getClass().getMethod("getSpecies", new Class[0])).invoke(battlePokemon, new Object[0])).getClass().getMethod("getName", new Class[0])).invoke(species, new Object[0])) == null || pokemonName.isEmpty()) continue;
                            opponentPokemon.add(pokemonName.toLowerCase());
                            BattleMessageColorizer.registerOpponentPokemon(pokemonName);
                            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Registered opponent Pokemon at battle start: {}", pokemonName);
                        }
                    }
                    catch (Exception e) {
                        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error extracting opponent Pokemon: {}", e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Error extracting opponent Pokemon from battle: {}", e.getMessage());
        }
    }

    public static String getCurrentWeather() {
        return currentWeather;
    }

    public static String getCurrentTerrain() {
        return currentTerrain;
    }

    public static int getWeatherTurns() {
        return weatherTurns;
    }

    public static int getTerrainTurns() {
        return terrainTurns;
    }

    public static int getTrickRoomTurns() {
        return trickRoomTurns;
    }

    public static int getWonderRoomTurns() {
        return wonderRoomTurns;
    }

    public static int getMagicRoomTurns() {
        return magicRoomTurns;
    }

    public static int getEmbargoTurns(String pokemonName) {
        if (pokemonName == null) {
            return 0;
        }
        int turns = embargo.getOrDefault(pokemonName.toLowerCase(), 0);
        if (turns > 0) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] getEmbargoTurns('{}') = {}", pokemonName, turns);
        }
        return turns;
    }

    public static int getEmbargoTurns(String side, String pokemonName) {
        String sidedKey;
        Integer val;
        if (pokemonName == null) {
            return 0;
        }
        if (side != null && !side.isEmpty() && (val = embargo.get(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName))) != null && val > 0) {
            return val;
        }
        return embargo.getOrDefault(pokemonName.toLowerCase(), 0);
    }

    public static int getHealBlockTurns(String pokemonName) {
        if (pokemonName == null) {
            return 0;
        }
        int turns = healBlock.getOrDefault(pokemonName.toLowerCase(), 0);
        if (turns > 0) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] getHealBlockTurns('{}') = {}", pokemonName, turns);
        }
        return turns;
    }

    public static int getHealBlockTurns(String side, String pokemonName) {
        String sidedKey;
        Integer val;
        if (pokemonName == null) {
            return 0;
        }
        if (side != null && !side.isEmpty() && (val = healBlock.get(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName))) != null && val > 0) {
            return val;
        }
        return healBlock.getOrDefault(pokemonName.toLowerCase(), 0);
    }

    public static Map<String, Integer> getStatStagesForPokemon(String side, String name) {
        Map<String, Integer> result;
        if (name == null) {
            return Collections.emptyMap();
        }
        String nameLower = name.toLowerCase(Locale.ROOT);
        if (side != null && !side.isEmpty()) {
            String sidedKey = side.toLowerCase(Locale.ROOT) + "_" + nameLower;
            Map<String, Integer> result2 = statStages.get(sidedKey);
            if (result2 != null && !result2.isEmpty()) {
                CobblemonBattleInfoClient.debug("[STAT_RETRIEVE] Found stats for {} (side: {}, key: {}): {}", name, side, sidedKey, result2);
                return result2;
            }
            CobblemonBattleInfoClient.debug("[STAT_RETRIEVE] No stats found for {} (side: {}, key: {})", name, side, sidedKey);
        }
        if ((result = statStages.get(name)) != null && !result.isEmpty()) {
            CobblemonBattleInfoClient.debug("[STAT_RETRIEVE] Found stats for {} (exact match): {}", name, result);
            return result;
        }
        for (Map.Entry<String, Map<String, Integer>> entry : statStages.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            CobblemonBattleInfoClient.debug("[STAT_RETRIEVE] Found stats for {} (case-insensitive match, key: {}): {}", name, entry.getKey(), entry.getValue());
            return entry.getValue();
        }
        CobblemonBattleInfoClient.debug("[STAT_RETRIEVE] No stats found for {} (side: {}). All keys: {}", name, side, statStages.keySet());
        return Collections.emptyMap();
    }

    public static int getStatStage(String side, String name, String stat) {
        Map<String, Integer> stages = BattleMessageSubscriber.getStatStagesForPokemon(side, name);
        if (stages.isEmpty()) {
            return 0;
        }
        return stages.getOrDefault(stat.toLowerCase(Locale.ROOT), 0);
    }

    public static Map<String, Integer> getStatStagesForPokemon(String name) {
        if (name == null) {
            return Collections.emptyMap();
        }
        String nameLower = name.toLowerCase(Locale.ROOT);
        Map<String, Integer> playerResult = statStages.get("player_" + nameLower);
        Map<String, Integer> opponentResult = statStages.get("opponent_" + nameLower);
        if (playerResult != null && !playerResult.isEmpty() && (opponentResult == null || opponentResult.isEmpty())) {
            return playerResult;
        }
        if (opponentResult != null && !opponentResult.isEmpty() && (playerResult == null || playerResult.isEmpty())) {
            return opponentResult;
        }
        Map<String, Integer> result = statStages.get(name);
        if (result != null && !result.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, Map<String, Integer>> entry : statStages.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return Collections.emptyMap();
    }

    public static Map<String, Map<String, Integer>> getAllStatStages() {
        return statStages;
    }

    public static Map<String, Integer> getScreensForSide(String side) {
        return screens.getOrDefault(side, Collections.emptyMap());
    }

    public static Map<String, Integer> getHazardsForSide(String side) {
        return hazards.getOrDefault(side, Collections.emptyMap());
    }

    public static int getTailwindTurns(String side) {
        return tailwind.getOrDefault(side, 0);
    }

    public static String getTeraType(String side, String pokemonName) {
        String sidedKey;
        String result;
        if (pokemonName == null) {
            return null;
        }
        String lower = pokemonName.toLowerCase();
        if (side != null && !side.isEmpty() && (result = terastallized.get(sidedKey = BattleMessageSubscriber.makeSidedKey(side, lower))) != null) {
            return result;
        }
        String result2 = terastallized.get(lower);
        if (result2 != null) {
            return result2;
        }
        for (Map.Entry<String, String> entry : terastallized.entrySet()) {
            String key = entry.getKey();
            if (key.contains("_") && (key.startsWith("player_") || key.startsWith("opponent_")) || !key.contains(lower) && !lower.contains(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getTeraType(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        String lower = pokemonName.toLowerCase();
        String teraType = terastallized.get(lower);
        if (teraType != null) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Found Tera type '{}' for '{}' (direct match)", teraType, pokemonName);
            return teraType;
        }
        for (Map.Entry<String, String> entry : terastallized.entrySet()) {
            if (!entry.getKey().contains(lower) && !lower.contains(entry.getKey())) continue;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Found Tera type '{}' for '{}' (partial match: {})", entry.getValue(), pokemonName, entry.getKey());
            return entry.getValue();
        }
        return null;
    }

    public static boolean isTerastallized(String pokemonName) {
        return BattleMessageSubscriber.getTeraType(pokemonName) != null;
    }

    public static boolean isTerastallized(String side, String pokemonName) {
        return BattleMessageSubscriber.getTeraType(side, pokemonName) != null;
    }

    public static boolean isIngrained(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Boolean val = ingrained.get(sidedKey);
            return val != null && val != false;
        }
        return false;
    }

    public static boolean isIngrained(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (ingrained.containsKey(lower) && ingrained.get(lower).booleanValue()) {
            return true;
        }
        if (ingrained.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && ingrained.get(BattleMessageSubscriber.makeSidedKey("player", lower)).booleanValue()) {
            return true;
        }
        return ingrained.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && ingrained.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) != false;
    }

    public static boolean hasAquaRing(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Boolean val = aquaRing.get(sidedKey);
            return val != null && val != false;
        }
        return false;
    }

    public static boolean hasAquaRing(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (aquaRing.containsKey(lower) && aquaRing.get(lower).booleanValue()) {
            return true;
        }
        if (aquaRing.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && aquaRing.get(BattleMessageSubscriber.makeSidedKey("player", lower)).booleanValue()) {
            return true;
        }
        return aquaRing.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && aquaRing.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) != false;
    }

    public static boolean hasEmbargo(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Integer val = embargo.get(sidedKey);
            return val != null && val > 0;
        }
        return false;
    }

    public static boolean hasEmbargo(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (embargo.containsKey(lower) && embargo.get(lower) > 0) {
            return true;
        }
        if (embargo.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && embargo.get(BattleMessageSubscriber.makeSidedKey("player", lower)) > 0) {
            return true;
        }
        return embargo.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && embargo.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) > 0;
    }

    public static boolean hasHealBlock(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Integer val = healBlock.get(sidedKey);
            return val != null && val > 0;
        }
        return false;
    }

    public static boolean hasHealBlock(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (healBlock.containsKey(lower) && healBlock.get(lower) > 0) {
            return true;
        }
        if (healBlock.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && healBlock.get(BattleMessageSubscriber.makeSidedKey("player", lower)) > 0) {
            return true;
        }
        return healBlock.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && healBlock.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) > 0;
    }

    public static boolean isLeechSeeded(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Boolean val = leechSeeded.get(sidedKey);
            return val != null && val != false;
        }
        return false;
    }

    public static boolean isLeechSeeded(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (leechSeeded.containsKey(lower) && leechSeeded.get(lower).booleanValue()) {
            return true;
        }
        if (leechSeeded.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && leechSeeded.get(BattleMessageSubscriber.makeSidedKey("player", lower)).booleanValue()) {
            return true;
        }
        return leechSeeded.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && leechSeeded.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) != false;
    }

    public static boolean hasSubstitute(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Boolean val = hasSubstitute.get(sidedKey);
            return val != null && val != false;
        }
        return false;
    }

    public static boolean hasSubstitute(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (hasSubstitute.containsKey(lower) && hasSubstitute.get(lower).booleanValue()) {
            return true;
        }
        if (hasSubstitute.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && hasSubstitute.get(BattleMessageSubscriber.makeSidedKey("player", lower)).booleanValue()) {
            return true;
        }
        return hasSubstitute.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && hasSubstitute.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) != false;
    }

    public static boolean isConfused(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Boolean val = confused.get(sidedKey);
            return val != null && val != false;
        }
        return false;
    }

    public static boolean isConfused(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (confused.containsKey(lower) && confused.get(lower).booleanValue()) {
            return true;
        }
        if (confused.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && confused.get(BattleMessageSubscriber.makeSidedKey("player", lower)).booleanValue()) {
            return true;
        }
        return confused.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && confused.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) != false;
    }

    public static boolean isIdentified(String side, String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        if (side != null && !side.isEmpty()) {
            String sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName);
            Boolean val = identified.get(sidedKey);
            return val != null && val != false;
        }
        return false;
    }

    public static boolean isIdentified(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        String lower = pokemonName.toLowerCase();
        if (identified.containsKey(lower) && identified.get(lower).booleanValue()) {
            return true;
        }
        if (identified.containsKey(BattleMessageSubscriber.makeSidedKey("player", lower)) && identified.get(BattleMessageSubscriber.makeSidedKey("player", lower)).booleanValue()) {
            return true;
        }
        return identified.containsKey(BattleMessageSubscriber.makeSidedKey("opponent", lower)) && identified.get(BattleMessageSubscriber.makeSidedKey("opponent", lower)) != false;
    }

    public static boolean isLocalPlayerPokemon(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        return localPlayerPokemon.contains(pokemonName.toLowerCase());
    }

    public static boolean isOpponentPokemon(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        return opponentPokemon.contains(pokemonName.toLowerCase());
    }

    public static List<String> getTrackedOpponentPokemon() {
        return new ArrayList<String>(opponentPokemon);
    }

    public static void clearVolatileStatus(String pokemonName) {
        if (pokemonName == null) {
            return;
        }
        String lower = pokemonName.toLowerCase();
        leechSeeded.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        ingrained.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        aquaRing.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        hasSubstitute.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        confused.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        identified.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        soaked.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        burnedUp.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        magnetRise.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        telekinesis.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        smackDownGrounded.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        transformedTypes.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        addedTypes.entrySet().removeIf(e -> ((String)e.getKey()).toLowerCase().equals(lower));
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Cleared volatile status for {}", pokemonName);
    }

    private static void parseMoveUsed(String text) {
        String lower = text.toLowerCase();
        if (!lower.contains(" used ")) {
            return;
        }
        int usedIdx = lower.indexOf(" used ");
        if (usedIdx <= 0) {
            return;
        }
        String pokemonName = text.substring(0, usedIdx).trim();
        String afterUsed = text.substring(usedIdx + 6);
        int endIdx = afterUsed.indexOf(33);
        if (endIdx <= 0) {
            return;
        }
        String moveName = afterUsed.substring(0, endIdx).trim();
        String displayPokemonName = pokemonName;
        if (displayPokemonName.contains("'s ")) {
            displayPokemonName = displayPokemonName.substring(displayPokemonName.lastIndexOf("'s ") + 3);
        }
        String lowerPokemonName = displayPokemonName.toLowerCase();
        boolean isOpponent = false;
        if (pokemonName.toLowerCase().startsWith("the opposing ") || pokemonName.toLowerCase().startsWith("the foe's ")) {
            isOpponent = true;
            if (displayPokemonName.toLowerCase().startsWith("opposing ")) {
                displayPokemonName = displayPokemonName.substring(9);
            }
            if (displayPokemonName.toLowerCase().startsWith("foe's ")) {
                displayPokemonName = displayPokemonName.substring(6);
            }
        } else if (opponentPokemon.contains(lowerPokemonName)) {
            isOpponent = true;
        } else if (localPlayerPokemon.contains(lowerPokemonName)) {
            isOpponent = false;
        } else if (pokemonName.contains("'s ")) {
            String owner = pokemonName.substring(0, pokemonName.indexOf("'s ")).trim();
            String cleanOwner = owner.replaceAll("^_", "").replaceAll("_$", "");
            String cleanLocal = localPlayerName != null ? localPlayerName.replaceAll("^_", "").replaceAll("_$", "") : "";
            boolean bl = isOpponent = !cleanOwner.equalsIgnoreCase(cleanLocal);
        }
        if (!isOpponent) {
            BattleMessageSubscriber.decrementMovePPWithFallback(pokemonName, moveName);
        }
    }

    private static void decrementMovePPWithFallback(String pokemonName, String moveName) {
        String lowerPokemon = pokemonName.toLowerCase();
        String lowerMove = moveName.toLowerCase();
        Map<String, int[]> movePP = pokemonMovePP.get(lowerPokemon);
        if (movePP != null && movePP.containsKey(lowerMove)) {
            int[] pp = movePP.get(lowerMove);
            if (pp[0] > 0) {
                pp[0] = pp[0] - 1;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used {} - PP now {}/{}", pokemonName, moveName, pp[0], pp[1]);
            }
            return;
        }
        for (Map.Entry<String, Map<String, int[]>> entry : pokemonMovePP.entrySet()) {
            Map<String, int[]> moves = entry.getValue();
            if (!moves.containsKey(lowerMove)) continue;
            int[] pp = moves.get(lowerMove);
            if (pp[0] > 0) {
                pp[0] = pp[0] - 1;
                CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used {} (fallback via {}) - PP now {}/{}", pokemonName, moveName, entry.getKey(), pp[0], pp[1]);
            }
            return;
        }
        CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] No PP tracked for move {} (Pokemon: {})", moveName, pokemonName);
    }

    private static void decrementMovePP(String pokemonName, String moveName) {
        String lowerPokemon = pokemonName.toLowerCase();
        String lowerMove = moveName.toLowerCase();
        Map<String, int[]> movePP = pokemonMovePP.get(lowerPokemon);
        if (movePP == null) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] No PP tracked for {} yet, cannot decrement {}", pokemonName, moveName);
            return;
        }
        int[] pp = movePP.get(lowerMove);
        if (pp == null) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Move {} not tracked for {}", moveName, pokemonName);
            return;
        }
        if (pp[0] > 0) {
            pp[0] = pp[0] - 1;
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] {} used {} - PP now {}/{}", pokemonName, moveName, pp[0], pp[1]);
        }
    }

    public static void initializeMovePP(String pokemonName, String moveName, int currentPP, int maxPP) {
        String lowerPokemon = pokemonName.toLowerCase();
        String lowerMove = moveName.toLowerCase();
        Map movePP = pokemonMovePP.computeIfAbsent(lowerPokemon, k -> new ConcurrentHashMap());
        if (!movePP.containsKey(lowerMove)) {
            movePP.put(lowerMove, new int[]{currentPP, maxPP});
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Initialized PP for {}'s {}: {}/{}", pokemonName, moveName, currentPP, maxPP);
        }
    }

    public static int[] getMovePP(String pokemonName, String moveName) {
        if (pokemonName == null || moveName == null) {
            return null;
        }
        String lowerPokemon = pokemonName.toLowerCase();
        String lowerMove = moveName.toLowerCase();
        Map<String, int[]> movePP = pokemonMovePP.get(lowerPokemon);
        if (movePP == null) {
            return null;
        }
        return movePP.get(lowerMove);
    }

    public static boolean hasPPDataFor(String pokemonName) {
        if (pokemonName == null) {
            return false;
        }
        return pokemonMovePP.containsKey(pokemonName.toLowerCase());
    }

    public static int[] getMovePPForAnyPokemon(String moveName) {
        if (moveName == null) {
            return null;
        }
        String lowerMove = moveName.toLowerCase();
        for (Map<String, int[]> moveMap : pokemonMovePP.values()) {
            if (!moveMap.containsKey(lowerMove)) continue;
            return moveMap.get(lowerMove);
        }
        return null;
    }

    public static void captureHeldItemIfNeeded(String pokemonName) {
        if (pokemonName == null) {
            return;
        }
        String lowerName = pokemonName.toLowerCase();
        if (heldItems.containsKey(lowerName)) {
            return;
        }
        try {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null || mc.field_1687 == null) {
                return;
            }
            Class<?> cobblemonClass = Class.forName("com.cobblemon.mod.common.Cobblemon");
            Field instanceField = cobblemonClass.getField("INSTANCE");
            Object cobblemonInstance = instanceField.get(null);
            if (cobblemonInstance == null) {
                return;
            }
            Method getStorage = cobblemonInstance.getClass().getMethod("getStorage", new Class[0]);
            Object storageInstance = getStorage.invoke(cobblemonInstance, new Object[0]);
            if (storageInstance == null) {
                return;
            }
            Method getPartyMethod = null;
            Class<?> secondParamClass = null;
            for (Method method : storageInstance.getClass().getMethods()) {
                Class<?>[] params;
                if (!method.getName().equals("getParty") || method.getParameterCount() != 2 || (params = method.getParameterTypes())[0] != UUID.class) continue;
                getPartyMethod = method;
                secondParamClass = params[1];
                break;
            }
            if (getPartyMethod == null || secondParamClass == null) {
                return;
            }
            class_5455 secondParam = null;
            if (secondParamClass.getName().contains("class_5455") || secondParamClass.getName().contains("RegistryAccess")) {
                secondParam = mc.field_1687.method_30349();
            }
            if (secondParam == null) {
                return;
            }
            Object party = getPartyMethod.invoke(storageInstance, mc.field_1724.method_5667(), secondParam);
            if (party == null) {
                return;
            }
            for (Object partyPokemon : (Iterable)party) {
                Pokemon pkm;
                String speciesName;
                if (!(partyPokemon instanceof Pokemon) || !(speciesName = (pkm = (Pokemon)partyPokemon).getSpecies().getName().toLowerCase()).equals(lowerName)) continue;
                class_1799 heldItem = pkm.heldItem();
                if (heldItem != null && !heldItem.method_7960()) {
                    String itemId = heldItem.method_7909().toString();
                    heldItems.put(lowerName, itemId);
                    CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Captured held item for {}: {}", pokemonName, itemId);
                } else {
                    heldItems.put(lowerName, "");
                }
                break;
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Could not capture held item for {}: {}", pokemonName, e.getMessage());
        }
    }

    public static String getHeldItem(String pokemonName) {
        if (pokemonName == null) {
            return null;
        }
        BattleMessageSubscriber.captureHeldItemIfNeeded(pokemonName);
        String item = heldItems.get(pokemonName.toLowerCase());
        return item == null || item.isEmpty() ? null : item;
    }

    public static String getHeldItem(String side, String pokemonName) {
        String sidedKey;
        String item;
        if (pokemonName == null) {
            return null;
        }
        if (side != null && !side.isEmpty() && (item = heldItems.get(sidedKey = BattleMessageSubscriber.makeSidedKey(side, pokemonName))) != null && !item.isEmpty()) {
            return item;
        }
        return BattleMessageSubscriber.getHeldItem(pokemonName);
    }

    static {
        translationKeyDebugLogging = BattleMessageSubscriber.readBooleanToggle(PROP_DEBUG_KEYS, ENV_DEBUG_KEYS, translationKeyDebugLogging);
        legacyStringParsingEnabled = BattleMessageSubscriber.readBooleanToggle(PROP_LEGACY_PARSING, ENV_LEGACY_PARSING, legacyStringParsingEnabled);
        translationKeyParsingEnabled = BattleMessageSubscriber.readBooleanToggle(PROP_KEY_PARSING, ENV_KEY_PARSING, translationKeyParsingEnabled);
        translationKeyDebugFilter = BattleMessageSubscriber.readStringToggle(PROP_DEBUG_KEYS_FILTER, ENV_DEBUG_KEYS_FILTER, null);
        if (translationKeyDebugLogging) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Translation-key debug logging enabled ({} / {}).", PROP_DEBUG_KEYS, ENV_DEBUG_KEYS);
        }
        if (!legacyStringParsingEnabled) {
            CobblemonBattleInfoClient.debug("[BattleMessageSubscriber] Legacy English parsing disabled ({} / {}).", PROP_LEGACY_PARSING, ENV_LEGACY_PARSING);
        }
        if (!translationKeyParsingEnabled) {
            LOGGER.warn("[BattleMessageSubscriber] Translation-key parsing disabled ({} / {}).", (Object)PROP_KEY_PARSING, (Object)ENV_KEY_PARSING);
        }
        cachedCobblemonClientClass = null;
        cachedCobblemonClientInstance = null;
        cachedGetBattleMethod = null;
        reflectionCacheInitialized = false;
        ACCESSOR_METHOD_NAMES = new String[]{"getComponent", "component", "getText", "getMessage", "getContents", "contents", "getArgs", "args"};
        DEBUG_ACCESSOR_METHOD_NAMES = new String[]{"getMessage", "getComponent", "message", "component", "getText", "text"};
        methodCache = new ConcurrentHashMap();
        methodNotFoundCache = new ConcurrentHashMap();
        recentAbilityPopups = new ConcurrentHashMap();
        lastAbilityPopupFromKeyMs = 0L;
        waterSportTurns = 0;
        mudSportTurns = 0;
        pendingIngrainPokemon = null;
        pendingAquaRingPokemon = null;
    }
}

