/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleSideHelper;
import name.modid.client.RevealedBattleInfo;
import name.modid.client.TypeChart;
import name.modid.client.TypeIconRenderer;
import name.modid.platform.Services;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BattleInfoPanelRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleInfoPanelRenderer");
    private static final class_2960 PANEL_TEXTURE = class_2960.method_60655((String)"cobblemon-battle-extras", (String)"textures/gui/battle_info.png");
    private static final int PANEL_WIDTH = 140;
    private static final int PANEL_HEIGHT = 114;
    private static final int ABILITY_SLOT_X = 15;
    private static final int ABILITY_SLOT_Y = 55;
    private static final int ABILITY_SLOT_WIDTH = 60;
    private static final int ABILITY_SLOT_HEIGHT = 14;
    private static final int ITEM_SLOT_X = 6;
    private static final int ITEM_SLOT_Y = 85;
    private static final int ITEM_SLOT_SIZE = 32;
    private static final int MOVE_SLOT_X = 74;
    private static final int MOVE_SLOT_Y = 60;
    private static final int MOVE_SLOT_WIDTH = 60;
    private static final int MOVE_SLOT_HEIGHT = 14;
    private static final int MOVE_SLOT_SPACING = -2;
    private static final int TILE_WIDTH = 140;
    private static final int COMPACT_TILE_WIDTH = 128;
    private static final int TILE_HEIGHT = 40;
    private static final int COMPACT_TILE_HEIGHT = 28;
    private static final int HORIZONTAL_INSET = 12;
    private static final int VERTICAL_INSET = 10;
    private static final int VERTICAL_SPACING = 40;
    private static final int COMPACT_VERTICAL_SPACING = 30;
    private static final int HORIZONTAL_SPACING = 4;
    private static final Map<String, PanelAnimationState> animationStates = new HashMap<String, PanelAnimationState>();
    private static final long SLIDE_DURATION_MS = 300L;
    private static final Map<String, Integer> TYPE_COLORS = new HashMap<String, Integer>();
    private static final class_2960 TYPE_SPRITE_SHEET;
    private static final int ICON_SIZE = 36;
    private static final int SPRITE_SHEET_WIDTH = 648;
    private static final int DISPLAY_ICON_SIZE = 10;
    private static final String[] TYPE_ORDER;

    public static void init() {
        if (!Services.PLATFORM.isModLoaded("cobblemon")) {
            return;
        }
        Services.EVENTS.registerHudRender((guiGraphics, tickDelta) -> {
            try {
                BattleInfoPanelRenderer.renderBattleInfoPanels(guiGraphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Battle info panel renderer initialized", new Object[0]);
    }

    private static void renderBattleInfoPanels(class_332 gui) {
        if (!BattleExtrasConfig.isBattleInfoPanelEnabled()) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            animationStates.clear();
            return;
        }
        RevealedBattleInfo.onBattleStart(battle);
        class_310 mc = class_310.method_1551();
        if (mc.field_1729.method_1613()) {
            return;
        }
        int screenWidth = mc.method_22683().method_4486();
        double mouseX = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double mouseY = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        boolean isCompact = battle.getBattleFormat().getBattleType().getPokemonPerSide() > 1;
        int totalOpponentPokemon = 0;
        for (ActiveClientBattlePokemon pokemon : opponentSide.getActiveClientBattlePokemon()) {
            ++totalOpponentPokemon;
        }
        int opponentSlot = 0;
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon activePokemon : actor.getActivePokemon()) {
                ClientBattlePokemon battlePokemon = activePokemon.getBattlePokemon();
                if (battlePokemon == null) continue;
                String pokemonName = battlePokemon.getSpecies().getName();
                String normalizedName = pokemonName.toLowerCase().replaceAll("[^a-z0-9]", "");
                int tileWidth = isCompact ? 128 : 140;
                int tileHeight = isCompact ? 28 : 40;
                int slotCount = battle.getBattleFormat().getBattleType().getSlotsPerActor();
                float tileX = screenWidth - 12 - (slotCount - (totalOpponentPokemon - opponentSlot - 1) - 1) * 4 - tileWidth;
                int tileY = 10 + (totalOpponentPokemon - opponentSlot - 1) * (isCompact ? 30 : 40);
                boolean isHovered = mouseX >= (double)tileX && mouseX <= (double)(tileX + (float)tileWidth) && mouseY >= (double)tileY && mouseY <= (double)(tileY + tileHeight);
                PanelAnimationState state = animationStates.computeIfAbsent(normalizedName, k -> new PanelAnimationState());
                state.setHovered(isHovered);
                float slideProgress = state.getSlideProgress();
                if (slideProgress > 0.0f) {
                    RevealedBattleInfo.PokemonRevealedInfo info = RevealedBattleInfo.getRevealedInfo(normalizedName);
                    BattleInfoPanelRenderer.renderPanel(gui, mc, (int)tileX, tileY + tileHeight, info, slideProgress, battlePokemon, pokemonName);
                }
                ++opponentSlot;
            }
        }
    }

    private static void renderPanel(class_332 gui, class_310 mc, int x, int y, RevealedBattleInfo.PokemonRevealedInfo info, float slideProgress, Object battlePokemon, String pokemonName) {
        float easedProgress = BattleInfoPanelRenderer.easeOutCubic(slideProgress);
        int slideOffset = (int)((1.0f - easedProgress) * -114.0f);
        int panelY = y + slideOffset - 40;
        float alpha = easedProgress;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
        gui.method_25290(PANEL_TEXTURE, x, panelY, 0.0f, 0.0f, 140, 114, 140, 114);
        int labelColor = 0xCCCCCC;
        BattleInfoPanelRenderer.drawScaledText(gui, mc, "Ability:", x + 15 + 14, panelY + 55 - 7, labelColor, alpha, 0.6f);
        BattleInfoPanelRenderer.drawScaledText(gui, mc, "Moves:", x + 74 + 20, panelY + 60 - 12, labelColor, alpha, 0.6f);
        BattleInfoPanelRenderer.drawScaledText(gui, mc, "Held Item:", x + 6 + 30, panelY + 85 + 5, labelColor, alpha, 0.6f);
        String abilityText = info != null && info.getAbilityDisplay() != null ? BattleInfoPanelRenderer.truncateText(mc, info.getAbilityDisplay(), 56) : "???";
        int abilityTextWidth = (int)((float)mc.field_1772.method_1727(abilityText) * 0.7f);
        int abilityTextX = x + 15 + (60 - abilityTextWidth) / 2 - 5;
        int abilityTextY = panelY + 55 + 3;
        int abilityColor = info != null && info.getAbilityDisplay() != null ? 0xFFFFFF : 0x888888;
        BattleInfoPanelRenderer.drawScaledText(gui, mc, abilityText, abilityTextX, abilityTextY, abilityColor, alpha, 0.7f);
        String itemText = info != null && info.getHeldItemDisplay() != null ? BattleInfoPanelRenderer.truncateText(mc, BattleInfoPanelRenderer.formatItemDisplayName(info.getHeldItemDisplay()), 62) : "???";
        int itemTextX = x + 6 + 32 - 2;
        int itemTextY = panelY + 85 + 16 - 1;
        int itemColor = info != null && info.getHeldItemDisplay() != null ? 0xFFFFFF : 0x888888;
        BattleInfoPanelRenderer.drawScaledText(gui, mc, itemText, itemTextX, itemTextY, itemColor, alpha, 0.55f);
        if (info != null && info.getHeldItem() != null) {
            BattleInfoPanelRenderer.renderHeldItemSprite(gui, mc, x + 6 + 4, panelY + 85, info.getHeldItem(), alpha);
        }
        int revealedMoveCount = info != null ? info.getMoves().size() : 0;
        for (int i = 0; i < 4; ++i) {
            int iconX = x + 74 + 2;
            int textX = iconX + 10;
            int extraOffset = 0;
            if (i == 0) {
                extraOffset = -1;
            } else if (i == 2) {
                extraOffset = 1;
            } else if (i == 3) {
                extraOffset = 2;
            }
            int textY = panelY + 60 + 3 + i * 12 + extraOffset;
            if (i < revealedMoveCount) {
                RevealedBattleInfo.PokemonRevealedInfo.MoveInfo move = info.getMoves().get(i);
                String moveText = BattleInfoPanelRenderer.truncateText(mc, move.displayName, 48);
                int color = TYPE_COLORS.getOrDefault(move.type != null ? move.type.toLowerCase() : "", 0xFFFFFF);
                if (move.type != null && !move.type.isBlank()) {
                    BattleInfoPanelRenderer.renderTypeIconScaled(gui, iconX, textY - 2, move.type, alpha, 8);
                }
                BattleInfoPanelRenderer.drawScaledText(gui, mc, moveText, textX, textY, color, alpha, 0.6f);
                continue;
            }
            BattleInfoPanelRenderer.drawScaledText(gui, mc, "???", textX, textY, 0x888888, alpha, 0.7f);
        }
        BattleInfoPanelRenderer.renderWeaknesses(gui, mc, x, panelY, battlePokemon, pokemonName, alpha);
        gui.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderWeaknesses(class_332 gui, class_310 mc, int panelX, int panelY, Object battlePokemon, String pokemonName, float alpha) {
        int iconX;
        List<String> types = BattleInfoPanelRenderer.getPokemonTypes(battlePokemon, pokemonName);
        if (types.isEmpty()) {
            return;
        }
        ArrayList<String> superEffective4x = new ArrayList<String>();
        ArrayList<String> superEffective2x = new ArrayList<String>();
        for (String attackType : TYPE_ORDER) {
            float effectiveness = BattleInfoPanelRenderer.calculateEffectiveness(attackType, types);
            if (effectiveness >= 4.0f) {
                superEffective4x.add(attackType);
                continue;
            }
            if (!(effectiveness >= 2.0f)) continue;
            superEffective2x.add(attackType);
        }
        int weaknessY = panelY + 85 + 32 - 50;
        int weaknessX = panelX + 4;
        if (!superEffective4x.isEmpty()) {
            BattleInfoPanelRenderer.drawScaledText(gui, mc, "x4:", weaknessX + 2, weaknessY + 2, 0xFF6666, alpha, 0.6f);
            iconX = weaknessX + 10;
            for (String type : superEffective4x) {
                BattleInfoPanelRenderer.renderTypeIcon(gui, iconX, weaknessY, type, alpha);
                iconX += 10;
            }
            weaknessY += 9;
        }
        if (!superEffective2x.isEmpty()) {
            BattleInfoPanelRenderer.drawScaledText(gui, mc, "x2:", weaknessX + 2, weaknessY + 2, 0xFFAA66, alpha, 0.6f);
            iconX = weaknessX + 10;
            for (String type : superEffective2x) {
                BattleInfoPanelRenderer.renderTypeIcon(gui, iconX, weaknessY, type, alpha);
                iconX += 10;
            }
        }
    }

    private static List<String> getPokemonTypes(Object battlePokemon, String pokemonName) {
        List<ElementalType> displayTypes;
        ArrayList<String> types = new ArrayList<String>();
        String pokemonUUID = null;
        try {
            Method getUuidMethod = battlePokemon.getClass().getMethod("getUuid", new Class[0]);
            Object uuidObj = getUuidMethod.invoke(battlePokemon, new Object[0]);
            if (uuidObj != null) {
                pokemonUUID = uuidObj.toString();
            }
        }
        catch (Throwable getUuidMethod) {
            // empty catch block
        }
        if (pokemonUUID != null) {
            try {
                String[] opponentTypes;
                Class<?> randomizerClient = Class.forName("cobblemon.randomizer.client.RandomizerClient");
                String[] wildTypes = (String[])randomizerClient.getMethod("getWildPokemonTypes", String.class).invoke(null, pokemonUUID);
                if (wildTypes != null && wildTypes.length > 0) {
                    for (String typeName : wildTypes) {
                        types.add(typeName.toLowerCase());
                    }
                    CobblemonBattleInfoClient.debug("[BattleInfoPanel] Using wild randomized types for {}: {}", pokemonName, types);
                    return types;
                }
                Boolean hasOpponentTypes = (Boolean)randomizerClient.getMethod("hasOpponentPokemonTypes", new Class[0]).invoke(null, new Object[0]);
                if (hasOpponentTypes != null && hasOpponentTypes.booleanValue() && (opponentTypes = (String[])randomizerClient.getMethod("getOpponentPokemonTypes", String.class).invoke(null, pokemonUUID)) != null && opponentTypes.length > 0) {
                    for (String typeName : opponentTypes) {
                        types.add(typeName.toLowerCase());
                    }
                    CobblemonBattleInfoClient.debug("[BattleInfoPanel] Using PvP opponent randomized types for {}: {}", pokemonName, types);
                    return types;
                }
            }
            catch (ClassNotFoundException randomizerClient) {
            }
            catch (Throwable t) {
                CobblemonBattleInfoClient.debug("[BattleInfoPanel] Error checking randomizer types: {}", t.getMessage());
            }
        }
        if ((displayTypes = TypeIconRenderer.getDisplayTypes(battlePokemon, pokemonName, "opponent", pokemonUUID)) == null) {
            return types;
        }
        if (!displayTypes.isEmpty()) {
            for (ElementalType type : displayTypes) {
                types.add(type.getName().toLowerCase());
            }
            return types;
        }
        try {
            Method getTypes = battlePokemon.getClass().getMethod("getTypes", new Class[0]);
            Object typesObj = getTypes.invoke(battlePokemon, new Object[0]);
            if (typesObj instanceof Iterable) {
                for (Object type : (Iterable)typesObj) {
                    if (!(type instanceof ElementalType)) continue;
                    types.add(((ElementalType)type).getName().toLowerCase());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return types;
    }

    private static float calculateEffectiveness(String attackType, List<String> defenderTypes) {
        if (defenderTypes.isEmpty()) {
            return 1.0f;
        }
        String defenderType1 = defenderTypes.get(0);
        String defenderType2 = defenderTypes.size() > 1 ? defenderTypes.get(1) : null;
        return TypeChart.getEffectivenessAgainstTypes(attackType, defenderType1, defenderType2);
    }

    private static void renderTypeIcon(class_332 gui, int x, int y, String type, float alpha) {
        int typeIndex = BattleInfoPanelRenderer.getTypeIndex(type);
        if (typeIndex < 0) {
            return;
        }
        int u = typeIndex * 36;
        boolean v = false;
        gui.method_51452();
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gui.method_25293(TYPE_SPRITE_SHEET, x, y, 10, 10, (float)u, (float)v, 36, 36, 648, 36);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.method_51448().method_22909();
        gui.method_51452();
    }

    private static void renderTypeIconScaled(class_332 gui, int x, int y, String type, float alpha, int displaySize) {
        int typeIndex = BattleInfoPanelRenderer.getTypeIndex(type);
        if (typeIndex < 0) {
            return;
        }
        int u = typeIndex * 36;
        boolean v = false;
        gui.method_51452();
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gui.method_25293(TYPE_SPRITE_SHEET, x, y, displaySize, displaySize, (float)u, (float)v, 36, 36, 648, 36);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.method_51448().method_22909();
        gui.method_51452();
    }

    private static int getTypeIndex(String type) {
        for (int i = 0; i < TYPE_ORDER.length; ++i) {
            if (!TYPE_ORDER[i].equals(type.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    private static void drawScaledText(class_332 gui, class_310 mc, String text, int x, int y, int color, float alpha, float scale) {
        int alphaInt = (int)(alpha * 255.0f) << 24;
        int finalColor = color & 0xFFFFFF | alphaInt;
        gui.method_51448().method_22903();
        gui.method_51448().method_46416((float)x, (float)y, 0.0f);
        gui.method_51448().method_22905(scale, scale, 1.0f);
        gui.method_51433(mc.field_1772, text, 0, 0, finalColor, true);
        gui.method_51448().method_22909();
    }

    private static String truncateText(class_310 mc, String text, int maxWidth) {
        if ((float)mc.field_1772.method_1727(text) * 0.7f <= (float)maxWidth) {
            return text;
        }
        String truncated = text;
        while (truncated.length() > 0 && (float)mc.field_1772.method_1727(truncated + "...") * 0.7f > (float)maxWidth) {
            truncated = truncated.substring(0, truncated.length() - 1);
        }
        return truncated + "...";
    }

    private static void renderHeldItemSprite(class_332 gui, class_310 mc, int x, int y, String itemId, float alpha) {
        try {
            String tryId;
            class_2960 itemLocation;
            if (itemId == null || itemId.isEmpty()) {
                return;
            }
            String normalizedId = itemId.toLowerCase();
            String[] possibleIds = new String[]{normalizedId, normalizedId.replace(" ", "_"), BattleInfoPanelRenderer.convertToSnakeCase(normalizedId), BattleInfoPanelRenderer.addUnderscoreBeforeCommonSuffixes(normalizedId)};
            class_1792 item = null;
            String[] stringArray = possibleIds;
            int n = stringArray.length;
            for (int i = 0; !(i >= n || (itemLocation = class_2960.method_12829((String)("cobblemon:" + (tryId = stringArray[i])))) != null && (item = (class_1792)class_7923.field_41178.method_10223(itemLocation)) != null && item != class_1802.field_8162 || (itemLocation = class_2960.method_12829((String)("mega_showdown:" + tryId))) != null && (item = (class_1792)class_7923.field_41178.method_10223(itemLocation)) != null && item != class_1802.field_8162 || (itemLocation = class_2960.method_12829((String)("minecraft:" + tryId))) != null && (item = (class_1792)class_7923.field_41178.method_10223(itemLocation)) != null && item != class_1802.field_8162); ++i) {
            }
            if (item != null && item != class_1802.field_8162) {
                class_1799 stack = new class_1799(item);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                gui.method_51448().method_22903();
                gui.method_51448().method_46416((float)(x + 2), (float)(y + 2), 100.0f);
                float scale = 1.25f;
                gui.method_51448().method_22905(scale, scale, 1.0f);
                gui.method_51427(stack, 0, 0);
                gui.method_51448().method_22909();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String addUnderscoreBeforeCommonSuffixes(String id) {
        String[] suffixes;
        for (String suffix : suffixes = new String[]{"balloon", "incense", "powder", "stone", "juice", "candy", "scale", "mail", "sash", "orb", "berry", "herb", "seed", "band", "belt", "scarf", "lens", "vest", "clay", "rock", "gem", "plate", "card", "ball", "bell", "fang", "claw", "wing", "tail", "tooth", "horn", "petal", "dust", "root", "leaf", "coat"}) {
            if (!id.endsWith(suffix) || id.length() <= suffix.length()) continue;
            int splitPoint = id.length() - suffix.length();
            return id.substring(0, splitPoint) + "_" + suffix;
        }
        return id;
    }

    private static String convertToSnakeCase(String id) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                result.append('_');
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    private static String formatItemDisplayName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        String[] suffixes = new String[]{"sash", "orb", "berry", "herb", "seed", "band", "belt", "scarf", "lens", "vest", "clay", "rock", "gem", "plate", "card", "ball", "bell", "fang", "claw", "mail", "incense", "powder", "juice", "candy", "scale", "stone"};
        String lowerName = name.toLowerCase();
        for (String suffix : suffixes) {
            if (!lowerName.endsWith(suffix) || lowerName.length() <= suffix.length()) continue;
            int splitPoint = name.length() - suffix.length();
            String prefix = name.substring(0, splitPoint);
            String suffixPart = name.substring(splitPoint);
            prefix = BattleInfoPanelRenderer.capitalizeFirst(prefix);
            suffixPart = BattleInfoPanelRenderer.capitalizeFirst(suffixPart);
            return prefix + " " + suffixPart;
        }
        return BattleInfoPanelRenderer.capitalizeFirst(name);
    }

    private static String capitalizeFirst(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private static float easeOutCubic(float x) {
        return 1.0f - (float)Math.pow(1.0f - x, 3.0);
    }

    static {
        TYPE_COLORS.put("normal", 13026983);
        TYPE_COLORS.put("fire", 15761456);
        TYPE_COLORS.put("water", 6852848);
        TYPE_COLORS.put("electric", 16306224);
        TYPE_COLORS.put("grass", 7915600);
        TYPE_COLORS.put("ice", 0x98D8D8);
        TYPE_COLORS.put("fighting", 12595240);
        TYPE_COLORS.put("poison", 0xA040A0);
        TYPE_COLORS.put("ground", 14729320);
        TYPE_COLORS.put("flying", 11047152);
        TYPE_COLORS.put("psychic", 0xF85888);
        TYPE_COLORS.put("bug", 11057184);
        TYPE_COLORS.put("rock", 12099640);
        TYPE_COLORS.put("ghost", 7362712);
        TYPE_COLORS.put("dragon", 7354616);
        TYPE_COLORS.put("dark", 7362632);
        TYPE_COLORS.put("steel", 12105936);
        TYPE_COLORS.put("fairy", 15636908);
        TYPE_SPRITE_SHEET = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
        TYPE_ORDER = new String[]{"normal", "fire", "water", "grass", "electric", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"};
    }

    private static class PanelAnimationState {
        boolean isHovered = false;
        long hoverStartTime = 0L;
        long hoverEndTime = 0L;

        private PanelAnimationState() {
        }

        float getSlideProgress() {
            long now = System.currentTimeMillis();
            if (this.isHovered) {
                if (this.hoverStartTime == 0L) {
                    return 0.0f;
                }
                float progress = (float)(now - this.hoverStartTime) / 300.0f;
                return Math.min(1.0f, progress);
            }
            if (this.hoverEndTime == 0L) {
                return 0.0f;
            }
            float progress = 1.0f - (float)(now - this.hoverEndTime) / 300.0f;
            return Math.max(0.0f, progress);
        }

        void setHovered(boolean hovered) {
            if (hovered && !this.isHovered) {
                this.hoverStartTime = System.currentTimeMillis();
            } else if (!hovered && this.isHovered) {
                this.hoverEndTime = System.currentTimeMillis();
            }
            this.isHovered = hovered;
        }
    }
}

