/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import name.modid.CobblemonBattleInfoClient;
import name.modid.platform.Services;

public class BattleExtrasConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "cobblemon-battle-extras.json";
    private static BattleExtrasConfig INSTANCE;
    public boolean enableDebugLogging = false;
    public boolean enableTypeIcons = true;
    public boolean enableStatStages = true;
    public boolean enableAbilityPopups = true;
    public float abilityPopupDuration = 3.0f;
    public boolean abilityPopupCentered = false;
    public boolean enableWeatherTerrain = true;
    public boolean enableEntryHazards = true;
    public boolean enableControllerNavigation = true;
    public boolean enableAutoExpandLog = true;
    public boolean enableBattleNameplates = true;
    public int nameplateStyle = 0;
    public float battleNameplateOpacity = 1.0f;
    public float battleNameplateBrightness = 0.5f;
    public boolean enableScreensDisplay = true;
    public boolean enableVolatileStatusIcons = true;
    public boolean enableMoveTooltips = true;
    public boolean enableSwitchTooltips = true;
    public boolean enableInstantNPCForfeit = false;
    public boolean enableBattleLogChatMessages = true;
    public boolean enableInstantWildRun = true;
    public boolean enableTurnCounter = true;
    public boolean enablePokemonCount = true;
    public boolean hideOpponentPokeballTypes = false;
    public boolean enableBButtonReenterBattle = true;
    public int battleBackKey = 340;
    public float battleAnimationSpeed = 1.0f;
    public boolean enableWeaknessTooltip = true;
    public boolean enableBattleLogColoring = true;
    public boolean enableBattleLogRecording = false;
    public boolean enableSpeedRange = true;
    public boolean hideBattleTiles = false;
    public boolean enableXPGainedDisplay = true;
    public boolean useEnhancedBattleLogStyle = true;
    public boolean enableBattleInfoPanel = true;
    public boolean battleLogCustomPosition = false;
    public int battleLogX = -1;
    public int battleLogY = -1;
    public float battleLogScale = 1.0f;
    public int battleLogWidth = 180;
    public int battleLogHeight = 120;
    public boolean battleLogExpanded = true;
    public float battleLogFontScale = 0.9f;

    public static BattleExtrasConfig get() {
        if (INSTANCE == null) {
            BattleExtrasConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        File configFile = BattleExtrasConfig.getConfigFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                INSTANCE = (BattleExtrasConfig)GSON.fromJson((Reader)reader, BattleExtrasConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new BattleExtrasConfig();
                }
                CobblemonBattleInfoClient.debug("Loaded config from {}", configFile.getAbsolutePath());
            }
            catch (IOException e) {
                CobblemonBattleInfoClient.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
                INSTANCE = new BattleExtrasConfig();
            }
        } else {
            INSTANCE = new BattleExtrasConfig();
            BattleExtrasConfig.save();
        }
    }

    public static void save() {
        if (INSTANCE == null) {
            INSTANCE = new BattleExtrasConfig();
        }
        File configFile = BattleExtrasConfig.getConfigFile();
        try {
            configFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
                CobblemonBattleInfoClient.debug("Saved config to {}", configFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            CobblemonBattleInfoClient.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private static File getConfigFile() {
        return Services.PLATFORM.getConfigDir().resolve(CONFIG_FILE).toFile();
    }

    public static boolean isTypeIconsEnabled() {
        return BattleExtrasConfig.get().enableTypeIcons;
    }

    public static boolean isStatStagesEnabled() {
        return BattleExtrasConfig.get().enableStatStages;
    }

    public static boolean isSpeedRangeEnabled() {
        return BattleExtrasConfig.get().enableSpeedRange;
    }

    public static boolean isHideBattleTilesEnabled() {
        return BattleExtrasConfig.get().hideBattleTiles;
    }

    public static boolean isAbilityPopupsEnabled() {
        return BattleExtrasConfig.get().enableAbilityPopups;
    }

    public static float getAbilityPopupDurationSeconds() {
        float seconds = BattleExtrasConfig.get().abilityPopupDuration;
        if (Float.isNaN(seconds)) {
            return 3.0f;
        }
        return Math.max(1.0f, Math.min(15.0f, seconds));
    }

    public static boolean isAbilityPopupCentered() {
        return BattleExtrasConfig.get().abilityPopupCentered;
    }

    public static boolean isWeatherTerrainEnabled() {
        return BattleExtrasConfig.get().enableWeatherTerrain;
    }

    public static boolean isEntryHazardsEnabled() {
        return BattleExtrasConfig.get().enableEntryHazards;
    }

    public static boolean isControllerNavigationEnabled() {
        return BattleExtrasConfig.get().enableControllerNavigation;
    }

    public static boolean isAutoExpandLogEnabled() {
        return BattleExtrasConfig.get().enableAutoExpandLog;
    }

    public static boolean isSelectionHighlightEnabled() {
        return true;
    }

    public static boolean isBattleNameplatesEnabled() {
        return BattleExtrasConfig.get().enableBattleNameplates;
    }

    public static boolean useAlternativeNameplateStyle() {
        return BattleExtrasConfig.get().nameplateStyle == 1;
    }

    public static boolean useSimplifiedNameplateStyle() {
        return BattleExtrasConfig.get().nameplateStyle == 2;
    }

    public static int getNameplateStyle() {
        int style = BattleExtrasConfig.get().nameplateStyle;
        return Math.max(0, Math.min(2, style));
    }

    public static void cycleNameplateStyle() {
        BattleExtrasConfig.get().nameplateStyle = (BattleExtrasConfig.get().nameplateStyle + 1) % 3;
    }

    public static float getBattleNameplateOpacity() {
        float v = BattleExtrasConfig.get().battleNameplateOpacity;
        if (Float.isNaN(v)) {
            return 1.0f;
        }
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    public static float getBattleNameplateBrightness() {
        float v = BattleExtrasConfig.get().battleNameplateBrightness;
        if (Float.isNaN(v)) {
            return 1.0f;
        }
        v = Math.max(0.0f, Math.min(1.0f, v));
        return v * 2.0f;
    }

    public static boolean isScreensDisplayEnabled() {
        return BattleExtrasConfig.get().enableScreensDisplay;
    }

    public static boolean isVolatileStatusIconsEnabled() {
        return BattleExtrasConfig.get().enableVolatileStatusIcons;
    }

    public static boolean isMoveTooltipsEnabled() {
        return BattleExtrasConfig.get().enableMoveTooltips;
    }

    public static boolean isVanillaStyleMoveTooltipsEnabled() {
        return false;
    }

    public static boolean isSwitchTooltipsEnabled() {
        return BattleExtrasConfig.get().enableSwitchTooltips;
    }

    public static boolean isInstantNPCForfeitEnabled() {
        return BattleExtrasConfig.get().enableInstantNPCForfeit;
    }

    public static boolean isBattleLogChatMessagesEnabled() {
        return BattleExtrasConfig.get().enableBattleLogChatMessages;
    }

    public static boolean isInstantWildRunEnabled() {
        return BattleExtrasConfig.get().enableInstantWildRun;
    }

    public static boolean isTurnCounterEnabled() {
        return BattleExtrasConfig.get().enableTurnCounter;
    }

    public static boolean isPokemonCountEnabled() {
        return BattleExtrasConfig.get().enablePokemonCount;
    }

    public static boolean hideOpponentPokeballTypes() {
        return BattleExtrasConfig.get().hideOpponentPokeballTypes;
    }

    public static boolean isBButtonReenterBattleEnabled() {
        return BattleExtrasConfig.get().enableBButtonReenterBattle;
    }

    public static int getBattleBackKey() {
        return BattleExtrasConfig.get().battleBackKey;
    }

    public static void setBattleBackKey(int keyCode) {
        BattleExtrasConfig.get().battleBackKey = keyCode;
        BattleExtrasConfig.save();
    }

    public static float getBattleAnimationSpeed() {
        float speed = BattleExtrasConfig.get().battleAnimationSpeed;
        if (Float.isNaN(speed)) {
            return 1.0f;
        }
        return Math.max(1.0f, Math.min(4.0f, speed));
    }

    public static boolean isWeaknessTooltipEnabled() {
        return BattleExtrasConfig.get().enableWeaknessTooltip;
    }

    public static boolean isBattleLogColoringEnabled() {
        return BattleExtrasConfig.get().enableBattleLogColoring;
    }

    public static boolean isBattleLogRecordingEnabled() {
        return BattleExtrasConfig.get().enableBattleLogRecording;
    }

    public static boolean isXPGainedDisplayEnabled() {
        return BattleExtrasConfig.get().enableXPGainedDisplay;
    }

    public static boolean isBattleLogCustomPosition() {
        return BattleExtrasConfig.get().battleLogCustomPosition;
    }

    public static int getBattleLogX() {
        return BattleExtrasConfig.get().battleLogX;
    }

    public static int getBattleLogY() {
        return BattleExtrasConfig.get().battleLogY;
    }

    public static void setBattleLogPosition(int x, int y) {
        BattleExtrasConfig.get().battleLogCustomPosition = true;
        BattleExtrasConfig.get().battleLogX = x;
        BattleExtrasConfig.get().battleLogY = y;
        BattleExtrasConfig.save();
    }

    public static void resetBattleLogPosition() {
        BattleExtrasConfig.get().battleLogCustomPosition = false;
        BattleExtrasConfig.get().battleLogX = -1;
        BattleExtrasConfig.get().battleLogY = -1;
        BattleExtrasConfig.save();
    }

    public static float getBattleLogScale() {
        float scale = BattleExtrasConfig.get().battleLogScale;
        return Math.max(0.5f, Math.min(2.0f, scale));
    }

    public static void setBattleLogScale(float scale) {
        BattleExtrasConfig.get().battleLogScale = Math.max(0.5f, Math.min(2.0f, scale));
        BattleExtrasConfig.save();
    }

    public static boolean useEnhancedBattleLogStyle() {
        return BattleExtrasConfig.get().useEnhancedBattleLogStyle;
    }

    public static int getBattleLogWidth() {
        return BattleExtrasConfig.get().battleLogWidth;
    }

    public static int getBattleLogHeight() {
        return BattleExtrasConfig.get().battleLogHeight;
    }

    public static boolean isBattleLogExpanded() {
        return BattleExtrasConfig.get().battleLogExpanded;
    }

    public static void setBattleLogSize(int width, int height) {
        BattleExtrasConfig.get().battleLogWidth = width;
        BattleExtrasConfig.get().battleLogHeight = height;
        BattleExtrasConfig.save();
    }

    public static void setBattleLogExpanded(boolean expanded) {
        BattleExtrasConfig.get().battleLogExpanded = expanded;
        BattleExtrasConfig.save();
    }

    public static float getBattleLogFontScale() {
        float scale = BattleExtrasConfig.get().battleLogFontScale;
        return Math.max(0.5f, Math.min(2.0f, scale));
    }

    public static void adjustBattleLogFontScale(float delta) {
        float current = BattleExtrasConfig.getBattleLogFontScale();
        BattleExtrasConfig.get().battleLogFontScale = Math.max(0.5f, Math.min(2.0f, current + delta));
    }

    public static boolean isDebugLoggingEnabled() {
        return BattleExtrasConfig.get().enableDebugLogging;
    }

    public static boolean isBattleInfoPanelEnabled() {
        return BattleExtrasConfig.get().enableBattleInfoPanel;
    }
}

