/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleSideHelper;
import name.modid.client.TypeIconRenderer;
import name.modid.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BattleEntityOverlayRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleEntityOverlayRenderer");
    private static final class_2960 BATTLE_INFO_BASE = class_2960.method_60654((String)"cobblemon:textures/gui/battle/battle_info_base.png");
    private static final class_2960 BATTLE_INFO_BASE_FLIPPED = class_2960.method_60654((String)"cobblemon:textures/gui/battle/battle_info_base_flipped.png");
    private static final class_2960 ALTERNATIVE_BATTLE_INFO_BASE = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/battle_info_base_alternative.png");
    private static final class_2960 ALTERNATIVE_BATTLE_INFO_BASE_FLIPPED = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/battle_info_base_alternative_flipped.png");
    private static final class_2960 SIMPLIFIED_BATTLE_INFO_BASE = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/battle_info_healthbar.png");
    private static final class_2960 SIMPLIFIED_BATTLE_INFO_BASE_FLIPPED = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/battle_info_healthbar_flipped.png");
    private static final class_2960 TYPE_SPRITE_SHEET = class_2960.method_60654((String)"cobblemon:textures/gui/types.png");
    private static final String MEGA_SHOWDOWN_TERA_PATH = "mega_showdown:textures/gui/summary/tera_types/";
    private static final int TERA_ICON_SIZE = 32;
    private static final boolean MEGA_SHOWDOWN_LOADED = Services.PLATFORM.isModLoaded("mega_showdown");
    private static final class_2960 MEGA_ICON = class_2960.method_60654((String)"cobblemon-battle-extras:textures/gui/mega_icon.png");
    private static final int MEGA_ICON_SIZE = 64;
    private static final int MEGA_ICON_DISPLAY_SIZE = 6;
    private static float MEGA_ICON_OFFSET_X_PLAYER_OVERLAY = -27.0f;
    private static float MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY = -16.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY = 27.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY = -16.0f;
    private static float MEGA_ICON_OFFSET_X_PLAYER_OVERLAY_SINGLE = -12.0f;
    private static float MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY_SINGLE = -17.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY_SINGLE = 98.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY_SINGLE = -17.0f;
    private static float MEGA_ICON_OFFSET_X_PLAYER_ALT = -32.0f;
    private static float MEGA_ICON_OFFSET_Y_PLAYER_ALT = -21.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_ALT = -100.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_ALT = -21.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_ALT_SINGLE = -114.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_ALT_SINGLE = -21.0f;
    private static final int TEXTURE_WIDTH = 140;
    private static final int TEXTURE_HEIGHT = 40;
    private static final int TYPE_ICON_SIZE = 36;
    private static final int TYPE_SHEET_WIDTH = 648;
    private static final int TYPE_DISPLAY_SIZE = 12;
    private static final float SCALE = 0.012f;
    private static final float HEIGHT_ABOVE_BASE = 0.5f;
    private static final float HEIGHT_SCALE_MULTIPLIER = 0.15f;
    private static final int LIGHT = 0xF000F0;
    private static final float HP_BAR_X_START_PLAYER = 38.0f;
    private static final float HP_BAR_X_START_OPPONENT = 3.0f;
    private static final float HP_BAR_MAX_WIDTH_PLAYER = 99.0f;
    private static final float HP_BAR_MAX_WIDTH_OPPONENT = 99.0f;
    private static final float HP_BAR_Y = 24.0f;
    private static final float HP_BAR_HEIGHT = 4.0f;
    private static final float ALT_HP_BAR_X_START_PLAYER = 2.0f;
    private static final float ALT_HP_BAR_X_START_OPPONENT = 6.0f;
    private static final float ALT_HP_BAR_MAX_WIDTH_PLAYER = 132.0f;
    private static final float ALT_HP_BAR_MAX_WIDTH_OPPONENT = 132.0f;
    private static final float SIMPLIFIED_HP_BAR_X_START_PLAYER = 2.0f;
    private static final float SIMPLIFIED_HP_BAR_X_START_OPPONENT = 6.0f;
    private static final float SIMPLIFIED_HP_BAR_MAX_WIDTH_PLAYER = 132.0f;
    private static final float SIMPLIFIED_HP_BAR_MAX_WIDTH_OPPONENT = 132.0f;
    private static final float SIMPLIFIED_HP_BAR_Y = 24.0f;
    private static final float SIMPLIFIED_HP_BAR_HEIGHT = 4.0f;
    private static final float PORTRAIT_X = 3.0f;
    private static final float PORTRAIT_Y = 3.0f;
    private static final float PORTRAIT_SIZE = 32.0f;
    private static final float ALT_NAME_X_PLAYER = 6.0f;
    private static final float ALT_NAME_X_OPPONENT = 10.0f;
    private static final float ALT_NAME_Y = 12.0f;
    private static final float ALT_LEVEL_RIGHT_PADDING_PLAYER = 10.0f;
    private static final float ALT_LEVEL_RIGHT_PADDING_OPPONENT = 6.0f;
    private static final float ALT_GENDER_SPACING = 2.0f;
    private static final float ALT_TYPE_ICON_PADDING_X = 3.0f;
    private static final float ALT_TYPE_ICON_Y = -10.0f;

    public static void renderBattleOverlay(class_1297 entity, class_4587 poseStack, class_4597 buffers, class_4184 camera, float partialTicks, double x, double y, double z) {
        if (entity == null || !entity.getClass().getName().contains("PokemonEntity")) {
            return;
        }
        if (!BattleExtrasConfig.isBattleNameplatesEnabled()) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        try {
            boolean useAltPositioning;
            String pokemonName;
            double dz;
            double dy;
            Method getBattleIdMethod = entity.getClass().getMethod("getBattleId", new Class[0]);
            UUID pokemonBattleId = (UUID)getBattleIdMethod.invoke((Object)entity, new Object[0]);
            UUID battleId = battle.getBattleId();
            if (battleId == null || pokemonBattleId == null || !battleId.equals(pokemonBattleId)) {
                return;
            }
            class_1297 cameraEntity = camera.method_19331();
            if (cameraEntity == null) {
                return;
            }
            double dx = entity.method_23317() - cameraEntity.method_23317();
            double distSq = dx * dx + (dy = entity.method_23318() - cameraEntity.method_23318()) * dy + (dz = entity.method_23321() - cameraEntity.method_23321()) * dz;
            if (distSq > 4096.0) {
                return;
            }
            Method getPokemonMethod = entity.getClass().getMethod("getPokemon", new Class[0]);
            Object pokemonData = getPokemonMethod.invoke((Object)entity, new Object[0]);
            Method getSpeciesMethod = pokemonData.getClass().getMethod("getSpecies", new Class[0]);
            Object species = getSpeciesMethod.invoke(pokemonData, new Object[0]);
            Method getNameMethod = species.getClass().getMethod("getName", new Class[0]);
            String displayName = pokemonName = (String)getNameMethod.invoke(species, new Object[0]);
            try {
                Method getTranslatedNameMethod = species.getClass().getMethod("getTranslatedName", new Class[0]);
                Object nameComponent = getTranslatedNameMethod.invoke(species, new Object[0]);
                if (nameComponent != null) {
                    displayName = nameComponent.getClass().getMethod("getString", new Class[0]).invoke(nameComponent, new Object[0]).toString();
                }
            }
            catch (Exception getTranslatedNameMethod) {
                // empty catch block
            }
            Method getLevelMethod = pokemonData.getClass().getMethod("getLevel", new Class[0]);
            int level = (Integer)getLevelMethod.invoke(pokemonData, new Object[0]);
            class_310 mc = class_310.method_1551();
            UUID playerUUID = mc.field_1724 != null ? mc.field_1724.method_5667() : null;
            UUID entityUUID = entity.method_5667();
            UUID pokemonUUID = null;
            try {
                Method getUuidMethod = pokemonData.getClass().getMethod("getUuid", new Class[0]);
                pokemonUUID = (UUID)getUuidMethod.invoke(pokemonData, new Object[0]);
            }
            catch (Exception getUuidMethod) {
                // empty catch block
            }
            boolean isPlayerPokemon = BattleEntityOverlayRenderer.isPlayerPokemonByPokemonUUID(battle, pokemonUUID, pokemonName);
            String side = isPlayerPokemon ? "player" : "opponent";
            List<ElementalType> types = TypeIconRenderer.getDisplayTypes(pokemonData, pokemonName, side, pokemonUUID != null ? pokemonUUID.toString() : null);
            if (types == null || types.isEmpty()) {
                types = BattleEntityOverlayRenderer.getTypesFromPokemon(pokemonData);
            }
            if (types == null || types.isEmpty()) {
                types = BattleEntityOverlayRenderer.getTypesFromSpecies(species);
            }
            float healthPercent = BattleEntityOverlayRenderer.getHealthPercentFromBattle(battle, pokemonName, isPlayerPokemon);
            String gender = BattleEntityOverlayRenderer.getGenderFromBattle(battle, pokemonName, isPlayerPokemon);
            float entityHeight = (float)entity.method_5829().method_17940();
            float heightOffset = 0.5f + entityHeight * 0.15f;
            poseStack.method_22903();
            poseStack.method_22904(x, y + (double)entityHeight + (double)heightOffset, z);
            poseStack.method_22907(camera.method_23767());
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            poseStack.method_22905(-0.012f, -0.012f, 0.012f);
            BattleEntityOverlayRenderer.renderBattleInfoPlate(poseStack, isPlayerPokemon);
            int nameplateStyle = BattleExtrasConfig.getNameplateStyle();
            boolean bl = useAltPositioning = nameplateStyle != 0;
            if (nameplateStyle == 0) {
                BattleEntityOverlayRenderer.renderPortrait(poseStack, buffers, entity, isPlayerPokemon, partialTicks, camera);
            }
            BattleEntityOverlayRenderer.renderHPBar(poseStack, healthPercent, isPlayerPokemon, nameplateStyle);
            BattleEntityOverlayRenderer.renderNameAndLevel(poseStack, buffers, mc.field_1772, displayName, level, isPlayerPokemon, gender, nameplateStyle);
            BattleEntityOverlayRenderer.renderSpeedRange(poseStack, buffers, mc.field_1772, pokemonData, level, isPlayerPokemon, pokemonName, nameplateStyle);
            String status = BattleEntityOverlayRenderer.getStatusFromBattle(battle, pokemonName, isPlayerPokemon);
            if (status != null) {
                BattleEntityOverlayRenderer.renderStatus(poseStack, buffers, mc.field_1772, status, isPlayerPokemon, nameplateStyle);
            }
            BattleEntityOverlayRenderer.renderTypeIcons(poseStack, types, isPlayerPokemon, pokemonName, nameplateStyle);
            String lowerPokemonName = pokemonName != null ? pokemonName.toLowerCase() : null;
            boolean isMegaEvolved = BattleMessageSubscriber.isMegaEvolved(lowerPokemonName);
            String currentFormName = null;
            try {
                Method getFormMethod = pokemonData.getClass().getMethod("getForm", new Class[0]);
                Object form = getFormMethod.invoke(pokemonData, new Object[0]);
                if (form != null) {
                    Method formNameMethod = form.getClass().getMethod("getName", new Class[0]);
                    currentFormName = (String)formNameMethod.invoke(form, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isMegaEvolved && currentFormName != null && currentFormName.toLowerCase().contains("mega")) {
                isMegaEvolved = true;
            }
            if (isMegaEvolved && types != null && !types.isEmpty()) {
                BattleEntityOverlayRenderer.renderMegaIcon(poseStack, isPlayerPokemon, types.size(), useAltPositioning);
            }
            poseStack.method_22909();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderBattleInfoPlate(class_4587 poseStack, boolean isPlayer) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        float alpha = BattleExtrasConfig.getBattleNameplateOpacity();
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        int nameplateStyle = BattleExtrasConfig.getNameplateStyle();
        class_2960 plateTexture = nameplateStyle == 2 ? (isPlayer ? SIMPLIFIED_BATTLE_INFO_BASE : SIMPLIFIED_BATTLE_INFO_BASE_FLIPPED) : (nameplateStyle == 1 ? (isPlayer ? ALTERNATIVE_BATTLE_INFO_BASE : ALTERNATIVE_BATTLE_INFO_BASE_FLIPPED) : (isPlayer ? BATTLE_INFO_BASE : BATTLE_INFO_BASE_FLIPPED));
        RenderSystem.setShaderTexture((int)0, (class_2960)plateTexture);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float halfWidth = 70.0f;
        float halfHeight = 20.0f;
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(matrix, -halfWidth, -halfHeight, 0.0f).method_22913(0.0f, 0.0f);
        buffer.method_22918(matrix, -halfWidth, halfHeight, 0.0f).method_22913(0.0f, 1.0f);
        buffer.method_22918(matrix, halfWidth, halfHeight, 0.0f).method_22913(1.0f, 1.0f);
        buffer.method_22918(matrix, halfWidth, -halfHeight, 0.0f).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    private static void renderPortrait(class_4587 poseStack, class_4597 buffers, class_1297 entity, boolean isPlayer, float partialTicks, class_4184 camera) {
        class_1309 living;
        class_310 mc = class_310.method_1551();
        float portCenterX = isPlayer ? -51.0f : 51.0f;
        float portCenterY = -1.0f;
        float entityHeight = (float)entity.method_5829().method_17940();
        float entityWidth = (float)entity.method_5829().method_17939();
        float maxDimension = Math.max(entityHeight, entityWidth);
        float scale = 16.8f / maxDimension;
        float savedYRot = entity.method_36454();
        float savedYRotO = entity.field_5982;
        float savedXRot = entity.method_36455();
        float savedXRotO = entity.field_6004;
        float savedYHeadRot = 0.0f;
        float savedYHeadRotO = 0.0f;
        float savedYBodyRot = 0.0f;
        float savedYBodyRotO = 0.0f;
        if (entity instanceof class_1309) {
            living = (class_1309)entity;
            savedYHeadRot = living.field_6241;
            savedYHeadRotO = living.field_6259;
            savedYBodyRot = living.field_6283;
            savedYBodyRotO = living.field_6220;
        }
        entity.method_36456(0.0f);
        entity.field_5982 = 0.0f;
        entity.method_36457(0.0f);
        entity.field_6004 = 0.0f;
        if (entity instanceof class_1309) {
            living = (class_1309)entity;
            living.field_6241 = 0.0f;
            living.field_6259 = 0.0f;
            living.field_6283 = 0.0f;
            living.field_6220 = 0.0f;
        }
        poseStack.method_22903();
        poseStack.method_46416(portCenterX, portCenterY + 9.6f, 0.01f);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        poseStack.method_22905(scale, scale, scale);
        try {
            class_898 dispatcher = mc.method_1561();
            dispatcher.method_3948(false);
            dispatcher.method_3954(entity, 0.0, 0.0, 0.0, 180.0f, 0.0f, poseStack, buffers, 0xF000F0);
            dispatcher.method_3948(true);
        }
        catch (Exception dispatcher) {
            // empty catch block
        }
        poseStack.method_22909();
        entity.method_36456(savedYRot);
        entity.field_5982 = savedYRotO;
        entity.method_36457(savedXRot);
        entity.field_6004 = savedXRotO;
        if (entity instanceof class_1309) {
            living = (class_1309)entity;
            living.field_6241 = savedYHeadRot;
            living.field_6259 = savedYHeadRotO;
            living.field_6283 = savedYBodyRot;
            living.field_6220 = savedYBodyRotO;
        }
    }

    private static void renderHPBar(class_4587 poseStack, float healthPercent, boolean isPlayer, int nameplateStyle) {
        int b;
        int g;
        int r;
        float barRight;
        float barTop;
        float barLeft;
        float hpBarY;
        float maxWidthOpponent;
        float maxWidthPlayer;
        float xStartOpponent;
        float xStartPlayer;
        healthPercent = Math.max(0.0f, Math.min(1.0f, healthPercent));
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float hpBarHeight = 4.0f;
        if (nameplateStyle == 2) {
            xStartPlayer = 2.0f;
            xStartOpponent = 6.0f;
            maxWidthPlayer = 132.0f;
            maxWidthOpponent = 132.0f;
            hpBarY = 24.0f;
            hpBarHeight = 4.0f;
        } else if (nameplateStyle == 1) {
            xStartPlayer = 2.0f;
            xStartOpponent = 6.0f;
            maxWidthPlayer = 132.0f;
            maxWidthOpponent = 132.0f;
            hpBarY = 24.0f;
        } else {
            xStartPlayer = 38.0f;
            xStartOpponent = 3.0f;
            maxWidthPlayer = 99.0f;
            maxWidthOpponent = 99.0f;
            hpBarY = 24.0f;
        }
        if (isPlayer) {
            barLeft = -70.0f + xStartPlayer;
            barTop = -20.0f + hpBarY - 2.0f;
            float barMaxWidth = maxWidthPlayer;
            barRight = barLeft + barMaxWidth * healthPercent;
        } else {
            barRight = -70.0f + xStartOpponent + maxWidthOpponent;
            barTop = -20.0f + hpBarY - 2.0f;
            float barMaxWidth = maxWidthOpponent;
            barLeft = barRight - barMaxWidth * healthPercent;
        }
        if (healthPercent > 0.5f) {
            r = 100;
            g = 220;
            b = 100;
        } else if (healthPercent > 0.2f) {
            r = 255;
            g = 200;
            b = 50;
        } else {
            r = 230;
            g = 70;
            b = 70;
        }
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        r = (int)Math.min(255.0f, (float)r * brightness);
        g = (int)Math.min(255.0f, (float)g * brightness);
        b = (int)Math.min(255.0f, (float)b * brightness);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, barLeft, barTop, 0.01f).method_1336(r, g, b, 255);
        buffer.method_22918(matrix, barLeft, barTop + hpBarHeight, 0.01f).method_1336(r, g, b, 255);
        buffer.method_22918(matrix, barRight, barTop + hpBarHeight, 0.01f).method_1336(r, g, b, 255);
        buffer.method_22918(matrix, barRight, barTop, 0.01f).method_1336(r, g, b, 255);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static void renderNameAndLevel(class_4587 poseStack, class_4597 buffers, class_327 font, String name, int level, boolean isPlayer, String gender, int nameplateStyle) {
        float levelX;
        String levelText;
        float genderX;
        float nameX;
        float nameY;
        class_310 mc = class_310.method_1551();
        float textZOffset = 0.1f;
        if (nameplateStyle == 2 || nameplateStyle == 1) {
            nameY = -8.0f;
            if (isPlayer) {
                nameX = -64.0f;
                nameWidth = font.method_1727(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.method_1727(levelText);
                levelX = 60.0f - (float)levelWidth * 0.7f;
            } else {
                nameX = -60.0f;
                nameWidth = font.method_1727(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.method_1727(levelText);
                levelX = 64.0f - (float)levelWidth * 0.7f;
            }
        } else {
            nameY = -8.0f;
            if (isPlayer) {
                nameX = -30.0f;
                nameWidth = font.method_1727(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.method_1727(levelText);
                levelX = 60.0f - (float)levelWidth * 0.7f;
            } else {
                nameX = -60.0f;
                nameWidth = font.method_1727(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.method_1727(levelText);
                levelX = 25.0f - (float)levelWidth * 0.7f;
            }
        }
        class_4597.class_4598 immediateBuffer = mc.method_22940().method_23000();
        poseStack.method_22903();
        poseStack.method_46416(nameX, nameY, textZOffset);
        poseStack.method_22905(0.8f, 0.8f, 0.8f);
        font.method_27521(name, 0.0f, 0.0f, -1, false, poseStack.method_23760().method_23761(), (class_4597)immediateBuffer, class_327.class_6415.field_33994, 0, 0xF000F0);
        poseStack.method_22909();
        if (gender != null && !gender.isEmpty()) {
            int genderColor;
            String genderSymbol;
            if (gender.equalsIgnoreCase("MALE")) {
                genderSymbol = "\u2642";
                genderColor = -9924368;
            } else if (gender.equalsIgnoreCase("FEMALE")) {
                genderSymbol = "\u2640";
                genderColor = -1140308;
            } else {
                genderSymbol = null;
                genderColor = 0;
            }
            if (genderSymbol != null) {
                poseStack.method_22903();
                poseStack.method_46416(genderX, nameY, textZOffset);
                poseStack.method_22905(0.8f, 0.8f, 0.8f);
                font.method_27521(genderSymbol, 0.0f, 0.0f, genderColor, false, poseStack.method_23760().method_23761(), (class_4597)immediateBuffer, class_327.class_6415.field_33994, 0, 0xF000F0);
                poseStack.method_22909();
            }
        }
        levelText = "Lv." + level;
        float levelY = nameY;
        poseStack.method_22903();
        poseStack.method_46416(levelX, levelY, textZOffset);
        poseStack.method_22905(0.7f, 0.7f, 0.7f);
        font.method_27521(levelText, 0.0f, 0.0f, -11141291, false, poseStack.method_23760().method_23761(), (class_4597)immediateBuffer, class_327.class_6415.field_33994, 0, 0xF000F0);
        poseStack.method_22909();
        immediateBuffer.method_22993();
    }

    private static void renderTypeIcons(class_4587 poseStack, List<ElementalType> types, boolean isPlayer, String pokemonName, int nameplateStyle) {
        float y;
        float paddingX;
        if (types == null || types.isEmpty()) {
            return;
        }
        boolean isTerastallized = BattleMessageSubscriber.isTerastallized(pokemonName);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float totalWidth = types.size() * 12 + (types.size() - 1) * 2;
        if (nameplateStyle == 2 || nameplateStyle == 1) {
            paddingX = 3.0f;
            y = 10.0f;
        } else {
            paddingX = 3.0f;
            y = 23.0f;
        }
        float startX = isPlayer ? -70.0f + paddingX : 70.0f - totalWidth - paddingX;
        float offsetX = 0.0f;
        for (ElementalType type : types) {
            float iconX = startX + offsetX;
            if (isTerastallized && MEGA_SHOWDOWN_LOADED) {
                String typeName = type.getName().toLowerCase();
                class_2960 teraIcon = class_2960.method_60654((String)(MEGA_SHOWDOWN_TERA_PATH + typeName + ".png"));
                RenderSystem.setShaderTexture((int)0, (class_2960)teraIcon);
                class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                buffer.method_22918(matrix, iconX, y, 0.001f).method_22913(0.0f, 0.0f);
                buffer.method_22918(matrix, iconX, y + 12.0f, 0.001f).method_22913(0.0f, 1.0f);
                buffer.method_22918(matrix, iconX + 12.0f, y + 12.0f, 0.001f).method_22913(1.0f, 1.0f);
                buffer.method_22918(matrix, iconX + 12.0f, y, 0.001f).method_22913(1.0f, 0.0f);
                class_286.method_43433((class_9801)buffer.method_60800());
            } else {
                RenderSystem.setShaderTexture((int)0, (class_2960)TYPE_SPRITE_SHEET);
                int textureX = type.getTextureXMultiplier() * 36;
                float u0 = (float)textureX / 648.0f;
                float u1 = (float)(textureX + 36) / 648.0f;
                class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                buffer.method_22918(matrix, iconX, y, 0.001f).method_22913(u0, 0.0f);
                buffer.method_22918(matrix, iconX, y + 12.0f, 0.001f).method_22913(u0, 1.0f);
                buffer.method_22918(matrix, iconX + 12.0f, y + 12.0f, 0.001f).method_22913(u1, 1.0f);
                buffer.method_22918(matrix, iconX + 12.0f, y, 0.001f).method_22913(u1, 0.0f);
                class_286.method_43433((class_9801)buffer.method_60800());
            }
            offsetX += 14.0f;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static List<ElementalType> getTypesFromSpecies(Object species) {
        ArrayList<ElementalType> types = new ArrayList<ElementalType>();
        try {
            Method getTypesMethod = species.getClass().getMethod("getTypes", new Class[0]);
            Iterable typeIterable = (Iterable)getTypesMethod.invoke(species, new Object[0]);
            for (ElementalType type : typeIterable) {
                types.add(type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return types;
    }

    private static List<ElementalType> getTypesFromPokemon(Object pokemonData) {
        ArrayList<ElementalType> types = new ArrayList<ElementalType>();
        try {
            Method getFormMethod = pokemonData.getClass().getMethod("getForm", new Class[0]);
            Object form = getFormMethod.invoke(pokemonData, new Object[0]);
            if (form != null) {
                Method getTypesMethod = form.getClass().getMethod("getTypes", new Class[0]);
                Object typesObj = getTypesMethod.invoke(form, new Object[0]);
                if (typesObj instanceof Iterable) {
                    for (Object type : (Iterable)typesObj) {
                        if (!(type instanceof ElementalType)) continue;
                        types.add((ElementalType)type);
                    }
                }
                if (!types.isEmpty()) {
                    CobblemonBattleInfoClient.debug("[BattleEntityOverlayRenderer] Got {} types from Pokemon.getForm().getTypes()", types.size());
                }
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleEntityOverlayRenderer] Failed to get form types from Pokemon: {}", e.getMessage());
        }
        return types;
    }

    private static float getHealthPercentFromBattle(ClientBattle battle, String pokemonName, boolean isPlayerPokemon) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        ClientBattleSide targetSide = isPlayerPokemon ? playerSide : opponentSide;
        for (ClientBattleActor actor : targetSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                float hpValue = bp.getHpValue();
                float maxHp = bp.getMaxHp();
                float ratio = !isPlayerPokemon && hpValue <= 1.0f && maxHp > 1.0f ? hpValue : (maxHp > 0.0f ? hpValue / maxHp : 1.0f);
                return ratio;
            }
        }
        return 1.0f;
    }

    private static String getGenderFromBattle(ClientBattle battle, String pokemonName, boolean isPlayerPokemon) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        ClientBattleSide targetSide = isPlayerPokemon ? playerSide : opponentSide;
        for (ClientBattleActor actor : targetSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                try {
                    Method getGenderMethod = bp.getClass().getMethod("getGender", new Class[0]);
                    Object genderObj = getGenderMethod.invoke((Object)bp, new Object[0]);
                    if (genderObj == null) continue;
                    return genderObj.toString();
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private static String getStatusFromBattle(ClientBattle battle, String pokemonName, boolean isPlayerPokemon) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        ClientBattleSide targetSide = isPlayerPokemon ? playerSide : opponentSide;
        for (ClientBattleActor actor : targetSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                try {
                    Method getShowdownNameMethod;
                    Object showdownName;
                    Method getStatusMethod = bp.getClass().getMethod("getStatus", new Class[0]);
                    Object statusObj = getStatusMethod.invoke((Object)bp, new Object[0]);
                    if (statusObj == null || (showdownName = (getShowdownNameMethod = statusObj.getClass().getMethod("getShowdownName", new Class[0])).invoke(statusObj, new Object[0])) == null) continue;
                    return showdownName.toString();
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private static boolean isPlayerPokemonByPokemonUUID(ClientBattle battle, UUID pokemonUUID, String pokemonName) {
        UUID battlePokemonUUID;
        ClientBattlePokemon bp;
        if (pokemonUUID == null) {
            return BattleEntityOverlayRenderer.isPlayerSidePokemon(battle, pokemonName);
        }
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        for (ClientBattleActor actor : playerSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                bp = active.getBattlePokemon();
                if (bp == null || (battlePokemonUUID = bp.getUuid()) == null || !battlePokemonUUID.equals(pokemonUUID)) continue;
                return true;
            }
        }
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                bp = active.getBattlePokemon();
                if (bp == null || (battlePokemonUUID = bp.getUuid()) == null || !battlePokemonUUID.equals(pokemonUUID)) continue;
                return false;
            }
        }
        return BattleEntityOverlayRenderer.isPlayerSidePokemon(battle, pokemonName);
    }

    private static boolean isPlayerSidePokemon(ClientBattle battle, String pokemonName) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        for (ClientBattleActor actor : playerSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                CobblemonBattleInfoClient.debug("[BattleEntityOverlay] {} found on PLAYER side", pokemonName);
                return true;
            }
        }
        CobblemonBattleInfoClient.debug("[BattleEntityOverlay] {} NOT found on player side -> must be OPPONENT", pokemonName);
        return false;
    }

    private static void renderMegaIcon(class_4587 poseStack, boolean isPlayer, int typeCount, boolean useAlternativeStyle) {
        float iconX;
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (class_2960)MEGA_ICON);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float typeIconsWidth = typeCount * 12 + (typeCount - 1) * 2;
        float paddingX = useAlternativeStyle ? 3.0f : 3.0f;
        float baseY = 20.0f + (useAlternativeStyle ? -10.0f : 3.0f);
        float iconY = baseY + 3.0f;
        if (isPlayer) {
            float typeStartX = -70.0f + paddingX;
            iconX = typeStartX + typeIconsWidth + 2.0f;
        } else {
            float typeEndX = 70.0f - paddingX - typeIconsWidth;
            iconX = typeEndX - 6.0f - 2.0f;
        }
        if (typeCount == 1) {
            if (useAlternativeStyle) {
                if (isPlayer) {
                    iconX -= 18.0f;
                    iconY -= 21.0f;
                } else {
                    iconX += MEGA_ICON_OFFSET_X_OPPONENT_ALT_SINGLE;
                    iconY += MEGA_ICON_OFFSET_Y_OPPONENT_ALT_SINGLE;
                }
            } else {
                iconX += isPlayer ? MEGA_ICON_OFFSET_X_PLAYER_OVERLAY_SINGLE : MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY_SINGLE;
                iconY += isPlayer ? MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY_SINGLE : MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY_SINGLE;
            }
        } else if (typeCount == 2) {
            if (useAlternativeStyle) {
                iconX += isPlayer ? MEGA_ICON_OFFSET_X_PLAYER_ALT : MEGA_ICON_OFFSET_X_OPPONENT_ALT;
                iconY += isPlayer ? MEGA_ICON_OFFSET_Y_PLAYER_ALT : MEGA_ICON_OFFSET_Y_OPPONENT_ALT;
            } else {
                iconX += isPlayer ? MEGA_ICON_OFFSET_X_PLAYER_OVERLAY : MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY;
                iconY += isPlayer ? MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY : MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY;
            }
        }
        float iconZ = -0.1f;
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(matrix, iconX, iconY, iconZ).method_22913(0.0f, 0.0f);
        buffer.method_22918(matrix, iconX, iconY + 6.0f, iconZ).method_22913(0.0f, 1.0f);
        buffer.method_22918(matrix, iconX + 6.0f, iconY + 6.0f, iconZ).method_22913(1.0f, 1.0f);
        buffer.method_22918(matrix, iconX + 6.0f, iconY, iconZ).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderSpeedRange(class_4587 poseStack, class_4597 buffers, class_327 font, Object pokemonData, int level, boolean isPlayer, String pokemonName, int nameplateStyle) {
        if (!BattleExtrasConfig.isSpeedRangeEnabled()) {
            return;
        }
        if (!BattleExtrasConfig.isHideBattleTilesEnabled()) {
            return;
        }
        try {
            String lowerName;
            int baseSpeed;
            block20: {
                baseSpeed = 0;
                String formName = "unknown";
                if (pokemonData != null) {
                    String statName;
                    Map statsMap;
                    Object baseStats;
                    Method getBaseStats;
                    block19: {
                        try {
                            Method getFormMethod = pokemonData.getClass().getMethod("getForm", new Class[0]);
                            Object form = getFormMethod.invoke(pokemonData, new Object[0]);
                            if (form == null) break block19;
                            try {
                                Method getNameMethod = form.getClass().getMethod("getName", new Class[0]);
                                formName = (String)getNameMethod.invoke(form, new Object[0]);
                            }
                            catch (Exception getNameMethod) {
                                // empty catch block
                            }
                            getBaseStats = form.getClass().getMethod("getBaseStats", new Class[0]);
                            baseStats = getBaseStats.invoke(form, new Object[0]);
                            if (!(baseStats instanceof Map)) break block19;
                            statsMap = (Map)baseStats;
                            for (Map.Entry entry : statsMap.entrySet()) {
                                statName = entry.getKey().toString().toLowerCase();
                                if (!statName.contains("speed") && !statName.equals("spe")) continue;
                                baseSpeed = (Integer)entry.getValue();
                                break;
                            }
                        }
                        catch (Exception getFormMethod) {
                            // empty catch block
                        }
                    }
                    if (baseSpeed == 0) {
                        try {
                            Method getSpeciesMethod = pokemonData.getClass().getMethod("getSpecies", new Class[0]);
                            Object species = getSpeciesMethod.invoke(pokemonData, new Object[0]);
                            if (species == null || !((baseStats = (getBaseStats = species.getClass().getMethod("getBaseStats", new Class[0])).invoke(species, new Object[0])) instanceof Map)) break block20;
                            statsMap = (Map)baseStats;
                            for (Map.Entry entry : statsMap.entrySet()) {
                                statName = entry.getKey().toString().toLowerCase();
                                if (!statName.contains("speed") && !statName.equals("spe")) continue;
                                baseSpeed = (Integer)entry.getValue();
                                break;
                            }
                        }
                        catch (Exception getSpeciesMethod) {
                            // empty catch block
                        }
                    }
                }
            }
            if (baseSpeed <= 0) {
                return;
            }
            int minSpeed = (int)Math.floor((double)((2 * baseSpeed + 0 + 0) * level / 100 + 5) * 0.9);
            int maxSpeed = (int)Math.floor((double)((2 * baseSpeed + 31 + 63) * level / 100 + 5) * 1.1);
            String side = isPlayer ? "player" : "opponent";
            int speedStage = BattleMessageSubscriber.getStatStage(side, lowerName = pokemonName != null ? pokemonName.toLowerCase() : "", "speed");
            if (speedStage != 0) {
                if (speedStage > 0) {
                    minSpeed = (int)((double)(minSpeed * (2 + speedStage)) / 2.0);
                    maxSpeed = (int)((double)(maxSpeed * (2 + speedStage)) / 2.0);
                } else {
                    minSpeed = (int)((double)minSpeed * 2.0 / (double)(2 - speedStage));
                    maxSpeed = (int)((double)maxSpeed * 2.0 / (double)(2 - speedStage));
                }
            }
            if (BattleMessageSubscriber.getTailwindTurns(side) > 0) {
                minSpeed *= 2;
                maxSpeed *= 2;
            }
            String speedText = "Spd: " + minSpeed + "-" + maxSpeed;
            int color = speedStage > 0 ? -11141291 : (speedStage < 0 ? -43691 : -5579265);
            class_310 mc = class_310.method_1551();
            class_4597.class_4598 immediateBuffer = mc.method_22940().method_23000();
            float textZOffset = 0.1f;
            float speedY = 14.0f;
            float textScale = 0.85f;
            int textWidth = font.method_1727(speedText);
            float speedX = isPlayer ? (float)(-textWidth) * 0.4f + 35.0f : (float)(-textWidth) * 0.4f - 40.0f;
            poseStack.method_22903();
            poseStack.method_46416(speedX, speedY, textZOffset);
            poseStack.method_22905(textScale, textScale, textScale);
            font.method_27521(speedText, 0.0f, 0.0f, color, false, poseStack.method_23760().method_23761(), (class_4597)immediateBuffer, class_327.class_6415.field_33994, 0, 0xF000F0);
            poseStack.method_22909();
            immediateBuffer.method_22993();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void renderStatus(class_4587 poseStack, class_4597 buffers, class_327 font, String status, boolean isPlayer, int nameplateStyle) {
        int bgColor;
        if (status == null || status.isEmpty()) {
            return;
        }
        int textColor = -1;
        String displayText = status.toUpperCase();
        switch (status.toLowerCase()) {
            case "slp": {
                bgColor = -7303008;
                break;
            }
            case "brn": {
                bgColor = -2068432;
                break;
            }
            case "psn": 
            case "tox": {
                bgColor = -6274912;
                if (!status.equalsIgnoreCase("tox")) break;
                displayText = "TOX";
                break;
            }
            case "par": {
                bgColor = -3100640;
                break;
            }
            case "frz": {
                bgColor = -9385776;
                break;
            }
            default: {
                bgColor = -8355712;
            }
        }
        class_310 mc = class_310.method_1551();
        class_4597.class_4598 immediateBuffer = mc.method_22940().method_23000();
        float textZOffset = 0.1f;
        float statusY = 11.0f;
        int textWidth = font.method_1727(displayText);
        float bgPadding = 2.0f;
        float bgWidth = (float)textWidth * 0.7f + bgPadding * 2.0f;
        float bgHeight = 8.0f;
        float typeIconsWidth = 26.0f;
        float statusX = isPlayer ? -67.0f + typeIconsWidth + 10.0f : 67.0f - typeIconsWidth - bgWidth - 10.0f;
        poseStack.method_22903();
        poseStack.method_46416(statusX, statusY, textZOffset - 0.01f);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        float r = (float)(bgColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(bgColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(bgColor & 0xFF) / 255.0f;
        float a = (float)(bgColor >> 24 & 0xFF) / 255.0f;
        buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, 0.0f, bgHeight, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, bgWidth, bgHeight, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, bgWidth, 0.0f, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_46416(statusX + bgPadding, statusY + 1.0f, textZOffset);
        poseStack.method_22905(0.7f, 0.7f, 0.7f);
        font.method_27521(displayText, 0.0f, 0.0f, textColor, false, poseStack.method_23760().method_23761(), (class_4597)immediateBuffer, class_327.class_6415.field_33994, 0, 0xF000F0);
        poseStack.method_22909();
        immediateBuffer.method_22993();
    }
}

