/*
 * Decompiled with CFR 0.152.
 */
package com.lankaster.pyrellium.render;

import com.lankaster.pyrellium.block.entity.HeadStoneBlockEntity;
import com.lankaster.pyrellium.render.ModModelLayers;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_8242;
import net.minecraft.class_827;
import net.minecraft.class_837;

@Environment(value=EnvType.CLIENT)
public class HeadStoneBlockEntityRenderer
implements class_827<HeadStoneBlockEntity> {
    private final class_837.class_4702 signModel;
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"pyrellium", (String)"entity/signs/headstone");
    private static final class_243 TEXT_OFFSET = new class_243(0.0, 0.3333333432674408, 0.09666666388511658);
    private final class_327 textRenderer;

    public HeadStoneBlockEntityRenderer(class_5614.class_5615 context) {
        this.signModel = new class_837.class_4702(context.method_32140(ModModelLayers.HEADSTONE));
        this.textRenderer = context.method_32143();
    }

    public void render(HeadStoneBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2680 blockState = entity.method_11010();
        class_2478 abstractSignBlock = (class_2478)blockState.method_26204();
        class_837.class_4702 signModel = this.signModel;
        this.render(entity, matrices, vertexConsumers, light, overlay, (class_3879)signModel, blockState, abstractSignBlock);
    }

    void render(HeadStoneBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_3879 model, class_2680 state, class_2478 block) {
        matrices.method_22903();
        this.setAngles(matrices, -block.method_49814(state), state);
        this.renderSign(matrices, vertexConsumers, light, overlay, model);
        this.renderText(entity.method_11016(), entity.method_49853(), matrices, vertexConsumers, light, entity.method_45469(), entity.method_45470(), true);
        this.renderText(entity.method_11016(), entity.method_49854(), matrices, vertexConsumers, light, entity.method_45469(), entity.method_45470(), false);
        matrices.method_22909();
    }

    void setAngles(class_4587 matrices, float rotationDegrees, class_2680 state) {
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));
        if (!(state.method_26204() instanceof class_2508)) {
            matrices.method_46416(0.0f, -0.3125f, -0.40625f);
        }
    }

    void renderSign(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_3879 model) {
        matrices.method_22903();
        class_4730 spriteIdentifier = new class_4730(class_4722.field_21708, TEXTURE);
        Objects.requireNonNull(model);
        class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumers, arg_0 -> ((class_3879)model).method_23500(arg_0));
        this.renderSignModel(matrices, light, overlay, model, vertexConsumer);
        matrices.method_22909();
    }

    void renderSignModel(class_4587 matrices, int light, int overlay, class_3879 model, class_4588 vertexConsumers) {
        class_837.class_4702 signModel = (class_837.class_4702)model;
        signModel.field_27756.method_22698(matrices, vertexConsumers, light, overlay);
    }

    void renderText(class_2338 pos, class_8242 signText, class_4587 matrices, class_4597 vertexConsumers, int light, int lineHeight, int lineWidth, boolean front) {
        int l;
        boolean bl;
        int k;
        matrices.method_22903();
        this.setTextAngles(matrices, front);
        int i = HeadStoneBlockEntityRenderer.getColor(signText);
        int j = 4 * lineHeight / 2;
        class_5481[] orderedTexts = signText.method_49868(class_310.method_1551().method_33883(), text -> {
            List list = this.textRenderer.method_1728((class_5348)text, lineWidth);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (signText.method_49856()) {
            k = signText.method_49872().method_16357();
            bl = HeadStoneBlockEntityRenderer.shouldRender(pos, k);
            l = 0xF000F0;
        } else {
            k = i;
            bl = false;
            l = light;
        }
        for (int m = 0; m < 4; ++m) {
            class_5481 orderedText = orderedTexts[m];
            float f = -this.textRenderer.method_30880(orderedText) / 2;
            if (bl) {
                this.textRenderer.method_37296(orderedText, f, (float)(m * lineHeight - j), k, i, matrices.method_23760().method_23761(), vertexConsumers, l);
                continue;
            }
            this.textRenderer.method_22942(orderedText, f, (float)(m * lineHeight - j), k, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33995, 0, l);
        }
        matrices.method_22909();
    }

    private void setTextAngles(class_4587 matrices, boolean front) {
        if (!front) {
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
        float f = 0.010416667f;
        matrices.method_22904(HeadStoneBlockEntityRenderer.TEXT_OFFSET.field_1352, HeadStoneBlockEntityRenderer.TEXT_OFFSET.field_1351, HeadStoneBlockEntityRenderer.TEXT_OFFSET.field_1350);
        matrices.method_22905(f, -f, f);
    }

    static boolean shouldRender(class_2338 pos, int signColor) {
        if (signColor == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraftClient = class_310.method_1551();
        class_746 clientPlayerEntity = minecraftClient.field_1724;
        if (clientPlayerEntity != null && minecraftClient.field_1690.method_31044().method_31034() && clientPlayerEntity.method_31550()) {
            return true;
        }
        class_1297 entity = minecraftClient.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)pos)) < (double)class_3532.method_34954((int)16);
    }

    static int getColor(class_8242 sign) {
        int i = sign.method_49872().method_16357();
        if (i == class_1767.field_7963.method_16357() && sign.method_49856()) {
            return -988212;
        }
        int j = (int)((double)class_5253.class_5254.method_27765((int)i) * 0.4);
        int k = (int)((double)class_5253.class_5254.method_27766((int)i) * 0.4);
        int l = (int)((double)class_5253.class_5254.method_27767((int)i) * 0.4);
        return class_5253.class_5254.method_27764((int)0, (int)j, (int)k, (int)l);
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("sign", class_5606.method_32108().method_32101(0, 0).method_32097(-8.0f, -3.0f, -1.5f, 16.0f, 13.0f, 3.0f), class_5603.field_27701);
        modelPartData.method_32117("top1", class_5606.method_32108().method_32101(0, 16).method_32097(-7.0f, 10.0f, -1.5f, 14.0f, 1.0f, 3.0f), class_5603.field_27701);
        modelPartData.method_32117("top2", class_5606.method_32108().method_32101(0, 20).method_32097(-6.0f, 11.0f, -1.5f, 12.0f, 1.0f, 3.0f), class_5603.field_27701);
        modelPartData.method_32117("top3", class_5606.method_32108().method_32101(0, 24).method_32097(-5.0f, 12.0f, -1.5f, 10.0f, 1.0f, 3.0f), class_5603.field_27701);
        modelPartData.method_32117("stick", class_5606.method_32108().method_32101(0, 14).method_32097(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)32);
    }
}

