/*
 * Decompiled with CFR 0.152.
 */
package me.drex.quickpack.packs;

import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FastFilePackResources
extends class_3255 {
    public static final Logger LOGGER = LogUtils.getLogger();
    private final TreeMap<String, byte[]> fileMap = new TreeMap();
    private final Map<String, Set<String>> namespaces = new HashMap<String, Set<String>>();
    private final ZipFile zipFile;
    private final List<String> prefixStack;
    private final Set<String> overlays;

    public FastFilePackResources(class_9224 packLocationInfo, ZipFile zipFile, List<String> overlays) {
        super(packLocationInfo);
        this.zipFile = zipFile;
        this.overlays = new HashSet<String>(overlays);
        this.prefixStack = new ArrayList<String>(overlays.size() + 1);
        for (int i = overlays.size() - 1; i >= 0; --i) {
            this.prefixStack.add(overlays.get(i) + "/");
        }
        this.prefixStack.add("");
        this.extractFiles();
    }

    public void extractFiles() {
        if (this.zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            this.extractNamespace(path);
            try {
                InputStream in = this.zipFile.getInputStream(entry);
                try {
                    byte[] data = in.readAllBytes();
                    this.fileMap.put(path, data);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load resource {}", (Object)path, (Object)e);
            }
        }
    }

    private void extractNamespace(String path) {
        String namespace;
        String type;
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return;
        }
        boolean isOverlay = this.overlays.contains(parts[0]);
        if (isOverlay && parts.length >= 3) {
            type = parts[1];
            namespace = parts[2];
        } else if (!isOverlay && parts.length >= 2) {
            type = parts[0];
            namespace = parts[1];
        } else {
            return;
        }
        if (class_2960.method_20209((String)namespace)) {
            this.namespaces.computeIfAbsent(type, s -> new HashSet()).add(namespace);
        } else {
            LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.zipFile);
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... parts) {
        byte[] data = this.fileMap.get(String.join((CharSequence)"/", parts));
        if (data == null) {
            return null;
        }
        return () -> new ByteArrayInputStream(data);
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 resourceLocation) {
        for (String prefix : this.prefixStack) {
            byte[] data = this.fileMap.get(prefix + packType.method_14413() + "/" + resourceLocation.method_12836() + "/" + resourceLocation.method_12832());
            if (data == null) continue;
            return () -> new ByteArrayInputStream(data);
        }
        return null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        HashMap map = new HashMap();
        for (String prefix : this.prefixStack) {
            String namespacePrefix = prefix + packType.method_14413() + "/" + namespace + "/";
            String dirPrefix = namespacePrefix + path + "/";
            String end = dirPrefix + "\uffff";
            this.fileMap.subMap(dirPrefix, end).forEach((filePath, bytes) -> {
                String rlPath = filePath.substring(namespacePrefix.length());
                class_2960 location = class_2960.method_43902((String)namespace, (String)rlPath);
                if (location != null) {
                    map.putIfAbsent(location, () -> new ByteArrayInputStream((byte[])bytes));
                } else {
                    LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)rlPath);
                }
            });
        }
        map.forEach(resourceOutput);
    }

    public Set<String> method_14406(class_3264 packType) {
        return this.namespaces.getOrDefault(packType.method_14413(), Collections.emptySet());
    }

    public void close() {
        if (this.zipFile != null) {
            IOUtils.closeQuietly((Closeable)this.zipFile);
        }
    }
}

