/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.stickers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9283;
import net.minecraft.class_9299;

public record StickerExplosion(class_2960 id, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) implements class_9299
{
    private static final class_9139<ByteBuf, IntList> COLOR_LIST_STREAM_CODEC = class_9135.field_49675.method_56433(class_9135.method_56363()).method_56432(IntArrayList::new, ArrayList::new);
    public static final Codec<StickerExplosion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(StickerExplosion::id), (App)class_9283.field_49318.optionalFieldOf("colors", (Object)IntList.of()).forGetter(StickerExplosion::colors), (App)class_9283.field_49318.optionalFieldOf("fade_colors", (Object)IntList.of()).forGetter(StickerExplosion::fadeColors), (App)Codec.BOOL.optionalFieldOf("has_trail", (Object)false).forGetter(StickerExplosion::hasTrail), (App)Codec.BOOL.optionalFieldOf("has_twinkle", (Object)false).forGetter(StickerExplosion::hasTwinkle)).apply((Applicative)instance, StickerExplosion::new));
    public static final class_9139<ByteBuf, StickerExplosion> STREAM_CODEC = class_9139.method_56906((class_9139)class_2960.field_48267, StickerExplosion::id, COLOR_LIST_STREAM_CODEC, StickerExplosion::colors, COLOR_LIST_STREAM_CODEC, StickerExplosion::fadeColors, (class_9139)class_9135.field_48547, StickerExplosion::hasTrail, (class_9139)class_9135.field_48547, StickerExplosion::hasTwinkle, StickerExplosion::new);

    public static StickerExplosion fromFireworks(class_9283 explosion) {
        class_2960 id = switch (explosion.comp_2386()) {
            default -> throw new MatchException(null, null);
            case class_9283.class_1782.field_7976 -> class_2960.method_60656((String)"small_ball");
            case class_9283.class_1782.field_7977 -> class_2960.method_60656((String)"large_ball");
            case class_9283.class_1782.field_7973 -> class_2960.method_60656((String)"star");
            case class_9283.class_1782.field_7974 -> class_2960.method_60656((String)"creeper");
            case class_9283.class_1782.field_7970 -> class_2960.method_60656((String)"burst");
        };
        return new StickerExplosion(id, explosion.comp_2387(), explosion.comp_2388(), explosion.comp_2389(), explosion.comp_2390());
    }

    public void method_57409(class_1792.class_9635 tooltipContext, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        this.addParticleNameTooltip(consumer);
        this.addAdditionalTooltip(consumer);
    }

    public void addParticleNameTooltip(Consumer<class_2561> consumer) {
        consumer.accept((class_2561)this.getName().method_27692(class_124.field_1080));
    }

    public void addAdditionalTooltip(Consumer<class_2561> consumer) {
        List<class_1767> dyeColors;
        if (!this.colors.isEmpty() && !(dyeColors = StickerExplosion.getDyeColors(this.colors)).isEmpty()) {
            consumer.accept(StickerExplosion.appendColors(class_2561.method_43473().method_27692(class_124.field_1080), dyeColors));
        }
        if (!this.fadeColors.isEmpty() && !(dyeColors = StickerExplosion.getDyeColors(this.fadeColors)).isEmpty()) {
            consumer.accept(StickerExplosion.appendColors(class_2561.method_43471((String)"item.minecraft.firework_star.fade_to").method_10852(class_5244.field_41874).method_27692(class_124.field_1080), dyeColors));
        }
        if (this.hasTrail) {
            consumer.accept((class_2561)class_2561.method_43471((String)"item.minecraft.firework_star.trail").method_27692(class_124.field_1080));
        }
        if (this.hasTwinkle) {
            consumer.accept((class_2561)class_2561.method_43471((String)"item.minecraft.firework_star.flicker").method_27692(class_124.field_1080));
        }
    }

    private static List<class_1767> getDyeColors(IntList colors) {
        ArrayList<class_1767> dyeColors = new ArrayList<class_1767>();
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            class_1767 dyeColor = class_1767.method_7786((int)color);
            if (dyeColor == null) continue;
            dyeColors.add(dyeColor);
        }
        return dyeColors;
    }

    private static class_2561 appendColors(class_5250 mutableComponent, List<class_1767> dyeColors) {
        for (int i = 0; i < dyeColors.size(); ++i) {
            if (i > 0) {
                mutableComponent.method_27693(", ");
            }
            mutableComponent.method_10852((class_2561)class_2561.method_43471((String)("item.minecraft.firework_star." + dyeColors.get(i).method_7792())));
        }
        return mutableComponent;
    }

    private class_5250 getName() {
        return class_2561.method_43471((String)String.format("item.%s.sticker.id.%s", this.id().method_12836(), this.id().method_12832()));
    }
}

