/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.particles;

import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.util.CustomParticleFunction;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3998;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_677;
import net.minecraft.class_702;
import net.minecraft.class_703;

@Environment(value=EnvType.CLIENT)
public class CapsuleParticle
extends class_677 {
    private static final Map<class_2960, CustomParticleFunction> EXPLOSION_MAP = new HashMap<class_2960, CustomParticleFunction>();

    public static void register(class_2960 id, CustomParticleFunction consumer) {
        EXPLOSION_MAP.put(id, consumer);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Starter
    extends class_3998 {
        private int life = 0;
        private final float rot;
        private final class_702 engine;
        private final List<StickerExplosion> explosions;
        protected final float scale;
        protected final double scaleFactor;

        public Starter(class_638 clientLevel, double d, double e, double f, float rot, class_702 particleEngine, List<StickerExplosion> list, float scale) {
            super(clientLevel, d, e, f, 0.0, 0.0, 0.0);
            this.rot = rot;
            this.engine = particleEngine;
            this.scale = scale;
            this.scaleFactor = scale < 1.0f ? 2.0 : (scale < 2.0f ? 1.0 : (scale < 3.0f ? 0.5 : 0.25));
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Cannot create capsule starter with no explosions");
            }
            this.explosions = list;
            this.field_3847 = list.size() * 2 - 1;
            if (this.explosions.stream().anyMatch(StickerExplosion::hasTwinkle)) {
                this.field_3847 += 15;
            }
        }

        public void method_3070() {
            if (this.life % 2 == 0 && this.life / 2 < this.explosions.size()) {
                StickerExplosion explosion = this.explosions.get(this.life / 2);
                boolean hasTrail = explosion.hasTrail();
                boolean hasTwinkle = explosion.hasTwinkle();
                IntList colors = explosion.colors();
                IntList fadeColors = explosion.fadeColors();
                if (colors.isEmpty()) {
                    colors = IntList.of((int)class_1767.field_7963.method_7790());
                }
                if (explosion.id().method_12836().equals("minecraft")) {
                    switch (explosion.id().method_12832()) {
                        case "small_ball": {
                            this.createParticleBall(0.2, 2, colors, fadeColors, hasTrail, hasTwinkle);
                            break;
                        }
                        case "large_ball": {
                            this.createParticleBall(0.25, 3, colors, fadeColors, hasTrail, hasTwinkle);
                            break;
                        }
                        case "star": {
                            this.createParticleShape(0.3, class_677.class_681.field_49566, colors, fadeColors, hasTrail, hasTwinkle, false);
                            break;
                        }
                        case "creeper": {
                            this.createParticleShape(0.3, class_677.class_681.field_49565, colors, fadeColors, hasTrail, hasTwinkle, true);
                            break;
                        }
                        case "burst": {
                            this.createParticleBurst(colors, fadeColors, hasTrail, hasTwinkle);
                            break;
                        }
                    }
                } else {
                    CustomParticleFunction explosionParticle = EXPLOSION_MAP.get(explosion.id());
                    if (explosionParticle != null) {
                        explosionParticle.accept(this.field_3851, this.field_3874, this.field_3854, this.field_3871, this.rot, this.engine, explosion, this.scale, this.scaleFactor);
                    }
                }
                int colorValue = colors.getInt(0);
                class_703 particle = this.engine.method_3056((class_2394)class_2398.field_17909, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
                if (particle != null) {
                    particle.method_3084((float)class_5253.class_5254.method_27765((int)colorValue) / 255.0f, (float)class_5253.class_5254.method_27766((int)colorValue) / 255.0f, (float)class_5253.class_5254.method_27767((int)colorValue) / 255.0f);
                }
            }
            if (++this.life > this.field_3847) {
                this.method_3085();
            }
        }

        public void createParticle(double d, double e, double f, double g, double h, double i, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) {
            class_677.class_680 sparkParticle = (class_677.class_680)this.engine.method_3056((class_2394)class_2398.field_11248, d, e, f, g, h, i);
            if (sparkParticle == null) {
                return;
            }
            sparkParticle.method_3027(hasTrail);
            sparkParticle.method_3026(hasTwinkle);
            sparkParticle.method_3083(0.99f);
            sparkParticle.method_3093(((Integer)class_156.method_32309((List)colors, (class_5819)this.field_3840)).intValue());
            if (!fadeColors.isEmpty()) {
                sparkParticle.method_3092(((Integer)class_156.method_32309((List)fadeColors, (class_5819)this.field_3840)).intValue());
            }
        }

        public void createParticleBall(double d, int i, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) {
            d *= (double)this.scale;
            for (double j = (double)(-i); j <= (double)i; j += this.scaleFactor) {
                for (double k = (double)(-i); k <= (double)i; k += this.scaleFactor) {
                    for (double l = (double)(-i); l <= (double)i; l += this.scaleFactor) {
                        double h = k + (this.field_3840.method_43058() - this.field_3840.method_43058()) * 0.5;
                        double m = j + (this.field_3840.method_43058() - this.field_3840.method_43058()) * 0.5;
                        double n = l + (this.field_3840.method_43058() - this.field_3840.method_43058()) * 0.5;
                        double o = Math.sqrt(h * h + m * m + n * n) / d + this.field_3840.method_43059() * 0.05;
                        this.createParticle(this.field_3874, this.field_3854, this.field_3871, h / o, m / o, n / o, colors, fadeColors, hasTrail, hasTwinkle);
                        if (j == (double)(-i) || j == (double)i || k == (double)(-i) || k == (double)i) continue;
                        l += (double)(i * 2 - 1);
                    }
                }
            }
        }

        public void createParticleShape(double d, double[][] ds, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle, boolean bl3) {
            double e = ds[0][0];
            double f = ds[0][1];
            this.createParticle(this.field_3874, this.field_3854, this.field_3871, e * (d *= (double)this.scale), f * d, 0.0, colors, fadeColors, hasTrail, hasTwinkle);
            float g = this.field_3840.method_43057() * (float)Math.PI;
            double h = bl3 ? 0.034 : 0.34;
            for (int i = 0; i < 3; ++i) {
                double j = (double)g + (double)((float)i * (float)Math.PI) * h;
                double k = e;
                double l = f;
                for (int m = 1; m < ds.length; ++m) {
                    double n = ds[m][0];
                    double o = ds[m][1];
                    for (double p = 0.25; p <= 1.0; p += 0.25 * this.scaleFactor) {
                        double q = class_3532.method_16436((double)p, (double)k, (double)n) * d;
                        double r = class_3532.method_16436((double)p, (double)l, (double)o) * d;
                        double s = q * Math.sin(j);
                        q *= Math.cos(j);
                        for (double t = -1.0; t <= 1.0; t += 2.0) {
                            this.createParticle(this.field_3874, this.field_3854, this.field_3871, q * t, r, s * t, colors, fadeColors, hasTrail, hasTwinkle);
                        }
                    }
                    k = n;
                    l = o;
                }
            }
        }

        public void createParticleBurst(IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) {
            double d = this.field_3840.method_43059() * 0.05;
            double e = this.field_3840.method_43059() * 0.05;
            int i = 0;
            while ((double)i < 70.0 / this.scaleFactor) {
                double f = (this.field_3852 * 0.5 + this.field_3840.method_43059() * 0.15 + d) * (double)this.scale * 0.5;
                double g = (this.field_3850 * 0.5 + this.field_3840.method_43059() * 0.15 + e) * (double)this.scale * 0.5;
                double h = (this.field_3869 * 0.5 + this.field_3840.method_43058() * 0.5) * (double)this.scale * 0.5;
                this.createParticle(this.field_3874, this.field_3854, this.field_3871, f, h, g, colors, fadeColors, hasTrail, hasTwinkle);
                ++i;
            }
        }
    }
}

