/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.gui;

import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.fireworkcapsules.common.item.FireworkCapsuleItems;
import com.necro.fireworkcapsules.common.util.ICapsuleHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public class CapsuleContainer
extends class_1277 {
    private final class_5455 registryAccess;
    private final Pokemon[] pokemon;

    public CapsuleContainer(List<class_1799> items, class_5455 registryAccess, Pokemon[] pokemon) {
        super((class_1799[])items.toArray(class_1799[]::new));
        this.registryAccess = registryAccess;
        this.pokemon = pokemon;
    }

    public static CapsuleContainer create(class_1657 player) {
        CapsuleContainer capsuleContainer;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            capsuleContainer = CapsuleContainer.createServer(serverPlayer);
        } else {
            capsuleContainer = CapsuleContainer.createClient(player);
        }
        return capsuleContainer;
    }

    private static CapsuleContainer createClient(class_1657 player) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        Pokemon[] pokemonList = new Pokemon[6];
        ClientParty party = CobblemonClient.INSTANCE.getStorage().getParty();
        for (int i = 0; i < 6; ++i) {
            Pokemon pokemon = party.get(i);
            if (pokemon == null) {
                items.add(class_1799.field_8037);
            } else {
                items.add(((ICapsuleHolder)pokemon).getCapsule((class_7225.class_7874)player.method_56673()));
            }
            pokemonList[i] = pokemon;
        }
        return new CapsuleContainer(items, player.method_56673(), pokemonList);
    }

    private static CapsuleContainer createServer(class_3222 player) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        Pokemon[] pokemonList = new Pokemon[6];
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        for (int i = 0; i < 6; ++i) {
            Pokemon pokemon = party.get(i);
            if (pokemon == null) {
                items.add(class_1799.field_8037);
            } else {
                items.add(((ICapsuleHolder)pokemon).getCapsule((class_7225.class_7874)player.method_56673()));
            }
            pokemonList[i] = pokemon;
        }
        return new CapsuleContainer(items, player.method_56673(), pokemonList);
    }

    public boolean method_27070(class_1799 stack) {
        return stack.method_41406(FireworkCapsuleItems.BALL_CAPSULE);
    }

    public boolean method_5437(int i, class_1799 stack) {
        return stack.method_41406(FireworkCapsuleItems.BALL_CAPSULE);
    }

    public void onCapsuleChange(int slot, class_1799 itemStack) {
        Pokemon pokemon = this.pokemon[slot];
        if (pokemon == null) {
            return;
        }
        ((ICapsuleHolder)pokemon).setCapsule((class_7225.class_7874)this.registryAccess, itemStack);
    }

    public boolean isActive(int slot) {
        return this.pokemon[slot] != null;
    }
}

