/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.entity;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.necro.fireworkcapsules.common.components.FireworkCapsuleComponents;
import com.necro.fireworkcapsules.common.entity.FireworkCapsuleEntities;
import com.necro.fireworkcapsules.common.item.FireworkCapsuleItems;
import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.stickers.Stickers;
import com.necro.fireworkcapsules.common.util.IParticleCreator;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3856;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public class CapsuleEntity
extends class_1297
implements class_3856 {
    private static final class_2940<class_1799> DATA_ID_CAPSULE_ITEM = class_2945.method_12791(CapsuleEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<OptionalInt> DATA_OWNER_ENTITY = class_2945.method_12791(CapsuleEntity.class, (class_2941)class_2943.field_17910);
    private PokemonEntity owner;

    public CapsuleEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public CapsuleEntity(class_1937 level, double x, double y, double z, class_1799 itemStack, PokemonEntity entity) {
        this((class_1299)FireworkCapsuleEntities.CAPSULE_ENTITY.comp_349(), level);
        this.owner = entity;
        this.method_5814(x, y, z);
        this.field_6011.method_12778(DATA_ID_CAPSULE_ITEM, (Object)itemStack.method_7972());
        this.field_6011.method_12778(DATA_OWNER_ENTITY, (Object)OptionalInt.of(entity.method_5628()));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_ID_CAPSULE_ITEM, (Object)CapsuleEntity.getDefaultItem());
        builder.method_56912(DATA_OWNER_ENTITY, (Object)OptionalInt.empty());
    }

    protected void method_5749(class_2487 compoundTag) {
        if (compoundTag.method_10573("CapsuleItem", 10)) {
            this.field_6011.method_12778(DATA_ID_CAPSULE_ITEM, (Object)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)compoundTag.method_10562("CapsuleItem")).orElseGet(CapsuleEntity::getDefaultItem));
        } else {
            this.field_6011.method_12778(DATA_ID_CAPSULE_ITEM, (Object)CapsuleEntity.getDefaultItem());
        }
        if (compoundTag.method_10545("EntityId")) {
            this.field_6011.method_12778(DATA_OWNER_ENTITY, (Object)OptionalInt.of(compoundTag.method_10550("EntityId")));
            this.owner = (PokemonEntity)this.method_37908().method_8469(compoundTag.method_10550("EntityId"));
        }
    }

    protected void method_5652(class_2487 compoundTag) {
        compoundTag.method_10566("CapsuleItem", this.method_7495().method_57358((class_7225.class_7874)this.method_56673()));
        if (this.owner != null) {
            compoundTag.method_10569("EntityId", this.owner.method_5628());
        }
    }

    public void method_5711(byte b) {
        if (b == 17 && this.method_37908().field_9236) {
            OptionalInt entityId = (OptionalInt)this.field_6011.method_12789(DATA_OWNER_ENTITY);
            if (entityId.isEmpty()) {
                return;
            }
            class_1297 entity = this.method_37908().method_8469(entityId.getAsInt());
            if (!(entity instanceof PokemonEntity)) {
                return;
            }
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            float scale = this.getScale(pokemonEntity);
            ((IParticleCreator)this.method_37908()).createCapsuleParticles(this.method_23317(), this.method_23318(), this.method_23321(), pokemonEntity.field_6283, this.getExplosions(), scale);
        }
        super.method_5711(b);
    }

    private List<StickerExplosion> getExplosions() {
        class_1799 itemStack = (class_1799)this.field_6011.method_12789(DATA_ID_CAPSULE_ITEM);
        Stickers stickers = (Stickers)itemStack.method_57824((class_9331)FireworkCapsuleComponents.STICKERS.comp_349());
        return stickers != null ? stickers.explosions() : List.of();
    }

    @NotNull
    public class_1799 method_7495() {
        return (class_1799)this.field_6011.method_12789(DATA_ID_CAPSULE_ITEM);
    }

    private static class_1799 getDefaultItem() {
        return new class_1799(FireworkCapsuleItems.BALL_CAPSULE);
    }

    public void explode() {
        this.method_37908().method_8421((class_1297)this, (byte)17);
        this.method_31472();
    }

    private float getScale(PokemonEntity entity) {
        class_238 boundingBox = entity.method_5829();
        return (float)Math.pow((boundingBox.method_17939() + boundingBox.method_17940() + boundingBox.method_17941()) / 3.0, 0.6);
    }
}

