/*
 * Decompiled with CFR 0.152.
 */
package com.dawnshade.biteforce.suite.mixin;

import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.storage.player.client.ClientPokedexManager;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.render.pokemon.PokemonRenderer;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.client.storage.ClientStorageManager;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={PokemonRenderer.class})
public abstract class PokemonNameMixin {
    private static final float ICON_W = 5.0f;
    private static final float ICON_H = 5.0f;
    private static final float ICON_Z = 0.05f;

    @Inject(method={"renderNameTag(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/text/Text;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/font/TextRenderer;draw(Lnet/minecraft/text/Text;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/font/TextRenderer$TextLayerType;II)I", shift=At.Shift.AFTER)})
    private void bitesuite$drawIconAfterLabel(PokemonEntity entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light, float tickDelta, CallbackInfo ci) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        CaptureVisual visual = this.getVisual(entity);
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)visual.texture()));
        class_4587.class_4665 entry = matrices.method_23760();
        int width = textRenderer.method_27525((class_5348)text);
        float halfWidth = (float)width / 2.0f;
        float iconX = halfWidth + 23.0f;
        float iconY = 4.5f;
        int[] tint = visual.tint();
        float r = (float)tint[0] / 255.0f;
        float g = (float)tint[1] / 255.0f;
        float b = (float)tint[2] / 255.0f;
        float a = 1.0f;
        int lightValue = 0xF000F0;
        class_4588 bgBuffer = vertexConsumers.getBuffer(class_1921.method_49045());
        float bgPad = 2.0f;
        float bgZ = 0.04f;
        float bgX0 = iconX - 5.0f - bgPad;
        float bgX1 = iconX + 5.0f + bgPad;
        float bgY0 = iconY - 5.0f - bgPad;
        float bgY1 = iconY + 5.0f + bgPad;
        float bgAlpha = 0.4f;
        bgBuffer.method_56824(entry, bgX0, bgY1, bgZ).method_22915(0.0f, 0.0f, 0.0f, bgAlpha).method_60803(lightValue);
        bgBuffer.method_56824(entry, bgX0, bgY0, bgZ).method_22915(0.0f, 0.0f, 0.0f, bgAlpha).method_60803(lightValue);
        bgBuffer.method_56824(entry, bgX1, bgY0, bgZ).method_22915(0.0f, 0.0f, 0.0f, bgAlpha).method_60803(lightValue);
        bgBuffer.method_56824(entry, bgX1, bgY1, bgZ).method_22915(0.0f, 0.0f, 0.0f, bgAlpha).method_60803(lightValue);
        buffer.method_56824(entry, iconX - 5.0f, iconY + 5.0f, 0.05f).method_22915(r, g, b, a).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(lightValue).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, iconX - 5.0f, iconY - 5.0f, 0.05f).method_22915(r, g, b, a).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(lightValue).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, iconX + 5.0f, iconY - 5.0f, 0.05f).method_22915(r, g, b, a).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(lightValue).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, iconX + 5.0f, iconY + 5.0f, 0.05f).method_22915(r, g, b, a).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(lightValue).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    private CaptureVisual getVisual(PokemonEntity entity) {
        boolean hasCaughtAny;
        class_2960 uncaughtTexture = class_2960.method_60655((String)"bitesuite", (String)"textures/captured/captured_no.png");
        class_2960 caughtTexture = class_2960.method_60655((String)"bitesuite", (String)"textures/captured/captured_this.png");
        class_2960 activeTexture = class_2960.method_60655((String)"bitesuite", (String)"textures/captured/captured_all.png");
        ClientPokedexManager pokedex = CobblemonClient.INSTANCE.getClientPokedexData();
        Pokemon pokemon = entity.getPokemon();
        class_2960 speciesId = pokemon.getSpecies().getResourceIdentifier();
        boolean isActiveOwned = false;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            ClientStorageManager storage;
            ClientParty party;
            UUID ownerUuid;
            isActiveOwned = pokemon.belongsTo((class_1657)player);
            if (!isActiveOwned && (ownerUuid = pokemon.getOwnerUUID()) != null && ownerUuid.equals(player.method_5667())) {
                isActiveOwned = true;
            }
            if (!isActiveOwned && pokemon.isPlayerOwned() && pokemon.getOwnerUUID() != null && !pokemon.isWild()) {
                isActiveOwned = pokemon.getOwnerUUID().equals(player.method_5667());
            }
            if (!isActiveOwned && (party = (storage = CobblemonClient.INSTANCE.getStorage()).getParty()) != null) {
                for (Pokemon slotMon : party.getSlots()) {
                    if (slotMon == null || !pokemon.getUuid().equals(slotMon.getUuid())) continue;
                    isActiveOwned = true;
                    break;
                }
            }
        }
        if (isActiveOwned) {
            return new CaptureVisual(activeTexture, new int[]{255, 215, 0});
        }
        PokedexEntryProgress progress = pokedex.getHighestKnowledgeForSpecies(speciesId);
        boolean bl = hasCaughtAny = progress == PokedexEntryProgress.CAUGHT;
        if (hasCaughtAny) {
            return new CaptureVisual(caughtTexture, new int[]{184, 255, 120});
        }
        return new CaptureVisual(uncaughtTexture, new int[]{255, 107, 107});
    }

    @Environment(value=EnvType.CLIENT)
    private record CaptureVisual(class_2960 texture, int[] tint) {
    }
}

