/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.sizing;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.sizing.SizeDefinition;
import dev.cudzer.cobblemonsizevariation.sizing.algorithms.BasicSizer;
import dev.cudzer.cobblemonsizevariation.sizing.algorithms.GenIXSizer;
import dev.cudzer.cobblemonsizevariation.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SizeDataManager {
    private final List<JsonElement> sizeDefinitionJsons = new ArrayList<JsonElement>();
    public List<SizeDefinition> sizeDefinitions = new ArrayList<SizeDefinition>();

    public void init() {
        CobblemonSizeVariation.LOGGER.info("Loading sizing algorithms...");
        ArrayList newDefinitions = new ArrayList();
        this.sizeDefinitionJsons.add(BasicSizer.createConfig(FileUtils.getSizeFile("basic.json")));
        this.sizeDefinitionJsons.add(GenIXSizer.createConfig(FileUtils.getSizeFile("gen9.json")));
        for (JsonElement element : this.sizeDefinitionJsons) {
            SizeDefinition.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).ifSuccess(result -> {
                SizeDefinition definition = (SizeDefinition)result.getFirst();
                newDefinitions.add(definition);
            }).ifError(partial -> CobblemonSizeVariation.LOGGER.error("Failed to parse json data when loading size files. Error: {}", (Object)partial.message()));
        }
        this.sizeDefinitions.addAll(newDefinitions);
        newDefinitions.clear();
        CobblemonSizeVariation.LOGGER.info("Loaded {} size definitions.", (Object)this.sizeDefinitions.size());
    }

    public SizeDefinition getDefinition(String name) {
        Objects.requireNonNull(name, "Definition name cannot be null");
        SizeDefinition def = this.findByName(name);
        if (def != null) {
            return def;
        }
        CobblemonSizeVariation.LOGGER.warn("[CSV] Unknown SizeDefinition '{}'. Falling back to 'basic'.", (Object)name);
        SizeDefinition fallback = this.findByName("basic");
        if (fallback == null) {
            throw new IllegalStateException("[CSV] No 'basic' SizeDefinition found. Mod cannot continue safely.");
        }
        return fallback;
    }

    private SizeDefinition findByName(String name) {
        return this.sizeDefinitions.stream().filter(d -> d.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }
}

