/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.data;

import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.data.PokemonSize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class CustomSizeDataManager
extends class_4309 {
    private static final Gson GSON = new Gson();
    protected static Map<class_2960, PokemonSize> data = new HashMap<class_2960, PokemonSize>();
    protected static List<class_2960> resourceLocationList = new ArrayList<class_2960>();
    protected static Map<String, PokemonSize> speciesSizeMap = new HashMap<String, PokemonSize>();

    public CustomSizeDataManager() {
        super(GSON, CobblemonSizeVariation.cobblemonSizeResource("custom_sizes").method_12832());
    }

    protected void apply(Map<class_2960, JsonElement> json, class_3300 resourceManager, class_3695 profilerFiller) {
        CobblemonSizeVariation.LOGGER.info("Loading custom pokemon sizes...");
        HashMap<class_2960, PokemonSize> newMap = new HashMap<class_2960, PokemonSize>();
        ArrayList<class_2960> newResourceLocationList = new ArrayList<class_2960>();
        HashMap<String, PokemonSize> newSpeciesMap = new HashMap<String, PokemonSize>();
        data.clear();
        resourceLocationList.clear();
        for (Map.Entry<class_2960, JsonElement> entry : json.entrySet()) {
            class_2960 key = entry.getKey();
            JsonElement element = entry.getValue();
            PokemonSize.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).ifSuccess(result -> {
                PokemonSize pokemonSize = (PokemonSize)result.getFirst();
                newMap.put(key, pokemonSize);
                pokemonSize.setJsonLocation(key);
                newResourceLocationList.add(key);
                for (String speciesName : pokemonSize.speciesList) {
                    if (speciesName == null || speciesName.isBlank()) continue;
                    newSpeciesMap.put(speciesName.toLowerCase(Locale.ROOT), pokemonSize);
                }
            }).ifError(partial -> CobblemonSizeVariation.LOGGER.error("Failed to parse json data for {} due to {}", (Object)key, (Object)partial.message()));
        }
        resourceLocationList = newResourceLocationList;
        data = newMap;
        speciesSizeMap = newSpeciesMap;
        CobblemonSizeVariation.LOGGER.info("Loaded {} custom size files", (Object)data.size());
    }

    public static PokemonSize getCustomSizeFile(Species species) {
        if (species == null) {
            return null;
        }
        return speciesSizeMap.get(species.getName().toLowerCase(Locale.ROOT));
    }
}

