/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl.model.obj;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.model.ModelOption;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.util.JsonUtils;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_793;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Environment(value=EnvType.CLIENT)
public record ObjModelOptionImpl(ModelOption modelOption, boolean flipV, String mtlOverride, Map<String, class_2960> textures) implements ObjModelOption
{
    public static ObjModelOptionImpl parse(JsonObject modelJson) {
        boolean flipV = class_3518.method_15258((JsonObject)modelJson, (String)"flip_v", (boolean)false);
        String mtlOverride = class_3518.method_15253((JsonObject)modelJson, (String)"mtl_override", null);
        ImmutableMap.Builder textures = ImmutableMap.builder();
        if (modelJson.has("textures") && modelJson.get("textures").isJsonObject()) {
            JsonObject texturesJo = modelJson.getAsJsonObject("textures");
            texturesJo.keySet().forEach(key -> {
                class_2960 tex = JsonUtils.getResourceLocation(texturesJo, key);
                if (tex != null) {
                    textures.put(key, (Object)tex);
                }
            });
        }
        return new ObjModelOptionImpl(ModelOption.parse(modelJson), flipV, mtlOverride, (Map<String, class_2960>)textures.build());
    }

    @Override
    public boolean isFlipV() {
        return this.flipV;
    }

    @Override
    @Nullable
    public String getMtlOverride() {
        return this.mtlOverride;
    }

    @Override
    public @Unmodifiable @NotNull Map<String, class_2960> getTextures() {
        return this.textures;
    }

    @Override
    public boolean isUseAmbientOcclusion() {
        return this.modelOption.isUseAmbientOcclusion();
    }

    @Override
    @Nullable
    public class_793.class_4751 getGuiLight() {
        return this.modelOption.getGuiLight();
    }

    @Override
    @Nullable
    public class_2960 getParticle() {
        return this.modelOption.getParticle();
    }

    @Override
    @NotNull
    public class_809 getTransforms() {
        return this.modelOption.getTransforms();
    }
}

