/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl.model.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlReader;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjReader;
import de.javagl.obj.ObjUtils;
import de.javagl.obj.ReadableObj;
import dev.felnull.specialmodelloader.api.model.LoadedResource;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import dev.felnull.specialmodelloader.impl.model.obj.ObjModelLoadedResource;
import dev.felnull.specialmodelloader.impl.model.obj.ObjUnbakedModelModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ObjModelLoaderImp
implements ObjModelLoader {
    public static final ObjModelLoaderImp INSTANCE = new ObjModelLoaderImp();

    @Override
    @Nullable
    public LoadedResource loadResource(@NotNull class_3300 resourceManager, @NotNull JsonObject modelJson) {
        if (!(modelJson.has("model") && modelJson.get("model").isJsonPrimitive() && modelJson.getAsJsonPrimitive("model").isString())) {
            return null;
        }
        class_2960 modelLocation = class_2960.method_60654((String)modelJson.get("model").getAsString());
        return this.loadResource(resourceManager, modelLocation, ObjModelOption.parse(modelJson));
    }

    @Override
    @Nullable
    public LoadedResource loadResource(@NotNull class_3300 resourceManager, @NotNull class_2960 modelLocation, @NotNull ObjModelOption option) {
        ObjModelLoadedResource objModelLoadedResource;
        block11: {
            Optional res = resourceManager.method_14486(modelLocation);
            if (res.isEmpty()) {
                return null;
            }
            BufferedReader reader = ((class_3298)res.get()).method_43039();
            try {
                Object mtlFileNames;
                class_2960 mtlDirLoc;
                Obj obj = ObjUtils.convertToRenderable((ReadableObj)ObjReader.read((Reader)reader));
                String mtlOverride = option.getMtlOverride();
                if (mtlOverride != null) {
                    Object[] overrideSplit = mtlOverride.split("/");
                    mtlDirLoc = class_2960.method_60654((String)String.join((CharSequence)"/", (CharSequence[])ArrayUtils.remove((Object[])overrideSplit, (int)(overrideSplit.length - 1))));
                    mtlFileNames = ImmutableList.of((Object)overrideSplit[overrideSplit.length - 1]);
                } else {
                    Object[] mtlDirPaths = modelLocation.method_12832().split("/");
                    mtlDirPaths = (String[])ArrayUtils.remove((Object[])mtlDirPaths, (int)(mtlDirPaths.length - 1));
                    mtlDirLoc = class_2960.method_60655((String)modelLocation.method_12836(), (String)String.join((CharSequence)"/", (CharSequence[])mtlDirPaths));
                    mtlFileNames = obj.getMtlFileNames();
                }
                objModelLoadedResource = new ObjModelLoadedResource(modelLocation, obj, (Map<String, Mtl>)ImmutableMap.copyOf(this.loadMtl(resourceManager, mtlDirLoc, (List<String>)mtlFileNames)), option);
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load obj file.", e);
                }
            }
            reader.close();
        }
        return objModelLoadedResource;
    }

    @Override
    @NotNull
    public class_1100 makeModel(@NotNull LoadedResource loadedResource) {
        if (loadedResource instanceof ObjModelLoadedResource) {
            ObjModelLoadedResource objRes = (ObjModelLoadedResource)loadedResource;
            return new ObjUnbakedModelModel(objRes.location(), objRes.obj(), objRes.mtl(), objRes.option());
        }
        throw new IllegalArgumentException("A loaded resource that is not an OBJ model was received as an argument.");
    }

    private Map<String, Mtl> loadMtl(class_3300 resourceManager, class_2960 location, List<String> mtlNames) {
        return mtlNames.stream().flatMap(r -> this.loadMtl(resourceManager, location, (String)r).stream()).collect(Collectors.toMap(Mtl::getName, r -> r));
    }

    private List<Mtl> loadMtl(class_3300 resourceManager, class_2960 location, String mtlName) {
        class_2960 loc = class_2960.method_60655((String)location.method_12836(), (String)(location.method_12832() + "/" + mtlName));
        return resourceManager.method_14486(loc).map(res -> {
            List list;
            block8: {
                BufferedReader reader = res.method_43039();
                try {
                    list = MtlReader.read((Reader)reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        SpecialModelLoader.LOGGER.error("Failed to read mtl file.", (Throwable)e);
                        return new ArrayList();
                    }
                }
                reader.close();
            }
            return list;
        }).orElseGet(List::of);
    }

    @Override
    public String getId() {
        return "obj";
    }
}

