/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl.model;

import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import dev.felnull.specialmodelloader.impl.util.JsonUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public final class NeoForgeCompat {
    private static final class_2960 NEO_FORGE_OBJ = class_2960.method_60655((String)"neoforge", (String)"obj");

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("connector")) {
            SpecialModelLoader.LOGGER.info("Sinytra Connector detected.");
            SpecialModelLoader.LOGGER.info("Disable NeoForge compatibility for OBJ loader.");
        }
    }

    public static boolean isEnable() {
        return !FabricLoader.getInstance().isModLoaded("connector");
    }

    public static Pair<class_2960, ObjModelOption> getObjModelData(JsonObject modelJson) {
        if (modelJson == null) {
            return null;
        }
        class_2960 loaderLoc = JsonUtils.getResourceLocation(modelJson, "loader");
        if (!NEO_FORGE_OBJ.equals((Object)loaderLoc)) {
            return null;
        }
        class_2960 model = JsonUtils.getResourceLocation(modelJson, "model");
        if (model == null) {
            return null;
        }
        return Pair.of((Object)model, (Object)ObjModelOption.parse(modelJson));
    }
}

