/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.worldgen.lithostitched.worldgen.poolelement.legacy.GuaranteedPoolElement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.bunten.enderscape.structure.EnderscapeTemplatePools;
import net.bunten.enderscape.structure.StrongholdProcessorLists;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5468;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

public class StrongholdTemplatePools {
    public static final class_5321<class_3785> START = EnderscapeTemplatePools.createKey("stronghold/start");
    public static final class_5321<class_3785> SMALL_HALL_OR_UNIQUE_FALLBACK = EnderscapeTemplatePools.createKey("stronghold/small_hall_or_unique_fallback");
    public static final class_5321<class_3785> LARGE_HALL_FALLBACK = EnderscapeTemplatePools.createKey("stronghold/large_hall_fallback");

    public static void bootstrap(class_7891<class_3785> context) {
        class_7871 processors = context.method_46799(class_7924.field_41247);
        class_7871 pools = context.method_46799(class_7924.field_41249);
        class_6880.class_6883 emptyFallback = pools.method_46747(class_5468.field_26254);
        EnderscapeTemplatePools.register(context, START, new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/starting_staircase", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)1)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/silverfish_spawner_start", new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/monster_room/silverfish_spawner_start", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)1)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/large_four_way_fountain_only", new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/large_four_way_fountain", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)1)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/small_hall_into_large_hall", new class_3785((class_6880)pools.method_46747(SMALL_HALL_OR_UNIQUE_FALLBACK), StrongholdTemplatePools.multiple(StrongholdTemplatePools.getSmallHallways((class_7871<class_5497>)processors), StrongholdTemplatePools.getStaircases((class_7871<class_5497>)processors)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, SMALL_HALL_OR_UNIQUE_FALLBACK, new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/small_hall_or_unique/altar", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/small_hall_or_unique/basic", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/small_hall_or_unique/chest", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)10), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/small_hall_or_unique/iron_bars", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/small_hall_or_unique/zombie", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/large_hall_into_unique", new class_3785((class_6880)pools.method_46747(LARGE_HALL_FALLBACK), StrongholdTemplatePools.getLargeHallways((class_7871<class_5497>)processors), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/large_hall_into_unique_without_chests", new class_3785((class_6880)pools.method_46747(LARGE_HALL_FALLBACK), StrongholdTemplatePools.getLargeHallwaysWithoutChests((class_7871<class_5497>)processors), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, LARGE_HALL_FALLBACK, new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/large_hall/altar", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/large_hall/basic", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/large_hall/chest", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)10), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/large_hall/iron_bars", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/fallback/large_hall/spiral", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/unique_rooms", new class_3785((class_6880)emptyFallback, StrongholdTemplatePools.getUniqueRooms((class_7871<class_5497>)processors), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/spawner/melee", new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/spawner/zombie", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/spawner/ranged", new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/spawner/skeleton", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20)), class_3785.class_3786.field_16687));
        EnderscapeTemplatePools.register(context, "stronghold/spawner/silverfish", new class_3785((class_6880)emptyFallback, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/spawner/silverfish", StrongholdTemplatePools.getDegradation((class_7871<class_5497>)processors)), (Object)20)), class_3785.class_3786.field_16687));
    }

    private static ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> getSmallHallways(class_7871<class_5497> processors) {
        class_6880.class_6883<class_5497> degradation = StrongholdTemplatePools.getDegradation(processors);
        return ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_chest", degradation), (Object)60), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_chest_trapped", degradation), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_door", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_door_chest", degradation), (Object)60), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_door_chest_trapped", degradation), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_door_step", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_door_step_dispenser", degradation), (Object)45), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_iron_door", degradation), (Object)60), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_iron_door_chest", degradation), (Object)30), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_iron_door_chest_trapped", degradation), (Object)15), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_step", degradation), (Object)90), (Object[])new Pair[]{Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/straight_step_dispenser", degradation), (Object)45), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/turn", degradation), (Object)40), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/turn_door", degradation), (Object)40), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/turn_iron_door", degradation), (Object)20), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/t_door", degradation), (Object)40), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/t_iron_door", degradation), (Object)20), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/t_section", degradation), (Object)20)});
    }

    private static ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> getStaircases(class_7871<class_5497> processors) {
        class_6880.class_6883<class_5497> degradation = StrongholdTemplatePools.getDegradation(processors);
        return ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_left", degradation), (Object)50), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_left_chest", degradation), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_right", degradation), (Object)50), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_right_chest", degradation), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_spiral", degradation), (Object)50), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_spiral_chest_bottom", degradation), (Object)10), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_spiral_chest_top", degradation), (Object)10), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/small_hall/stairs/down_spiral_trapped", degradation), (Object)10));
    }

    private static ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> getLargeHallways(class_7871<class_5497> processors) {
        class_6880.class_6883<class_5497> degradation = StrongholdTemplatePools.getDegradation(processors);
        return ImmutableList.of((Object)Pair.of(projection -> new GuaranteedPoolElement((class_3784)class_3784.method_30435((String)"enderscape:stronghold/end_portal", (class_6880)processors.method_46747(StrongholdProcessorLists.PORTAL_ROOM_DEGRADATION)).apply(projection), Optional.empty(), 1), (Object)1), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/monster_room/fabric", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/monster_room/forge", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/monster_room/mansion", (class_6880)processors.method_46747(StrongholdProcessorLists.LIBRARY_DEGRADATION)), (Object)120), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/monster_room/silverfish_spawner", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/broken_floor", degradation), (Object)40), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_left", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_left_chests1", degradation), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_left_chests2", degradation), (Object)20), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_left_chest", degradation), (Object)60), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_right", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_right_chests1", degradation), (Object)20), (Object[])new Pair[]{Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_right_chests2", degradation), (Object)20), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_right_chest", degradation), (Object)60), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/thin", degradation), (Object)90), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/thin_chest", degradation), (Object)60)});
    }

    private static ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> getLargeHallwaysWithoutChests(class_7871<class_5497> processors) {
        class_6880.class_6883<class_5497> degradation = StrongholdTemplatePools.getDegradation(processors);
        return ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/broken_floor", degradation), (Object)40), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_left", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/split_right", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/large_hall/thin", degradation), (Object)90));
    }

    private static ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> getUniqueRooms(class_7871<class_5497> processors) {
        class_6880.class_6883<class_5497> degradation = StrongholdTemplatePools.getDegradation(processors);
        return ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/monster_room/garden", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/armory", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/aquarium", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/bedrooms", degradation), (Object)45), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/bedrooms_two_story", degradation), (Object)45), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/bridge_intersection_bottom", degradation), (Object)30), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/bridge_intersection_middle", degradation), (Object)30), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/bridge_intersection_top", degradation), (Object)30), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/lab", degradation), (Object)90), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/large_four_way", degradation), (Object)45), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/large_four_way_fountain", degradation), (Object)45), (Object)Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/large_spiral", degradation), (Object)45), (Object[])new Pair[]{Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/large_spiral_bridge", degradation), (Object)45), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/large_three_way", degradation), (Object)60), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/library", (class_6880)processors.method_46747(StrongholdProcessorLists.LIBRARY_DEGRADATION)), (Object)90), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/library_ruin", (class_6880)processors.method_46747(StrongholdProcessorLists.LIBRARY_DEGRADATION)), (Object)25), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/prison", degradation), (Object)90), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/storage_room", degradation), (Object)90), Pair.of((Object)class_3784.method_30435((String)"enderscape:stronghold/unique/tall_hall_chest", degradation), (Object)90)});
    }

    private static class_6880.class_6883<class_5497> getDegradation(class_7871<class_5497> processors) {
        return processors.method_46747(StrongholdProcessorLists.DEGRADATION);
    }

    private static ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> multiple(ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> ... lists) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableList<Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer>> list : lists) {
            builder.addAll(list);
        }
        return builder.build();
    }
}

