/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.registry.EnderscapeSoundTypes;
import net.bunten.enderscape.sound.SoundTypeOverride;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class EnderscapeSoundTypeOverrides {
    private static final EnderscapeConfig CONFIG = EnderscapeConfig.getInstance();
    public static final List<SoundTypeOverride> SOUND_TYPE_OVERRIDES = new ArrayList<SoundTypeOverride>();
    private static final List<class_2680> IGNORED_STATES = new ArrayList<class_2680>();
    private static final Map<class_2680, class_2498> SOUND_TYPE_CACHE = new IdentityHashMap<class_2680, class_2498>();

    public static Optional<class_2498> getSoundType(class_2680 state) {
        if (IGNORED_STATES.contains(state)) {
            return Optional.empty();
        }
        return Optional.ofNullable(SOUND_TYPE_CACHE.computeIfAbsent(state, s -> {
            for (SoundTypeOverride override : SOUND_TYPE_OVERRIDES) {
                if (!override.applies((class_2680)s)) continue;
                return override.getSoundType();
            }
            IGNORED_STATES.add((class_2680)s);
            return null;
        }));
    }

    public static void register(SoundTypeOverride override) {
        Objects.requireNonNull(override);
        SOUND_TYPE_OVERRIDES.add(override);
    }

    public static void register(SoundTypeOverride ... overrides) {
        for (SoundTypeOverride override : overrides) {
            EnderscapeSoundTypeOverrides.register(override);
        }
    }

    private static String getNameOf(class_2680 state) {
        return class_7923.field_41175.method_10221((Object)state.method_26204()).method_12832();
    }

    private static boolean canApplyOverride(class_2680 state, boolean condition, List<String> allowed, List<String> disallowed) {
        return EnderscapeSoundTypeOverrides.canApplyOverride(state, condition, allowed, disallowed, false);
    }

    private static boolean canApplyOverride(class_2680 state, boolean condition, List<String> allowed, List<String> disallowed, boolean requireAllAlloweds) {
        if (!condition) {
            return false;
        }
        String name = EnderscapeSoundTypeOverrides.getNameOf(state);
        for (String string : disallowed) {
            if (!name.contains(string)) continue;
            return false;
        }
        if (requireAllAlloweds) {
            for (String string : allowed) {
                if (name.contains(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : allowed) {
            if (!name.contains(string)) continue;
            return true;
        }
        return false;
    }

    static {
        Map<class_2498, Predicate<class_2680>> overrides = Map.of(EnderscapeSoundTypes.CHORUS_PLANT, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blocksSoundUpdateChorus, List.of("chorus_plant"), List.of(), true), EnderscapeSoundTypes.CHORUS_FLOWER, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blocksSoundUpdateChorus, List.of("chorus_flower"), List.of(), true), EnderscapeSoundTypes.PURPUR, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blocksSoundUpdatePurpur, List.of("purpur"), List.of("dusk")), EnderscapeSoundTypes.END_PORTAL_FRAME, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortalFrame, List.of("end_portal_frame"), List.of(), true), EnderscapeSoundTypes.END_PORTAL, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortals, List.of("end_portal"), List.of("frame"), true), EnderscapeSoundTypes.END_GATEWAY, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortals, List.of("end_gateway"), List.of(), true), EnderscapeSoundTypes.END_ROD, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blockSoundsUpdateEndRods, List.of("end_rod"), List.of(), true), EnderscapeSoundTypes.END_STONE, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndStone, List.of("end_stone"), List.of("brick", "veiled")), EnderscapeSoundTypes.END_STONE_BRICKS, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndStoneBricks, List.of("end_stone", "brick"), List.of("chiseled"), true), EnderscapeSoundTypes.SHULKER_BOX, state -> EnderscapeSoundTypeOverrides.canApplyOverride(state, EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateShulkerBoxes, List.of("shulker", "box"), List.of(), true));
        overrides.forEach((sound, condition) -> EnderscapeSoundTypeOverrides.register(new SoundTypeOverride((class_2498)sound, (Predicate<class_2680>)condition)));
    }
}

