/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.Optional;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.block.dispenser.LodestoneTeleportationDispenserBehavior;
import net.bunten.enderscape.registry.EnderscapeBiomes;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeLootTables;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistryView;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.LandPathNodeTypesRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_3962;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5633;
import net.minecraft.class_5658;
import net.minecraft.class_7;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_83;

public class EnderscapeCompatibility {
    private static final EnderscapeConfig CONFIG = EnderscapeConfig.getInstance();

    private static void addLootTableInjection(boolean allowed, class_5321<class_52> original, class_5321<class_52> injection, class_5321<class_52> key, class_52.class_53 builder) {
        if (allowed && key.equals(original)) {
            builder.method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_83.method_428(injection).method_437(1)));
        }
    }

    private static void registerAliases() {
        DynamicRegistrySetupCallback.EVENT.register(registryView -> {
            EnderscapeCompatibility.dynamicRegistryAlias(registryView, class_7924.field_41236, "magnia_crags", EnderscapeBiomes.MAGNIA_FIELDS.method_29177().method_12832());
            EnderscapeCompatibility.dynamicRegistryAlias(registryView, class_7924.field_49659, "current_nebulite_fuel", "current_fuel");
            EnderscapeCompatibility.dynamicRegistryAlias(registryView, class_7924.field_41265, "lightspeed", EnderscapeEnchantments.RESONANCE.method_29177().method_12832());
        });
        class_7923.field_41177.addAlias(Enderscape.id("driftlet"), Enderscape.id("drifter"));
        EnderscapeCompatibility.blockAndItemAlias("celestial_path_block", "celestial_path");
        EnderscapeCompatibility.blockAndItemAlias("corrupt_path_block", "corrupt_path");
        EnderscapeCompatibility.blockAndItemAlias("murublight_shelf", "murublight_bracket");
    }

    private static <T> void dynamicRegistryAlias(DynamicRegistryView view, class_5321<class_2378<T>> registry, String old_name, String new_name) {
        Optional optional = view.getOptional(registry);
        optional.ifPresent(value -> value.addAlias(Enderscape.id(old_name), Enderscape.id(new_name)));
    }

    private static void blockAndItemAlias(String previous, String current) {
        class_7923.field_41175.addAlias(Enderscape.id(previous), Enderscape.id(current));
        class_7923.field_41178.addAlias(Enderscape.id(previous), Enderscape.id(current));
    }

    private static void registerCompostables() {
        EnderscapeCompatibility.registerCompostableItem(0.1f, (class_1935)EnderscapeBlocks.VEILED_LEAF_PILE);
        EnderscapeCompatibility.registerCompostableItem(0.3f, (class_1935)EnderscapeBlocks.WISP_SPROUTS);
        EnderscapeCompatibility.registerCompostableItem(0.3f, (class_1935)EnderscapeBlocks.CELESTIAL_CAP);
        EnderscapeCompatibility.registerCompostableItem(0.3f, (class_1935)EnderscapeBlocks.CELESTIAL_GROWTH);
        EnderscapeCompatibility.registerCompostableItem(0.3f, (class_1935)class_1802.field_8233);
        EnderscapeCompatibility.registerCompostableItem(0.3f, (class_1935)EnderscapeBlocks.CORRUPT_GROWTH);
        EnderscapeCompatibility.registerCompostableItem(0.3f, (class_1935)EnderscapeBlocks.MURUBLIGHT_CAP);
        EnderscapeCompatibility.registerCompostableItem(0.3f, (class_1935)EnderscapeBlocks.VEILED_LEAVES);
        EnderscapeCompatibility.registerCompostableItem(0.5f, (class_1935)EnderscapeItems.BLINKLIGHT);
        EnderscapeCompatibility.registerCompostableItem(0.5f, (class_1935)EnderscapeBlocks.CHORUS_SPROUTS);
        EnderscapeCompatibility.registerCompostableItem(0.5f, (class_1935)EnderscapeBlocks.DRY_END_GROWTH);
        EnderscapeCompatibility.registerCompostableItem(0.5f, (class_1935)EnderscapeBlocks.WISP_GROWTH);
        EnderscapeCompatibility.registerCompostableItem(0.5f, (class_1935)EnderscapeItems.FLANGER_BERRY);
        EnderscapeCompatibility.registerCompostableItem(0.5f, (class_1935)EnderscapeBlocks.MURUBLIGHT_BRACKET);
        EnderscapeCompatibility.registerCompostableItem(0.5f, (class_1935)EnderscapeBlocks.VEILED_SAPLING);
        EnderscapeCompatibility.registerCompostableItem(0.65f, (class_1935)EnderscapeBlocks.BULB_FLOWER);
        EnderscapeCompatibility.registerCompostableItem(0.65f, (class_1935)EnderscapeBlocks.CELESTIAL_CHANTERELLE);
        EnderscapeCompatibility.registerCompostableItem(0.65f, (class_1935)EnderscapeBlocks.MURUBLIGHT_CHANTERELLE);
        EnderscapeCompatibility.registerCompostableItem(0.65f, (class_1935)EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK);
        EnderscapeCompatibility.registerCompostableItem(0.65f, (class_1935)EnderscapeBlocks.WISP_FLOWER);
    }

    private static void registerDispenserBehavior() {
        class_2315.method_10009((class_1935)EnderscapeItems.RUSTLE_BUCKET, (class_2357)new class_2347(){
            private final class_2347 defaultBehavior = new class_2347();

            public class_1799 method_10135(class_2342 source, class_1799 stack) {
                class_5633 item = (class_5633)stack.method_7909();
                class_2338 pos = source.comp_1968().method_10093((class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918));
                class_3218 level = source.comp_1967();
                if (item.method_7731(null, (class_1937)level, pos, null)) {
                    item.method_7728(null, (class_1937)level, stack, pos);
                    return this.method_60577(source, stack, new class_1799((class_1935)class_1802.field_8550));
                }
                return this.defaultBehavior.dispense(source, stack);
            }
        });
        class_2315.method_10009((class_1935)EnderscapeItems.MIRROR, (class_2357)new LodestoneTeleportationDispenserBehavior());
    }

    private static void registerFlammableBlocks() {
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.DRY_END_GROWTH, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CHORUS_SPROUTS, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.WISP_GROWTH, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.WISP_SPROUTS, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.WISP_FLOWER, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(class_2246.field_10021, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(class_2246.field_10528, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_LOG, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_WOOD, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.STRIPPED_VEILED_LOG, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.STRIPPED_VEILED_WOOD, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_PLANKS, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_SLAB, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_FENCE_GATE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_FENCE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_STAIRS, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_SAPLING, 15, 60);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_LEAVES, 30, 60);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VEILED_LEAF_PILE, 60, 20);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_STEM, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_HYPHAE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.STRIPPED_CELESTIAL_STEM, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.STRIPPED_CELESTIAL_HYPHAE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_PLANKS, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_SLAB, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_FENCE_GATE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_FENCE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_STAIRS, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_CAP, 30, 60);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_STEM, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_HYPHAE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.STRIPPED_MURUBLIGHT_STEM, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.STRIPPED_MURUBLIGHT_HYPHAE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_PLANKS, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_SLAB, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_FENCE_GATE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_FENCE, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_STAIRS, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_CAP, 30, 60);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_GROWTH, 60, 60);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.BULB_FLOWER, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.FLANGER_BERRY_VINE, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.FLANGER_BERRY_FLOWER, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.UNRIPE_FLANGER_BERRY_BLOCK, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CELESTIAL_CHANTERELLE, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_CHANTERELLE, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.CORRUPT_GROWTH, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.BLINKLIGHT_VINES_BODY, 15, 60);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.BLINKLIGHT_VINES_HEAD, 15, 60);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.MURUBLIGHT_BRACKET, 60, 100);
        FlammableBlockRegistry.getDefaultInstance().add(EnderscapeBlocks.VOID_SHALE, 5, 5);
    }

    private static void registerFuelItems() {
        FuelRegistry.INSTANCE.add((class_1935)EnderscapeBlocks.VOID_SHALE, (Object)200);
    }

    private static void registerStrippables() {
        StrippableBlockRegistry.register((class_2248)EnderscapeBlocks.VEILED_LOG, (class_2248)EnderscapeBlocks.STRIPPED_VEILED_LOG);
        StrippableBlockRegistry.register((class_2248)EnderscapeBlocks.VEILED_WOOD, (class_2248)EnderscapeBlocks.STRIPPED_VEILED_WOOD);
        StrippableBlockRegistry.register((class_2248)EnderscapeBlocks.CELESTIAL_STEM, (class_2248)EnderscapeBlocks.STRIPPED_CELESTIAL_STEM);
        StrippableBlockRegistry.register((class_2248)EnderscapeBlocks.CELESTIAL_HYPHAE, (class_2248)EnderscapeBlocks.STRIPPED_CELESTIAL_HYPHAE);
        StrippableBlockRegistry.register((class_2248)EnderscapeBlocks.MURUBLIGHT_STEM, (class_2248)EnderscapeBlocks.STRIPPED_MURUBLIGHT_STEM);
        StrippableBlockRegistry.register((class_2248)EnderscapeBlocks.MURUBLIGHT_HYPHAE, (class_2248)EnderscapeBlocks.STRIPPED_MURUBLIGHT_HYPHAE);
    }

    public static void registerCompostableItem(float chance, class_1935 item) {
        class_3962.field_17566.put((Object)item.method_8389(), chance);
    }

    static {
        EnderscapeCompatibility.registerAliases();
        EnderscapeCompatibility.registerCompostables();
        EnderscapeCompatibility.registerDispenserBehavior();
        EnderscapeCompatibility.registerFlammableBlocks();
        EnderscapeCompatibility.registerFuelItems();
        EnderscapeCompatibility.registerStrippables();
        LandPathNodeTypesRegistry.register((class_2248)EnderscapeBlocks.DRIFT_JELLY_BLOCK, (state, neighbor) -> class_7.field_17);
        LootTableEvents.MODIFY.register(Enderscape.id("inject_supplemental_loot_tables"), (key, builder, source, registries) -> EnderscapeCompatibility.addLootTableInjection(EnderscapeCompatibility.CONFIG.supplementVanillaStrongholdLibraryLoot, (class_5321<class_52>)class_39.field_683, EnderscapeLootTables.STRONGHOLD_LIBRARY_CHEST_SUPPLEMENTS, (class_5321<class_52>)key, builder));
    }
}

