/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeTrimMaterials;
import net.bunten.enderscape.registry.EnderscapeTrimPatterns;
import net.minecraft.class_1738;
import net.minecraft.class_2960;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.ResourceReference;

public final class EnderscapeAssetModifications {
    private static final List<class_2960> ARMOR_MATERIALS = List.of(class_2960.method_60656((String)"leather"), class_2960.method_60656((String)"chainmail"), class_2960.method_60656((String)"iron"), class_2960.method_60656((String)"golden"), class_2960.method_60656((String)"diamond"), class_2960.method_60656((String)"netherite"), Enderscape.id("shadoline"));

    private static void registerItemModelModification(String armorPieceType, class_2960 armorMaterial) {
        Mixson.registerEvent((int)1, (String)class_2960.method_60655((String)armorMaterial.method_12836(), (String)("models/item/" + armorMaterial.method_12832() + "_" + armorPieceType)).toString(), (String)Enderscape.id("add_trims_to_" + armorMaterial.method_12832() + "_" + armorPieceType).toString(), context -> {
            JsonObject root = ((JsonElement)context.getFile()).getAsJsonObject();
            if (root == null || !root.has("overrides")) {
                return;
            }
            JsonArray overrides = root.getAsJsonArray("overrides");
            if (overrides == null || overrides.isEmpty()) {
                return;
            }
            EnderscapeTrimMaterials.TRIM_MATERIALS.forEach((material, value) -> {
                JsonObject newCase = new JsonObject();
                JsonObject predicate = new JsonObject();
                predicate.addProperty("trim_type", (Number)value);
                newCase.add("predicate", (JsonElement)predicate);
                newCase.addProperty("model", Enderscape.id("item/" + armorMaterial.method_12832() + "_" + armorPieceType + "_" + material.method_29177().method_12832() + "_trim").toString());
                overrides.add((JsonElement)newCase);
            });
            ArrayList<JsonElement> list = new ArrayList<JsonElement>();
            for (JsonElement override : overrides) {
                list.add(override);
            }
            list.sort((a, b) -> {
                JsonObject objectA = a.getAsJsonObject();
                JsonObject objectB = b.getAsJsonObject();
                if (objectA == null || objectB == null) {
                    return 0;
                }
                JsonObject predicateA = objectA.getAsJsonObject("predicate");
                JsonObject predicateB = objectB.getAsJsonObject("predicate");
                if (predicateA == null || predicateB == null) {
                    return 0;
                }
                JsonElement trimA = predicateA.get("trim_type");
                JsonElement trimB = predicateB.get("trim_type");
                if (trimA == null || trimB == null) {
                    return 0;
                }
                return Float.compare(trimA.getAsFloat(), trimB.getAsFloat());
            });
            JsonArray sorted = new JsonArray();
            list.forEach(arg_0 -> ((JsonArray)sorted).add(arg_0));
            root.add("overrides", (JsonElement)sorted);
        }, (ResourceReference[])new ResourceReference[0]);
    }

    private static void registerTrimPatternTextures() {
        Mixson.registerEvent((int)1, (String)class_2960.method_60656((String)"atlases/armor_trims").toString(), (String)Enderscape.id("add_trim_patterns_to_armor_trims_atlas").toString(), context -> {
            JsonObject root = ((JsonElement)context.getFile()).getAsJsonObject();
            if (root == null || !root.has("sources")) {
                return;
            }
            JsonArray sources = root.getAsJsonArray("sources");
            if (sources == null || sources.isEmpty()) {
                return;
            }
            for (JsonElement element : sources) {
                String type;
                JsonObject object;
                if (!element.isJsonObject() || (object = element.getAsJsonObject()) == null || !object.has("type") || !"paletted_permutations".equals(type = object.get("type").getAsString()) && !"minecraft:paletted_permutations".equals(type)) continue;
                JsonArray textures = object.getAsJsonArray("textures");
                if (textures == null || textures.isEmpty()) {
                    return;
                }
                EnderscapeTrimPatterns.TRIM_PATTERNS.forEach(pattern -> {
                    String name = pattern.method_29177().method_12832();
                    textures.add(Enderscape.id("trims/models/armor/" + name).toString());
                    textures.add(Enderscape.id("trims/models/armor/" + name + "_leggings").toString());
                });
                break;
            }
        }, (ResourceReference[])new ResourceReference[0]);
    }

    private static void registerTrimMaterialsToAtlas(String atlasName) {
        Mixson.registerEvent((int)1, (String)class_2960.method_60656((String)("atlases/" + atlasName)).toString(), (String)Enderscape.id("add_trim_materials_to_" + atlasName + "_atlas").toString(), context -> {
            JsonObject root = ((JsonElement)context.getFile()).getAsJsonObject();
            if (root == null || !root.has("sources")) {
                return;
            }
            JsonArray sources = root.getAsJsonArray("sources");
            if (sources == null || sources.isEmpty()) {
                return;
            }
            for (JsonElement element : sources) {
                if (!element.isJsonObject()) continue;
                JsonObject object = element.getAsJsonObject();
                if (object == null || !object.has("type")) {
                    return;
                }
                String type = object.get("type").getAsString();
                if (!"paletted_permutations".equals(type) && !"minecraft:paletted_permutations".equals(type)) continue;
                JsonObject permutations = object.getAsJsonObject("permutations");
                if (permutations == null || permutations.isEmpty()) {
                    return;
                }
                EnderscapeTrimMaterials.TRIM_MATERIALS.forEach((material, value) -> {
                    String trimName = material.method_29177().method_12832();
                    permutations.addProperty(trimName, Enderscape.id("trims/color_palettes/" + trimName).toString());
                });
                break;
            }
        }, (ResourceReference[])new ResourceReference[0]);
    }

    static {
        Arrays.stream(class_1738.class_8051.values()).filter(type -> type != class_1738.class_8051.field_48838).forEach(type -> ARMOR_MATERIALS.forEach(material -> EnderscapeAssetModifications.registerItemModelModification(type.method_48400(), material)));
        EnderscapeAssetModifications.registerItemModelModification("helmet", class_2960.method_60656((String)"turtle"));
        EnderscapeAssetModifications.registerItemModelModification("leggings", Enderscape.id("drift"));
        EnderscapeAssetModifications.registerTrimMaterialsToAtlas("armor_trims");
        EnderscapeAssetModifications.registerTrimMaterialsToAtlas("blocks");
        EnderscapeAssetModifications.registerTrimPatternTextures();
    }
}

