/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.HashMap;
import java.util.Map;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.component.AttackSounds;
import net.bunten.enderscape.item.component.DashJump;
import net.bunten.enderscape.item.component.Enabled;
import net.bunten.enderscape.item.component.EntityMagnet;
import net.bunten.enderscape.particle.MagniaParticleOptions;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309 {
    @Unique
    private int Enderscape$airTicks = 0;
    @Unique
    private final Map<class_1297, Integer> Enderscape$magniaTrackedEntities = new HashMap<class_1297, Integer>();
    @Unique
    private final Map<class_1297, Integer> Enderscape$pullTickCounters = new HashMap<class_1297, Integer>();

    @Shadow
    public abstract class_1661 method_31548();

    @Shadow
    @NotNull
    public abstract class_1799 method_59958();

    protected PlayerMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void Enderscape$tick(CallbackInfo info) {
        this.Enderscape$tickMagniaAttractorItemMovement();
        int n = this.Enderscape$airTicks = !this.method_24828() && !this.method_5799() ? this.Enderscape$airTicks + 1 : 0;
        if (this.method_6128() && this.method_5715() && EnderscapeConfig.getInstance().elytraSneakToStopGliding) {
            ((class_1657)this).method_23670();
        }
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=0), index=4)
    public class_3414 Enderscape$changeKnockbackSound(class_3414 original) {
        class_1799 stack = this.method_59958();
        return !stack.method_7960() && AttackSounds.is(stack) ? (class_3414)AttackSounds.get(stack).knockback().comp_349() : original;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=1), index=4)
    public class_3414 Enderscape$changeSweepSound(class_3414 original) {
        class_1799 stack = this.method_59958();
        return !stack.method_7960() && AttackSounds.is(stack) ? (class_3414)AttackSounds.get(stack).sweep().comp_349() : original;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=2), index=4)
    public class_3414 Enderscape$changeCritSound(class_3414 original) {
        class_1799 stack = this.method_59958();
        return !stack.method_7960() && AttackSounds.is(stack) ? (class_3414)AttackSounds.get(stack).crit().comp_349() : original;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=3), index=4)
    public class_3414 Enderscape$changeStrongSound(class_3414 original) {
        class_1799 stack = this.method_59958();
        return !stack.method_7960() && AttackSounds.is(stack) ? (class_3414)AttackSounds.get(stack).strong().comp_349() : original;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=4), index=4)
    public class_3414 Enderscape$changeWeakSound(class_3414 original) {
        class_1799 stack = this.method_59958();
        return !stack.method_7960() && AttackSounds.is(stack) ? (class_3414)AttackSounds.get(stack).weak().comp_349() : original;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=5), index=4)
    public class_3414 Enderscape$changeNoDamageSound(class_3414 original) {
        class_1799 stack = this.method_59958();
        return !stack.method_7960() && AttackSounds.is(stack) ? (class_3414)AttackSounds.get(stack).noDamage().comp_349() : original;
    }

    @Unique
    private void Enderscape$tickMagniaAttractorItemMovement() {
        if (this.method_5805() && !this.method_7325() && !this.method_37908().method_8608()) {
            class_1799 stack = EntityMagnet.getFirstUsableMagnet(this.method_31548());
            if (!stack.method_7960() && Enabled.get(stack)) {
                EntityMagnet magnet = EntityMagnet.get(stack);
                class_238 totalRange = this.method_5829().method_1009((double)magnet.pullRange().field_1343, (double)magnet.pullRange().field_1342, (double)magnet.pullRange().field_1343);
                ItemStackContext context = new ItemStackContext(stack, this.method_37908(), (class_1309)((class_1657)this));
                this.method_37908().method_8390(class_1297.class, totalRange, entity -> EntityMagnet.CAN_PULL_ENTITY.test((class_1297)entity, magnet)).forEach(entity -> this.Enderscape$pullEntity(context, (class_1297)entity, magnet, EntityMagnet.abuseCost(entity, magnet)));
                this.Enderscape$magniaTrackedEntities.entrySet().removeIf(entry -> {
                    class_1297 item = (class_1297)entry.getKey();
                    int cooldown = (Integer)entry.getValue();
                    if (!totalRange.method_1006(item.method_19538())) {
                        if (cooldown >= 20) {
                            MagniaMoveable.setMovedByMagnia(item, false);
                            return true;
                        }
                        entry.setValue(cooldown + 1);
                    } else {
                        entry.setValue(0);
                    }
                    return false;
                });
            }
            this.Enderscape$pullTickCounters.entrySet().removeIf(entry -> !MagniaMoveable.wasMovedByMagnia((class_1297)entry.getKey()));
        }
    }

    @Unique
    private void Enderscape$pullEntity(ItemStackContext context, class_1297 entity, EntityMagnet magnet, int abuseCost) {
        class_3218 server;
        class_1799 stack = context.stack();
        if (!this.Enderscape$magniaTrackedEntities.containsKey(entity)) {
            if (!MagniaMoveable.wasMovedByMagnia(entity)) {
                this.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)magnet.pullEntitySound().comp_349(), entity.method_5634(), 1.0f, 1.0f);
            }
            this.Enderscape$magniaTrackedEntities.put(entity, 0);
        }
        class_243 speed = this.method_19538().method_1020(entity.method_19538()).method_1029().method_1021(entity.method_5869() ? 0.04 : 0.2);
        entity.method_18799(entity.method_18798().method_1019(speed));
        MagniaMoveable.setMovedByMagnia(entity, true);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            server = (class_3218)class_19372;
            MagniaMoveable.sendEntityEffectParticles(server, entity, MagniaParticleOptions.MAGNIA_ATTRACTOR, 0.25f);
        }
        if (abuseCost > 0) {
            if (MagniaMoveable.wasMovedByMagnia(entity)) {
                int ticks = this.Enderscape$pullTickCounters.getOrDefault(entity, 0) + 1;
                if (ticks >= 40) {
                    stack.method_7970(1, (class_1309)this, this.method_32326(stack));
                    ticks = 0;
                }
                this.Enderscape$pullTickCounters.put(entity, ticks);
            } else {
                this.Enderscape$pullTickCounters.remove(entity);
            }
        }
        if ((class_19372 = context.user()) instanceof class_3222) {
            server = (class_3222)class_19372;
            EnderscapeCriteria.PULL_ENTITY.trigger((class_3222)server, entity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tryToStartFallFlying"}, cancellable=true)
    public void Enderscape$tryToStartFallFlying(CallbackInfoReturnable<Boolean> cir) {
        if (this.Enderscape$airTicks < 1) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"startFallFlying"})
    public void Enderscape$startFallFlying(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().elytraAddOpenCloseSounds && this.method_37908().method_8608() && this.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833)) {
            this.method_5783(EnderscapeItemSounds.ELYTRA_START_GLIDING, 1.0f, class_3532.method_15344((class_5819)this.method_59922(), (float)0.8f, (float)1.2f));
        }
        this.method_37908().method_8421((class_1297)this, (byte)-68);
    }

    @Inject(at={@At(value="TAIL")}, method={"stopFallFlying"})
    public void Enderscape$stopFallFlying(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().elytraAddOpenCloseSounds && this.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833)) {
            this.method_5783(EnderscapeItemSounds.ELYTRA_STOP_GLIDING, 1.0f, class_3532.method_15344((class_5819)this.method_59922(), (float)0.8f, (float)1.2f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"jumpFromGround"})
    public void Enderscape$jumpFromGround(CallbackInfo info) {
        class_1799 stack = this.method_6030();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_19372 = (class_1657)this;
            if (class_19372 instanceof class_3222) {
                class_3222 player = (class_3222)class_19372;
                if (this.method_6115() && stack.method_57826(EnderscapeDataComponents.DASH_JUMP)) {
                    DashJump.apply(level, player, stack);
                }
            }
        }
    }
}

