/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item.crafting;

import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.registry.EnderscapeRecipeSerializers;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;

public class ToolFuelingRecipe
extends class_1852 {
    public ToolFuelingRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 level) {
        int maxFuel;
        class_1799 stack;
        int i;
        int toolIndex = -1;
        int fuel = 0;
        for (i = 0; i < input.method_59983(); ++i) {
            stack = input.method_59984(i);
            if (stack.method_7960() || !FueledTool.is(stack)) continue;
            toolIndex = i;
            break;
        }
        if (toolIndex < 0) {
            return false;
        }
        for (i = 0; i < input.method_59983(); ++i) {
            stack = input.method_59984(i);
            if (stack.method_7960() || i == toolIndex) continue;
            if (ToolFuelingRecipe.isAcceptableFuel(input, stack, toolIndex)) {
                ++fuel;
                continue;
            }
            return false;
        }
        if (fuel == 0) {
            return false;
        }
        class_1799 tool = input.method_59984(toolIndex);
        int currentFuel = FueledTool.currentFuel(tool);
        return currentFuel < (maxFuel = FueledTool.maxFuel(tool)) && fuel <= maxFuel - currentFuel;
    }

    public class_1799 assemble(class_9694 input, class_7225.class_7874 provider) {
        class_1799 stack;
        int i;
        int toolIndex = -1;
        int fuel = 0;
        for (i = 0; i < input.method_59983(); ++i) {
            stack = input.method_59984(i);
            if (stack.method_7960() || !FueledTool.is(stack)) continue;
            toolIndex = i;
            break;
        }
        if (toolIndex < 0) {
            return class_1799.field_8037;
        }
        for (i = 0; i < input.method_59983(); ++i) {
            stack = input.method_59984(i);
            if (stack.method_7960() || i == toolIndex || !ToolFuelingRecipe.isAcceptableFuel(input, stack, toolIndex)) continue;
            ++fuel;
        }
        if (fuel == 0) {
            return class_1799.field_8037;
        }
        class_1799 tool = input.method_59984(toolIndex).method_7972();
        int added = Math.min(fuel, FueledTool.maxFuel(tool) - FueledTool.currentFuel(tool));
        FueledTool.setFuel(tool, FueledTool.currentFuel(tool) + added);
        return tool;
    }

    public boolean method_8113(int i, int j) {
        return i * j >= 2;
    }

    private static boolean isAcceptableFuel(class_9694 input, class_1799 stack, int toolIndex) {
        return stack.method_31573(FueledTool.fuels(input.method_59984(toolIndex)));
    }

    public class_1865<ToolFuelingRecipe> method_8119() {
        return EnderscapeRecipeSerializers.TOOL_FUELING;
    }
}

