/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.network.EnderscapeCodecs;
import net.bunten.enderscape.registry.EnderscapeAttributes;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeMobEffects;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record StunAttack(float backstabEffectDurationMultiplier, class_241 range, class_6880<class_3414> normalSound, class_1293 effect, class_2394 particle) {
    public static final float DEFAULT_BACKSTAB_EFFECT_DURATION_MULTIPLIER = 4.0f;
    public static final class_241 DEFAULT_RANGE = new class_241(4.0f, 0.5f);
    public static final class_6880<class_3414> DEFAULT_NORMAL_SOUND = EnderscapeItemSounds.DAGGER_STUN;
    public static final class_1293 DEFAULT_EFFECT = new class_1293(EnderscapeMobEffects.STUNNED, 20);
    public static final class_2394 DEFAULT_PARTICLE = EnderscapeParticles.VOID_POOF;
    public static final Codec<StunAttack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("backstab_effect_duration_multiplier", (Object)Float.valueOf(4.0f)).forGetter(StunAttack::backstabEffectDurationMultiplier), (App)EnderscapeCodecs.VEC2.optionalFieldOf("range", (Object)DEFAULT_RANGE).forGetter(StunAttack::range), (App)class_3414.field_41699.optionalFieldOf("normal_sound", DEFAULT_NORMAL_SOUND).forGetter(StunAttack::normalSound), (App)class_1293.field_48821.optionalFieldOf("effect", (Object)DEFAULT_EFFECT).forGetter(StunAttack::effect), (App)class_2398.field_25125.optionalFieldOf("particle", (Object)DEFAULT_PARTICLE).forGetter(StunAttack::particle)).apply((Applicative)instance, StunAttack::new));
    public static final class_9139<class_9129, StunAttack> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48552, StunAttack::backstabEffectDurationMultiplier, EnderscapeCodecs.VEC2_STREAM, StunAttack::range, (class_9139)class_3414.field_48279, StunAttack::normalSound, (class_9139)class_1293.field_49207, StunAttack::effect, (class_9139)class_2398.field_48456, StunAttack::particle, StunAttack::new);
    public static final StunAttack DEFAULT = new StunAttack(4.0f, DEFAULT_RANGE, DEFAULT_NORMAL_SOUND, DEFAULT_EFFECT, DEFAULT_PARTICLE);

    public static boolean is(class_1799 stack) {
        return stack.method_57826(EnderscapeDataComponents.STUN_ATTACK);
    }

    public static StunAttack get(class_1799 stack) {
        return (StunAttack)stack.method_57824(EnderscapeDataComponents.STUN_ATTACK);
    }

    public static boolean apply(class_3218 level, class_1309 attacker, class_1309 victim, class_1799 stack) {
        ItemStackContext context = new ItemStackContext(stack, (class_1937)level, attacker);
        StunAttack attack = StunAttack.get(stack);
        if (StunAttack.canStun(attacker, context)) {
            class_3222 player;
            boolean backstab = stack.method_57826(EnderscapeDataComponents.BACKSTAB_ANGLE) && EnderscapeAttributes.isBackstab(stack, context.user().method_19538(), (class_1297)victim);
            List<class_1309> affectedEntities = List.of(victim);
            StunAttack.doSingularStun(context, victim, attack, backstab);
            if (attacker instanceof class_3222) {
                player = (class_3222)attacker;
                EnderscapeCriteria.STUN_ATTACK.trigger(player, stack, victim, affectedEntities, backstab);
            }
            stack.method_7970(10, attacker, attacker.method_32326(stack));
            stack.method_7910((class_1937)level, attacker);
            if (attacker instanceof class_1657) {
                player = (class_1657)attacker;
                player.method_7357().method_7906(stack.method_7909(), 140);
            }
            return true;
        }
        return false;
    }

    private static boolean canStun(class_1309 attacker, ItemStackContext context) {
        class_1799 stack = context.stack();
        boolean notOnCooldown = !(attacker instanceof class_1657) || !((class_1657)attacker).method_7357().method_7904(stack.method_7909());
        boolean hasFuel = !FueledTool.is(stack) || FueledTool.fuelExceedsCost(context);
        return notOnCooldown && hasFuel;
    }

    private static void doSingularStun(ItemStackContext context, class_1309 victim, StunAttack attack, boolean backstab) {
        class_1309 attacker = context.user();
        context.serverLevel().method_60511(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), attack.normalSound(), attacker.method_5634(), 1.0f, 1.0f);
        StunAttack.stun(context, victim, attack, backstab);
    }

    private static void stun(ItemStackContext context, class_1309 victim, StunAttack attack, boolean backstab) {
        class_243 pos = victim.method_19538();
        class_1293 effect = attack.effect();
        if (effect != null) {
            float multiplier = backstab ? attack.backstabEffectDurationMultiplier() : 1.0f;
            int duration = (int)((float)effect.method_5584() * multiplier);
            victim.method_37222(new class_1293(effect.method_5579(), duration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()), (class_1297)context.user());
        }
        context.serverLevel().method_14199(attack.particle(), pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 15, 1.0, 1.0, 1.0, 0.1);
    }
}

