/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.LodestoneTeleportationCheck;
import net.bunten.enderscape.item.LodestoneTrackerContext;
import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.item.component.value.LodestoneTeleportationCost;
import net.bunten.enderscape.item.component.value.LodestoneTeleportationSounds;
import net.bunten.enderscape.item.component.value.LodestoneTeleportationVisuals;
import net.bunten.enderscape.network.ClientboundTransdimensionalTravelSoundPayload;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeEnchantmentEffectComponents;
import net.bunten.enderscape.registry.EnderscapeServerNetworking;
import net.bunten.enderscape.registry.EnderscapeStats;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4208;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableFloat;

public record LodestoneTeleportation(boolean nameHasPrefix, boolean allowsTransdimensionalByDefault, LodestoneTeleportationCost cost, LodestoneTeleportationVisuals visuals, LodestoneTeleportationSounds sounds) {
    public static final boolean DEFAULT_NAME_HAS_PREFIX = false;
    public static final boolean DEFAULT_ALLOWS_TRANSDIMENSIONAL_BY_DEFAULT = false;
    public static final Codec<LodestoneTeleportation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("name_has_prefix", (Object)false).forGetter(LodestoneTeleportation::nameHasPrefix), (App)Codec.BOOL.optionalFieldOf("allows_transdimensional_by_default", (Object)false).forGetter(LodestoneTeleportation::allowsTransdimensionalByDefault), (App)LodestoneTeleportationCost.CODEC.optionalFieldOf("cost", (Object)LodestoneTeleportationCost.DEFAULT).forGetter(LodestoneTeleportation::cost), (App)LodestoneTeleportationVisuals.CODEC.optionalFieldOf("visuals", (Object)LodestoneTeleportationVisuals.DEFAULT).forGetter(LodestoneTeleportation::visuals), (App)LodestoneTeleportationSounds.CODEC.optionalFieldOf("sounds", (Object)LodestoneTeleportationSounds.DEFAULT).forGetter(LodestoneTeleportation::sounds)).apply((Applicative)instance, LodestoneTeleportation::new));
    public static final class_9139<class_9129, LodestoneTeleportation> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48547, LodestoneTeleportation::nameHasPrefix, (class_9139)class_9135.field_48547, LodestoneTeleportation::allowsTransdimensionalByDefault, LodestoneTeleportationCost.STREAM_CODEC, LodestoneTeleportation::cost, LodestoneTeleportationVisuals.STREAM_CODEC, LodestoneTeleportation::visuals, LodestoneTeleportationSounds.STREAM_CODEC, LodestoneTeleportation::sounds, LodestoneTeleportation::new);
    public static final LodestoneTeleportation DEFAULT = new LodestoneTeleportation(false, false, LodestoneTeleportationCost.DEFAULT, LodestoneTeleportationVisuals.DEFAULT, LodestoneTeleportationSounds.DEFAULT);

    public static boolean is(class_1799 stack) {
        return stack.method_57826(EnderscapeDataComponents.LODESTONE_TELEPORTATION);
    }

    public static LodestoneTeleportation get(class_1799 stack) {
        return (LodestoneTeleportation)stack.method_57824(EnderscapeDataComponents.LODESTONE_TELEPORTATION);
    }

    public static void inventoryTick(class_1799 stack, class_3218 level) {
        LodestoneTeleportation.updateLodestoneTracker(stack, (class_1937)level);
    }

    public static void updateLodestoneTracker(class_1799 stack, class_1937 level) {
        if (level instanceof class_3218) {
            class_9291 tracker;
            class_9291 ticked;
            class_3218 server = (class_3218)level;
            if (stack.method_57826(class_9334.field_49614) && (ticked = (tracker = (class_9291)stack.method_57824(class_9334.field_49614)).method_58115(server)) != tracker) {
                stack.method_57379(class_9334.field_49614, (Object)ticked);
            }
        }
    }

    public static boolean isLinked(class_1799 stack) {
        return LodestoneTeleportation.wasLinkedBefore(stack) && ((class_9291)stack.method_57824(class_9334.field_49614)).comp_2402().isPresent();
    }

    public static int fuelCost(ItemStackContext context) {
        class_1799 stack = context.stack();
        class_1309 user = context.user();
        LodestoneTrackerContext tracker = LodestoneTrackerContext.of(context);
        if (FueledTool.is(stack) && user != null) {
            if (tracker.dimension() != tracker.linkedDimension()) {
                return FueledTool.maxFuel(stack);
            }
            if (LodestoneTeleportation.get(stack).cost().increaseWithDistance()) {
                return 1 + LodestoneTeleportation.distanceBetweenPoints(user.method_24515(), tracker.linkedPos()) / LodestoneTeleportation.getTotalDistanceForCostIncrease(context);
            }
            return 1;
        }
        return 0;
    }

    public static boolean hideInvalidOutlineWhen(ItemStackContext context) {
        LodestoneTrackerContext tracker = LodestoneTrackerContext.of(context);
        boolean isLinked = LodestoneTeleportation.isLinked(context.stack());
        boolean exceedsCost = FueledTool.fuelExceedsCost(context);
        boolean sameDimension = LodestoneTeleportation.isSameDimension(tracker, tracker.linkedDimension());
        return isLinked && exceedsCost && (sameDimension || LodestoneTeleportation.isTransdimensionalAllowed(tracker) && LodestoneTeleportation.isSameCoordinateScale(tracker));
    }

    public static boolean isTransdimensionalAllowed(LodestoneTrackerContext tracker) {
        class_1799 stack = tracker.stack();
        if (LodestoneTeleportation.is(stack)) {
            LodestoneTeleportation teleportation = LodestoneTeleportation.get(stack);
            return teleportation.allowsTransdimensionalByDefault() || LodestoneTeleportation.isTransdimensionalAdditionallyAllowed(tracker.stack(), tracker.user());
        }
        throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.LODESTONE_TELEPORTATION));
    }

    public static boolean wasLinkedBefore(class_1799 stack) {
        return stack.method_57826(class_9334.field_49614);
    }

    public static boolean isFoil(class_1799 stack) {
        return LodestoneTeleportation.wasLinkedBefore(stack);
    }

    public static class_2561 getName(class_1799 stack, class_2561 original) {
        if (LodestoneTeleportation.isLinked(stack) && stack.method_57826(EnderscapeDataComponents.LODESTONE_TELEPORTATION) && ((LodestoneTeleportation)stack.method_57824(EnderscapeDataComponents.LODESTONE_TELEPORTATION)).nameHasPrefix()) {
            return class_2561.method_43469((String)"item.enderscape.lodestone_teleportation.linked_prefix", (Object[])new Object[]{class_2561.method_43471((String)stack.method_7909().method_7876())});
        }
        return original;
    }

    public static boolean useOn(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);
        class_1799 stack = context.method_8041();
        if (LodestoneTeleportation.is(stack) && state.method_27852(class_2246.field_23261)) {
            LodestoneTeleportation.writeData(stack, pos, (class_5321<class_1937>)context.method_8045().method_27983());
            level.method_8396(null, pos, (class_3414)LodestoneTeleportation.get(stack).sounds().link().comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static void writeData(class_1799 stack, class_2338 pos, class_5321<class_1937> dimension) {
        stack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.of(class_4208.method_19443(dimension, (class_2338)pos)), true));
    }

    public static class_1271<class_1799> use(class_1937 level, class_1657 player, class_1268 hand) {
        LodestoneTrackerContext context = new LodestoneTrackerContext(player.method_5998(hand), level, (class_1309)player);
        for (LodestoneTeleportationCheck check : LodestoneTeleportationCheck.CHECKS_IN_ORDER) {
            if (!check.fails(context)) continue;
            return check.getFailureResult(context);
        }
        return LodestoneTeleportation.teleport(context, false) ? class_1271.method_22427((Object)player.method_5998(hand)) : LodestoneTeleportationCheck.TELEPORT_POSITION_IS_SAFE.getFailureResult(context);
    }

    public static boolean teleport(LodestoneTrackerContext context, boolean fromDispenser) {
        block2: {
            class_243 position;
            boolean sameDimension;
            class_4208 destination;
            class_4208 prior;
            block4: {
                class_1309 user;
                block3: {
                    user = context.user();
                    prior = new class_4208(context.dimension(), user.method_23312());
                    destination = new class_4208(context.linkedDimension(), context.linkedPos());
                    Optional<class_243> optional = LodestoneTeleportation.getTeleportPosition(context);
                    sameDimension = LodestoneTeleportation.isSameDimension(context, (class_5321<class_1937>)destination.comp_2207());
                    if (!optional.isPresent()) break block2;
                    position = optional.get();
                    class_1309 class_13092 = context.user();
                    if (!(class_13092 instanceof class_1657)) break block3;
                    class_1657 player = (class_1657)class_13092;
                    if (player.method_31549().field_7477 && !fromDispenser) break block4;
                }
                context.stack().method_7970(1, user, user.method_32326(context.stack()));
            }
            LodestoneTeleportation.doPreTeleportEffects(context, prior.comp_2208().method_46558(), !sameDimension);
            LodestoneTeleportation.teleportToLocation(context, class_2338.method_49638((class_2374)position), !sameDimension);
            LodestoneTeleportation.awardStatistics(context, prior, destination, fromDispenser);
            return true;
        }
        return false;
    }

    public static Optional<class_243> getTeleportPosition(LodestoneTrackerContext context) {
        class_3218 level = context.linkedLevel();
        class_1309 user = context.user();
        class_4048 dimensions = user.method_18377(class_4050.field_18076);
        class_243 offsetPos = context.linkedPos().method_10084().method_61082().method_1031(0.0, (double)dimensions.comp_2186() / 2.0, 0.0);
        class_265 shape = class_259.method_1078((class_238)class_238.method_30048((class_243)offsetPos, (double)(dimensions.comp_2185() + 1.0f), (double)(dimensions.comp_2186() + 1.0f), (double)(dimensions.comp_2185() + 1.0f)).method_1014(1.0E-6));
        Optional freePos = level.method_33594((class_1297)user, shape, offsetPos, (double)dimensions.comp_2185(), (double)dimensions.comp_2186(), (double)dimensions.comp_2185());
        if (freePos.isPresent()) {
            class_243 pos = (class_243)freePos.get();
            class_2338.class_2339 mutable = class_2338.method_49638((class_2374)pos).method_25503();
            for (int i = 0; i < 8; ++i) {
                if (level.method_8320(mutable.method_10074()).method_26206((class_1922)level, (class_2338)mutable, class_2350.field_11036)) {
                    return Optional.of(class_243.method_24954((class_2382)mutable));
                }
                mutable.method_10098(class_2350.field_11033);
            }
        }
        return Optional.empty();
    }

    public static boolean isSameDimension(LodestoneTrackerContext context, class_5321<class_1937> dimension) {
        return context.dimension() == dimension;
    }

    private static void doPreTeleportEffects(LodestoneTrackerContext context, class_243 priorVec3, boolean sameDimension) {
        LodestoneTeleportation teleportation = LodestoneTeleportation.get(context.stack());
        class_1309 user = context.user();
        user.method_5848();
        user.field_6017 = 0.0f;
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            if (user.method_6128()) {
                player.method_23670();
            }
            EnderscapeServerNetworking.sendLodestoneTeleportationInfoPayload(player, sameDimension, teleportation.visuals());
        }
        context.serverLevel().method_14199(teleportation.visuals().teleportOutParticle(), priorVec3.field_1352, priorVec3.field_1351 + 0.5, priorVec3.field_1350, 50, 0.5, 1.0, 0.5, 0.1);
    }

    private static void teleportToLocation(LodestoneTrackerContext context, class_2338 destination, boolean transdimensional) {
        LodestoneTeleportation teleportation = LodestoneTeleportation.get(context.stack());
        class_3218 level = context.linkedLevel();
        class_243 pos = destination.method_61082();
        class_1309 user = context.user();
        user.method_48105(level, pos.field_1352, pos.field_1351, pos.field_1350, Set.of(), 0.0f, 0.0f);
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            if (transdimensional) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundTransdimensionalTravelSoundPayload(((class_3414)teleportation.sounds().transdimensionalTravel().comp_349()).method_14833()));
            }
        }
        level.method_14199(teleportation.visuals().teleportInParticle(), pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 50, 0.5, 1.0, 0.5, 0.1);
        level.method_60511(null, pos.field_1352, pos.field_1351, pos.field_1350, teleportation.sounds().teleportSuccess(), user.method_5634(), 0.65f, 1.0f);
        level.method_32888((class_6880)class_5712.field_39446, user.method_19538(), class_5712.class_7397.method_43285((class_1297)user));
    }

    private static void awardStatistics(LodestoneTrackerContext context, class_4208 prior, class_4208 destination, boolean fromDispenser) {
        class_1309 class_13092 = context.user();
        if (class_13092 instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            if (!player.method_31549().field_7477 || fromDispenser) {
                player.method_7357().method_7906(context.stack().method_7909(), 100);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)context.stack().method_7909()));
            player.method_7281(EnderscapeStats.MIRROR_TELEPORT);
            double distance = Math.sqrt(Math.pow(destination.comp_2208().method_10263() - prior.comp_2208().method_10263(), 2.0) + Math.pow(destination.comp_2208().method_10260() - prior.comp_2208().method_10260(), 2.0));
            int centimeterDistance = Math.round((float)distance * 100.0f);
            if (centimeterDistance > 0) {
                player.method_7339(EnderscapeStats.MIRROR_ONE_CM, centimeterDistance);
            }
            EnderscapeCriteria.LODESTONE_TELEPORTATION.trigger(player, context.stack(), prior, destination);
        }
    }

    public static boolean isSameCoordinateScale(LodestoneTrackerContext tracker) {
        class_7225.class_7226 registry = tracker.level().method_30349().method_46762(class_7924.field_41241);
        class_5321 beginning = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)tracker.dimension().method_29177());
        class_5321 linked = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)tracker.linkedDimension().method_29177());
        return class_2874.method_31109((class_2874)((class_2874)((class_6880.class_6883)registry.method_46746(beginning).get()).comp_349()), (class_2874)((class_2874)((class_6880.class_6883)registry.method_46746(linked).get()).comp_349())) == 1.0;
    }

    private static int getTotalDistanceForCostIncrease(ItemStackContext context) {
        class_1799 stack = context.stack();
        if (LodestoneTeleportation.is(stack)) {
            LodestoneTeleportation teleportation = LodestoneTeleportation.get(stack);
            return (int)LodestoneTeleportation.getAddedDistanceToIncreaseCost(stack, context.user(), teleportation.cost.distanceToIncrease());
        }
        throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.LODESTONE_TELEPORTATION));
    }

    public static float getAddedDistanceToIncreaseCost(class_1799 stack, class_1309 user, float distanceToIncreaseCost) {
        MutableFloat mutable = new MutableFloat(distanceToIncreaseCost);
        class_1890.method_8220((class_1799)stack, (holder, i) -> ((class_1887)holder.comp_349()).method_60506(EnderscapeEnchantmentEffectComponents.LODESTONE_TELEPORTATION_DISTANCE_TO_INCREASE_COST, user.method_59922(), i, mutable));
        return Math.max(0.0f, mutable.floatValue());
    }

    public static boolean isTransdimensionalAdditionallyAllowed(class_1799 stack, class_1309 user) {
        MutableFloat mutable = new MutableFloat(0.0f);
        class_1890.method_8220((class_1799)stack, (holder, i) -> ((class_1887)holder.comp_349()).method_60506(EnderscapeEnchantmentEffectComponents.LODESTONE_TELEPORTATION_ENABLE_TRANSDIMENSIONAL, user.method_59922(), i, mutable));
        return mutable.floatValue() > 0.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public static void appendHoverText(class_1799 stack, List<class_2561> list) {
        class_310 client = class_310.method_1551();
        EnderscapeConfig config = EnderscapeConfig.getInstance();
        LodestoneTrackerContext context = new LodestoneTrackerContext(stack, (class_1937)client.field_1687, (class_1309)client.field_1724);
        if (LodestoneTeleportation.is(stack) && LodestoneTeleportation.isLinked(stack) && config.mirrorTooltipEnabled) {
            LodestoneTeleportation teleportation = LodestoneTeleportation.get(stack);
            class_124 headerColor = class_124.field_1080;
            class_124 infoColor = class_124.field_1063;
            class_124 valueColor = class_124.field_1078;
            if (!config.mirrorTooltipShiftToDisplay || class_437.method_25442()) {
                class_2338 user = context.user().method_24515();
                class_2338 linkedPos = context.linkedPos();
                class_5321<class_1937> linkedDimension = context.linkedDimension();
                list.add((class_2561)LodestoneTeleportation.tooltip("header", new Object[0]).method_27692(headerColor));
                if (config.mirrorTooltipDisplayCoordinates) {
                    class_5250 position = LodestoneTeleportation.tooltip("position.coordinates", linkedPos.method_10263(), linkedPos.method_10264(), linkedPos.method_10260()).method_27692(valueColor);
                    class_5250 unknown = LodestoneTeleportation.tooltip("position.unknown", new Object[0]).method_27692(valueColor);
                    class_5250 component = LodestoneTeleportation.tooltip("position", LodestoneTeleportation.isSameDimension(context, linkedDimension) ? position : unknown);
                    list.add((class_2561)class_5244.method_48320().method_10852((class_2561)component.method_27692(infoColor)));
                }
                if (config.mirrorTooltipDisplayDistance) {
                    float step = (float)teleportation.cost().distanceToIncrease() / 2.0f;
                    int roundedDistance = (int)((float)Math.round((float)LodestoneTeleportation.distanceBetweenPoints(user, linkedPos) / step) * step);
                    class_5250 approximate = LodestoneTeleportation.tooltip("distance.approximate_value", roundedDistance).method_27692(valueColor);
                    class_5250 unknown = LodestoneTeleportation.tooltip("distance.unknown", new Object[0]).method_27692(valueColor);
                    class_5250 component = LodestoneTeleportation.tooltip("distance", LodestoneTeleportation.isSameDimension(context, linkedDimension) ? approximate : unknown);
                    list.add((class_2561)class_5244.method_48320().method_10852((class_2561)component.method_27692(infoColor)));
                }
                if (config.mirrorTooltipDisplayDimension) {
                    class_5250 dimension = class_2561.method_43471((String)class_156.method_646((String)"dimension", (class_2960)linkedDimension.method_29177())).method_27692(valueColor);
                    class_5250 component = LodestoneTeleportation.tooltip("dimension", dimension);
                    list.add((class_2561)class_5244.method_48320().method_10852((class_2561)component.method_27692(infoColor)));
                }
            } else {
                list.add((class_2561)LodestoneTeleportation.tooltip("unshifted", new Object[0]).method_27692(headerColor));
            }
        }
    }

    private static class_5250 tooltip(String name, Object ... objects) {
        return class_2561.method_43469((String)("item.enderscape.lodestone_teleportation.desc." + name), (Object[])objects);
    }

    private static int distanceBetweenPoints(class_2338 pos, class_2338 pos2) {
        float x = pos.method_10263() - pos2.method_10263();
        float z = pos.method_10260() - pos2.method_10260();
        return (int)class_3532.method_15355((float)(x * x + z * z));
    }
}

