/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.component.Enabled;
import net.bunten.enderscape.item.component.LodestoneTeleportation;
import net.bunten.enderscape.item.component.ThresholdCounter;
import net.bunten.enderscape.item.component.value.FuelDisplay;
import net.bunten.enderscape.item.component.value.FuelHud;
import net.bunten.enderscape.item.component.value.FuelSounds;
import net.bunten.enderscape.item.component.value.FuelTooltip;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5699;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FueledTool(class_6862<class_1792> fuels, int maximumFuel, int fuelPerUse, FuelDisplay display, FuelSounds sounds) {
    public static final class_6862<class_1792> DEFAULT_FUELS = EnderscapeItemTags.NEBULITE_TOOL_FUELS;
    public static final int DEFAULT_FUEL_PER_USE = 1;
    public static final FuelDisplay DEFAULT_FUEL_DISPLAY = FuelDisplay.DEFAULT;
    public static final FuelSounds DEFAULT_FUEL_SOUNDS = FuelSounds.DEFAULT;
    public static final Codec<FueledTool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("fuels", DEFAULT_FUELS).forGetter(FueledTool::fuels), (App)class_5699.field_33442.fieldOf("maximum_fuel").forGetter(FueledTool::maximumFuel), (App)class_5699.field_33442.optionalFieldOf("fuel_per_use", (Object)1).forGetter(FueledTool::fuelPerUse), (App)FuelDisplay.CODEC.optionalFieldOf("display", (Object)DEFAULT_FUEL_DISPLAY).forGetter(FueledTool::display), (App)FuelSounds.CODEC.optionalFieldOf("sounds", (Object)DEFAULT_FUEL_SOUNDS).forGetter(FueledTool::sounds)).apply((Applicative)instance, FueledTool::new));
    public static final class_9139<class_9129, FueledTool> STREAM_CODEC = class_9139.method_56906(FueledTool.streamCodec(class_7924.field_41197), FueledTool::fuels, (class_9139)class_9135.field_49675, FueledTool::maximumFuel, (class_9139)class_9135.field_49675, FueledTool::fuelPerUse, FuelDisplay.STREAM_CODEC, FueledTool::display, FuelSounds.STREAM_CODEC, FueledTool::sounds, FueledTool::new);

    public static <T> class_9139<ByteBuf, class_6862<T>> streamCodec(class_5321<? extends class_2378<T>> key) {
        return class_2960.field_48267.method_56432(location -> class_6862.method_40092((class_5321)key, (class_2960)location), class_6862::comp_327);
    }

    public static FueledTool simple(int maximumFuel) {
        return Builder.create(maximumFuel).build();
    }

    public static boolean is(class_1799 stack) {
        return stack.method_57826(EnderscapeDataComponents.FUELED_TOOL);
    }

    public static FueledTool get(class_1799 stack) {
        return (FueledTool)stack.method_57824(EnderscapeDataComponents.FUELED_TOOL);
    }

    public static int currentFuel(class_1799 stack) {
        return stack.method_57826(EnderscapeDataComponents.CURRENT_FUEL) ? Math.max(0, (Integer)stack.method_57824(EnderscapeDataComponents.CURRENT_FUEL)) : 0;
    }

    public static void setFuel(class_1799 stack, int value) {
        if (!FueledTool.is(stack)) {
            throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.FUELED_TOOL));
        }
        stack.method_57379(EnderscapeDataComponents.CURRENT_FUEL, (Object)class_3532.method_15340((int)value, (int)0, (int)FueledTool.get(stack).maximumFuel()));
    }

    public static int maxFuel(class_1799 stack) {
        if (FueledTool.is(stack)) {
            return Math.max(0, FueledTool.get(stack).maximumFuel());
        }
        throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.FUELED_TOOL));
    }

    public static class_6862<class_1792> fuels(class_1799 stack) {
        return FueledTool.get(stack).fuels();
    }

    public static FuelHud hud(class_1799 stack) {
        return FueledTool.get(stack).display().hud();
    }

    public static FuelTooltip tooltip(class_1799 stack) {
        return FueledTool.get(stack).display().tooltip();
    }

    public static boolean tryFuel(class_1799 stack, class_1799 other, class_5536 action, class_1657 player) {
        return FueledTool.tryFuelOnce(stack, other, action, player) || FueledTool.tryFuelCompletely(other, stack, action, player);
    }

    public static boolean tryFuelOnce(class_1799 fueled, class_1799 fuel, class_5536 action, class_1657 player) {
        if (action == class_5536.field_27013 && FueledTool.is(fueled) && fuel.method_31573(FueledTool.fuels(fueled))) {
            FueledTool tool = FueledTool.get(fueled);
            if (FueledTool.currentFuel(fueled) < FueledTool.maxFuel(fueled)) {
                FueledTool.setFuel(fueled, FueledTool.currentFuel(fueled) + 1);
                fuel.method_7934(1);
                player.method_5783((class_3414)tool.sounds().addFuel().comp_349(), 1.0f, 1.0f);
                player.method_32876((class_6880)class_5712.field_28146);
            } else {
                player.method_5783((class_3414)tool.sounds().fuelFull().comp_349(), 1.0f, 1.0f);
                player.method_32876((class_6880)class_5712.field_28146);
            }
            return true;
        }
        return false;
    }

    public static boolean tryFuelCompletely(class_1799 fueled, class_1799 fuel, class_5536 action, class_1657 player) {
        if (action == class_5536.field_27013 && FueledTool.is(fueled) && fuel.method_31573(FueledTool.fuels(fueled))) {
            FueledTool tool = FueledTool.get(fueled);
            if (FueledTool.currentFuel(fueled) < FueledTool.maxFuel(fueled)) {
                int added = Math.min(fuel.method_7947(), FueledTool.maxFuel(fueled) - FueledTool.currentFuel(fueled));
                FueledTool.setFuel(fueled, FueledTool.currentFuel(fueled) + added);
                fuel.method_7934(added);
                player.method_5783((class_3414)tool.sounds().addFuel().comp_349(), 1.0f, 1.0f);
                player.method_32876((class_6880)class_5712.field_28146);
            } else {
                player.method_5783((class_3414)tool.sounds().fuelFull().comp_349(), 1.0f, 1.0f);
                player.method_32876((class_6880)class_5712.field_28146);
            }
            return true;
        }
        return false;
    }

    public static int fuelCost(ItemStackContext context) {
        class_1799 stack = context.stack();
        if (FueledTool.is(stack)) {
            if (LodestoneTeleportation.isLinked(stack)) {
                return LodestoneTeleportation.fuelCost(context);
            }
            return FueledTool.get(stack).fuelPerUse();
        }
        throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.FUELED_TOOL));
    }

    public static boolean useFuel(ItemStackContext context) {
        class_1799 stack = context.stack();
        if (FueledTool.is(stack)) {
            boolean hasCounter = ThresholdCounter.is(stack);
            if (hasCounter) {
                ThresholdCounter.increment(stack, 1);
            }
            if (!hasCounter || ThresholdCounter.pastThreshold(context.serverLevel(), stack)) {
                FueledTool.setFuel(stack, FueledTool.currentFuel(stack) - FueledTool.fuelCost(context));
                if (hasCounter) {
                    ThresholdCounter.set(stack, 0);
                }
                if (Enabled.is(stack)) {
                    Enabled.set(stack, true);
                }
                class_1309 user = context.user();
                class_6880<class_3414> useFuelSound = FueledTool.get(stack).sounds().useFuel();
                if (useFuelSound.comp_349() != class_3417.field_42593 && user != null) {
                    context.level().method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_3414)useFuelSound.comp_349(), user.method_5634(), 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean fuelExceedsCost(ItemStackContext context) {
        class_1799 stack = context.stack();
        if (FueledTool.is(stack)) {
            return FueledTool.currentFuel(stack) >= FueledTool.fuelCost(context);
        }
        return true;
    }

    public static class Builder {
        private class_6862<class_1792> fuels = DEFAULT_FUELS;
        private int maximumFuel;
        private int fuelPerUse = 1;
        private FuelDisplay.Builder fuelDisplayBuilder = FuelDisplay.Builder.create();
        private FuelSounds.Builder fuelSoundsBuilder = FuelSounds.Builder.create();

        public static Builder create(int maximumFuel) {
            Builder builder = new Builder();
            builder.maximumFuel = maximumFuel;
            return builder;
        }

        public Builder fuels(class_6862<class_1792> fuels) {
            this.fuels = fuels;
            return this;
        }

        public Builder fuelPerUse(int fuelPerUse) {
            this.fuelPerUse = fuelPerUse;
            return this;
        }

        public Builder fuelDisplay(FuelDisplay.Builder fuelDisplayBuilder) {
            this.fuelDisplayBuilder = fuelDisplayBuilder;
            return this;
        }

        public Builder fuelSounds(FuelSounds.Builder fuelSoundsBuilder) {
            this.fuelSoundsBuilder = fuelSoundsBuilder;
            return this;
        }

        public FueledTool build() {
            return new FueledTool(this.fuels, this.maximumFuel, this.fuelPerUse, this.fuelDisplayBuilder.build(), this.fuelSoundsBuilder.build());
        }
    }
}

