/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.component.Enabled;
import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.network.EnderscapeCodecs;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeEnchantmentEffectComponents;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.tag.EnderscapeEntityTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_5537;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableFloat;

public record EntityMagnet(class_6862<class_1299<?>> entitiesToPull, class_6862<class_1299<?>> exemptFromAbuseCost, boolean canDepositIntoBundlesByDefault, class_241 pullRange, class_6880<class_3414> pullEntitySound) {
    public static final BiPredicate<class_1297, EntityMagnet> CAN_PULL_ENTITY = (entity, magnet) -> {
        if (entity.method_5864().method_20210(magnet.entitiesToPull())) {
            if (entity instanceof class_1542) {
                class_1542 item = (class_1542)entity;
                return !item.method_6977();
            }
            return entity.field_6012 >= 20;
        }
        return false;
    };
    public static final class_6862<class_1299<?>> DEFAULT_ENTITIES_TO_PULL = EnderscapeEntityTags.PULLED_BY_MAGNIA_ATTRACTOR;
    public static final class_6862<class_1299<?>> DEFAULT_EXEMPT_FROM_ABUSE_COST = EnderscapeEntityTags.EXEMPT_FROM_MAGNIA_ATTRACTOR_ABUSE_COST;
    public static final boolean DEFAULT_CAN_DEPOSIT_INTO_BUNDLES_BY_DEFAULT = false;
    public static final class_241 DEFAULT_PULL_RANGE = new class_241(10.0f, 4.0f);
    public static final class_6880.class_6883<class_3414> DEFAULT_USE_FUEL_SOUND = EnderscapeItemSounds.MAGNIA_ATTRACTOR_USE_FUEL;
    public static final class_6880.class_6883<class_3414> DEFAULT_PULL_ENTITY_SOUND = EnderscapeItemSounds.MAGNIA_ATTRACTOR_MOVE;
    public static final Codec<EntityMagnet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41266).optionalFieldOf("entities_to_pull", DEFAULT_ENTITIES_TO_PULL).forGetter(EntityMagnet::entitiesToPull), (App)class_6862.method_40090((class_5321)class_7924.field_41266).optionalFieldOf("exempt_from_abuse_cost", DEFAULT_EXEMPT_FROM_ABUSE_COST).forGetter(EntityMagnet::exemptFromAbuseCost), (App)Codec.BOOL.optionalFieldOf("can_deposit_into_bundles_by_default", (Object)false).forGetter(EntityMagnet::canDepositIntoBundlesByDefault), (App)EnderscapeCodecs.VEC2.optionalFieldOf("pull_range", (Object)DEFAULT_PULL_RANGE).forGetter(EntityMagnet::pullRange), (App)class_3414.field_41699.optionalFieldOf("pull_entity_sound", DEFAULT_PULL_ENTITY_SOUND).forGetter(EntityMagnet::pullEntitySound)).apply((Applicative)instance, EntityMagnet::new));
    public static final class_9139<class_9129, EntityMagnet> STREAM_CODEC = class_9139.method_56906(EntityMagnet.streamCodec(class_7924.field_41266), EntityMagnet::entitiesToPull, EntityMagnet.streamCodec(class_7924.field_41266), EntityMagnet::exemptFromAbuseCost, (class_9139)class_9135.field_48547, EntityMagnet::canDepositIntoBundlesByDefault, EnderscapeCodecs.VEC2_STREAM, EntityMagnet::pullRange, (class_9139)class_3414.field_48279, EntityMagnet::pullEntitySound, EntityMagnet::new);
    public static final EntityMagnet DEFAULT = new EntityMagnet(DEFAULT_ENTITIES_TO_PULL, DEFAULT_EXEMPT_FROM_ABUSE_COST, false, DEFAULT_PULL_RANGE, (class_6880<class_3414>)DEFAULT_PULL_ENTITY_SOUND);

    public static <T> class_9139<ByteBuf, class_6862<T>> streamCodec(class_5321<? extends class_2378<T>> key) {
        return class_2960.field_48267.method_56432(location -> class_6862.method_40092((class_5321)key, (class_2960)location), class_6862::comp_327);
    }

    public static boolean is(class_1799 stack) {
        return stack.method_57826(EnderscapeDataComponents.ENTITY_MAGNET);
    }

    public static EntityMagnet get(class_1799 stack) {
        return (EntityMagnet)stack.method_57824(EnderscapeDataComponents.ENTITY_MAGNET);
    }

    public static boolean tryAddToBundle(class_1661 inventory, class_1799 toAdd) {
        class_1799 magnet = EntityMagnet.getFirstUsableMagnet(inventory);
        if (magnet.method_7960() || !Enabled.get(magnet) || !EntityMagnet.canDepositIntoBundles(magnet, (class_1309)inventory.field_7546)) {
            return false;
        }
        for (class_1799 stack : inventory.field_7547) {
            if (!(stack.method_7909() instanceof class_5537) || !stack.method_57826(class_9334.field_49650)) continue;
            class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
            for (class_1799 bundle : contents.method_57421()) {
                class_9276.class_9277 mutableContents;
                if (!class_1799.method_31577((class_1799)bundle, (class_1799)toAdd) || (mutableContents = new class_9276.class_9277(contents)).method_57432(toAdd) <= 0) continue;
                stack.method_57379(class_9334.field_49650, (Object)mutableContents.method_57435());
                return true;
            }
        }
        return false;
    }

    public static class_1799 getFirstUsableMagnet(class_1661 inventory) {
        class_1657 player = inventory.field_7546;
        class_1937 level = player.method_37908();
        Predicate<class_1799> valid = stack -> EntityMagnet.is(stack) && Enabled.get(stack) && (!FueledTool.is(stack) || FueledTool.fuelExceedsCost(new ItemStackContext((class_1799)stack, level, (class_1309)player)));
        if (valid.test(player.method_6047())) {
            return player.method_6047();
        }
        if (valid.test(player.method_6079())) {
            return player.method_6079();
        }
        return inventory.field_7547.stream().filter(valid).findFirst().orElse(class_1799.field_8037);
    }

    public static int abuseCost(class_1297 entity, EntityMagnet entityMagnet) {
        return entity.method_5864().method_20210(entityMagnet.exemptFromAbuseCost()) ? 0 : 1;
    }

    public static boolean canDepositIntoBundles(class_1799 stack, class_1309 user) {
        if (EntityMagnet.is(stack)) {
            EntityMagnet entityMagnet = EntityMagnet.get(stack);
            return entityMagnet.canDepositIntoBundlesByDefault() || EntityMagnet.canAdditionallyDepositIntoBundles(stack, user);
        }
        throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.ENTITY_MAGNET));
    }

    public static boolean canAdditionallyDepositIntoBundles(class_1799 stack, class_1309 user) {
        MutableFloat mutable = new MutableFloat(0.0f);
        class_1890.method_8220((class_1799)stack, (holder, i) -> ((class_1887)holder.comp_349()).method_60506(EnderscapeEnchantmentEffectComponents.MAGNET_ENABLE_DEPOSIT_INTO_BUNDLES, user.method_59922(), i, mutable));
        return mutable.floatValue() > 0.0f;
    }
}

