/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.bunten.enderscape.entity.DashJumpUser;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.RubbleShieldItem;
import net.bunten.enderscape.item.component.DashPower;
import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.item.component.value.ContextualValue;
import net.bunten.enderscape.network.ClientboundDashJumpPayload;
import net.bunten.enderscape.network.ClientboundDashJumpSoundPayload;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeGameEvents;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record DashJump(DashPower power, ContextualValue durabilityDamage, ContextualValue foodExhaustion, class_6880<class_3414> sound, float particleDuration, boolean stopUsingAfterwards) {
    public static final DashPower DEFAULT_DASH_POWER = new DashPower(new class_241(2.35f, 0.35f), 0.7f);
    public static final ContextualValue DEFAULT_DURABILITY_DAMAGE = new ContextualValue(5.0f, 2.0f);
    public static final ContextualValue DEFAULT_FOOD_EXHAUSTION = new ContextualValue(4.0f, 4.0f);
    public static final class_6880.class_6883<class_3414> DEFAULT_DASH_SOUND = EnderscapeItemSounds.RUBBLE_SHIELD_DASH;
    public static final float DEFAULT_PARTICLE_DURATION = 3.0f;
    public static final boolean DEFAULT_STOP_USING_AFTERWARDS = true;
    public static final Codec<DashJump> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DashPower.CODEC.optionalFieldOf("power", (Object)DEFAULT_DASH_POWER).forGetter(DashJump::power), (App)ContextualValue.CODEC.optionalFieldOf("durability_damage", (Object)DEFAULT_DURABILITY_DAMAGE).forGetter(DashJump::durabilityDamage), (App)ContextualValue.CODEC.optionalFieldOf("food_exhaustion", (Object)DEFAULT_DURABILITY_DAMAGE).forGetter(DashJump::foodExhaustion), (App)class_3414.field_41699.optionalFieldOf("sound", DEFAULT_DASH_SOUND).forGetter(DashJump::sound), (App)class_5699.field_34387.optionalFieldOf("particle_duration", (Object)Float.valueOf(3.0f)).forGetter(DashJump::particleDuration), (App)Codec.BOOL.optionalFieldOf("stop_using_afterwards", (Object)true).forGetter(DashJump::stopUsingAfterwards)).apply((Applicative)instance, DashJump::new));
    public static final class_9139<class_9129, DashJump> STREAM_CODEC = class_9139.method_58025(DashPower.STREAM_CODEC, DashJump::power, ContextualValue.STREAM_CODEC, DashJump::durabilityDamage, ContextualValue.STREAM_CODEC, DashJump::foodExhaustion, (class_9139)class_3414.field_48279, DashJump::sound, (class_9139)class_9135.field_48552, DashJump::particleDuration, (class_9139)class_9135.field_48547, DashJump::stopUsingAfterwards, DashJump::new);
    public static final DashJump DEFAULT = new DashJump(DEFAULT_DASH_POWER, DEFAULT_DURABILITY_DAMAGE, DEFAULT_FOOD_EXHAUSTION, (class_6880<class_3414>)DEFAULT_DASH_SOUND, 3.0f, true);

    public static boolean apply(class_3218 level, class_3222 player, class_1799 stack) {
        DashJump dash = (DashJump)stack.method_57824(EnderscapeDataComponents.DASH_JUMP);
        if (player.method_24828() && !player.method_52535() && (player.method_31549().field_7477 || (float)player.method_7344().method_7586() > 6.0f) && (!FueledTool.is(stack) || FueledTool.fuelExceedsCost(new ItemStackContext(stack, (class_1937)level, (class_1309)player)))) {
            class_243 pos = player.method_19538();
            level.method_14199((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 5, 0.0, 0.0, 0.0, 0.1);
            stack.method_7970(dash.durabilityDamage().calculate(player).asInteger(), (class_1309)player, class_3222.method_56079((class_1268)player.method_6058()));
            player.method_7322(dash.foodExhaustion().calculate(player).asFloat());
            level.method_18456().stream().filter(other -> other.method_5707(pos) < 4096.0).forEach(other -> ServerPlayNetworking.send((class_3222)other, (class_8710)new ClientboundDashJumpSoundPayload(player.method_5628(), ((class_3414)dash.sound().comp_349()).method_14833())));
            DashJumpUser.setDashed((class_1297)player, true);
            DashJumpUser.setDashTicks((class_1297)player, (int)(dash.particleDuration() * 20.0f));
            if (dash.stopUsingAfterwards()) {
                player.method_6021();
                stack.method_7910(player.method_37908(), (class_1309)player);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            player.method_32876(EnderscapeGameEvents.DASH_JUMP);
            class_7225.class_7226 shields = level.method_30349().method_46762(class_7924.field_41197).method_56882(item -> item instanceof RubbleShieldItem);
            shields.method_42017().forEach(reference -> player.method_7357().method_7906((class_1792)reference.comp_349(), 60));
            EnderscapeCriteria.DASH_JUMP.trigger(player, stack);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundDashJumpPayload(dash.power().calculate(player)));
            stack.method_7970(dash.durabilityDamage().calculate(player).asInteger(), (class_1309)player, class_3222.method_56079((class_1268)player.method_6058()));
            player.method_7322(dash.foodExhaustion().calculate(player).asFloat());
            return true;
        }
        return false;
    }
}

