/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import java.util.List;
import java.util.function.Predicate;
import net.bunten.enderscape.item.LodestoneTrackerContext;
import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.item.component.LodestoneTeleportation;
import net.minecraft.class_124;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public record LodestoneTeleportationCheck(@Nullable class_2561 failureComponent, Predicate<LodestoneTrackerContext> shouldProceed) {
    public static final LodestoneTeleportationCheck IS_RUNNING_ON_SERVER = new LodestoneTeleportationCheck(null, context -> !context.level().method_8608());
    public static final LodestoneTeleportationCheck IS_LINKED_TO_LODESTONE = new LodestoneTeleportationCheck((class_2561)class_2561.method_43471((String)"item.enderscape.lodestone_teleportation.message.unlinked"), context -> LodestoneTeleportation.isLinked(context.stack()));
    public static final LodestoneTeleportationCheck CAN_TRAVEL_TO_LODESTONE = new LodestoneTeleportationCheck((class_2561)class_2561.method_43471((String)"item.enderscape.lodestone_teleportation.message.wrong_dimension"), LodestoneTeleportationCheck::canTravelTo);
    public static final LodestoneTeleportationCheck IS_SAME_COORDINATE_SCALE = new LodestoneTeleportationCheck((class_2561)class_2561.method_43471((String)"item.enderscape.lodestone_teleportation.message.wrong_coordinate_scale"), LodestoneTeleportation::isSameCoordinateScale);
    public static final LodestoneTeleportationCheck ISNT_TOO_FAR_FROM_LODESTONE = new LodestoneTeleportationCheck((class_2561)class_2561.method_43471((String)"item.enderscape.lodestone_teleportation.message.too_far"), context -> !LodestoneTeleportationCheck.isTooFar(context));
    public static final LodestoneTeleportationCheck FUEL_EXCEEDS_COST = new LodestoneTeleportationCheck((class_2561)class_2561.method_43471((String)"item.enderscape.lodestone_teleportation.message.need_fuel"), FueledTool::fuelExceedsCost);
    public static final LodestoneTeleportationCheck USER_IS_NOT_TOO_BIG = new LodestoneTeleportationCheck((class_2561)class_2561.method_43471((String)"item.enderscape.lodestone_teleportation.message.unsafe"), context -> !LodestoneTeleportationCheck.isTooBig(context));
    public static final LodestoneTeleportationCheck TELEPORT_POSITION_IS_SAFE = new LodestoneTeleportationCheck((class_2561)class_2561.method_43471((String)"item.enderscape.lodestone_teleportation.message.unsafe"), context -> LodestoneTeleportation.getTeleportPosition(context).isPresent());
    public static final List<LodestoneTeleportationCheck> CHECKS_IN_ORDER = List.of(IS_RUNNING_ON_SERVER, IS_LINKED_TO_LODESTONE, CAN_TRAVEL_TO_LODESTONE, IS_SAME_COORDINATE_SCALE, ISNT_TOO_FAR_FROM_LODESTONE, FUEL_EXCEEDS_COST, USER_IS_NOT_TOO_BIG, TELEPORT_POSITION_IS_SAFE);

    public boolean fails(LodestoneTrackerContext context) {
        return !this.shouldProceed.test(context);
    }

    public class_1271<class_1799> getFailureResult(LodestoneTrackerContext context) {
        return this.failureComponent != null ? LodestoneTeleportationCheck.failureResult(context, (class_2561)class_2561.method_43471((String)this.failureComponent.getString()).method_27692(class_124.field_1061)) : class_1271.method_22428((Object)context.stack());
    }

    private static class_1271<class_1799> failureResult(LodestoneTrackerContext context, class_2561 failureComponent) {
        class_1309 user = context.user();
        class_1799 stack = context.stack();
        user.method_37908().method_60511(null, user.method_23317(), user.method_23318(), user.method_23321(), LodestoneTeleportation.get(stack).sounds().teleportFailure(), user.method_5634(), 0.65f, class_3532.method_15344((class_5819)user.method_59922(), (float)0.9f, (float)1.1f));
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            player.method_7353(failureComponent, true);
            player.method_7357().method_7906(stack.method_7909(), 20);
        }
        user.method_32876((class_6880)class_5712.field_28146);
        return class_1271.method_22427((Object)stack);
    }

    private static boolean canTravelTo(LodestoneTrackerContext context) {
        return LodestoneTeleportation.isTransdimensionalAllowed(context) || LodestoneTeleportation.isSameDimension(context, context.linkedDimension());
    }

    private static boolean isTooFar(LodestoneTrackerContext context) {
        class_1799 stack = context.stack();
        if (FueledTool.is(stack)) {
            return FueledTool.fuelCost(context) > FueledTool.maxFuel(stack);
        }
        return false;
    }

    private static boolean isTooBig(LodestoneTrackerContext context) {
        class_1309 user = context.user();
        class_4048 dimensions = user.method_18377(user.method_18376());
        float limit = 4.0f;
        return dimensions.comp_2185() > limit || dimensions.comp_2186() > limit;
    }
}

