/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature.generator;

import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.block.VeiledLeafPileBlock;
import net.bunten.enderscape.block.VeiledLeavesBlock;
import net.bunten.enderscape.block.VeiledVinesBlock;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.feature.GrowthConfig;
import net.bunten.enderscape.feature.VeiledLeafPileConfig;
import net.bunten.enderscape.feature.VeiledTreeConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.joml.SimplexNoise;

public class VeiledTreeGenerator {
    public static final class_2248 LEAVES = EnderscapeBlocks.VEILED_LEAVES;
    public static final class_2248 LOG = EnderscapeBlocks.VEILED_LOG;

    public static boolean tryGenerate(class_1936 level, class_5819 random, class_2338 origin, VeiledTreeConfig config) {
        if (level.method_8320(origin.method_10074()).method_26216((class_1922)level, origin.method_10074()) && BlockUtil.hasTerrainDepth(level, origin.method_10074(), 8, class_2350.field_11033)) {
            int heightOffset = class_3532.method_15395((class_5819)random, (int)0, (int)2);
            VeiledTreeGenerator.generateLogs(level, origin.method_10086(heightOffset), random, config);
            for (class_2350 dir : class_2350.values()) {
                if (dir.method_10166() == class_2350.class_2351.field_11052) continue;
                VeiledTreeGenerator.setLeaves(level, origin.method_10086(heightOffset).method_10093(dir));
            }
            VeiledTreeGenerator.generateLeaves(level, origin.method_10086(heightOffset + 1), random, config);
            if (config.leafPileConfig().isPresent()) {
                VeiledTreeGenerator.generateLeafPiles(level, origin, random, config.leafPileConfig().get());
            }
            return true;
        }
        return false;
    }

    private static void generateLogs(class_1936 level, class_2338 pos, class_5819 random, VeiledTreeConfig config) {
        int i;
        class_2338.class_2339 mutable = pos.method_10084().method_25503();
        for (i = 0; i < config.log_height().method_35008(random); ++i) {
            VeiledTreeGenerator.setLog(level, (class_2338)mutable);
            mutable.method_10098(class_2350.field_11033);
        }
        for (i = 0; i < config.branch_count().method_35008(random); ++i) {
            VeiledTreeGenerator.generateBranch(level, mutable.method_25503(), random, config);
        }
    }

    private static void generateBranch(class_1936 level, class_2338.class_2339 mutable, class_5819 random, VeiledTreeConfig config) {
        for (int i = 0; i < config.branch_segments().method_35008(random) * random.method_43051(1, 2); ++i) {
            int x = (int)((float)(class_3532.method_15395((class_5819)random, (int)3, (int)4) * (random.method_43056() ? 1 : -1)) * VeiledTreeGenerator.calculateHorizontalFactor(random, i));
            int y = (int)((float)class_3532.method_15395((class_5819)random, (int)-4, (int)-6) * VeiledTreeGenerator.calculateVerticalFactor(random, i));
            int z = (int)((float)(class_3532.method_15395((class_5819)random, (int)3, (int)4) * (random.method_43056() ? 1 : -1)) * VeiledTreeGenerator.calculateHorizontalFactor(random, i));
            class_2338 end = mutable.method_10069(x, y, z);
            for (int o = 0; o <= 20; ++o) {
                double t = (double)o / 20.0;
                int x1 = (int)class_3532.method_16436((double)t, (double)mutable.method_10263(), (double)end.method_10263());
                int y1 = (int)class_3532.method_16436((double)t, (double)mutable.method_10264(), (double)end.method_10264());
                int z1 = (int)class_3532.method_16436((double)t, (double)mutable.method_10260(), (double)end.method_10260());
                class_2338 current = new class_2338(x1, y1, z1);
                VeiledTreeGenerator.setLog(level, current);
            }
            mutable.method_10100(x, y, z);
        }
    }

    private static void generateLeaves(class_1936 level, class_2338 origin, class_5819 random, VeiledTreeConfig config) {
        ArrayList<class_2338> leavesBlocks = new ArrayList<class_2338>();
        int radius = config.leaf_radius().method_35008(random);
        for (int x = -radius + 1; x < radius; ++x) {
            for (int z = -radius + 1; z < radius; ++z) {
                float distance = (float)Math.sqrt(x * x + z * z);
                if (!(distance <= (float)radius)) continue;
                int yOffset = (int)(Math.pow(distance, 2.0) * (double)0.1f);
                class_2338 offset = origin.method_10069(x, yOffset, z);
                if (VeiledTreeGenerator.setLeaves(level, offset)) {
                    leavesBlocks.add(offset);
                }
                if (VeiledTreeGenerator.setLeaves(level, offset.method_10084())) {
                    leavesBlocks.add(offset.method_10084());
                }
                if (!(distance >= (float)radius * 0.8f)) continue;
                for (int i = 1; i <= random.method_43048(3); ++i) {
                    if (VeiledTreeGenerator.setLeaves(level, offset.method_10086(i))) {
                        leavesBlocks.add(offset.method_10086(i));
                    }
                    if (!VeiledTreeGenerator.setLeaves(level, offset.method_10086(i + 1))) continue;
                    leavesBlocks.add(offset.method_10086(i + 1));
                }
            }
        }
        if (!leavesBlocks.isEmpty() && config.vineConfig().isPresent()) {
            VeiledTreeGenerator.generateVines(level, leavesBlocks, random, config);
        }
    }

    private static void generateVines(class_1936 level, List<class_2338> leaves, class_5819 random, VeiledTreeConfig config) {
        GrowthConfig vineConfig = config.vineConfig().get();
        class_2680 state = vineConfig.state();
        for (class_2338 pos2 : leaves.stream().filter(pos -> level.method_22347(pos.method_10084())).toList()) {
            class_2350 direction;
            class_2338 offset;
            if (random.method_43057() > config.vine_generation_chance().method_33920(random) || !level.method_22347(offset = pos2.method_10093(direction = (class_2350)state.method_11654((class_2769)StateProperties.field_12525))) || !state.method_26184((class_4538)level, offset)) continue;
            VeiledVinesBlock.generate(level, offset, random, vineConfig);
        }
    }

    private static void generateLeafPiles(class_1936 level, class_2338 origin, class_5819 random, VeiledLeafPileConfig config) {
        float radius = config.radius().method_33920(random);
        float noiseScale = 0.1f;
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                class_2338 offset = origin.method_10069((int)x, 0, (int)z);
                float noiseValue = SimplexNoise.noise((float)(x * noiseScale), (float)(z * noiseScale));
                float distance = (float)Math.sqrt(x * x + z * z);
                if (!(distance <= radius * (0.8f + noiseValue * 0.4f)) || !(random.method_43057() > config.density().method_33920(random))) continue;
                class_2338.class_2339 mutable = offset.method_10086(3).method_25503();
                for (int i = 0; i < 6; ++i) {
                    class_2248 block = EnderscapeBlocks.VEILED_LEAF_PILE;
                    if (level.method_22347((class_2338)mutable) && level.method_22347(mutable.method_10084()) && VeiledLeafPileBlock.canSurvive((class_4538)level, (class_2338)mutable, block)) {
                        level.method_8652((class_2338)mutable, (class_2680)block.method_9564().method_11657((class_2769)VeiledLeafPileBlock.LAYERS, (Comparable)Integer.valueOf(config.layers().method_35008(random))), 2);
                    }
                    mutable.method_10098(class_2350.field_11033);
                }
            }
        }
    }

    private static boolean setLeaves(class_1936 level, class_2338 pos) {
        return BlockUtil.replace(level, pos, (class_2680)LEAVES.method_9564().method_11657((class_2769)VeiledLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
    }

    private static boolean setLog(class_1936 level, class_2338 pos) {
        return BlockUtil.place(level, pos, LOG.method_9564());
    }

    private static float calculateVerticalFactor(class_5819 random, int g) {
        return g % 2 == 0 ? class_3532.method_15344((class_5819)random, (float)0.8f, (float)1.2f) : class_3532.method_15344((class_5819)random, (float)0.4f, (float)0.6f);
    }

    private static float calculateHorizontalFactor(class_5819 random, int index) {
        return index % 2 == 0 ? class_3532.method_15344((class_5819)random, (float)0.5f, (float)0.6f) : class_3532.method_15344((class_5819)random, (float)0.9f, (float)1.2f);
    }
}

