/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rubblemite;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rubblemite.RubblemiteAI;
import net.bunten.enderscape.entity.rubblemite.RubblemiteVariant;
import net.bunten.enderscape.registry.EnderscapeEntityDataSerializers;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeDamageTypeTags;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class Rubblemite
extends class_1588 {
    private static final class_2940<State> DATA_STATE = class_2945.method_12791(Rubblemite.class, EnderscapeEntityDataSerializers.RUBBLEMITE_STATE_SERIALIZER);
    public final class_7094 insideShellAnimationState = new class_7094();
    public final class_7094 dashAnimationState = new class_7094();
    public final class_7094 prepareDashAnimationState = new class_7094();

    public Rubblemite(class_1299<? extends Rubblemite> type, class_1937 world) {
        super(type, world);
        this.method_5941(class_7.field_18, -1.0f);
        this.field_6194 = 5;
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(DATA_STATE));
    }

    public Rubblemite setState(State state) {
        this.field_6011.method_12778(DATA_STATE, (Object)state);
        return this;
    }

    public static class_5132.class_5133 createAttributes() {
        return Rubblemite.method_26828().method_26868(class_5134.field_23724, 15.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, 0.28).method_26868(class_5134.field_49079, 6.0);
    }

    protected class_4095.class_5303<Rubblemite> method_28306() {
        return class_4095.method_28311(RubblemiteAI.MEMORY_TYPES, RubblemiteAI.SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return RubblemiteAI.makeBrain((class_4095<Rubblemite>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Rubblemite> method_18868() {
        return super.method_18868();
    }

    protected void method_5958() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_3695 profiler = server.method_16107();
            profiler.method_15396("rubblemiteBrain");
            this.method_18868().method_19542(server, (class_1309)this);
            profiler.method_15407();
            profiler.method_15396("rubblemiteActivityUpdate");
            RubblemiteAI.updateActivity(this);
            profiler.method_15407();
        }
        super.method_5958();
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 groupData) {
        RubblemiteVariant.set(this, RubblemiteVariant.pickForSpawning(this.field_5974, (class_6880<class_1959>)level.method_23753(this.method_24515())));
        return super.method_5943(level, difficulty, spawnType, groupData);
    }

    public static boolean canSpawn(class_1299<Rubblemite> type, class_5425 level, class_3730 reason, class_2338 pos, class_5819 random) {
        return !(level.method_8407() == class_1267.field_5801 || !class_3730.method_54986((class_3730)reason) && !level.method_8320(pos.method_10074()).method_26164(EnderscapeBlockTags.RUBBLEMITE_SPAWNABLE_ON) || !class_3730.method_54987((class_3730)reason) && !Rubblemite.method_20679((class_5425)level, (class_2338)pos, (class_5819)random));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_STATE, (Object)State.IDLING);
        builder.method_56912(RubblemiteVariant.DATA, (Object)RubblemiteVariant.END_STONE.getId());
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("RubblemiteVariant", RubblemiteVariant.get(this).getId());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        RubblemiteVariant.set(this, RubblemiteVariant.byId(tag.method_10550("RubblemiteVariant")));
    }

    public void method_5674(class_2940<?> accessor) {
        if (DATA_STATE.equals(accessor)) {
            this.resetAnimations();
            switch (this.getState().ordinal()) {
                case 1: {
                    this.insideShellAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 2: {
                    this.prepareDashAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 3: {
                    this.dashAnimationState.method_41324(this.field_6012);
                }
            }
            this.method_18382();
        }
        super.method_5674(accessor);
    }

    private void resetAnimations() {
        this.insideShellAnimationState.method_41325();
        this.prepareDashAnimationState.method_41325();
        this.dashAnimationState.method_41325();
    }

    public boolean isInsideShell() {
        return this.getState() == State.INSIDE_SHELL || this.field_18321.method_18896(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION);
    }

    public boolean isDashing() {
        return this.getState() == State.DASHING && !this.field_18321.method_18896(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN);
    }

    public boolean isPreparingToDash() {
        return this.getState() == State.PREPARING_DASH || this.field_18321.method_18896(EnderscapeMemory.RUBBLEMITE_PREPARING_DASH);
    }

    public void enterShell(int value) {
        this.setState(State.INSIDE_SHELL);
        if (value > 0) {
            this.field_18321.method_18878(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION, (Object)value);
        }
    }

    public void exitShell() {
        this.setState(State.IDLING);
        this.field_18321.method_18875(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION);
        this.field_18321.method_24525(EnderscapeMemory.RUBBLEMITE_HIDING_ON_COOLDOWN, (Object)true, 100L);
        this.field_18321.method_24525(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN, (Object)true, 20L);
    }

    public boolean canHideInShell() {
        return this.getState() == State.IDLING && !RubblemiteAI.isShellCoolingDown(this);
    }

    public boolean shouldStopDashing() {
        return this.method_24828() || this.method_5721() || this.method_5854() != null;
    }

    public void prepareDash() {
        this.setState(State.PREPARING_DASH);
        this.method_18868().method_18878(EnderscapeMemory.RUBBLEMITE_PREPARING_DASH, (Object)true);
        this.method_18868().method_18878(EnderscapeMemory.RUBBLEMITE_PREPARING_DASH_TIME, (Object)5);
        this.method_5783(EnderscapeEntitySounds.RUBBLEMITE_PREPARE_DASH, 1.0f, 1.0f);
    }

    public void dash() {
        this.setState(State.DASHING);
        this.method_18868().method_18875(EnderscapeMemory.RUBBLEMITE_PREPARING_DASH);
        this.method_18868().method_24525(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN, (Object)true, 40L);
        class_243 vec = this.method_5720();
        vec = vec.method_18805(1.4, 0.0, 1.4).method_1031(0.0, (double)0.33f, 0.0);
        this.method_18799(vec);
        this.method_5783(EnderscapeEntitySounds.RUBBLEMITE_HOP, 1.0f, 1.0f);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_243 pos = this.method_19538();
            server.method_14199((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 5, 0.0, 0.0, 0.0, 0.1);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5805() && source.method_48789(EnderscapeDamageTypeTags.RUBBLEMITES_CAN_BLOCK)) {
            if (amount >= 12.0f && super.method_5643(source, amount)) {
                return true;
            }
            if (this.getState() != State.IDLING && super.method_5643(source, 0.0f)) {
                return true;
            }
            if (this.canHideInShell() && super.method_5643(source, amount)) {
                this.enterShell(40);
                return true;
            }
        }
        return super.method_5643(source, amount);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.enterShell(0);
    }

    public void method_6091(class_243 vec) {
        if (this.getState() != State.IDLING) {
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            vec = class_243.field_1353;
        }
        super.method_6091(vec);
    }

    protected class_3414 method_5994() {
        return this.getState() != State.IDLING ? null : EnderscapeEntitySounds.RUBBLEMITE_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.getState() != State.IDLING ? EnderscapeEntitySounds.RUBBLEMITE_SHIELD : EnderscapeEntitySounds.RUBBLEMITE_HURT;
    }

    protected class_3414 method_6002() {
        return EnderscapeEntitySounds.RUBBLEMITE_DEATH;
    }

    protected class_3414 getStepSound() {
        return EnderscapeEntitySounds.RUBBLEMITE_STEP;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.15f, class_3532.method_15344((class_5819)this.field_5974, (float)0.9f, (float)1.1f));
    }

    public static enum State {
        IDLING(0),
        INSIDE_SHELL(1),
        PREPARING_DASH(2),
        DASHING(3);

        public static final IntFunction<State> BY_ID;
        public static final class_9139<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int j) {
            this.id = j;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = class_7995.method_47914(State::id, (Object[])State.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, State::id);
        }
    }
}

