/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class StunAttackCriterion
extends class_4558<Conditions> {
    public void trigger(class_3222 player, class_1799 stack, class_1309 victim, List<class_1297> affectedEntities, boolean backstab) {
        this.method_22510(player, instance -> instance.matches(player, stack, victim, affectedEntities, backstab));
    }

    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public static final class Conditions
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2073> item;
        private final Optional<class_2048> victim;
        private final Optional<List<class_2048>> affectedEntities;
        private final Optional<Boolean> backstab;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(Conditions::comp_2029), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(Conditions::item), (App)class_2048.field_45746.optionalFieldOf("victim").forGetter(Conditions::victim), (App)class_2048.field_45746.listOf().optionalFieldOf("affected_entities").forGetter(Conditions::affectedEntities), (App)Codec.BOOL.optionalFieldOf("backstab").forGetter(Conditions::backstab)).apply((Applicative)instance, Conditions::new));

        public Conditions(Optional<class_5258> player, Optional<class_2073> item, Optional<class_2048> victim, Optional<List<class_2048>> affectedEntities, Optional<Boolean> backstab) {
            this.player = player;
            this.item = item;
            this.victim = victim;
            this.affectedEntities = affectedEntities;
            this.backstab = backstab;
        }

        public boolean matches(class_3222 player, class_1799 stack, class_1309 victim, List<class_1297> affectedEntities, boolean backstab) {
            if (this.item().isPresent() && !this.item().get().method_8970(stack)) {
                return false;
            }
            if (this.victim().isPresent() && !this.victim().get().method_8914(player, (class_1297)victim)) {
                return false;
            }
            if (this.affectedEntities().isPresent()) {
                for (class_2048 predicate : this.affectedEntities().get()) {
                    boolean matched = affectedEntities.stream().anyMatch(e -> predicate.method_8914(player, e));
                    if (matched) continue;
                    return false;
                }
            }
            return !this.backstab().isPresent() || this.backstab().get().equals(backstab);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Conditions.class, "player;item;victim;affectedEntities;backstab", "player", "item", "victim", "affectedEntities", "backstab"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Conditions.class, "player;item;victim;affectedEntities;backstab", "player", "item", "victim", "affectedEntities", "backstab"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Conditions.class, "player;item;victim;affectedEntities;backstab", "player", "item", "victim", "affectedEntities", "backstab"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2073> item() {
            return this.item;
        }

        public Optional<class_2048> victim() {
            return this.victim;
        }

        public Optional<List<class_2048>> affectedEntities() {
            return this.affectedEntities;
        }

        public Optional<Boolean> backstab() {
            return this.backstab;
        }
    }
}

