/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.hud;

import net.bunten.enderscape.client.hud.HudElement;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.LodestoneTrackerContext;
import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.item.component.LodestoneTeleportation;
import net.bunten.enderscape.item.component.value.FuelDisplay;
import net.bunten.enderscape.item.component.value.FuelHud;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.util.NineSliceBlitUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class FueledToolHud
extends HudElement {
    private class_2960 emptySegments;
    private class_2960 fueledSegments;
    private class_2960 invalidSegments;
    private class_2960 outlineOverlay;
    private class_2960 costOverlay;
    private float heightOffset = 0.0f;
    private float previousHeightOffset = 0.0f;
    private float totalAlpha = 0.0f;
    private float previousTotalAlpha = 0.0f;
    private float invalidAlpha = 0.0f;
    private float previousInvalidAlpha = 0.0f;
    private float transdimensionalAlpha = 0.0f;
    private float previousTransdimensionalAlpha = 0.0f;
    private float costAlpha = 0.0f;
    private float previousCostAlpha = 0.0f;
    private int costDisplayTicks = 0;
    private int invalidDisplayTicks = 0;
    private int transdimensionalDisplayTicks = 0;
    private int costOverlayPosition = -1;
    private int fuel;
    private int maxFuel;
    private int cost;

    public FueledToolHud() {
        super(HudElement.RenderPhase.AFTER_HUD);
    }

    @Override
    public void render(class_332 graphics, class_9779 tracker) {
        if (!this.config.nebuliteToolHudEnabled || this.client.field_1724 == null || this.client.field_1690.field_1842 || !this.client.field_1690.method_31044().method_31034() || this.client.field_1724.method_7325()) {
            return;
        }
        float delta = tracker.method_60637(false);
        float offset = class_3532.method_16439((float)delta, (float)this.previousHeightOffset, (float)this.heightOffset);
        float total = class_3532.method_16439((float)delta, (float)this.previousTotalAlpha, (float)this.totalAlpha);
        if (total <= 0.01f) {
            return;
        }
        graphics.method_51448().method_22903();
        int verticalOffset = this.config.nebuliteToolHudOffset;
        graphics.method_51448().method_46416(0.0f, verticalOffset < 0 ? -offset : offset, 0.0f);
        float opacity = class_3532.method_15363((float)(total * (float)this.config.nebuliteToolHudOpacity / 100.0f), (float)0.0f, (float)1.0f);
        int x = graphics.method_51421() / 2 - (11 * this.maxFuel + 1) / 2;
        int y = graphics.method_51443() / 2 - verticalOffset;
        this.renderFuelBar(graphics, x, y, opacity);
        this.renderTransdimensionalOutline(graphics, x, y, class_3532.method_16439((float)delta, (float)this.previousTransdimensionalAlpha, (float)this.transdimensionalAlpha) * opacity);
        this.renderInvalidOverlay(graphics, x, y, class_3532.method_16439((float)delta, (float)this.previousInvalidAlpha, (float)this.invalidAlpha) * opacity);
        this.renderCostOverlay(graphics, y, class_3532.method_16439((float)delta, (float)this.previousCostAlpha, (float)this.costAlpha) * opacity);
        graphics.method_51448().method_22909();
    }

    private void renderFuelBar(class_332 graphics, int x, int y, float opacity) {
        int lastFueled = -1;
        int rx = x;
        for (int i = 0; i < this.maxFuel; ++i) {
            boolean isFueled;
            boolean bl = isFueled = i < this.fuel;
            if (i > 0) {
                rx += 11;
            }
            if (isFueled) {
                lastFueled = rx;
            }
            int index = i == 0 ? 0 : (i == this.maxFuel - 1 ? 2 : 1);
            int width = i == this.maxFuel - 1 ? 12 : 11;
            class_1058 sprite = class_310.method_1551().method_52699().method_18667(FuelDisplay.segmentOf(isFueled ? this.fueledSegments : this.emptySegments, index));
            graphics.method_48465(rx, y, 0, width, 5, sprite, 1.0f, 1.0f, 1.0f, opacity);
        }
        this.costOverlayPosition = lastFueled;
    }

    private void renderTransdimensionalOutline(class_332 graphics, int x, int y, float opacity) {
        NineSliceBlitUtil nineSliceBlit = new NineSliceBlitUtil(class_310.method_1551().method_52699(), graphics, opacity);
        nineSliceBlit.blitSprite(this.outlineOverlay, x - 6, y - 6, 0, this.maxFuel * 11 + 13, 17);
    }

    private void renderInvalidOverlay(class_332 graphics, int x, int y, float opacity) {
        int rx = x;
        for (int i = 0; i < this.maxFuel; ++i) {
            if (i > 0) {
                rx += 11;
            }
            int index = i == 0 ? 0 : (i == this.maxFuel - 1 ? 2 : 1);
            int width = i == this.maxFuel - 1 ? 12 : 11;
            class_1058 sprite = class_310.method_1551().method_52699().method_18667(FuelDisplay.segmentOf(this.invalidSegments, index));
            graphics.method_48465(rx, y, 0, width, 5, sprite, 1.0f, 1.0f, 1.0f, opacity);
        }
    }

    private void renderCostOverlay(class_332 graphics, int y, float opacity) {
        if (opacity > 0.0f && this.costOverlayPosition >= 0 && this.fuel >= this.cost) {
            for (int i = 0; i < this.cost; ++i) {
                class_1058 sprite = class_310.method_1551().method_52699().method_18667(this.costOverlay);
                graphics.method_48465(this.costOverlayPosition - i * 11, y, 0, 11, 5, sprite, 1.0f, 1.0f, 1.0f, opacity);
            }
        }
    }

    @Override
    public void tick() {
        class_746 player = this.client.field_1724;
        if (player == null) {
            return;
        }
        this.previousTotalAlpha = this.totalAlpha;
        this.previousHeightOffset = this.heightOffset;
        this.previousCostAlpha = this.costAlpha;
        this.previousInvalidAlpha = this.invalidAlpha;
        this.previousTransdimensionalAlpha = this.transdimensionalAlpha;
        class_1799 stack = FueledTool.is(player.method_6047()) ? player.method_6047() : player.method_6079();
        ItemStackContext context = new ItemStackContext(stack, player.method_37908(), (class_1309)player);
        boolean displayUI = FueledTool.is(stack) && FueledTool.get(stack).display().hud().visible() && !player.method_7325() && player.method_6030().method_7960();
        boolean displayOutline = false;
        boolean displayTransdimensional = false;
        if (stack.method_57826(EnderscapeDataComponents.ENABLED)) {
            boolean bl = displayUI = displayUI && (Boolean)stack.method_57824(EnderscapeDataComponents.ENABLED) != false;
        }
        if (LodestoneTeleportation.is(stack)) {
            LodestoneTrackerContext tracker = LodestoneTrackerContext.of(context);
            displayUI = displayUI && LodestoneTeleportation.isLinked(stack);
            displayOutline = !LodestoneTeleportation.hideInvalidOutlineWhen(context);
            boolean bl = displayTransdimensional = LodestoneTeleportation.isTransdimensionalAllowed(tracker) && !LodestoneTeleportation.isSameDimension(tracker, tracker.linkedDimension()) && !displayOutline;
        }
        if (displayUI) {
            FuelHud hud = FueledTool.hud(stack);
            this.emptySegments = hud.empty();
            this.fueledSegments = hud.fueled();
            this.invalidSegments = hud.invalidOverlay();
            this.outlineOverlay = hud.outline();
            this.costOverlay = hud.costOverlay();
            this.fuel = FueledTool.currentFuel(stack);
            this.maxFuel = FueledTool.maxFuel(stack);
            this.cost = FueledTool.fuelCost(context);
            this.totalAlpha = class_3532.method_16439((float)0.5f, (float)this.totalAlpha, (float)1.0f);
            this.heightOffset = class_3532.method_16439((float)0.5f, (float)this.heightOffset, (float)-3.0f);
        } else {
            this.totalAlpha = class_3532.method_16439((float)0.5f, (float)this.totalAlpha, (float)0.0f);
            this.heightOffset = class_3532.method_16439((float)0.5f, (float)this.heightOffset, (float)0.0f);
        }
        this.invalidAlpha = class_3532.method_16439((float)0.35f, (float)this.invalidAlpha, (float)(displayUI && displayOutline ? class_3532.method_15363((float)(class_3532.method_15374((float)((float)this.invalidDisplayTicks * 0.4f)) * 0.5f + 0.5f), (float)0.65f, (float)1.0f) : 0.0f));
        this.costAlpha = class_3532.method_16439((float)0.35f, (float)this.costAlpha, (float)(displayUI && !displayOutline ? class_3532.method_15363((float)(class_3532.method_15374((float)((float)this.costDisplayTicks * 0.25f)) * 0.2f + 0.5f), (float)0.75f, (float)1.0f) : 0.0f));
        this.transdimensionalAlpha = class_3532.method_16439((float)0.35f, (float)this.transdimensionalAlpha, (float)(displayUI && displayTransdimensional ? class_3532.method_15363((float)(class_3532.method_15374((float)((float)this.transdimensionalDisplayTicks * 0.1f)) * 0.5f + 0.5f), (float)0.4f, (float)1.0f) : 0.0f));
        this.invalidDisplayTicks = this.invalidAlpha > 0.0f ? this.invalidDisplayTicks + 1 : 0;
        this.costDisplayTicks = this.costAlpha > 0.0f ? this.costDisplayTicks + 1 : 0;
        this.transdimensionalDisplayTicks = this.transdimensionalAlpha > 0.0f ? this.transdimensionalDisplayTicks + 1 : 0;
    }
}

