/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.LightingStyle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EnderscapeModMenu
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return EnderscapeModMenu::buildMenu;
    }

    @Environment(value=EnvType.CLIENT)
    private static class_437 buildMenu(class_437 parent) {
        return YetAnotherConfigLib.create(EnderscapeConfig.HANDLER, (defaults, config, builder) -> builder.title((class_2561)class_2561.method_43471((String)"menu.enderscape.config")).category(EnderscapeModMenu.createMainCategory(config)).category(EnderscapeModMenu.createClientsideCategory(config))).generateScreen(parent);
    }

    private static <T> Option<T> boolOption(String name, T defaultValue, Supplier<T> getter, Consumer<T> setter, Function<Option<T>, ControllerBuilder<T>> builder) {
        return Option.createBuilder().name((class_2561)class_2561.method_43471((String)("option.enderscape." + name))).binding(defaultValue, getter, setter).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)("option.enderscape." + name + ".desc"))}).build()).controller(builder).build();
    }

    private static Option<Integer> intOption(String name, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter, int min, int max, int step) {
        return Option.createBuilder().name((class_2561)class_2561.method_43471((String)("option.enderscape." + name))).binding((Object)defaultValue, getter, setter).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)("option.enderscape." + name + ".desc"))}).build()).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)min, (Number)max)).step((Number)step)).build();
    }

    private static ConfigCategory createMainCategory(EnderscapeConfig config) {
        ConfigCategory.Builder main = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"option.enderscape.category.serverside"));
        EnderscapeModMenu.addCreativeModeOptions(config, main);
        EnderscapeModMenu.addDataPackOptions(config, main);
        EnderscapeModMenu.addLootTableOptions(config, main);
        EnderscapeModMenu.addServersideAmbienceOptions(config, main);
        EnderscapeModMenu.addServersideBlockOptions(config, main);
        EnderscapeModMenu.addServersideEntityOptions(config, main);
        EnderscapeModMenu.addServersideItemOptions(config, main);
        return main.build();
    }

    private static ConfigCategory createClientsideCategory(EnderscapeConfig config) {
        ConfigCategory.Builder main = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"option.enderscape.category.clientside"));
        if (Enderscape.IS_DEBUG) {
            EnderscapeModMenu.addDebugOptions(config, main);
        }
        EnderscapeModMenu.addClientsideAmbienceOptions(config, main);
        EnderscapeModMenu.addClientsideBlockOptions(config, main);
        EnderscapeModMenu.addClientsideEntityOptions(config, main);
        EnderscapeModMenu.addClientsideItemOptions(config, main);
        if (!Enderscape.IS_DEBUG) {
            EnderscapeModMenu.addDebugOptions(config, main);
        }
        return main.build();
    }

    private static void addCreativeModeOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> creativeTabEnabled = EnderscapeModMenu.boolOption("creative_tab_enabled", true, () -> config.creativeTabEnabled, value -> {
            config.creativeTabEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> includeItemsInVanillaCreativeTabs = EnderscapeModMenu.boolOption("include_items_in_vanilla_creative_tabs", true, () -> config.includeItemsInVanillaCreativeTabs, value -> {
            config.includeItemsInVanillaCreativeTabs = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.creative_mode")).option(creativeTabEnabled).option(includeItemsInVanillaCreativeTabs).build());
    }

    private static void addDebugOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> debugHudEnabled = EnderscapeModMenu.boolOption("debug_hud_enabled", false, () -> config.debugHudEnabled, value -> {
            config.debugHudEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugHudClientInfo = EnderscapeModMenu.boolOption("debug_hud_client_info", true, () -> config.debugHudClientInfo, value -> {
            config.debugHudClientInfo = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugHudMusicInfo = EnderscapeModMenu.boolOption("debug_hud_music_info", true, () -> config.debugHudMusicInfo, value -> {
            config.debugHudMusicInfo = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugHudPlayerInfo = EnderscapeModMenu.boolOption("debug_hud_player_info", true, () -> config.debugHudPlayerInfo, value -> {
            config.debugHudPlayerInfo = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugMagniaSproutHitboxes = EnderscapeModMenu.boolOption("debug_magnia_sprout_hitboxes", false, () -> config.debugMagniaSproutHitboxes, value -> {
            config.debugMagniaSproutHitboxes = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.debug")).option(debugHudEnabled).option(debugHudClientInfo).option(debugHudMusicInfo).option(debugHudPlayerInfo).option(debugMagniaSproutHitboxes).build());
    }

    private static void addLootTableOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> supplementVanillaStrongholdLibraryLoot = EnderscapeModMenu.boolOption("supplement_vanilla_stronghold_library_loot", true, () -> config.supplementVanillaStrongholdLibraryLoot, value -> {
            config.supplementVanillaStrongholdLibraryLoot = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> supplementVanillaEndCityTreasureLoot = EnderscapeModMenu.boolOption("supplement_vanilla_end_city_treasure_loot", true, () -> config.supplementVanillaEndCityTreasureLoot, value -> {
            config.supplementVanillaEndCityTreasureLoot = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.loot_tables")).option(supplementVanillaStrongholdLibraryLoot).option(supplementVanillaEndCityTreasureLoot).build());
    }

    private static void addDataPackOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> defaultDataPackFixLevitationAdvancement = EnderscapeModMenu.boolOption("default_data_pack_fix_levitation_advancement", true, () -> config.defaultDataPackFixLevitationAdvancement, value -> {
            config.defaultDataPackFixLevitationAdvancement = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> defaultDataPackFixVanillaRecipes = EnderscapeModMenu.boolOption("default_data_pack_fix_vanilla_recipes", true, () -> config.defaultDataPackFixVanillaRecipes, value -> {
            config.defaultDataPackFixVanillaRecipes = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> defaultDataPackNewTerrain = EnderscapeModMenu.boolOption("default_data_pack_new_terrain", true, () -> config.defaultDataPackNewTerrain, value -> {
            config.defaultDataPackNewTerrain = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> defaultDataPackNewEndCities = EnderscapeModMenu.boolOption("default_data_pack_new_end_cities", true, () -> config.defaultDataPackNewEndCities, value -> {
            config.defaultDataPackNewEndCities = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> defaultDataPackNewStrongholds = EnderscapeModMenu.boolOption("default_data_pack_new_strongholds", true, () -> config.defaultDataPackNewStrongholds, value -> {
            config.defaultDataPackNewStrongholds = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.data_packs")).option(defaultDataPackFixLevitationAdvancement).option(defaultDataPackFixVanillaRecipes).option(defaultDataPackNewTerrain).option(defaultDataPackNewEndCities).option(defaultDataPackNewStrongholds).build());
    }

    private static void addResourcePackOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> defaultResourcePackLighting = EnderscapeModMenu.boolOption("default_resource_pack_lighting", true, () -> config.defaultResourcePackLighting, value -> {
            config.defaultResourcePackLighting = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> defaultResourcePackDarkLighting = EnderscapeModMenu.boolOption("default_resource_pack_dark_lighting", false, () -> config.defaultResourcePackDarkLighting, value -> {
            config.defaultResourcePackDarkLighting = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.resource_packs")).option(defaultResourcePackLighting).option(defaultResourcePackDarkLighting).build());
    }

    private static void addClientsideAmbienceOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> skyboxUpdateEnabled = EnderscapeModMenu.boolOption("skybox_update_enabled", true, () -> config.skyboxUpdateEnabled, value -> {
            config.skyboxUpdateEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option lightingStyle = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"option.enderscape.lighting_style")).binding((Object)LightingStyle.IMPROVED, () -> config.lightingStyle, value -> {
            config.lightingStyle = value;
        }).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"option.enderscape.lighting_style.desc")}).build()).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(LightingStyle.class)).build();
        Option<Boolean> skyboxAddDynamicFogDensity = EnderscapeModMenu.boolOption("skybox_add_dynamic_fog_density", true, () -> config.skyboxAddDynamicFogDensity, value -> {
            config.skyboxAddDynamicFogDensity = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> skyboxScalesBrightnessWithGamma = EnderscapeModMenu.boolOption("skybox_scales_brightness_with_gamma", true, () -> config.skyboxScalesBrightnessWithGamma, value -> {
            config.skyboxScalesBrightnessWithGamma = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> skyboxBrightnessScaleFactor = EnderscapeModMenu.intOption("skybox_brightness_scale_factor", 40, () -> config.skyboxBrightnessScaleFactor, value -> {
            config.skyboxBrightnessScaleFactor = value;
        }, 10, 100, 1);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.ambience")).option(skyboxUpdateEnabled).option(skyboxScalesBrightnessWithGamma).option(skyboxBrightnessScaleFactor).option(skyboxAddDynamicFogDensity).option(lightingStyle).build());
    }

    private static void addServersideAmbienceOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> updateDefaultEndMusic = EnderscapeModMenu.boolOption("ambience_update_music_pools", true, () -> config.ambienceUpdateMusicPools, value -> {
            config.ambienceUpdateMusicPools = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndLoop = EnderscapeModMenu.boolOption("ambience_update_loop_sounds", true, () -> config.ambienceUpdateLoopSounds, value -> {
            config.ambienceUpdateLoopSounds = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndAdditions = EnderscapeModMenu.boolOption("ambience_update_addition_sounds", true, () -> config.ambienceUpdateAdditionSounds, value -> {
            config.ambienceUpdateAdditionSounds = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndMood = EnderscapeModMenu.boolOption("ambience_update_mood_sounds", true, () -> config.ambienceUpdateMoodSounds, value -> {
            config.ambienceUpdateMoodSounds = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndParticles = EnderscapeModMenu.boolOption("ambience_update_particles", true, () -> config.ambienceUpdateParticles, value -> {
            config.ambienceUpdateParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndSkyColor = EnderscapeModMenu.boolOption("ambience_update_sky_colors", true, () -> config.ambienceUpdateSkyColors, value -> {
            config.ambienceUpdateSkyColors = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndFogColor = EnderscapeModMenu.boolOption("ambience_update_fog_colors", true, () -> config.ambienceUpdateFogColors, value -> {
            config.ambienceUpdateFogColors = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndGrassColor = EnderscapeModMenu.boolOption("ambience_update_grass_colors", true, () -> config.ambienceUpdateGrassColors, value -> {
            config.ambienceUpdateGrassColors = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndFoliageColor = EnderscapeModMenu.boolOption("ambience_update_foliage_colors", true, () -> config.ambienceUpdateFoliageColors, value -> {
            config.ambienceUpdateFoliageColors = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndWaterColor = EnderscapeModMenu.boolOption("ambience_update_water_colors", true, () -> config.ambienceUpdateWaterColors, value -> {
            config.ambienceUpdateWaterColors = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndWaterFogColor = EnderscapeModMenu.boolOption("ambience_update_water_fog_colors", true, () -> config.ambienceUpdateWaterFogColors, value -> {
            config.ambienceUpdateWaterFogColors = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.ambience")).option(updateDefaultEndMusic).option(updateDefaultEndLoop).option(updateDefaultEndAdditions).option(updateDefaultEndMood).option(updateDefaultEndParticles).option(updateDefaultEndSkyColor).option(updateDefaultEndFogColor).option(updateDefaultEndGrassColor).option(updateDefaultEndFoliageColor).option(updateDefaultEndWaterColor).option(updateDefaultEndWaterFogColor).build());
    }

    private static void addServersideBlockOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> blockSoundsUpdateChorus = EnderscapeModMenu.boolOption("block_sounds_update_chorus", true, () -> config.blocksSoundUpdateChorus, value -> {
            config.blocksSoundUpdateChorus = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blocksSoundUpdatePurpur = EnderscapeModMenu.boolOption("block_sounds_update_purpur", true, () -> config.blocksSoundUpdatePurpur, value -> {
            config.blocksSoundUpdatePurpur = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndPortalFrame = EnderscapeModMenu.boolOption("block_sounds_update_end_portal_frame", true, () -> config.blockSoundUpdateEndPortalFrame, value -> {
            config.blockSoundUpdateEndPortalFrame = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndPortals = EnderscapeModMenu.boolOption("block_sounds_update_end_portals", true, () -> config.blockSoundUpdateEndPortals, value -> {
            config.blockSoundUpdateEndPortals = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundsUpdateEndRods = EnderscapeModMenu.boolOption("block_sounds_update_end_rods", true, () -> config.blockSoundsUpdateEndRods, value -> {
            config.blockSoundsUpdateEndRods = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndStone = EnderscapeModMenu.boolOption("block_sounds_update_end_stone", true, () -> config.blockSoundUpdateEndStone, value -> {
            config.blockSoundUpdateEndStone = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndStoneBricks = EnderscapeModMenu.boolOption("block_sounds_update_end_stone_bricks", true, () -> config.blockSoundUpdateEndStoneBricks, value -> {
            config.blockSoundUpdateEndStoneBricks = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateShulkerBoxes = EnderscapeModMenu.boolOption("block_sounds_update_shulker_boxes", true, () -> config.blockSoundUpdateShulkerBoxes, value -> {
            config.blockSoundUpdateShulkerBoxes = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.blocks")).option(blockSoundsUpdateChorus).option(blockSoundUpdateEndPortalFrame).option(blockSoundUpdateEndPortals).option(blockSoundsUpdateEndRods).option(blockSoundUpdateEndStoneBricks).option(blockSoundUpdateEndStone).option(blocksSoundUpdatePurpur).option(blockSoundUpdateShulkerBoxes).build());
    }

    private static void addClientsideBlockOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> chorusFlowerHumming = EnderscapeModMenu.boolOption("chorus_flower_humming", true, () -> config.chorusFlowerHumming, value -> {
            config.chorusFlowerHumming = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> chorusFlowerPollen = EnderscapeModMenu.boolOption("chorus_flower_pollen", true, () -> config.chorusFlowerPollen, value -> {
            config.chorusFlowerPollen = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endPortalUpdateParticles = EnderscapeModMenu.boolOption("end_portal_update_particles", true, () -> config.endPortalUpdateParticles, value -> {
            config.endPortalUpdateParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endPortalUpdateTravelSound = EnderscapeModMenu.boolOption("end_portal_update_travel_sound", true, () -> config.endPortalUpdateTravelSound, value -> {
            config.endPortalUpdateTravelSound = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.blocks")).option(chorusFlowerHumming).option(chorusFlowerPollen).option(endPortalUpdateParticles).option(endPortalUpdateTravelSound).build());
    }

    private static void addServersideEntityOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> endermanStereoStareSound = EnderscapeModMenu.boolOption("enderman_stereo_stare_sound", true, () -> config.endermanStereoStareSound, value -> {
            config.endermanStereoStareSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermiteNaturalSpawnsObeyLightLevel = EnderscapeModMenu.boolOption("endermite_natural_spawns_obey_light_level", true, () -> config.endermiteNaturalSpawnsObeyLightLevel, value -> {
            config.endermiteNaturalSpawnsObeyLightLevel = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermiteExpandHitRange = EnderscapeModMenu.boolOption("endermite_expand_hit_range", true, () -> config.endermiteExpandHitRange, value -> {
            config.endermiteExpandHitRange = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermiteUpdateSounds = EnderscapeModMenu.boolOption("endermite_update_sounds", true, () -> config.endermiteUpdateSounds, value -> {
            config.endermiteUpdateSounds = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> rubblemiteExpandHitRange = EnderscapeModMenu.boolOption("rubblemite_expand_hit_range", true, () -> config.rubblemiteExpandHitRange, value -> {
            config.rubblemiteExpandHitRange = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> shulkerBulletEnforceTimeLimit = EnderscapeModMenu.intOption("shulker_bullet_enforce_time_limit", 30, () -> config.shulkerBulletEnforceTimeLimit, value -> {
            config.shulkerBulletEnforceTimeLimit = value;
        }, 0, 60, 1);
        Option<Integer> shulkerBulletEnforceDistanceLimit = EnderscapeModMenu.intOption("shulker_bullet_enforce_distance_limit", 30, () -> config.shulkerBulletEnforceDistanceLimit, value -> {
            config.shulkerBulletEnforceDistanceLimit = value;
        }, 0, 100, 1);
        Option<Boolean> shulkerBulletEnforceOwnerLimit = EnderscapeModMenu.boolOption("shulker_bullet_enforce_owner_limit", true, () -> config.shulkerBulletEnforceOwnerLimit, value -> {
            config.shulkerBulletEnforceOwnerLimit = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> shulkerBulletRebalanceLevitation = EnderscapeModMenu.boolOption("shulker_bullet_rebalance_levitation", true, () -> config.shulkerBulletRebalanceLevitation, value -> {
            config.shulkerBulletRebalanceLevitation = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> shulkerBulletEnforceCountLimit = EnderscapeModMenu.intOption("shulker_bullet_enforce_count_limit", 3, () -> config.shulkerBulletEnforceCountLimit, value -> {
            config.shulkerBulletEnforceCountLimit = value;
        }, 0, 8, 1);
        Option<Boolean> shulkerHurtByPiercing = EnderscapeModMenu.boolOption("shulker_hurt_by_piercing", true, () -> config.shulkerHurtByPiercing, value -> {
            config.shulkerHurtByPiercing = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> silverfishDelayBeforeInfestingStone = EnderscapeModMenu.boolOption("silverfish_delay_before_infesting_stone", true, () -> config.silverfishDelayBeforeInfestingStone, value -> {
            config.silverfishDelayBeforeInfestingStone = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> silverfishExpandHitRange = EnderscapeModMenu.boolOption("silverfish_expand_hit_range", true, () -> config.silverfishExpandHitRange, value -> {
            config.silverfishExpandHitRange = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> silverfishNaturalSpawnsObeyLightLevel = EnderscapeModMenu.boolOption("silverfish_natural_spawns_obey_light_level", true, () -> config.silverfishNaturalSpawnsObeyLightLevel, value -> {
            config.silverfishNaturalSpawnsObeyLightLevel = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> voidPoofParticlesUponDeath = EnderscapeModMenu.boolOption("void_poof_particles_upon_death", true, () -> config.voidPoofParticlesUponDeath, value -> {
            config.voidPoofParticlesUponDeath = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.entity")).option(endermanStereoStareSound).option(endermiteExpandHitRange).option(endermiteNaturalSpawnsObeyLightLevel).option(endermiteUpdateSounds).option(rubblemiteExpandHitRange).option(shulkerBulletEnforceCountLimit).option(shulkerBulletEnforceDistanceLimit).option(shulkerBulletEnforceOwnerLimit).option(shulkerBulletEnforceTimeLimit).option(shulkerBulletRebalanceLevitation).option(shulkerHurtByPiercing).option(silverfishDelayBeforeInfestingStone).option(silverfishExpandHitRange).option(silverfishNaturalSpawnsObeyLightLevel).option(voidPoofParticlesUponDeath).build());
    }

    private static void addClientsideEntityOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> portalParticleEmissive = EnderscapeModMenu.boolOption("portal_particle_emissive", true, () -> config.portalParticleEmissive, value -> {
            config.portalParticleEmissive = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermiteEmissiveEyes = EnderscapeModMenu.boolOption("endermite_emissive_eyes", true, () -> config.endermiteEmissiveEyes, value -> {
            config.endermiteEmissiveEyes = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> shulkerBulletLoopSound = EnderscapeModMenu.boolOption("shulker_bullet_loop_sound", true, () -> config.shulkerBulletLoopSound, value -> {
            config.shulkerBulletLoopSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermanStaticSound = EnderscapeModMenu.boolOption("enderman_static_sound", true, () -> config.endermanStaticSound, value -> {
            config.endermanStaticSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermanStaticOverlay = EnderscapeModMenu.boolOption("enderman_static_overlay", true, () -> config.endermanStaticOverlay, value -> {
            config.endermanStaticOverlay = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.entity")).option(endermanStaticOverlay).option(endermanStaticSound).option(endermiteEmissiveEyes).option(portalParticleEmissive).option(shulkerBulletLoopSound).build());
    }

    private static void addServersideItemOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> elytraAddOpenCloseSounds = EnderscapeModMenu.boolOption("elytra_add_open_close_sounds", true, () -> config.elytraAddOpenCloseSounds, value -> {
            config.elytraAddOpenCloseSounds = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> elytraSneakToStopGliding = EnderscapeModMenu.boolOption("elytra_sneak_to_stop_gliding", true, () -> config.elytraSneakToStopGliding, value -> {
            config.elytraSneakToStopGliding = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> elytraUpdateEquipSound = EnderscapeModMenu.boolOption("elytra_update_equip_sound", true, () -> config.elytraUpdateEquipSound, value -> {
            config.elytraUpdateEquipSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> enderPearlBreakParticles = EnderscapeModMenu.boolOption("ender_pearl_break_particles", true, () -> config.enderPearlBreakParticles, value -> {
            config.enderPearlBreakParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> enderPearlUpdateTeleportSound = EnderscapeModMenu.boolOption("ender_pearl_update_teleport_sound", true, () -> config.enderPearlUpdateTeleportSound, value -> {
            config.enderPearlUpdateTeleportSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> enderPearlUpdateThrowSound = EnderscapeModMenu.boolOption("ender_pearl_update_throw_sound", true, () -> config.enderPearlUpdateThrowSound, value -> {
            config.enderPearlUpdateThrowSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> tridentsReturnFromVoid = EnderscapeModMenu.boolOption("tridents_return_from_void", true, () -> config.tridentsReturnFromVoid, value -> {
            config.tridentsReturnFromVoid = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.item")).option(elytraAddOpenCloseSounds).option(elytraSneakToStopGliding).option(elytraUpdateEquipSound).option(enderPearlBreakParticles).option(enderPearlUpdateTeleportSound).option(enderPearlUpdateThrowSound).option(tridentsReturnFromVoid).build());
    }

    private static void addClientsideItemOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> elytraAddGlidingSound = EnderscapeModMenu.boolOption("elytra_add_gliding_sound", true, () -> config.elytraAddGlidingSound, value -> {
            config.elytraAddGlidingSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> elytraAddFovEffects = EnderscapeModMenu.boolOption("elytra_add_fov_effects", true, () -> config.elytraAddFovEffects, value -> {
            config.elytraAddFovEffects = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> elytraFovEffectIntensity = EnderscapeModMenu.intOption("elytra_fov_effect_intensity", 100, () -> config.elytraFovEffectIntensity, value -> {
            config.elytraFovEffectIntensity = value;
        }, 0, 200, 1);
        Option<Boolean> enderPearlAddParticles = EnderscapeModMenu.boolOption("ender_pearl_add_particles", true, () -> config.enderPearlAddParticles, value -> {
            config.enderPearlAddParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipEnabled = EnderscapeModMenu.boolOption("mirror_tooltip_enabled", true, () -> config.mirrorTooltipEnabled, value -> {
            config.mirrorTooltipEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipDisplayCoordinates = EnderscapeModMenu.boolOption("mirror_tooltip_display_coordinates", false, () -> config.mirrorTooltipDisplayCoordinates, value -> {
            config.mirrorTooltipDisplayCoordinates = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipDisplayDimension = EnderscapeModMenu.boolOption("mirror_tooltip_display_dimension", true, () -> config.mirrorTooltipDisplayDimension, value -> {
            config.mirrorTooltipDisplayDimension = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipDisplayDistance = EnderscapeModMenu.boolOption("mirror_tooltip_display_distance", true, () -> config.mirrorTooltipDisplayDistance, value -> {
            config.mirrorTooltipDisplayDistance = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipShiftToDisplay = EnderscapeModMenu.boolOption("mirror_tooltip_shift_to_display", false, () -> config.mirrorTooltipShiftToDisplay, value -> {
            config.mirrorTooltipShiftToDisplay = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorScreenEffectEnabled = EnderscapeModMenu.boolOption("mirror_screen_effect_enabled", true, () -> config.mirrorScreenEffectEnabled, value -> {
            config.mirrorScreenEffectEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> mirrorScreenEffectOverlayIntensity = EnderscapeModMenu.intOption("mirror_screen_effect_overlay_intensity", 50, () -> config.mirrorScreenEffectOverlayIntensity, value -> {
            config.mirrorScreenEffectOverlayIntensity = value;
        }, 0, 100, 1);
        Option<Integer> mirrorScreenEffectVignetteIntensity = EnderscapeModMenu.intOption("mirror_screen_effect_vignette_intensity", 50, () -> config.mirrorScreenEffectVignetteIntensity, value -> {
            config.mirrorScreenEffectVignetteIntensity = value;
        }, 0, 100, 1);
        Option<Boolean> nebuliteToolHudEnabled = EnderscapeModMenu.boolOption("nebulite_tool_hud_enabled", true, () -> config.nebuliteToolHudEnabled, value -> {
            config.nebuliteToolHudEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> nebuliteToolHudOffset = EnderscapeModMenu.intOption("nebulite_tool_hud_offset", 13, () -> config.nebuliteToolHudOffset, value -> {
            config.nebuliteToolHudOffset = value;
        }, -25, 25, 1);
        Option<Integer> nebuliteToolHudOpacity = EnderscapeModMenu.intOption("nebulite_tool_hud_opacity", 100, () -> config.nebuliteToolHudOpacity, value -> {
            config.nebuliteToolHudOpacity = value;
        }, 10, 100, 1);
        builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"option.group.enderscape.item")).option(elytraAddFovEffects).option(elytraFovEffectIntensity).option(elytraAddGlidingSound).option(enderPearlAddParticles).option(mirrorTooltipEnabled).option(mirrorTooltipShiftToDisplay).option(mirrorTooltipDisplayCoordinates).option(mirrorTooltipDisplayDimension).option(mirrorTooltipDisplayDistance).option(mirrorScreenEffectEnabled).option(mirrorScreenEffectOverlayIntensity).option(mirrorScreenEffectVignetteIntensity).option(nebuliteToolHudEnabled).option(nebuliteToolHudOffset).option(nebuliteToolHudOpacity).build());
    }
}

